/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

@ManagedObject(value="Abstract Extension")
public abstract class AbstractExtension
extends AbstractLifeCycle
implements Extension {
    private final Logger log = Log.getLogger(((Object)((Object)this)).getClass());
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;
    private ExtensionConfig config;
    private LogicalConnection connection;
    private OutgoingFrames nextOutgoing;
    private IncomingFrames nextIncoming;

    @Deprecated
    public void init(WebSocketContainerScope container) {
        this.init(container.getPolicy(), container.getBufferPool());
    }

    public void init(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        this.bufferPool = bufferPool;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ExtensionConfig getConfig() {
        return this.config;
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public String getName() {
        return this.config.getName();
    }

    @ManagedAttribute(name="Next Incoming Frame Handler", readonly=true)
    public IncomingFrames getNextIncoming() {
        return this.nextIncoming;
    }

    @ManagedAttribute(name="Next Outgoing Frame Handler", readonly=true)
    public OutgoingFrames getNextOutgoing() {
        return this.nextOutgoing;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public boolean isRsv1User() {
        return false;
    }

    public boolean isRsv2User() {
        return false;
    }

    public boolean isRsv3User() {
        return false;
    }

    protected void nextIncomingFrame(Frame frame) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("nextIncomingFrame({})", new Object[]{frame});
        }
        this.nextIncoming.incomingFrame(frame);
    }

    protected void nextOutgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("nextOutgoingFrame({})", new Object[]{frame});
            }
            this.nextOutgoing.outgoingFrame(frame, callback, batchMode);
        }
        catch (Throwable t) {
            if (callback != null) {
                callback.writeFailed(t);
            }
            this.log.warn(t);
        }
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void setConfig(ExtensionConfig config) {
        this.config = config;
    }

    public void setConnection(LogicalConnection connection) {
        this.connection = connection;
    }

    public void setNextIncomingFrames(IncomingFrames nextIncoming) {
        this.nextIncoming = nextIncoming;
    }

    public void setNextOutgoingFrames(OutgoingFrames nextOutgoing) {
        this.nextOutgoing = nextOutgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.config.getParameterizedName());
    }
}

