/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.view.CreateViewAction;
import org.opensearch.action.admin.indices.view.DeleteViewAction;
import org.opensearch.action.admin.indices.view.GetViewAction;
import org.opensearch.action.admin.indices.view.ListViewNamesAction;
import org.opensearch.action.admin.indices.view.SearchViewAction;
import org.opensearch.action.admin.indices.view.ViewAlreadyExistsException;
import org.opensearch.action.admin.indices.view.ViewNotFoundException;
import org.opensearch.action.search.SearchAction;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.View;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class ViewService {
    private static final Logger LOG = LogManager.getLogger(ViewService.class);
    private final ClusterService clusterService;
    private final NodeClient client;
    private final LongSupplier timeProvider;

    public ViewService(ClusterService clusterService, NodeClient client, LongSupplier timeProvider) {
        this.clusterService = clusterService;
        this.client = client;
        this.timeProvider = Optional.ofNullable(timeProvider).orElse(System::currentTimeMillis);
    }

    public void createView(CreateViewAction.Request request, ActionListener<GetViewAction.Response> listener) {
        long currentTime = this.timeProvider.getAsLong();
        List targets = request.getTargets().stream().map(target -> new View.Target(target.getIndexPattern())).collect(Collectors.toList());
        View view = new View(request.getName(), request.getDescription(), currentTime, currentTime, new TreeSet<View.Target>(targets));
        this.createOrUpdateView(Operation.CreateView, view, listener);
    }

    public void updateView(CreateViewAction.Request request, ActionListener<GetViewAction.Response> listener) {
        View originalView = this.getViewOrThrowException(request.getName());
        long currentTime = this.timeProvider.getAsLong();
        List targets = request.getTargets().stream().map(target -> new View.Target(target.getIndexPattern())).collect(Collectors.toList());
        View updatedView = new View(request.getName(), request.getDescription(), originalView.getCreatedAt(), currentTime, new TreeSet<View.Target>(targets));
        this.createOrUpdateView(Operation.UpdateView, updatedView, listener);
    }

    public void deleteView(final DeleteViewAction.Request request, final ActionListener<AcknowledgedResponse> listener) {
        this.getViewOrThrowException(request.getName());
        this.clusterService.submitStateUpdateTask("delete_view_task", new ClusterStateUpdateTask(this){
            final /* synthetic */ ViewService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return new ClusterState.Builder(this.this$0.clusterService.state()).metadata(Metadata.builder(currentState.metadata()).removeView(request.getName())).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOG.error("Unable to delete view, from " + source, (Throwable)e);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    public void getView(GetViewAction.Request request, ActionListener<GetViewAction.Response> listener) {
        View view = this.getViewOrThrowException(request.getName());
        listener.onResponse((Object)new GetViewAction.Response(view));
    }

    public void listViewNames(ActionListener<ListViewNamesAction.Response> listener) {
        ArrayList<String> viewNames = new ArrayList<String>(Optional.ofNullable(this.clusterService).map(ClusterService::state).map(ClusterState::metadata).map(Metadata::views).map(Map::keySet).orElseThrow());
        listener.onResponse((Object)new ListViewNamesAction.Response(viewNames));
    }

    public void searchView(SearchViewAction.Request request, ActionListener<SearchResponse> listener) {
        View view = this.getViewOrThrowException(request.getView());
        String[] indices = (String[])view.getTargets().stream().map(View.Target::getIndexPattern).toArray(String[]::new);
        request.indices(indices);
        this.client.executeLocally(SearchAction.INSTANCE, request, listener);
    }

    View getViewOrThrowException(String viewName) {
        return Optional.ofNullable(this.clusterService).map(ClusterService::state).map(ClusterState::metadata).map(Metadata::views).map(views -> (View)views.get(viewName)).orElseThrow(() -> new ViewNotFoundException(viewName));
    }

    private void createOrUpdateView(final Operation operation, final View view, final ActionListener<GetViewAction.Response> listener) {
        this.clusterService.submitStateUpdateTask(operation.name + "_view_task", new ClusterStateUpdateTask(this){
            final /* synthetic */ ViewService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                if (!operation.allowOverriding && currentState.metadata().views().containsKey(view.getName())) {
                    throw new ViewAlreadyExistsException(view.getName());
                }
                return new ClusterState.Builder(this.this$0.clusterService.state()).metadata(Metadata.builder(currentState.metadata()).put(view)).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                LOG.error("Unable to " + operation.name + " view, from " + source, (Throwable)e);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                View createdView = newState.getMetadata().views().get(view.getName());
                GetViewAction.Response response = new GetViewAction.Response(createdView);
                listener.onResponse((Object)response);
            }
        });
    }

    private static enum Operation {
        CreateView("create", false),
        UpdateView("update", true);

        private final String name;
        private final boolean allowOverriding;

        private Operation(String name, boolean allowOverriding) {
            this.name = name;
            this.allowOverriding = allowOverriding;
        }
    }
}

