/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.registry.cloud;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.platform.registry.cloud.AlertData;
import com.intellij.platform.registry.cloud.AlertUpdate;
import com.intellij.platform.registry.cloud.AlertUpdateType;
import com.intellij.platform.registry.cloud.ConfigClientKt;
import com.intellij.platform.registry.cloud.RegistryKeyUpdate;
import com.intellij.platform.registry.cloud.RegistryValueData;
import com.intellij.platform.registry.cloud.UpdateConfig;
import com.intellij.platform.registry.cloud.UpdateDocument;
import com.intellij.platform.registry.cloud.Updates;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0018H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0002J$\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0002J$\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#2\b\u0010%\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/registry/cloud/ConfigClient;", "", "config", "Lcom/intellij/platform/registry/cloud/UpdateConfig;", "<init>", "(Lcom/intellij/platform/registry/cloud/UpdateConfig;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "update", "Lcom/intellij/platform/registry/cloud/Updates;", "uniqueOverlapping", "", "Lcom/intellij/platform/registry/cloud/RegistryValueData;", "data", "mapType", "Lcom/intellij/notification/NotificationType;", "type", "Lcom/intellij/platform/registry/cloud/AlertUpdateType;", "loadData", "Lcom/intellij/platform/registry/cloud/UpdateDocument;", "uri", "Ljava/net/URI;", "isApplicable", "", "Lcom/intellij/platform/registry/cloud/RegistryKeyUpdate;", "Lcom/intellij/platform/registry/cloud/AlertUpdate;", "matchesPlugin", "pluginId", "", "since", "until", "matchesIdeVersion", "ideCodeMatches", "isInRange", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "sinceVersion", "untilVersion", "intellij.platform.registry.cloud"})
@SourceDebugExtension(value={"SMAP\nConfigClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigClient.kt\ncom/intellij/platform/registry/cloud/ConfigClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n774#2:174\n865#2,2:175\n1563#2:177\n1634#2,3:178\n774#2:181\n865#2,2:182\n1563#2:184\n1634#2,3:185\n*S KotlinDebug\n*F\n+ 1 ConfigClient.kt\ncom/intellij/platform/registry/cloud/ConfigClient\n*L\n53#1:174\n53#1:175,2\n54#1:177\n54#1:178,3\n57#1:181\n57#1:182,2\n58#1:184\n58#1:185,3\n*E\n"})
public final class ConfigClient {
    @NotNull
    private final UpdateConfig config;
    @NotNull
    private final ObjectMapper objectMapper;

    public ConfigClient(@NotNull UpdateConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"configure(...)");
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Updates update() {
        Object object;
        URI uRI = URI.create(this.config.getServiceHost());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        URI uri = UriUtilKt.withPath((URI)uRI, (String)("/remote-config/" + this.config.getProtocolVersion() + "/update.json"));
        try {
            object = this.loadData(uri);
        }
        catch (SocketTimeoutException uhe) {
            ConfigClientKt.access$getLOG$p().debug("Service timed out " + uri + " " + uhe.getMessage());
            return new Updates(null, null, 3, null);
        }
        catch (UnknownHostException uhe) {
            ConfigClientKt.access$getLOG$p().debug("Service is unavailable " + uri + " " + uhe.getMessage());
            return new Updates(null, null, 3, null);
        }
        catch (IOException e) {
            ConfigClientKt.access$getLOG$p().info("Unable to load config data from " + uri, (Throwable)e);
            return new Updates(null, null, 3, null);
        }
        UpdateDocument updateDocument = object;
        try {
            void it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object p0;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            object = updateDocument.getRegistryKeys();
            Object object2 = this;
            boolean $i$f$filter = false;
            void var5_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (RegistryKeyUpdate)element$iv$iv;
                boolean bl = false;
                if (!this.isApplicable((RegistryKeyUpdate)p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (RegistryKeyUpdate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new RegistryValueData(it.getKey(), it.getValue(), it.getReason()));
            }
            $this$map$iv = updateDocument.getAlerts();
            object2 = ((ConfigClient)object2).uniqueOverlapping((List)destination$iv$iv);
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (AlertUpdate)element$iv$iv;
                boolean bl = false;
                if (!this.isApplicable((AlertUpdate)p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (AlertUpdate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AlertData(it.getId(), it.getTitle(), it.getText(), this.mapType(it.getType()), it.getLinkText(), it.getLinkUrl()));
            }
            List list = (List)destination$iv$iv;
            Object object3 = object2;
            return new Updates((List<RegistryValueData>)object3, list);
        }
        catch (Throwable e) {
            ConfigClientKt.access$getLOG$p().warn("Unable to match config data from " + uri, e);
            return new Updates(null, null, 3, null);
        }
    }

    private final List<RegistryValueData> uniqueOverlapping(List<RegistryValueData> data) {
        LinkedHashMap<String, RegistryValueData> map = new LinkedHashMap<String, RegistryValueData>();
        for (RegistryValueData item : data) {
            map.put(item.getKey(), item);
        }
        Collection collection = map.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private final NotificationType mapType(AlertUpdateType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> NotificationType.INFORMATION;
            case 2 -> NotificationType.WARNING;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final UpdateDocument loadData(URI uri) {
        ConfigClientKt.access$getLOG$p().debug("Loading config data from " + uri);
        Object object = HttpRequests.request((String)uri.toString()).productNameAsUserAgent().accept("application/json").connectTimeout(10000).readTimeout(10000).connect(arg_0 -> ConfigClient.loadData$lambda$4(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (UpdateDocument)object;
    }

    private final boolean isApplicable(RegistryKeyUpdate update) {
        if (update.getIdeCodeMatches() == null && update.getPluginId() == null) {
            ConfigClientKt.access$getLOG$p().warn("Invalid registry update without conditions: " + update.getKey());
            return false;
        }
        return !(update.getIdeCodeMatches() != null && !this.matchesIdeVersion(update.getIdeCodeMatches(), update.getIdeSinceVersion(), update.getIdeUntilVersion()) || update.getPluginId() != null && !this.matchesPlugin(update.getPluginId(), update.getPluginSinceVersion(), update.getPluginUntilVersion()));
    }

    private final boolean isApplicable(AlertUpdate update) {
        if (update.getIdeCodeMatches() == null && update.getPluginId() == null) {
            ConfigClientKt.access$getLOG$p().warn("Invalid alert update without conditions: " + update.getId());
            return false;
        }
        return !(update.getIdeCodeMatches() != null && !this.matchesIdeVersion(update.getIdeCodeMatches(), update.getIdeSinceVersion(), update.getIdeUntilVersion()) || update.getPluginId() != null && !this.matchesPlugin(update.getPluginId(), update.getPluginSinceVersion(), update.getPluginUntilVersion()));
    }

    private final boolean matchesPlugin(String pluginId, String since, String until) {
        BuildNumber buildNumber = this.config.getPluginVersions().get(pluginId);
        if (buildNumber == null) {
            return false;
        }
        BuildNumber pluginVersion = buildNumber;
        return this.isInRange(pluginVersion, ConfigClientKt.access$rangeBuildNumber(since), ConfigClientKt.access$rangeBuildNumber(until));
    }

    private final boolean matchesIdeVersion(String ideCodeMatches, String since, String until) {
        Regex regex = new Regex(ideCodeMatches);
        String string = this.config.getIdeVersion().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        return regex.matches((CharSequence)string) && this.isInRange(this.config.getIdeVersion(), ConfigClientKt.access$rangeBuildNumber(since), ConfigClientKt.access$rangeBuildNumber(until));
    }

    private final boolean isInRange(BuildNumber buildNumber, BuildNumber sinceVersion, BuildNumber untilVersion) {
        return sinceVersion != null && buildNumber.compareTo(sinceVersion) >= 0 && untilVersion != null && buildNumber.compareTo(untilVersion) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final UpdateDocument loadData$lambda$4(ConfigClient this$0, HttpRequests.Request request) {
        Object jsonRootElement;
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BufferedReader bufferedReader = request.getReader();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"getReader(...)");
        BufferedReader reader = bufferedReader;
        try {
            UpdateDocument updateDocument;
            object = reader;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                updateDocument = (UpdateDocument)this$0.objectMapper.readValue((Reader)it, UpdateDocument.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = updateDocument;
        }
        catch (Throwable e) {
            throw new IOException("Unable to read JSON response from " + request.getURL(), e);
        }
        Object object2 = jsonRootElement = object;
        if (object2 == null) {
            throw new IOException("Error parsing JSON response: empty document");
        }
        return object2;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlertUpdateType.values().length];
            try {
                nArray[AlertUpdateType.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlertUpdateType.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

