/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridModelWithNestedTables;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.datagrid.MultiPageModelImpl;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.datagrid.StaticNestedTable;
import com.intellij.database.datagrid.nested.NestedTablesAware;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NestedTableGridPagingModel<Row, Column>
implements MultiPageModel<Row, Column>,
NestedTablesAware<Void> {
    private final NestedTablesAware.NonEmptyStack<MultiPageModel<Row, Column>> myNestedTablePageModels;
    private final MultiPageModel<Row, Column> myTopLevelPagingModel;
    private MultiPageModel<Row, Column> myCurrentPagingModel;
    private final GridModelWithNestedTables myGridModel;
    private final List<MultiPageModel.PageModelListener> myListeners;

    public NestedTableGridPagingModel(GridModelWithNestedTables gridModel, MultiPageModel<Row, Column> pageModel) {
        this.myTopLevelPagingModel = pageModel;
        this.myGridModel = gridModel;
        this.myNestedTablePageModels = new NestedTablesAware.NonEmptyStack<MultiPageModel<Row, Column>>(pageModel);
        this.myCurrentPagingModel = pageModel;
        this.myListeners = new ArrayList<MultiPageModel.PageModelListener>();
    }

    @Override
    public Void enterNestedTable(@NotNull NestedTablesDataGridModel.NestedTableCellCoordinate coordinate, @NotNull NestedTable nestedTable) {
        if (coordinate == null) {
            NestedTableGridPagingModel.$$$reportNull$$$0(0);
        }
        if (nestedTable == null) {
            NestedTableGridPagingModel.$$$reportNull$$$0(1);
        }
        this.navigateIntoNestedTable(nestedTable);
        return null;
    }

    @Override
    public Void exitNestedTable(int steps) {
        this.navigateBackFromNestedTable(steps);
        return null;
    }

    @Deprecated(forRemoval=true)
    public void navigateIntoNestedTable(@NotNull NestedTable newSelectedNestedTable) {
        if (newSelectedNestedTable == null) {
            NestedTableGridPagingModel.$$$reportNull$$$0(2);
        }
        this.myCurrentPagingModel = this.createPageModel(newSelectedNestedTable);
        this.myNestedTablePageModels.push(this.myCurrentPagingModel);
    }

    @Deprecated(forRemoval=true)
    public void navigateBackFromNestedTable(int steps) {
        this.myNestedTablePageModels.pop(steps);
        this.myCurrentPagingModel = this.myNestedTablePageModels.last();
    }

    public void reset() {
        this.myCurrentPagingModel = this.myTopLevelPagingModel;
        this.myNestedTablePageModels.reset(this.myTopLevelPagingModel);
    }

    @NotNull
    private MultiPageModel<Row, Column> createPageModel(@NotNull NestedTable newSelectedNestedTable) {
        if (newSelectedNestedTable == null) {
            NestedTableGridPagingModel.$$$reportNull$$$0(3);
        }
        MultiPageModel<Row, Column> model = newSelectedNestedTable instanceof StaticNestedTable ? new StaticMultiPageModel<Row, Column>((GridModel)((Object)this.myGridModel), this.myTopLevelPagingModel) : new MultiPageModelImpl((GridModel)((Object)this.myGridModel), null);
        model.setPageSize(this.myTopLevelPagingModel.getPageSize());
        for (MultiPageModel.PageModelListener listener : this.myListeners) {
            model.addPageModelListener(listener);
        }
        MultiPageModel<Row, Column> multiPageModel = model;
        if (multiPageModel == null) {
            NestedTableGridPagingModel.$$$reportNull$$$0(4);
        }
        return multiPageModel;
    }

    @Override
    public boolean isFirstPage() {
        return this.myCurrentPagingModel.isFirstPage();
    }

    @Override
    public boolean isLastPage() {
        return this.myCurrentPagingModel.isLastPage();
    }

    @Override
    public void setPageSize(int pageSize) {
        this.myCurrentPagingModel.setPageSize(pageSize);
    }

    @Override
    public int getPageSize() {
        return this.myCurrentPagingModel.getPageSize();
    }

    @Override
    public long getTotalRowCount() {
        return this.myCurrentPagingModel.getTotalRowCount();
    }

    @Override
    public boolean isTotalRowCountPrecise() {
        return this.myCurrentPagingModel.isTotalRowCountPrecise();
    }

    @Override
    public boolean isTotalRowCountUpdateable() {
        return this.myCurrentPagingModel.isTotalRowCountUpdateable();
    }

    @Override
    public int getPageStart() {
        return this.myCurrentPagingModel.getPageStart();
    }

    @Override
    public int getPageEnd() {
        return this.myCurrentPagingModel.getPageEnd();
    }

    @Override
    @NotNull
    public ModelIndex<Row> findRow(int rowNumber) {
        ModelIndex modelIndex = this.myCurrentPagingModel.findRow(rowNumber);
        if (modelIndex == null) {
            NestedTableGridPagingModel.$$$reportNull$$$0(5);
        }
        return modelIndex;
    }

    @Override
    public boolean pageSizeSet() {
        return this.myCurrentPagingModel.pageSizeSet();
    }

    @Override
    public void setPageStart(int pageStart) {
        this.myCurrentPagingModel.setPageStart(pageStart);
    }

    @Override
    public void setPageEnd(int pageEnd) {
        this.myCurrentPagingModel.setPageEnd(pageEnd);
    }

    @Override
    public void setTotalRowCount(long totalRowCount, boolean precise) {
        this.myCurrentPagingModel.setTotalRowCount(totalRowCount, precise);
    }

    @Override
    public void setTotalRowCountUpdateable(boolean updateable) {
        this.myCurrentPagingModel.setTotalRowCountUpdateable(updateable);
    }

    @Override
    public void addPageModelListener(@NotNull MultiPageModel.PageModelListener listener) {
        if (listener == null) {
            NestedTableGridPagingModel.$$$reportNull$$$0(6);
        }
        this.myListeners.add(listener);
        for (MultiPageModel<Row, Column> model : this.myNestedTablePageModels) {
            model.addPageModelListener(listener);
        }
    }

    public boolean isStatic() {
        return this.myCurrentPagingModel instanceof StaticMultiPageModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedTable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelectedNestedTable";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/NestedTableGridPagingModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/NestedTableGridPagingModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPageModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findRow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enterNestedTable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "navigateIntoNestedTable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPageModel";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPageModelListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class StaticMultiPageModel<Row, Column>
    implements MultiPageModel<Row, Column> {
        private final GridPagingModel<Row, Column> myDelegate;
        private final GridModel<Row, Column> myGridModel;

        public StaticMultiPageModel(GridModel<Row, Column> gridModel, GridPagingModel<Row, Column> pageModel) {
            this.myDelegate = pageModel;
            this.myGridModel = gridModel;
        }

        @Override
        public boolean isFirstPage() {
            return this.isNestedGrid() || this.myDelegate.isFirstPage();
        }

        private boolean isNestedGrid() {
            HierarchicalColumnsDataGridModel model;
            GridModel<Row, Column> gridModel = this.myGridModel;
            return gridModel instanceof HierarchicalColumnsDataGridModel && !(model = (HierarchicalColumnsDataGridModel)gridModel).isTopLevelGrid();
        }

        @Override
        public boolean isLastPage() {
            return this.isNestedGrid() || this.myDelegate.isLastPage();
        }

        @Override
        public void setPageSize(int pageSize) {
            if (!this.isNestedGrid()) {
                this.myDelegate.setPageSize(pageSize);
            }
        }

        @Override
        public int getPageSize() {
            return this.isNestedGrid() ? this.myGridModel.getRowCount() : this.myDelegate.getPageSize();
        }

        @Override
        public long getTotalRowCount() {
            return this.isNestedGrid() ? (long)this.myGridModel.getRowCount() : this.myDelegate.getTotalRowCount();
        }

        @Override
        public boolean isTotalRowCountPrecise() {
            return this.isNestedGrid() || this.myDelegate.isTotalRowCountPrecise();
        }

        @Override
        public boolean isTotalRowCountUpdateable() {
            return this.isNestedGrid() || this.myDelegate.isTotalRowCountUpdateable();
        }

        @Override
        public int getPageStart() {
            return this.isNestedGrid() ? 1 : this.myDelegate.getPageStart();
        }

        @Override
        public int getPageEnd() {
            return this.isNestedGrid() ? this.myGridModel.getRowCount() : this.myDelegate.getPageEnd();
        }

        @Override
        @NotNull
        public ModelIndex<Row> findRow(int rowNumber) {
            ModelIndex<Row> modelIndex = this.isNestedGrid() ? ModelIndex.forRow(this.myGridModel, rowNumber - 1) : this.myDelegate.findRow(rowNumber);
            if (modelIndex == null) {
                StaticMultiPageModel.$$$reportNull$$$0(0);
            }
            return modelIndex;
        }

        @Override
        public boolean pageSizeSet() {
            return this.isNestedGrid() || this.myDelegate.pageSizeSet();
        }

        @Override
        public void setPageStart(int pageStart) {
        }

        @Override
        public void setPageEnd(int pageEnd) {
        }

        @Override
        public void setTotalRowCount(long totalRowCount, boolean precise) {
        }

        @Override
        public void setTotalRowCountUpdateable(boolean updateable) {
        }

        @Override
        public void addPageModelListener(@NotNull MultiPageModel.PageModelListener listener) {
            if (listener == null) {
                StaticMultiPageModel.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/NestedTableGridPagingModel$StaticMultiPageModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/NestedTableGridPagingModel$StaticMultiPageModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addPageModelListener";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

