/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input.run;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutor;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorResult;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputPathWithVariableName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUtil;
import com.intellij.jupyter.core.jupyter.data.input.run.JupyterDataInputErrorMessageFactory;
import com.intellij.jupyter.core.jupyter.data.input.run.JupyterDataInputGenerateCodeTaskData;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesUtilsKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/run/JupyterDataInputFileTaskExecutor;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutor;", "<init>", "()V", "createTasksIfApplicable", "", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "executeIfApplicable", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "task", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showError", "", "text", "notebookLanguage", "Lcom/intellij/lang/Language;", "onTasksCanceled", "", "taskWithError", "canceledTasks", "interruptExecution", "intellij.jupyter.core"})
public final class JupyterDataInputFileTaskExecutor
implements JupyterTaskExecutor {
    @Override
    @Nullable
    public List<JupyterExecutionTask> createTasksIfApplicable(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile2, @NotNull Document document, @NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        if (JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval2) != JupyterCellType.DATA_INPUT) {
            return null;
        }
        JupyterCell cell = notebookVirtualFile2.getNotebook().getCell(interval2.getOrdinal());
        cell.setOutputs(null);
        if (!JupyterDataInputCellMetadataKt.getHasFileMetadata(cell)) {
            return null;
        }
        JupyterDataInputGenerateCodeTaskData metadata = new JupyterDataInputGenerateCodeTaskData(JupyterDataInputCellMetadataKt.getImportFileMetadataOrDefault(cell));
        JupyterExecutionTask generateCodeTask2 = new JupyterExecutionTask(((Object)NotebookCellLinesUtilsKt.getContentText((Document)document, (NotebookCellLines.Interval)interval2)).toString(), JupyterExecutionTask.Options.Companion.cellExecution(cellPointer).withData(JupyterDataInputGenerateCodeTaskData.Companion.getKey$intellij_jupyter_core(), metadata), (Function2)new Function2<Exception, Continuation<? super Unit>, Object>(project, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Exception exception = (Exception)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void e;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                        this.label = 1;
                        Object object2 = JupyterNotification.INSTANCE.displayAndLogError(this.$project, (Throwable)e, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, notebookVirtualFile2, notebookVirtualFile2, project, null, null, 392, null);
        return CollectionsKt.listOf((Object)generateCodeTask2);
    }

    @Override
    @Nullable
    public Object executeIfApplicable(@NotNull JupyterExecutionTask task2, @NotNull Continuation<? super JupyterTaskExecutorResult> $completion) {
        Path path;
        Project project = task2.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        JupyterDataInputGenerateCodeTaskData jupyterDataInputGenerateCodeTaskData = task2.getOptions().get(JupyterDataInputGenerateCodeTaskData.Companion.getKey$intellij_jupyter_core());
        if (jupyterDataInputGenerateCodeTaskData == null) {
            return null;
        }
        JupyterDataInputGenerateCodeTaskData data = jupyterDataInputGenerateCodeTaskData;
        Language language = task2.getNotebookVirtualFile().getNotebook().getLanguage();
        String presentableFileName = data.getMetadata().getPresentableFilePath();
        JupyterExecutionTask[] jupyterExecutionTaskArray = (JupyterExecutionTask[])presentableFileName;
        if (jupyterExecutionTaskArray == null || StringsKt.isBlank((CharSequence)jupyterExecutionTaskArray)) {
            jupyterExecutionTaskArray = new JupyterExecutionTask[]{JupyterDataInputFileTaskExecutor.executeIfApplicable$makeTask(task2, project2, this.showError("unknown file '" + presentableFileName + "'", language))};
            return new JupyterTaskExecutorResult.FinishedSuccessfully(jupyterExecutionTaskArray);
        }
        try {
            path = data.getMetadata().getFilePath(task2.getNotebookVirtualFile().getFile().toNioPath());
            if (path == null) {
                JupyterExecutionTask[] jupyterExecutionTaskArray2 = new JupyterExecutionTask[]{JupyterDataInputFileTaskExecutor.executeIfApplicable$makeTask(task2, project2, this.showError("unknown file '" + presentableFileName + "'", language))};
                return new JupyterTaskExecutorResult.FinishedSuccessfully(jupyterExecutionTaskArray2);
            }
        }
        catch (InvalidPathException invalidPathException) {
            JupyterExecutionTask[] jupyterExecutionTaskArray3 = new JupyterExecutionTask[]{JupyterDataInputFileTaskExecutor.executeIfApplicable$makeTask(task2, project2, this.showError("unknown file '" + presentableFileName + "'", language))};
            return new JupyterTaskExecutorResult.FinishedSuccessfully(jupyterExecutionTaskArray3);
        }
        Path fullPath = path;
        List<String> cells = JupyterDataInputUtil.INSTANCE.generateCells(task2.getNotebookVirtualFile(), project2, CollectionsKt.listOf((Object)new JupyterDataInputPathWithVariableName(fullPath, data.getMetadata().getVariableName())), DataInputCodeGenerationContext.FOR_EXECUTION);
        String string = (String)CollectionsKt.singleOrNull(cells);
        if (string == null) {
            string = this.showError("unknown file '" + presentableFileName + "'", language);
        }
        String validCode = string;
        JupyterExecutionTask[] jupyterExecutionTaskArray4 = new JupyterExecutionTask[]{JupyterDataInputFileTaskExecutor.executeIfApplicable$makeTask(task2, project2, validCode)};
        return new JupyterTaskExecutorResult.FinishedSuccessfully(jupyterExecutionTaskArray4);
    }

    private final String showError(String text, Language notebookLanguage) {
        String string = JupyterDataInputErrorMessageFactory.Companion.makeErrorMessage(text, notebookLanguage);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public void onTasksCanceled(@NotNull JupyterExecutionTask taskWithError, @NotNull List<JupyterExecutionTask> canceledTasks) {
        Intrinsics.checkNotNullParameter((Object)taskWithError, (String)"taskWithError");
        Intrinsics.checkNotNullParameter(canceledTasks, (String)"canceledTasks");
    }

    @Override
    public void interruptExecution(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
    }

    private static final JupyterExecutionTask executeIfApplicable$makeTask(JupyterExecutionTask $task, Project project, String code) {
        NotebookIntervalPointer notebookIntervalPointer = $task.getOptions().getCellPointer();
        Intrinsics.checkNotNull((Object)notebookIntervalPointer);
        return new JupyterExecutionTask(code, JupyterExecutionTask.Options.Companion.cellExecution(notebookIntervalPointer), (Function2)new Function2<Exception, Continuation<? super Unit>, Object>($task, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ JupyterExecutionTask $task;
            {
                this.$task = $task;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Exception exception = (Exception)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void e;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                        this.label = 1;
                        Object object2 = JupyterNotification.INSTANCE.displayAndLogError(this.$task.getProject(), (Throwable)e, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, null, $task.getNotebookVirtualFile(), $task.getNotebookVirtualFile(), project, null, null, 392, null);
    }
}

