/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.Date;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.helper.DateUtil;
import org.traccar.model.Command;

public class MobilogixProtocolEncoder
extends StringProtocolEncoder {
    public MobilogixProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private Object encodeCommand(Date time, String param) {
        return String.format("[%s,%s]", DateUtil.formatDate(time, false), param);
    }

    @Override
    protected Object encodeCommand(Command command) {
        return this.encodeCommand(command, new Date());
    }

    protected Object encodeCommand(Command command, Date time) {
        return switch (command.getType()) {
            case "custom" -> this.encodeCommand(time, command.getString("data"));
            case "engineResume" -> this.encodeCommand(time, "S6,RELAY=0");
            case "engineStop" -> this.encodeCommand(time, "S6,RELAY=1");
            case "positionSingle" -> this.encodeCommand(time, "S4,1,1");
            case "rebootDevice" -> this.encodeCommand(time, "S7");
            default -> null;
        };
    }
}

