/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;

public class EvictVisitor
extends AbstractVisitor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EvictVisitor.class);
    private final Object owner;

    public EvictVisitor(EventSource session, Object owner) {
        super(session);
        this.owner = owner;
    }

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            this.evictCollection(collection, type);
        }
        return null;
    }

    public void evictCollection(Object value, CollectionType type) {
        PersistentCollection collection;
        EventSource session = this.getSession();
        if (type.hasHolder()) {
            collection = session.getPersistenceContextInternal().removeCollectionHolder(value);
        } else if (value instanceof PersistentCollection) {
            PersistentCollection persistentCollection;
            collection = persistentCollection = (PersistentCollection)value;
        } else if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            collection = (PersistentCollection)type.getCollection(type.getKeyOfOwner(this.owner, session), session, this.owner, false);
        } else {
            return;
        }
        if (collection != null && collection.unsetSession(session)) {
            this.evictCollection(collection);
        }
    }

    private void evictCollection(PersistentCollection<?> collection) {
        EventSource session = this.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        CollectionEntry ce = persistenceContext.removeCollectionEntry(collection);
        CollectionPersister persister = ce.getLoadedPersister();
        Object loadedKey = ce.getLoadedKey();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Evicting collection: " + MessageHelper.collectionInfoString(persister, collection, loadedKey, session));
        }
        if (persister != null) {
            if (session.getLoadQueryInfluencers().effectivelyBatchLoadable(persister)) {
                persistenceContext.getBatchFetchQueue().removeBatchLoadableCollection(ce);
            }
            if (loadedKey != null) {
                persistenceContext.removeCollectionByKey(new CollectionKey(persister, loadedKey));
            }
        }
    }

    @Override
    boolean includeEntityProperty(Object[] values, int i) {
        return true;
    }
}

