/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.internal.commands.AutomationCommandsPluggable;

@NonNullByDefault
public abstract class AutomationCommand {
    protected static final String SUCCESS = "SUCCESS";
    protected static final String FAIL = "FAIL";
    protected static final String OPTION_ST = "-st";
    protected boolean st = false;
    protected String parsingResult;
    protected String command;
    protected int providerType;
    protected AutomationCommandsPluggable autoCommands;

    public AutomationCommand(String command, String[] parameterValues, int providerType, AutomationCommandsPluggable autoCommands) {
        this.command = command;
        this.providerType = providerType;
        this.autoCommands = autoCommands;
        this.parsingResult = this.parseOptionsAndParameters(parameterValues);
    }

    public abstract String execute();

    protected String getStackTrace(Exception e) {
        StringBuilder writer = new StringBuilder();
        if (this.st) {
            StackTraceElement[] ste = e.getStackTrace();
            int i = 0;
            while (i < ste.length) {
                if (i == 0) {
                    writer.append(String.format("FAIL : %s", ste[i].toString() + "\n"));
                } else {
                    writer.append(String.format("%s", ste[i].toString() + "\n"));
                }
                ++i;
            }
        } else {
            writer.append(String.format("FAIL : %s", e.getMessage() + "\n"));
        }
        return writer.toString();
    }

    protected abstract String parseOptionsAndParameters(String[] var1);
}

