/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.settings.put;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class UpdateSettingsRequest
extends AcknowledgedRequest<UpdateSettingsRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private boolean preserveExisting = false;

    public UpdateSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.settings = Settings.readSettingsFromStream(in);
        this.preserveExisting = in.readBoolean();
    }

    public UpdateSettingsRequest() {
    }

    public UpdateSettingsRequest(String ... indices) {
        this.indices = indices;
    }

    public UpdateSettingsRequest(Settings settings, String ... indices) {
        this.indices = indices;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.settings.isEmpty()) {
            validationException = ValidateActions.addValidationError("no settings to update", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public UpdateSettingsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public UpdateSettingsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public UpdateSettingsRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public UpdateSettingsRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public UpdateSettingsRequest settings(String source, MediaType mediaType) {
        this.settings = Settings.builder().loadFromSource(source, mediaType).build();
        return this;
    }

    public boolean isPreserveExisting() {
        return this.preserveExisting;
    }

    public UpdateSettingsRequest setPreserveExisting(boolean preserveExisting) {
        this.preserveExisting = preserveExisting;
        return this;
    }

    public UpdateSettingsRequest settings(Map<String, ?> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeBoolean(this.preserveExisting);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.settings.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public UpdateSettingsRequest fromXContent(XContentParser parser) throws IOException {
        HashMap settings = new HashMap();
        Map bodySettings = parser.map();
        Object innerBodySettings = bodySettings.get("settings");
        if (innerBodySettings instanceof Map) {
            Map innerBodySettingsMap = (Map)innerBodySettings;
            settings.putAll(innerBodySettingsMap);
        } else {
            settings.putAll(bodySettings);
        }
        return this.settings(settings);
    }

    public String toString() {
        return "indices : " + Arrays.toString(this.indices) + "," + Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSettingsRequest that = (UpdateSettingsRequest)o;
        return this.clusterManagerNodeTimeout.equals((Object)that.clusterManagerNodeTimeout) && this.timeout.equals((Object)that.timeout) && Objects.equals(this.settings, that.settings) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.preserveExisting, that.preserveExisting) && Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.clusterManagerNodeTimeout, this.timeout, this.settings, this.indicesOptions, this.preserveExisting, Arrays.hashCode(this.indices));
    }
}

