/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import java.util.Map;
import java.util.TreeMap;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.VariableIDInfo;
import org.tribuo.VariableInfo;
import org.tribuo.hash.Hasher;

public final class HashedFeatureMap
extends ImmutableFeatureMap {
    private static final long serialVersionUID = 1L;
    private final Hasher hasher;

    private HashedFeatureMap(Hasher hasher) {
        this.hasher = hasher;
    }

    @Override
    public VariableIDInfo get(String name) {
        String hash = this.hasher.hash(name);
        return (VariableIDInfo)this.m.get(hash);
    }

    @Override
    public int getID(String name) {
        VariableIDInfo info = this.get(name);
        if (info != null) {
            return info.getID();
        }
        return -1;
    }

    public void setSalt(String salt) {
        this.hasher.setSalt(salt);
    }

    public static HashedFeatureMap generateHashedFeatureMap(FeatureMap map, Hasher hasher) {
        VariableInfo newF;
        HashedFeatureMap hashedMap = new HashedFeatureMap(hasher);
        TreeMap<String, VariableInfo> treeHashMap = new TreeMap<String, VariableInfo>();
        for (VariableInfo f : map) {
            String hash = hasher.hash(f.getName());
            if (treeHashMap.containsKey(f.getName())) continue;
            newF = f.rename(hash);
            treeHashMap.put(f.getName(), newF);
        }
        int counter = 0;
        for (Map.Entry e : treeHashMap.entrySet()) {
            newF = ((VariableInfo)e.getValue()).makeIDInfo(counter);
            if (hashedMap.m.containsKey(newF.getName())) continue;
            hashedMap.m.put(newF.getName(), newF);
            hashedMap.idMap.put(newF.getID(), newF);
            ++counter;
        }
        hashedMap.size = hashedMap.m.size();
        return hashedMap;
    }
}

