/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.utilities;

import ciir.umass.edu.utilities.RankLibError;
import ciir.umass.edu.utilities.WorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MyThreadPool
extends ThreadPoolExecutor {
    private final Semaphore semaphore;
    private int size = 0;
    private static MyThreadPool singleton = null;

    private MyThreadPool(int size) {
        super(size, size, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.semaphore = new Semaphore(size, true);
        this.size = size;
    }

    public static MyThreadPool getInstance() {
        if (singleton == null) {
            MyThreadPool.init(Runtime.getRuntime().availableProcessors());
        }
        return singleton;
    }

    public static void init(int poolSize) {
        singleton = new MyThreadPool(poolSize);
    }

    public int size() {
        return this.size;
    }

    public WorkerThread[] execute(WorkerThread worker, int nTasks) {
        MyThreadPool p = MyThreadPool.getInstance();
        int[] partition = p.partition(nTasks);
        WorkerThread[] workers = new WorkerThread[partition.length - 1];
        for (int i = 0; i < partition.length - 1; ++i) {
            WorkerThread w = worker.clone();
            w.set(partition[i], partition[i + 1] - 1);
            workers[i] = w;
            p.execute(w);
        }
        this.await();
        return workers;
    }

    public void await() {
        int i;
        for (i = 0; i < this.size; ++i) {
            try {
                this.semaphore.acquire();
                continue;
            }
            catch (Exception ex) {
                throw RankLibError.create("Error in MyThreadPool.await(): ", ex);
            }
        }
        for (i = 0; i < this.size; ++i) {
            this.semaphore.release();
        }
    }

    public int[] partition(int listSize) {
        int nChunks = Math.min(listSize, this.size);
        int chunkSize = listSize / nChunks;
        int mod = listSize % nChunks;
        int[] partition = new int[nChunks + 1];
        partition[0] = 0;
        for (int i = 1; i <= nChunks; ++i) {
            partition[i] = partition[i - 1] + chunkSize + (i <= mod ? 1 : 0);
        }
        return partition;
    }

    @Override
    public void execute(Runnable task) {
        try {
            this.semaphore.acquire();
            super.execute(task);
        }
        catch (Exception ex) {
            throw RankLibError.create("Error in MyThreadPool.execute(): ", ex);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.semaphore.release();
    }
}

