/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.jspecify.annotations.Nullable;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.InternalProducerAttr;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

class ParallelFluxRestoringThreadLocals<T>
extends ParallelFlux<T>
implements Scannable {
    private final ParallelFlux<? extends T> source;

    ParallelFluxRestoringThreadLocals(ParallelFlux<? extends T> source) {
        this.source = source;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        CoreSubscriber<? super T>[] actualSubscribers = Operators.restoreContextOnSubscribers(this.source, subscribers);
        this.source.subscribe(actualSubscribers);
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return null;
    }
}

