"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_CONNECTOR_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = exports.MIN_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_TEMPLATE_STRING_LENGTH = exports.MAX_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = exports.MAX_DOCS_TO_IMPORT = exports.MAX_DOCS = exports.MAX_DESCRIPTION_LENGTH = exports.MAX_BYTES_FORMATTED = exports.MAX_BYTES = exports.MATCH_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = exports.LEFT_NAV_SELECTED_STYLE = exports.LABEL_FIELD_PATTERN = exports.KNN_VECTOR_DOCS_LINK = exports.KNN_QUERY = exports.JSONPATH_ROOT_SELECTOR = exports.JSONPATH_DOCS_LINK = exports.JSONLINES_LINK = exports.INVALID_DATASOURCE_MSG = exports.INSPECTOR_TAB_ID = exports.INSPECTOR_TABS = exports.INPUT_TRANSFORM_OPTIONS = exports.INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_NODE_API_PATH = exports.INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NAME_REGEXP = exports.IMAGE_FIELD_PATTERN = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = exports.GITHUB_FEEDBACK_LINK = exports.GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = exports.GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = exports.FUZZY_QUERY_TEXT = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY = exports.EXPANDED_FORM_QUERY_ISSUE = exports.EXISTS_QUERY_TEXT = exports.ERROR_GETTING_WORKFLOW_MSG = exports.EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_FIELD_STRING = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DELIMITER_OPTIONAL_FIELDS = exports.DELETE_WORKFLOW_NODE_API_PATH = exports.DEFAULT_VECTOR_FIELD = exports.DEFAULT_TEXT_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_K = exports.DEFAULT_IMAGE_FIELD = exports.DEFAULT_FETCH_SIZE = exports.DEEPSEEK_CHAT_DOCS_LINK = exports.DATE_FORMAT_PATTERN = exports.CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_LINK = exports.CONFIG_STEP = exports.COMPONENT_ID = exports.COMPONENT_CLASS = exports.COMPONENT_CATEGORY = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_CONFIGS = exports.CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CAT_INDICES_NODE_API_PATH = exports.BULK_NODE_API_PATH = exports.BULK_API_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_CONFIGS = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BASE_WORKFLOW_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = void 0;
exports.WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE = exports.WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_REGEXP = exports.WILDCARD_QUERY_TEXT = exports.VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_PATTERN = exports.VECTOR_FIELD_PATTERN = exports.VECTOR = exports.UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_MODEL_DOCS_LINK = exports.UI_METADATA_SCHEMA_VERSION = exports.TRANSFORM_TYPE = exports.TRANSFORM_CONTEXT = exports.TEXT_FIELD_PATTERN = exports.TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_ALGORITHM = exports.TERM_QUERY_TEXT = exports.SOURCE_OPTIONS = exports.SORT_ORDER = exports.SIMULATE_PIPELINE_NODE_API_PATH = exports.SHARED_OPTIONAL_FIELDS = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX = exports.QUERY_TEXT_PATTERN = exports.QUERY_STRING_QUERY_TEXT = exports.QUERY_PRESETS = exports.QUERY_IMAGE_PATTERN = exports.PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_TIMEOUT = exports.PROMPT_PRESETS = exports.PROCESSOR_TYPE = exports.PROCESSOR_CONTEXT = exports.PREFIX_QUERY_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OUTPUT_TRANSFORM_OPTIONS = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENSEARCH_FLOW = exports.OPENAI_GPT35_DOCS_LINK = exports.OPENAI_CONFIGS = exports.OMIT_SYSTEM_INDEX_PATTERN = exports.NO_TRANSFORMATION = exports.NO_TEMPLATES_FOUND_MSG = exports.NO_MODIFICATIONS_FOUND_TEXT = exports.NORMALIZATION_PROCESSOR_LINK = exports.NODE_CATEGORY = exports.NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_CONFIGS = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = exports.MODEL_TYPE = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_ID_PATTERN = exports.MODEL_CATEGORY = exports.ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_REMOTE_MODEL_LINK = exports.ML_MODEL_ROUTE_PREFIX = exports.ML_MODELS_SETUP_DOCS_LINK = exports.ML_INTERFACE_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = void 0;
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearch-flow';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'AI Search Flows'; // visible plugin name in the context of OSD
const OPENSEARCH_FLOW = exports.OPENSEARCH_FLOW = 'OpenSearch Flow'; // overall feature / name that the plugin encapsulates

/**
 * BACKEND FLOW FRAMEWORK APIs
 */
const FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = '/_plugins/_flow_framework';
const FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = `${FLOW_FRAMEWORK_API_ROUTE_PREFIX}/workflow`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/_search`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/state/_search`;

/**
 * BACKEND ML PLUGIN APIs
 */
const ML_API_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = '/_plugins/_ml';
const ML_MODEL_ROUTE_PREFIX = exports.ML_MODEL_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/models`;
const ML_CONNECTOR_ROUTE_PREFIX = exports.ML_CONNECTOR_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/connectors`;
const ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_MODELS_ROUTE = `${ML_MODEL_ROUTE_PREFIX}/_search`;
const ML_SEARCH_CONNECTORS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = `${ML_CONNECTOR_ROUTE_PREFIX}/_search`;

/**
 * OpenSearch APIs
 */
const SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_ROUTE = '/_search/pipeline';

/**
 * NODE APIs
 */
const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/flow_framework';

// OpenSearch node APIs
const BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = `${BASE_NODE_API_PATH}/opensearch`;
const CAT_INDICES_NODE_API_PATH = exports.CAT_INDICES_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/catIndices`;
const GET_MAPPINGS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/mappings`;
const GET_INDEX_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIndex`;
const SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/search`;
const INGEST_NODE_API_PATH = exports.INGEST_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/ingest`;
const BULK_NODE_API_PATH = exports.BULK_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/bulk`;
const SIMULATE_PIPELINE_NODE_API_PATH = exports.SIMULATE_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/simulatePipeline`;
const INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIngestPipeline`;
const SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getSearchPipeline`;

// Flow Framework node APIs
const BASE_WORKFLOW_NODE_API_PATH = exports.BASE_WORKFLOW_NODE_API_PATH = `${BASE_NODE_API_PATH}/workflow`;
const GET_WORKFLOW_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}`;
const SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/search`;
const GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_STATE_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/state`;
const CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/create`;
const UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/update`;
const PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/provision`;
const DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/deprovision`;
const DELETE_WORKFLOW_NODE_API_PATH = exports.DELETE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/delete`;
const GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/presets`;

// ML Plugin node APIs
const BASE_MODEL_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = `${BASE_NODE_API_PATH}/model`;
const BASE_CONNECTOR_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = `${BASE_NODE_API_PATH}/connector`;
const SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_MODELS_NODE_API_PATH = `${BASE_MODEL_NODE_API_PATH}/search`;
const SEARCH_CONNECTORS_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = `${BASE_CONNECTOR_NODE_API_PATH}/search`;

/**
 * Remote model dimensions. Used for attempting to pre-fill dimension size
 * based on the specified remote model from a remote service, if found
 */

// Amazon BedRock
const BEDROCK_CONFIGS = exports.BEDROCK_CONFIGS = {
  [`amazon.titan-embed-text-v1`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-text-v2`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-image-v1`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`cohere.embed-english-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`cohere.embed-multilingual-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  }
};

// Cohere
const COHERE_CONFIGS = exports.COHERE_CONFIGS = {
  [`embed-english-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-english-v2.0`]: {
    dimension: 4096,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v2.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v2.0`]: {
    dimension: 768,
    fieldName: 'embeddings'
  }
};

// OpenAI
const OPENAI_CONFIGS = exports.OPENAI_CONFIGS = {
  [`text-embedding-3-small`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`text-embedding-3-large`]: {
    dimension: 3072,
    fieldName: 'embedding'
  },
  [`text-embedding-ada-002`]: {
    dimension: 1536,
    fieldName: 'embedding'
  }
};

// Neural Sparse
const NEURAL_SPARSE_CONFIGS = exports.NEURAL_SPARSE_CONFIGS = {
  [`opensearch-neural-sparse-encoding-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-multilingual-v1`]: {
    dimension: 105879,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-mini`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v3-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  }
};

/**
 * Various constants pertaining to Workflow configs
 */

/**
 * Schema versioning for tracking all changes made to the config fields within ui_metadata. Used for BWC and debugging.
 * Version 1: Initial release
 * Version 2: Updates ML search response processor to have an additional "ext_output" field. https://github.com/opensearch-project/dashboards-flow-framework/pull/699
 */
const UI_METADATA_SCHEMA_VERSION = exports.UI_METADATA_SCHEMA_VERSION = 2;

// frontend-specific workflow types, derived from the available preset templates
let WORKFLOW_TYPE = exports.WORKFLOW_TYPE = /*#__PURE__*/function (WORKFLOW_TYPE) {
  WORKFLOW_TYPE["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE["VECTOR_SEARCH_WITH_RAG"] = "RAG with Vector Retrieval";
  WORKFLOW_TYPE["HYBRID_SEARCH_WITH_RAG"] = "RAG with Hybrid Search";
  WORKFLOW_TYPE["SEMANTIC_SEARCH_USING_SPARSE_ENCODERS"] = "Semantic Search using Sparse Encoders";
  WORKFLOW_TYPE["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE;
}({});
let WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE_LEGACY = /*#__PURE__*/function (WORKFLOW_TYPE_LEGACY) {
  WORKFLOW_TYPE_LEGACY["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE_LEGACY["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE_LEGACY["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE_LEGACY["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE_LEGACY["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE_LEGACY;
}({}); // If no datasource version is found, we default to 2.17.0
const MIN_SUPPORTED_VERSION = exports.MIN_SUPPORTED_VERSION = '2.17.0';
// Min version to support ML processors
const MINIMUM_FULL_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = '2.19.0';

// the names should be consistent with the underlying implementation. used when generating the
// final ingest/search pipeline configurations.
let PROCESSOR_TYPE = exports.PROCESSOR_TYPE = /*#__PURE__*/function (PROCESSOR_TYPE) {
  PROCESSOR_TYPE["ML"] = "ml_inference";
  PROCESSOR_TYPE["SPLIT"] = "split";
  PROCESSOR_TYPE["SORT"] = "sort";
  PROCESSOR_TYPE["TEXT_CHUNKING"] = "text_chunking";
  PROCESSOR_TYPE["NORMALIZATION"] = "normalization-processor";
  PROCESSOR_TYPE["COLLAPSE"] = "collapse";
  PROCESSOR_TYPE["RERANK"] = "rerank";
  PROCESSOR_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  PROCESSOR_TYPE["TEXT_IMAGE_EMBEDDING"] = "text_image_embedding";
  PROCESSOR_TYPE["COPY"] = "copy";
  return PROCESSOR_TYPE;
}({});
let MODEL_TYPE = exports.MODEL_TYPE = /*#__PURE__*/function (MODEL_TYPE) {
  MODEL_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  MODEL_TYPE["SPARSE_ENCODER"] = "sparse_encoder";
  return MODEL_TYPE;
}({});
let MODEL_CATEGORY = exports.MODEL_CATEGORY = /*#__PURE__*/function (MODEL_CATEGORY) {
  MODEL_CATEGORY["EMBEDDING"] = "EMBEDDING";
  MODEL_CATEGORY["LLM"] = "LLM";
  MODEL_CATEGORY["SPARSE_ENCODER"] = "SPARSE_ENCODER";
  return MODEL_CATEGORY;
}({});
/**
 * Various constants pertaining to the drag-and-drop UI components
 */
let COMPONENT_CATEGORY = exports.COMPONENT_CATEGORY = /*#__PURE__*/function (COMPONENT_CATEGORY) {
  COMPONENT_CATEGORY["INGEST"] = "Ingest";
  COMPONENT_CATEGORY["SEARCH"] = "Search";
  return COMPONENT_CATEGORY;
}({});
let NODE_CATEGORY = exports.NODE_CATEGORY = /*#__PURE__*/function (NODE_CATEGORY) {
  NODE_CATEGORY["CUSTOM"] = "custom";
  NODE_CATEGORY["INGEST_GROUP"] = "ingestGroup";
  NODE_CATEGORY["SEARCH_GROUP"] = "searchGroup";
  return NODE_CATEGORY;
}({});
/**
 * A base set of component classes / types.
 */
let COMPONENT_CLASS = exports.COMPONENT_CLASS = /*#__PURE__*/function (COMPONENT_CLASS) {
  COMPONENT_CLASS["INDEX"] = "index";
  COMPONENT_CLASS["KNN_INDEX"] = "knn_index";
  COMPONENT_CLASS["TRANSFORMER"] = "transformer";
  COMPONENT_CLASS["ML_TRANSFORMER"] = "ml_transformer";
  COMPONENT_CLASS["SEARCH_REQUEST"] = "search_request";
  COMPONENT_CLASS["DOCUMENT"] = "document";
  COMPONENT_CLASS["SEARCH_RESPONSE"] = "search_response";
  return COMPONENT_CLASS;
}({});
/**
 * LINKS
 */
const ML_INFERENCE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/ml-inference/#configuration-parameters';
const ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#request-fields';
const ML_REMOTE_MODEL_LINK = exports.ML_REMOTE_MODEL_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/remote-models/supported-connectors/';
const ML_INTERFACE_LINK = exports.ML_INTERFACE_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/register-model/#the-interface-parameter';
const TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/text-chunking/';
const CREATE_WORKFLOW_LINK = exports.CREATE_WORKFLOW_LINK = 'https://opensearch.org/docs/latest/automating-configurations/api/create-workflow/';
const WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_TUTORIAL_LINK = 'https://opensearch.org/docs/latest/automating-configurations/workflow-tutorial/';
const NORMALIZATION_PROCESSOR_LINK = exports.NORMALIZATION_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/normalization-processor/';
const GITHUB_FEEDBACK_LINK = exports.GITHUB_FEEDBACK_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/issues/new/choose';
const JSONPATH_DOCS_LINK = exports.JSONPATH_DOCS_LINK = 'https://www.npmjs.com/package/jsonpath';
const KNN_VECTOR_DOCS_LINK = exports.KNN_VECTOR_DOCS_LINK = 'https://opensearch.org/docs/latest/field-types/supported-field-types/knn-vector/';
const BULK_API_DOCS_LINK = exports.BULK_API_DOCS_LINK = 'https://opensearch.org/docs/latest/api-reference/document-apis/bulk/';
const SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_PIPELINE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/using-search-pipeline/';
const ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#example-externally-hosted-text-embedding-model';
const UPDATE_MODEL_DOCS_LINK = exports.UPDATE_MODEL_DOCS_LINK = 'https://opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/update-model/';
const JSONLINES_LINK = exports.JSONLINES_LINK = 'https://jsonlines.org/';
const EXPANDED_FORM_QUERY_ISSUE = exports.EXPANDED_FORM_QUERY_ISSUE = 'https://github.com/opensearch-project/OpenSearch/issues/17358';

// Large Language Models Documentation Links
const BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#claude-3-sonnet-hosted-on-amazon-bedrock';
const OPENAI_GPT35_DOCS_LINK = exports.OPENAI_GPT35_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#openai-gpt-35';
const DEEPSEEK_CHAT_DOCS_LINK = exports.DEEPSEEK_CHAT_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#deepseek-chat';

// Embedding Models Documentation Links
const COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#cohere-embed';
const BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#amazon-bedrock-titan-text-embedding';

// Sparse Encoder Models Documentation Links
const OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = 'https://huggingface.co/opensearch-project/opensearch-neural-sparse-encoding-v2-distill';

// TODO: Update this with the official OpenSearch documentation URL when it's available
const SAGEMAKER_SPARSE_DEPLOY_LINK = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = 'https://github.com/zhichao-aws/opensearch-neural-sparse-sample/tree/main/examples/deploy_on_sagemaker';

// ML Models setup Documentation Link
const ML_MODELS_SETUP_DOCS_LINK = exports.ML_MODELS_SETUP_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md';

/**
 * Text chunking algorithm constants
 */
let TEXT_CHUNKING_ALGORITHM = exports.TEXT_CHUNKING_ALGORITHM = /*#__PURE__*/function (TEXT_CHUNKING_ALGORITHM) {
  TEXT_CHUNKING_ALGORITHM["FIXED_TOKEN_LENGTH"] = "fixed_token_length";
  TEXT_CHUNKING_ALGORITHM["DELIMITER"] = "delimiter";
  return TEXT_CHUNKING_ALGORITHM;
}({});
const FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = ['token_limit', 'tokenizer', 'overlap_rate'];
const DELIMITER_OPTIONAL_FIELDS = exports.DELIMITER_OPTIONAL_FIELDS = ['delimiter'];
const SHARED_OPTIONAL_FIELDS = exports.SHARED_OPTIONAL_FIELDS = ['max_chunk_limit', 'description', 'tag'];

/**
 * DEFAULT FIELD VALUES
 */
const DEFAULT_TEXT_FIELD = exports.DEFAULT_TEXT_FIELD = 'my_text';
const DEFAULT_VECTOR_FIELD = exports.DEFAULT_VECTOR_FIELD = 'my_embedding';
const DEFAULT_IMAGE_FIELD = exports.DEFAULT_IMAGE_FIELD = 'my_image';
const DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_LLM_RESPONSE_FIELD = 'llm_response';

/**
 * QUERY PRESETS
 */
const VECTOR_FIELD_PATTERN = exports.VECTOR_FIELD_PATTERN = `{{vector_field}}`;
const TEXT_FIELD_PATTERN = exports.TEXT_FIELD_PATTERN = `{{text_field}}`;
const IMAGE_FIELD_PATTERN = exports.IMAGE_FIELD_PATTERN = `{{image_field}}`;
const LABEL_FIELD_PATTERN = exports.LABEL_FIELD_PATTERN = `{{label_field}}`;
const QUERY_TEXT_PATTERN = exports.QUERY_TEXT_PATTERN = `{{query_text}}`;
const QUERY_IMAGE_PATTERN = exports.QUERY_IMAGE_PATTERN = `{{query_image}}`;
const MODEL_ID_PATTERN = exports.MODEL_ID_PATTERN = `{{model_id}}`;
const VECTOR = exports.VECTOR = 'vector';
const VECTOR_PATTERN = exports.VECTOR_PATTERN = `{{${VECTOR}}}`;
const VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_TEMPLATE_PLACEHOLDER = `\$\{${VECTOR}\}`;
const DEFAULT_K = exports.DEFAULT_K = 10;
const DEFAULT_FETCH_SIZE = exports.DEFAULT_FETCH_SIZE = 10;

// term-level queries
const TERM_QUERY_TEXT = exports.TERM_QUERY_TEXT = {
  query: {
    term: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const EXISTS_QUERY_TEXT = exports.EXISTS_QUERY_TEXT = {
  query: {
    exists: {
      field: TEXT_FIELD_PATTERN
    }
  }
};
const FUZZY_QUERY_TEXT = exports.FUZZY_QUERY_TEXT = {
  query: {
    fuzzy: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const WILDCARD_QUERY_TEXT = exports.WILDCARD_QUERY_TEXT = {
  query: {
    wildcard: {
      [TEXT_FIELD_PATTERN]: {
        wildcard: QUERY_TEXT_PATTERN,
        case_insensitive: false
      }
    }
  }
};
const PREFIX_QUERY_TEXT = exports.PREFIX_QUERY_TEXT = {
  query: {
    prefix: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
// full-text queries
const MATCH_QUERY_TEXT = exports.MATCH_QUERY_TEXT = {
  query: {
    match: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_BOOLEAN_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = {
  query: {
    match_bool_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = {
  query: {
    match_phrase: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = {
  query: {
    match_phrase_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const QUERY_STRING_QUERY_TEXT = exports.QUERY_STRING_QUERY_TEXT = {
  query: {
    query_string: {
      query: QUERY_TEXT_PATTERN
    }
  }
};
// misc / other queries
const FETCH_ALL_QUERY = exports.FETCH_ALL_QUERY = {
  query: {
    match_all: {}
  },
  size: DEFAULT_FETCH_SIZE
};
const FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY_LARGE = {
  query: {
    match_all: {}
  },
  size: 1000
};
const KNN_QUERY = exports.KNN_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    knn: {
      [VECTOR_FIELD_PATTERN]: {
        vector: VECTOR_PATTERN,
        k: DEFAULT_K
      }
    }
  },
  size: 10
};
const SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEMANTIC_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = {
  query: {
    template: {
      knn: {
        [VECTOR_FIELD_PATTERN]: {
          vector: VECTOR_PATTERN,
          k: 2
        }
      }
    }
  },
  ext: {
    ml_inference: {
      text: QUERY_TEXT_PATTERN
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        query_image: QUERY_IMAGE_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_BOOL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = {
  query: {
    bool: {
      must: [{
        match: {
          [TEXT_FIELD_PATTERN]: QUERY_TEXT_PATTERN
        }
      }, {
        match: {
          [IMAGE_FIELD_PATTERN]: QUERY_IMAGE_PATTERN
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_KNN = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        knn: {
          [VECTOR_FIELD_PATTERN]: {
            vector: VECTOR_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        neural: {
          [VECTOR_FIELD_PATTERN]: {
            query_text: QUERY_TEXT_PATTERN,
            model_id: MODEL_ID_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        term: {
          [TEXT_FIELD_PATTERN]: {
            value: QUERY_TEXT_PATTERN
          }
        }
      }]
    }
  }
};
const NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_SEARCH_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural_sparse: {
      [VECTOR_FIELD_PATTERN]: {
        query_tokens: VECTOR_PATTERN
      }
    }
  }
};
const QUERY_PRESETS = exports.QUERY_PRESETS = [{
  name: 'Fetch all',
  query: (0, _utils.customStringify)(FETCH_ALL_QUERY)
}, {
  name: 'Term',
  query: (0, _utils.customStringify)(TERM_QUERY_TEXT)
}, {
  name: 'Match',
  query: (0, _utils.customStringify)(MATCH_QUERY_TEXT)
}, {
  name: 'Exists',
  query: (0, _utils.customStringify)(EXISTS_QUERY_TEXT)
}, {
  name: 'Fuzzy',
  query: (0, _utils.customStringify)(FUZZY_QUERY_TEXT)
}, {
  name: 'Wildcard',
  query: (0, _utils.customStringify)(WILDCARD_QUERY_TEXT)
}, {
  name: 'Prefix',
  query: (0, _utils.customStringify)(PREFIX_QUERY_TEXT)
}, {
  name: 'Match boolean',
  query: (0, _utils.customStringify)(MATCH_BOOLEAN_QUERY_TEXT)
}, {
  name: 'Match phrase',
  query: (0, _utils.customStringify)(MATCH_PHRASE_QUERY_TEXT)
}, {
  name: 'Match phrase prefix',
  query: (0, _utils.customStringify)(MATCH_PHRASE_PREFIX_QUERY_TEXT)
}, {
  name: 'Query string',
  query: (0, _utils.customStringify)(QUERY_STRING_QUERY_TEXT)
}, {
  name: 'Basic k-NN',
  query: (0, _utils.customStringify)(KNN_QUERY)
}, {
  name: WORKFLOW_TYPE.MULTIMODAL_SEARCH,
  query: (0, _utils.customStringify)(MULTIMODAL_SEARCH_QUERY_BOOL)
}, {
  name: 'Neural Sparse Search Query',
  query: (0, _utils.customStringify)(NEURAL_SPARSE_SEARCH_QUERY)
}, {
  name: 'Semantic search (neural query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_QUERY_NEURAL)
}, {
  name: 'Semantic search (template query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_TEMPLATE_QUERY)
}, {
  name: `Hybrid search (match & k-NN queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_KNN)
}, {
  name: `Hybrid search (match & term queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_TERM)
}];

/**
 * DEFAULT TEMPLATE VAR NAMES
 */
const DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = 'results';
const DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = 'question';
const DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = 'textCategory';
const DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = 'role';

/**
 * PROMPT PRESETS. Based off of https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-templates-and-examples.html
 */
const GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = 'Read the following text: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\nSummarize the text in one sentence.';
const GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = 'Read the following text, and answer the question at the end: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\n${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_QA_NO_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = 'Answer the following question: \
${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_TEXT_GENERATION_PROMPT = 'Please write a ${parameters.' + DEFAULT_PROMPT_TEXT_CATEGORY_FIELD + '.toString()} in the voice of ${parameters.' + DEFAULT_PROMPT_ROLE_FIELD + '.toString()}';
const CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_SUMMARIZE_PROMPT = 'Human: read the following results inside the <text></text> XML tags:\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + ".toString()}\n</text>\n\n\
Summarize the above results in one sentence. If you don't know the answer, just \
say I don't know.\
\n\nAssistant:";
const CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = 'Human: read the following results inside the <text></text> XML tags, and then answer the question:\
\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()}\n\
</text>\n\n' + '${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}\n\nAssistant:';
const PROMPT_PRESETS = exports.PROMPT_PRESETS = [{
  name: 'Summarize text',
  prompt: GENERAL_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context',
  prompt: GENERAL_QA_WITH_CONTEXT_PROMPT
}, {
  name: 'Question-answer, without context',
  prompt: GENERAL_QA_NO_CONTEXT_PROMPT
}, {
  name: 'Text generation',
  prompt: GENERAL_TEXT_GENERATION_PROMPT
}, {
  name: 'Summarize text (Claude)',
  prompt: CLAUDE_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context (Claude)',
  prompt: CLAUDE_QA_WITH_CONTEXT_PROMPT
}];

/**
 * MISCELLANEOUS
 */
let PROCESSOR_CONTEXT = exports.PROCESSOR_CONTEXT = /*#__PURE__*/function (PROCESSOR_CONTEXT) {
  PROCESSOR_CONTEXT["INGEST"] = "ingest";
  PROCESSOR_CONTEXT["SEARCH_REQUEST"] = "search_request";
  PROCESSOR_CONTEXT["SEARCH_RESPONSE"] = "search_response";
  return PROCESSOR_CONTEXT;
}({});
const NO_TRANSFORMATION = exports.NO_TRANSFORMATION = 'No transformation';
let TRANSFORM_CONTEXT = exports.TRANSFORM_CONTEXT = /*#__PURE__*/function (TRANSFORM_CONTEXT) {
  TRANSFORM_CONTEXT["INPUT"] = "input";
  TRANSFORM_CONTEXT["OUTPUT"] = "output";
  return TRANSFORM_CONTEXT;
}({});
let TRANSFORM_TYPE = exports.TRANSFORM_TYPE = /*#__PURE__*/function (TRANSFORM_TYPE) {
  TRANSFORM_TYPE["STRING"] = "Custom string";
  TRANSFORM_TYPE["FIELD"] = "Data field";
  TRANSFORM_TYPE["EXPRESSION"] = "JSONPath expression";
  TRANSFORM_TYPE["TEMPLATE"] = "Prompt";
  return TRANSFORM_TYPE;
}({});
const INPUT_TRANSFORM_OPTIONS = exports.INPUT_TRANSFORM_OPTIONS = [{
  id: TRANSFORM_TYPE.FIELD,
  description: 'Use an existing field from your data as the model input field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to the model input field.'
}, {
  id: TRANSFORM_TYPE.TEMPLATE,
  description: 'Configure a prompt to map data to the model input field.'
}, {
  id: TRANSFORM_TYPE.STRING,
  description: 'Use a custom string in the model input field.'
}];
const OUTPUT_TRANSFORM_OPTIONS = exports.OUTPUT_TRANSFORM_OPTIONS = [{
  id: NO_TRANSFORMATION,
  description: ''
}, {
  id: TRANSFORM_TYPE.FIELD,
  description: 'Copy the model output into a new document field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to a new document field.'
}];
const DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_NAME = 'new_workflow';
const DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = 'My new workflow';
const DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = 'NOT_STARTED';
const DATE_FORMAT_PATTERN = exports.DATE_FORMAT_PATTERN = 'MM/DD/YY hh:mm A';
const EMPTY_FIELD_STRING = exports.EMPTY_FIELD_STRING = '--';
const OMIT_SYSTEM_INDEX_PATTERN = exports.OMIT_SYSTEM_INDEX_PATTERN = '*,-.*';
const INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NOT_FOUND_EXCEPTION = 'index_not_found_exception';
const ERROR_GETTING_WORKFLOW_MSG = exports.ERROR_GETTING_WORKFLOW_MSG = 'Failed to retrieve template';
const INVALID_DATASOURCE_MSG = exports.INVALID_DATASOURCE_MSG = 'No Living connections';
const NO_TEMPLATES_FOUND_MSG = exports.NO_TEMPLATES_FOUND_MSG = 'There are no templates';
const NO_MODIFICATIONS_FOUND_TEXT = exports.NO_MODIFICATIONS_FOUND_TEXT = 'Template does not contain any modifications';
const JSONPATH_ROOT_SELECTOR = exports.JSONPATH_ROOT_SELECTOR = '$';
const REQUEST_PREFIX = exports.REQUEST_PREFIX = '_request.';
const REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = '$._request.';
const WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_RESTRICTIONS = 'Invalid workflow name. Valid characters are a-z, A-Z, 0-9, -(hyphen), _(underscore).';
let SORT_ORDER = exports.SORT_ORDER = /*#__PURE__*/function (SORT_ORDER) {
  SORT_ORDER["ASC"] = "asc";
  SORT_ORDER["DESC"] = "desc";
  return SORT_ORDER;
}({});
const MAX_DOCS = exports.MAX_DOCS = 1000;
const MAX_DOCS_TO_IMPORT = exports.MAX_DOCS_TO_IMPORT = 100;
const MAX_STRING_LENGTH = exports.MAX_STRING_LENGTH = 100;
const MAX_DESCRIPTION_LENGTH = exports.MAX_DESCRIPTION_LENGTH = 1000;
const MAX_JSON_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = 10000;
const MAX_TEMPLATE_STRING_LENGTH = exports.MAX_TEMPLATE_STRING_LENGTH = 10000;
const MAX_BYTES = exports.MAX_BYTES = 1048576; // OSD REST request payload size limit
const MAX_BYTES_FORMATTED = exports.MAX_BYTES_FORMATTED = '1,048,576';
const MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = 40;
const WORKFLOW_NAME_REGEXP = exports.WORKFLOW_NAME_REGEXP = RegExp('^[a-zA-Z0-9_-]*$');
const INDEX_NAME_REGEXP = exports.INDEX_NAME_REGEXP = WORKFLOW_NAME_REGEXP;
const PROVISION_TIMEOUT = exports.PROVISION_TIMEOUT = '10s'; // the timeout config for synchronous provisioning. https://github.com/opensearch-project/flow-framework/pull/990
const EMPTY_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = {
  key: '',
  value: ''
};
const EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = {
  key: '',
  value: {
    transformType: TRANSFORM_TYPE.FIELD,
    value: ''
  }
};
const EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_OUTPUT_MAP_ENTRY = {
  ...EMPTY_INPUT_MAP_ENTRY,
  value: {
    ...EMPTY_INPUT_MAP_ENTRY.value,
    transformType: NO_TRANSFORMATION
  }
};
const MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = 'output.properties.inference_results.items.properties.output.items.properties.dataAsMap.properties';
const MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = 'output.properties';
let CONFIG_STEP = exports.CONFIG_STEP = /*#__PURE__*/function (CONFIG_STEP) {
  CONFIG_STEP["INGEST"] = "Ingest pipeline";
  CONFIG_STEP["SEARCH"] = "Search pipeline";
  return CONFIG_STEP;
}({});
let SOURCE_OPTIONS = exports.SOURCE_OPTIONS = /*#__PURE__*/function (SOURCE_OPTIONS) {
  SOURCE_OPTIONS["MANUAL"] = "manual";
  SOURCE_OPTIONS["UPLOAD"] = "upload";
  SOURCE_OPTIONS["EXISTING_INDEX"] = "existing_index";
  return SOURCE_OPTIONS;
}({});
let INSPECTOR_TAB_ID = exports.INSPECTOR_TAB_ID = /*#__PURE__*/function (INSPECTOR_TAB_ID) {
  INSPECTOR_TAB_ID["TEST"] = "test";
  INSPECTOR_TAB_ID["INGEST"] = "ingest";
  INSPECTOR_TAB_ID["ERRORS"] = "errors";
  INSPECTOR_TAB_ID["RESOURCES"] = "resources";
  INSPECTOR_TAB_ID["PREVIEW"] = "preview";
  return INSPECTOR_TAB_ID;
}({});
const INSPECTOR_TABS = exports.INSPECTOR_TABS = [{
  id: INSPECTOR_TAB_ID.TEST,
  name: 'Test flow',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.INGEST,
  name: 'Ingest response',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.ERRORS,
  name: 'Errors',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.RESOURCES,
  name: 'Resources',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.PREVIEW,
  name: 'Preview',
  disabled: false
}];

// component IDs for each left nav component. Some may be tied
// to the lower-level form, others are for visual flow purposes only,
// like 'retrieveFromDataSource' and 'searchResults'
let COMPONENT_ID = exports.COMPONENT_ID = /*#__PURE__*/function (COMPONENT_ID) {
  COMPONENT_ID["SOURCE_DATA"] = "ingest.docs";
  COMPONENT_ID["ENRICH_DATA"] = "ingest.enrich";
  COMPONENT_ID["INGEST_DATA"] = "ingest.index";
  COMPONENT_ID["SEARCH_REQUEST"] = "search.request";
  COMPONENT_ID["ENRICH_SEARCH_REQUEST"] = "search.enrichRequest";
  COMPONENT_ID["RUN_QUERY"] = "runQuery";
  COMPONENT_ID["ENRICH_SEARCH_RESPONSE"] = "search.enrichResponse";
  COMPONENT_ID["SEARCH_RESULTS"] = "searchResults";
  return COMPONENT_ID;
}({}); // We have to persist a standalone string to override 'style' component, as setting className does
// not override the default styles from the EuiCard component.
const LEFT_NAV_SELECTED_STYLE = exports.LEFT_NAV_SELECTED_STYLE = '2px solid rgba(128, 128, 128, 0.8)';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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