"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupAlertsRoutes = setupAlertsRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupAlertsRoutes(services, router) {
  const {
    alertService
  } = services;
  router.get({
    path: _constants.API.GET_ALERTS,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        detectorType: _configSchema.schema.maybe(_configSchema.schema.string()),
        detector_id: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortOrder: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.maybe(_configSchema.schema.number()),
        startIndex: _configSchema.schema.maybe(_configSchema.schema.number()),
        startTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        endTime: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    }
  }, alertService.getAlerts);
  router.post({
    path: _constants.API.ACKNOWLEDGE_ALERTS,
    validate: {
      params: _configSchema.schema.object({
        detector_id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, alertService.acknowledgeAlerts);
  router.get({
    path: `${_constants.API.THREAT_INTEL_BASE}/alerts`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        sortOrder: _configSchema.schema.maybe(_configSchema.schema.string()),
        size: _configSchema.schema.maybe(_configSchema.schema.number()),
        startIndex: _configSchema.schema.maybe(_configSchema.schema.number()),
        startTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        endTime: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    }
  }, alertService.getThreatIntelAlerts);
  router.put({
    path: `${_constants.API.THREAT_INTEL_BASE}/alerts/status`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        state: _configSchema.schema.string(),
        alert_ids: _configSchema.schema.string()
      })
    }
  }, alertService.updateThreatIntelAlertsState);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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