/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.WinFlatUtils;
import org.openide.awt.HtmlRenderer;

public class WinFlatViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int ICON_X_PAD = 4;
    private static boolean colorsReady = false;
    private static Color background;
    private static Color activeBackground;
    private static Color selectedBackground;
    private static Color hoverBackground;
    private static Color unselectedHoverBackground;
    private static Color attentionBackground;
    private static Color foreground;
    private static Color activeForeground;
    private static Color selectedForeground;
    private static Color hoverForeground;
    private static Color attentionForeground;
    private static Color underlineColor;
    private static Color inactiveUnderlineColor;
    private static Color tabSeparatorColor;
    private static Color contentBorderColor;
    private static Insets tabInsets;
    private static int underlineHeight;
    private static boolean underlineAtTop;
    private static boolean showTabSeparators;
    private static boolean showSelectedTabBorder;
    private static boolean unscaledBorders;
    private Font font;

    public WinFlatViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinFlatViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        WinFlatViewTabDisplayerUI.initColors();
        this.getLayoutModel().setPadding(new Dimension(WinFlatViewTabDisplayerUI.tabInsets.left + WinFlatViewTabDisplayerUI.tabInsets.right, 0));
    }

    @Override
    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics.getHeight() + WinFlatViewTabDisplayerUI.tabInsets.top + WinFlatViewTabDisplayerUI.tabInsets.bottom;
        return new Dimension(100, n);
    }

    @Override
    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        int n10 = WinFlatViewTabDisplayerUI.tabInsets.left;
        int n11 = WinFlatViewTabDisplayerUI.tabInsets.right;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n12 = n4 - (n10 + n11);
        if (this.isSelected(n) && null != (object = this.getControlButtons())) {
            Dimension dimension = ((Component)object).getPreferredSize();
            if (n4 < dimension.width + 4) {
                ((Component)object).setVisible(false);
            } else {
                ((Component)object).setVisible(true);
                n12 -= dimension.width + 4;
                n9 = 2;
                ((Component)object).setLocation(n2 + n4 - dimension.width - 4, n3 + (n5 - dimension.height) / 2 - 1 + n9);
            }
        }
        if (this.isTabBusy(n)) {
            object = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(n));
            n8 = object.getIconWidth() + WinFlatUtils.UIScale.scale(3);
            n12 -= n8;
        } else {
            object = null;
            n8 = 0;
        }
        int n13 = n9 = string.startsWith("<html") || string.startsWith("<HTML") ? (int)HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.getTxtFont(), (Color)foreground, (int)1, (boolean)false) : fontMetrics.stringWidth(string);
        if (n9 > n12) {
            int n14 = Math.min(n10 - 2, n9 - n12);
            n10 -= n14;
            if (n9 > (n12 += n14 + n11) && string.length() > 3 && (n7 = fontMetrics.stringWidth(string.substring(0, 3) + "\u2026")) > n12) {
                for (n6 = 2; n6 >= 0 && fontMetrics.stringWidth(string = string.substring(0, n6) + "\u2026") >= n12; --n6) {
                }
            }
        }
        if (object != null) {
            object.paintIcon(this.displayer, graphics, n2 + n10, n3 + (n5 - object.getIconHeight()) / 2);
            n2 += n8;
            n4 -= n8;
        }
        Color color = this.colorForState(n, foreground, activeForeground, selectedForeground, hoverForeground, hoverForeground, attentionForeground);
        n7 = n2 + n10;
        n6 = n5 - WinFlatViewTabDisplayerUI.tabInsets.top - WinFlatViewTabDisplayerUI.tabInsets.bottom;
        int n15 = 1;
        if (!this.isSelected(n)) {
            n7 = Math.max(n2 + 1, n2 + (n4 - n9) / 2);
        }
        double d = this.getTxtFont().createGlyphVector(fontMetrics.getFontRenderContext(), "H").getVisualBounds().getHeight();
        int n16 = WinFlatViewTabDisplayerUI.tabInsets.top + (int)Math.round(((double)n6 + d) / 2.0) + 1;
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n7, (int)n16, (int)n12, (int)n5, (Font)this.getTxtFont(), (Color)color, (int)n15, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n4, int n5, int n6, int n7) {
        WinFlatUtils.HiDPIUtils.paintAtScale1x(graphics, n4, n5, n6, n7, (graphics2D, n2, n3, d) -> this.paintTabBackgroundAtScale1x(graphics2D, n, n2, n3, d));
    }

    private void paintTabBackgroundAtScale1x(Graphics2D graphics2D, int n, int n2, int n3, double d) {
        int n4;
        boolean bl = this.isSelected(n);
        Color color = this.colorForState(n, background, activeBackground, selectedBackground, hoverBackground, unselectedHoverBackground, attentionBackground);
        boolean bl2 = showTabSeparators && n >= 0 && (!showSelectedTabBorder || !bl && n < this.getDataModel().size() - 1 && !this.isSelected(n + 1));
        int n5 = unscaledBorders ? 1 : WinFlatUtils.HiDPIUtils.deviceBorderWidth(d, 1);
        int n6 = bl2 ? n5 : 0;
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n2 - (color != background ? n6 : 0), n3);
        if (bl) {
            if (showSelectedTabBorder) {
                graphics2D.setColor(contentBorderColor);
                graphics2D.fillRect(0, 0, n2 - n6, n5);
                graphics2D.fillRect(0, 0, n5, n3);
                graphics2D.fillRect(n2 - n6 - n5, 0, n5, n3);
            }
            if (underlineHeight > 0) {
                n4 = (int)Math.round((double)underlineHeight * d);
                graphics2D.setColor(this.isActive() ? underlineColor : inactiveUnderlineColor);
                if (underlineAtTop) {
                    graphics2D.fillRect(0, 0, n2 - n6, n4);
                } else {
                    graphics2D.fillRect(0, n3 - n4, n2 - n6, n4);
                }
            }
        } else {
            graphics2D.setColor(contentBorderColor);
            graphics2D.fillRect(0, n3 - n5, n2, n5);
        }
        if (bl2) {
            n4 = (int)(4.0 * d);
            graphics2D.setColor(tabSeparatorColor);
            graphics2D.fillRect(n2 - n6, n4, n6, n3 - n4 * 2 - 1);
        }
    }

    @Override
    protected void paintDisplayerBackground(Graphics graphics, JComponent jComponent) {
        this.paintTabBackground(graphics, -1, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        super.paintDisplayerBackground(graphics, jComponent);
    }

    private Color colorForState(int n, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        return this.isAttention(n) ? color6 : (this.isMouseOver(n) ? (this.isSelected(n) ? color4 : color5) : (this.isSelected(n) ? color3 : (this.isActive() ? color2 : color)));
    }

    @Override
    protected Font getTxtFont() {
        if (this.font == null) {
            this.font = UIManager.getFont("ViewTab.font");
            if (this.font == null) {
                this.font = UIManager.getFont("Label.font");
            }
        }
        return this.font;
    }

    boolean isMouseOver(int n) {
        if (n < 0) {
            return false;
        }
        return ((OwnController)this.getController()).getMouseIndex() == n;
    }

    private static void initColors() {
        if (!colorsReady) {
            background = UIManager.getColor("ViewTab.background");
            activeBackground = WinFlatUtils.Utils.getUIColor("ViewTab.activeBackground", background);
            selectedBackground = WinFlatUtils.Utils.getUIColor("ViewTab.selectedBackground", activeBackground);
            hoverBackground = UIManager.getColor("ViewTab.hoverBackground");
            unselectedHoverBackground = WinFlatUtils.Utils.getUIColor("ViewTab.unselectedHoverBackground", hoverBackground);
            attentionBackground = UIManager.getColor("ViewTab.attentionBackground");
            foreground = WinFlatUtils.Utils.getUIColor("ViewTab.foreground", "TabbedPane.foreground");
            activeForeground = WinFlatUtils.Utils.getUIColor("ViewTab.activeForeground", foreground);
            selectedForeground = WinFlatUtils.Utils.getUIColor("ViewTab.selectedForeground", activeForeground);
            hoverForeground = WinFlatUtils.Utils.getUIColor("ViewTab.hoverForeground", foreground);
            attentionForeground = WinFlatUtils.Utils.getUIColor("ViewTab.attentionForeground", foreground);
            underlineColor = UIManager.getColor("ViewTab.underlineColor");
            inactiveUnderlineColor = UIManager.getColor("ViewTab.inactiveUnderlineColor");
            tabSeparatorColor = UIManager.getColor("ViewTab.tabSeparatorColor");
            contentBorderColor = UIManager.getColor("TabbedContainer.view.contentBorderColor");
            tabInsets = UIManager.getInsets("ViewTab.tabInsets");
            underlineHeight = UIManager.getInt("ViewTab.underlineHeight");
            underlineAtTop = UIManager.getBoolean("ViewTab.underlineAtTop");
            showTabSeparators = UIManager.getBoolean("ViewTab.showTabSeparators");
            tabInsets = WinFlatUtils.UIScale.scale(tabInsets);
            underlineHeight = WinFlatUtils.UIScale.scale(underlineHeight);
            showSelectedTabBorder = WinFlatUtils.Utils.getUIBoolean("ViewTab.showSelectedTabBorder", false);
            unscaledBorders = WinFlatUtils.Utils.getUIBoolean("ViewTab.unscaledBorders", false);
            colorsReady = true;
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = WinFlatUtils.FlatTabControlIcon.get(n, n2);
        return icon != null ? icon : super.getButtonIcon(n, n2);
    }

    @Override
    public void postTabAction(TabActionEvent tabActionEvent) {
        super.postTabAction(tabActionEvent);
        if ("maximize".equals(tabActionEvent.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Point point = mouseEvent.getPoint();
            this.updateHighlight(WinFlatViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!this.inControlButtonsRect(mouseEvent.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == this.lastIndex) {
                return;
            }
            TabLayoutModel tabLayoutModel = WinFlatViewTabDisplayerUI.this.getLayoutModel();
            Rectangle rectangle = null;
            if (n != -1) {
                n5 = tabLayoutModel.getX(n) - 1;
                n4 = tabLayoutModel.getY(n);
                n3 = tabLayoutModel.getW(n) + 2;
                n2 = tabLayoutModel.getH(n);
                rectangle = new Rectangle(n5, n4, n3, n2);
            }
            if (this.lastIndex != -1 && this.lastIndex < WinFlatViewTabDisplayerUI.this.getDataModel().size()) {
                n5 = tabLayoutModel.getX(this.lastIndex) - 1;
                n4 = tabLayoutModel.getY(this.lastIndex);
                n3 = tabLayoutModel.getW(this.lastIndex) + 2;
                n2 = tabLayoutModel.getH(this.lastIndex);
                rectangle = rectangle != null ? rectangle.union(new Rectangle(n5, n4, n3, n2)) : new Rectangle(n5, n4, n3, n2);
            }
            if (rectangle != null) {
                WinFlatViewTabDisplayerUI.this.getDisplayer().repaint(rectangle);
            }
            this.lastIndex = n;
        }
    }
}

