//  (C) Copyright John Maddock 2024.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 4>, 12112> nc_t_pdf_data = {{
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.4381813277523004272343589190146201842804e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(1.7570993138850640675881332555246167625001e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(2.1776624749602608724215749701932540495194e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(2.7437748471563251651810419842608555823112e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(3.5242068285498268064856885581705033301522e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(4.6306441321775042248572523975297685709043e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(6.2524582986546127466128626136898551304061e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(8.7277004154694400993170850522354837910928e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(1.2698822611984500166119118630224410637015e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(1.9485879183139325712134962445161030227791e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(3.2086387152381181297690359790022815747067e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(5.8273840556190222406296411457432136139729e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(1.2231493859692107909954847981598455305555e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(3.2419501327949399831436883948257874465481e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(1.3150870759896782842146518731597698204537e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(1.2502536175677130652478644413803447848099e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.7392658805528147996492784000917750482146e-01) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.5505237245131592879465049509558564339510e-01) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.3891484344063819340920397074590876366327e-01) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5882358551025390625000000000000000000000e+00), SC_(7.0573515208378571098450697999426970255806e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8823528289794921875000000000000000000000e+00), SC_(3.8659108941274892704939877688209596486522e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1764717102050781250000000000000000000000e+00), SC_(2.2972870175517668819501307839139439765597e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.4612138020671884199410920956065499300964e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7647056579589843750000000000000000000000e+00), SC_(9.8155803353488957527588448888355653147470e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1058822631835937500000000000000000000000e+01), SC_(6.8892329703213950547819353284115218987106e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2352939605712890625000000000000000000000e+01), SC_(5.0110055005455076612933152412755070324156e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3647060394287109375000000000000000000000e+01), SC_(3.7537643616370592501494430511246425118804e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4941177368164062500000000000000000000000e+01), SC_(2.8820947300776745522732463222576655813809e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6235290527343750000000000000000000000000e+01), SC_(2.2595114796970283273606264072755840851385e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7529411315917968750000000000000000000000e+01), SC_(1.8033857138844883616646264529329275269992e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8823524475097656250000000000000000000000e+01), SC_(1.4618023277491700254576904946550613071766e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.2010567922668599338034822360685891048573e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.1411766052246093750000000000000000000000e+01), SC_(9.9864909838274633148295747522888074251920e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.2705879211425781250000000000000000000000e+01), SC_(8.3917577421362860751024209004037584513413e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4000000000000000000000000000000000000000e+01), SC_(7.1185408035729552160450145203995363226997e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.5294113159179687500000000000000000000000e+01), SC_(6.0899023174638864536541511117915647815923e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.6588233947753906250000000000000000000000e+01), SC_(5.2499209036812976210490530247988827336209e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.7882354736328125000000000000000000000000e+01), SC_(4.5573301166456967934784270104383263818628e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.9812211483809037366198434952769852429178e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.0470588684082031250000000000000000000000e+01), SC_(3.4981290070150162434927481887970003801838e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.1764701843261718750000000000000000000000e+01), SC_(3.0900423801167881959448575122971810717785e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.3058822631835937500000000000000000000000e+01), SC_(2.7429648942571774824427815556237965522167e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.4352935791015625000000000000000000000000e+01), SC_(2.4459244769146319507415060872541619816038e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.5647048950195312500000000000000000000000e+01), SC_(2.1902271781867434879475079615325359430352e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.9689277701848234503083782721650057769639e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.7764407568114622135559094754607699381020e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.9529403686523437500000000000000000000000e+01), SC_(1.6082275635651116139041564271947395438616e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.0823532104492187500000000000000000000000e+01), SC_(1.4605807481783500715849221562776584303156e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.2117645263671875000000000000000000000000e+01), SC_(1.3304561423706586533888117869501400880892e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.2153301121523862313482574820783060724421e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.1131039103922523427411533756220334101415e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.0220203298224593537874082685745363929158e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.7294113159179687500000000000000000000000e+01), SC_(9.4060441082441367396037390083438962186616e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.8588226318359375000000000000000000000000e+01), SC_(8.6760664627983602056469845771199465786538e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.9882354736328125000000000000000000000000e+01), SC_(8.0196639915530512247358832167502790702000e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.1176467895507812500000000000000000000000e+01), SC_(7.4278141405871561824392218467923377775258e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.2470581054687500000000000000000000000000e+01), SC_(6.8927702334717041005168417775838360518285e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.3764709472656250000000000000000000000000e+01), SC_(6.4078749802564052275781318760033026037582e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.5058822631835937500000000000000000000000e+01), SC_(5.9674007334952078256165411046585365594523e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6352935791015625000000000000000000000000e+01), SC_(5.5663724864661427683445580241854502881837e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.7647048950195312500000000000000000000000e+01), SC_(5.2004734096686882685943429909228304145044e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8941177368164062500000000000000000000000e+01), SC_(4.8659373976500911812550094307443029049764e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.0235290527343750000000000000000000000000e+01), SC_(4.5594831565178386191651067138776370915643e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.1529403686523437500000000000000000000000e+01), SC_(4.2782226209260173247674541493211140317047e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.2823532104492187500000000000000000000000e+01), SC_(4.0196170850694408610197942112156871824568e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.4117645263671875000000000000000000000000e+01), SC_(3.7814369571987899385809215077672470731164e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.5411743164062500000000000000000000000000e+01), SC_(3.5617053722180565965278447145032542772899e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.6705871582031250000000000000000000000000e+01), SC_(3.3586637177683780639225308833005621590727e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.8000000000000000000000000000000000000000e+01), SC_(3.1707618880709916695698188279225134134419e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.9294097900390625000000000000000000000000e+01), SC_(2.9966190098997381564917900576320395954155e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588226318359375000000000000000000000000e+01), SC_(2.8349912874361375679870697845567148379864e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1882354736328125000000000000000000000000e+01), SC_(2.6847781762772375633649402172934284199640e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.3176452636718750000000000000000000000000e+01), SC_(2.5449929802141140784245154237009649074703e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.4470581054687500000000000000000000000000e+01), SC_(2.4147404701365809974706583884272517010091e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.2932247608719058719063246832245052800614e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.7058807373046875000000000000000000000000e+01), SC_(2.1797281865155125805626537539078146763368e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.0735952306127187787146556950723353143752e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.9742407365870616496835350191026931949226e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.8811343147115999135894138602281115339182e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.7937884795869599745315342621785790730431e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.3529418945312500000000000000000000000000e+01), SC_(1.7117665405476357328138525348496202786965e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4823516845703125000000000000000000000000e+01), SC_(1.6346708140050998795580231125563002561952e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.6117645263671875000000000000000000000000e+01), SC_(1.5621336484619831963146367366985846054613e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.7411743164062500000000000000000000000000e+01), SC_(1.4938262726068967937395801819861259016577e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.4294418781074615409676240292073143212066e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+01), SC_(1.3687043138823140045385569576270696707754e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.1294097900390625000000000000000000000000e+01), SC_(1.3113603476900997222635559165021191056851e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.2588226318359375000000000000000000000000e+01), SC_(1.2571737558746901699717322922081219043643e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.2059314311095242758125105422403025369990e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.1574372288719967166256553984687796931360e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.1115072544595633258623649582436065211658e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.0679752894177704002560230966125418215400e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.0266878243535384955291459276675622953537e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0035293579101562500000000000000000000000e+02), SC_(9.8750024162088989562178581740984923808329e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0164706420898437500000000000000000000000e+02), SC_(9.5028161651143588733514182683155389121756e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0294116210937500000000000000000000000000e+02), SC_(9.1491065417219905512542716396007164595357e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0423529052734375000000000000000000000000e+02), SC_(8.8127255494112212832347820137934197078385e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0552941894531250000000000000000000000000e+02), SC_(8.4926325498363033395542185005680241457432e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0682351684570312500000000000000000000000e+02), SC_(8.1878606345900629193480707580822776518336e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0811764526367187500000000000000000000000e+02), SC_(7.8974905698847238134092541541895614597238e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0941174316406250000000000000000000000000e+02), SC_(7.6206946180667740766339518253714629767024e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1070587158203125000000000000000000000000e+02), SC_(7.3566765438254545097321149654312661601389e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1200000000000000000000000000000000000000e+02), SC_(7.1047134603885385469328573299932709418007e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1329409790039062500000000000000000000000e+02), SC_(6.8641307318614392867097305973744416684247e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1458822631835937500000000000000000000000e+02), SC_(6.6342823767692515136431400241868648549768e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1588235473632812500000000000000000000000e+02), SC_(6.4145815698299314380944371697692946837373e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1717645263671875000000000000000000000000e+02), SC_(6.2044793341425261927868543569861226188924e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1847058105468750000000000000000000000000e+02), SC_(6.0034478228214473102434709941634822388981e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1976470947265625000000000000000000000000e+02), SC_(5.8110073467129733842009537779900473850856e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2105880737304687500000000000000000000000e+02), SC_(5.6267081426886050001175954615691144099642e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2235293579101562500000000000000000000000e+02), SC_(5.4501159978777144861774757883374112323387e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2364706420898437500000000000000000000000e+02), SC_(5.2808362479928542033787938621442966320630e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2494116210937500000000000000000000000000e+02), SC_(5.1184980676212069923052470793882197461032e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2623529052734375000000000000000000000000e+02), SC_(4.9627420212030382824876156256647537336622e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2752941894531250000000000000000000000000e+02), SC_(4.8132414191347266917523914135341347115444e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2882348632812500000000000000000000000000e+02), SC_(4.6696920122384391567016925355352539699311e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3011761474609375000000000000000000000000e+02), SC_(4.5317877424193244653036705828437079724128e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3141174316406250000000000000000000000000e+02), SC_(4.3992600933376106212575002147918618116837e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3270587158203125000000000000000000000000e+02), SC_(4.2718495890724970899617278560460492462852e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3400000000000000000000000000000000000000e+02), SC_(4.1493116354380535119964712447146513288404e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3529412841796875000000000000000000000000e+02), SC_(4.0314155337371727652824183199910956303575e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.9179488191544532854631254561915909425546e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3788232421875000000000000000000000000000e+02), SC_(3.8086952194182318905532692354339925235023e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3917645263671875000000000000000000000000e+02), SC_(3.7034659682133922177466771150453572025713e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4047058105468750000000000000000000000000e+02), SC_(3.6020774762321756155611302608166920945054e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4176470947265625000000000000000000000000e+02), SC_(3.5043561127953797878737167117310280641768e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4305877685546875000000000000000000000000e+02), SC_(3.4101419448426773969291458710261275935732e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4435290527343750000000000000000000000000e+02), SC_(3.3192705483440036770374101811785227456045e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4564703369140625000000000000000000000000e+02), SC_(3.2315991198625561456422392156699612625760e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4694116210937500000000000000000000000000e+02), SC_(3.1469880439107822737917303166781943848640e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4823529052734375000000000000000000000000e+02), SC_(3.0653049509665367669734407225296957705892e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4952941894531250000000000000000000000000e+02), SC_(2.9864242825299254942853505803316089674814e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5082348632812500000000000000000000000000e+02), SC_(2.9102304179983271568486708191594677309372e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5211761474609375000000000000000000000000e+02), SC_(2.8366030490562323668680699537071567089219e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.7654383812083954778408735695151595512877e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.6966343094437947414833070518167446198673e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5600000000000000000000000000000000000000e+02), SC_(2.6300937666240656248081853439028803741281e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.5657244358710171641560179309274220592371e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5858819580078125000000000000000000000000e+02), SC_(2.5034413713709780142094110312637688163918e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5988232421875000000000000000000000000000e+02), SC_(2.4431550950179464232603347121084388447712e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6117645263671875000000000000000000000000e+02), SC_(2.3847889804265535884711610073018821712984e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6247058105468750000000000000000000000000e+02), SC_(2.3282671881818647150082572221396727187789e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6376470947265625000000000000000000000000e+02), SC_(2.2735174449311328717711972090242147901442e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6505877685546875000000000000000000000000e+02), SC_(2.2204733120176144370198559944257003749431e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.1690640767287337959139017003343611410662e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.1192295877671870613468444971442338550519e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.0709100106866998268285621297651161954742e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.0240482184885413439347346586465846548889e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.9785896497720486159021048460509026479966e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.9344842244945312728788075290406248682969e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.8916779614724178864288364651114337066171e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.8501253381538894469010431854902404812779e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.8097807973902571200869557227422567367988e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.7706007542438728337737521271217216427118e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.7325434970982294718883473252567754783591e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.6955708132965269607148525994787693476589e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.6596409771467178353621143958771670629857e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.6247191271406040494553659070312060650682e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.5907701632873136129738682658952038158608e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.5577604420785844007561743410459411942280e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.5256577064664897490800925407964044753115e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.4944324722243060103582686323605744759520e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.4640521158474554308102749568120019594894e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.4344896497100548000173585441363506044244e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.4057177353467397974222015438032365497032e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.3777101235262221487799764837281131949327e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.3504428729819968699425767230210797389614e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.3238891934934621647636070278300569060308e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.2980271154166692743953217150314094636485e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.2728342690723031598028018112490909380323e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(2.5061544034743743720294572773491059009925e-39) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(2.2864680660418352419266392637710327357067e-28) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(9.2212522906836467441445415520781924921303e-127) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(5.6026995606334253939502103143774675916517e-69) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(2.7312453922369736797066496177596595373576e-38) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(4.2122781325318111304835831425686946213317e-24) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.4559400506167416618180077796748253231392e-16) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(3.8364571374523017469175367529881883493805e-12) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(2.3359544422729050455330368767278303029570e-09) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.6537791694447975588380053365704394512065e-07) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(3.1538387793138891275540477468076497014453e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(2.5921265209134895908814379446642704752983e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.2133214484379931351239293548819491148762e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(3.8468885705442186843004006693443839783368e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(9.2428898797866746374306770251437011875797e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(1.8142233707876111320502008111144495052609e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(3.0635750701532902744193920420090416091221e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(4.6160997947304892326781562215691415224200e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(6.3718056732715083490078390456970891314247e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(8.2146935915031917054442765671978820931693e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.0035391279203470849112412007266717114671e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.1744876377188823386460653288821581318201e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(1.3279647628197689877667198549652004398697e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.4601186156441198583083188608229119841493e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(1.5692233322344113308301103270715102206669e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.6551827966963132830507516695708427497816e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.7190503086505380791144642120080341117556e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.7626062226779043633244722769817049384631e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.7880311366814460916416030213745545416590e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.7976616772689443763926318468937632991816e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.7938232183352728170604303972578006778579e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(1.7787228477500397800559044413389191065617e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(1.7543855973952983476477412489211406210998e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(1.7226251029451531166526898298391392392492e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.6850328656383159444030655864990729689600e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.6429844253822084161660804843832423517664e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.5976521639994897627061716619768963806836e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.5500256244484239578645529872194383611865e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(1.5009283272851943453647206361442767198278e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.4510395147839554046341264091467857674400e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.4009153414816724208283532416250794804234e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(1.3510032103515290095125416406058833135772e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.3016596664124089414745629399560585237473e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.2531664090716985852877181507195255777566e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.2057392700696946608610953867395183228738e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.1595413341878365196048550721505632344303e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.1146910737788761921372185351459367648354e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.0712723120846817588831691697870405104589e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.0293377017037359423486599367704987569186e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(9.8891598897823473929621970890173784487044e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(9.5001805709017684562020396764503226835363e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(9.1263841292964847739579436611313213906593e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(8.7675820627121197967151189737707558426198e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(8.4235136007577189580979057662648474755590e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(8.0938446022747962610202744741936160752752e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(7.7781640567707422158467933841763972596844e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(7.4760456584677991472592457792095254934644e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(7.1870352126141821440634875440526232434340e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(6.9106414829962029666812287149109996139511e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(6.6463850016037413332326081421036158027775e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(6.3937826738045083904147322017134234997209e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(6.1523362161825032142941850675773299153289e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(5.9215718130014827397604044699988489432625e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(5.7010241480210684957994258851435355332345e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(5.4902242365274874476917545468022318295537e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(5.2887323148803893918463239107784429152151e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(5.0961224592975768951893215143719606415253e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(4.9119707600263498071367045421570511376093e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(4.7358871116962137282070623693775526509052e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(4.5674806632909977272395513508121321499559e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(4.4063893942174246381182178817888998633190e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(4.2522667488252163191115607444828276200316e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(4.1047712523964078188488110878389588686280e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(3.9635879530558541145666870454064164985161e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(3.8284164220059691217787194661836622223115e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(3.6989613822438856019366943590522709008836e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(3.5749513086021590728382105974361043525365e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(3.4561277471573432961320460532294014073321e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(3.3422369340047948385739049096833156062201e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(3.2330460407531010634865238993298041932493e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(3.1283337119841050966953105722254134374057e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(3.0278826056501612562897080005395432966024e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(2.9314936613454610430005639627130998869464e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(2.8389777341542446425651347940387618290484e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(2.7501489698131270469934909999646448530137e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(2.6648393665415293802422448787931336687328e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(2.5828815230875692540309996192451484990186e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(2.5041224741637722212632810811318572121853e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(2.4284168788083032446589320340529072674260e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(2.3556215871153336550219956161423816659605e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(2.2856059494639163732025738090489050775094e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(2.2182457869711247988250429208200556475507e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(2.1534185613973173626580884422160224021427e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(2.0910125603125260520704421909031086409332e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(2.0309215505324956177995864645731001448975e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(1.9730404769868890280304333209792416410106e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.9172736708253594826402512810986990162888e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(1.8635300985864054422881289002157787906600e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(1.8117195243367094516341847255858793512692e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(1.7617598649059296892369309717972403699769e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.7135740747938889441742066703122174177524e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(1.6670822106617380297864497240052391092625e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.6222148547867745299200553865217335874142e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.5789037491104368115170078093767597843116e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.5370839241867394011083459570656388165324e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(1.4966935246095763846471335605284941699106e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(1.4576754530976127075225293352327142045150e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(1.4199699187328007930491447989822272371049e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(1.3835253279780616342456966253092893932634e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.3482907234115736454568210919356239426471e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.3142175250640852579615923817428911277587e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.2812609357255308252819355771647366080290e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.2493736595713525095173778506271030916382e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.2185151153921233479561055101844776181099e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(1.1886450648858349859142012119011023205728e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(1.1597250948047511427074410594408177357587e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.1317185241926316629726456194094583031634e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.1045915760174418518873828421467897720115e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(1.0783082181923183149823846501117505096424e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.0528377596590717684948800868842807022517e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.0281496190602404058617217870423508417405e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.0042145546877201583756210227931385067398e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(9.8100459833597572882272560027404308095153e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(9.5849403839381003107552393995911894318730e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(9.3665514688092494449704797211149483882020e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(9.1546449193924485647569004856491493027234e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(8.9489860645153143355435861887759662175959e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(8.7493501583293426519098637537936008525295e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(8.5555309129246213609354618884921038089615e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(8.3673037572137318942502629744375969858635e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(8.1844802452125627595828079777195921495085e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(8.0068708234112345640000927847388945727411e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(7.8342937245688631433237778256342814100054e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(7.6665746045418439252175008384765174217826e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(7.5035537787511179907792266958735849367903e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(7.3450553620350624280643836775425676802691e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(7.1909330809631508124000564213458654211244e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(7.0410390117402936130213670625883218912561e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(6.8952310992291011357176730115607966097969e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(6.7533728918076008926619333568127048572780e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(6.6153397118864984510317566237475245155039e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(6.4809925560761002030851322114460447996385e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(6.3502169212718430485148646569766838605049e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(6.2228963740480400743653282588191270517935e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(6.0989189446721605005791649635125616669682e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(5.9781769317721187070620010181274607827370e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(5.8605721911394359509362605187088051057137e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(5.7459939198483923991067399325608171560108e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(5.6343517622046462131749078810935090913389e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(5.5255533200356524485273915061507248615512e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(5.4195096201502178977148152860718750390828e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(5.3161397829831904238853462641092231008990e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(5.2153515088097386739847719710715991474334e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(5.1170701929740408801661133113792010126276e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(5.0212191771417375700760952800514910581504e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1218012123878669574182067661152720350007e-229) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(2.5151377754158576334246266783177651111052e-106) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(4.9848743757836787695853217488591020327378e-59) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(4.2875972841974211992499549005125291790227e-37) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(2.1553455338203303277646684437935811251387e-25) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.6969484472509695914349516188864829781260e-18) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(3.9779234532560465371482356065119821368519e-14) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(3.3412234791569452528532018057682516947723e-11) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(3.6711251793087589356507397511027687975939e-09) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.0897310625459485626183951148369863020560e-07) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.3444017727301195668288923300910047754634e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(9.0155145801641299009526156960197097990965e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(3.9109756491496575072549055273775012241312e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(1.2333316453745486269613309369801048171852e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(3.0644142781034012767291117819683480609923e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(6.3506338725694628092084944976436897562039e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.1438317643952531126399663659718521375632e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.8456589495757297669684986320819144099962e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(2.7292528215298954739648221312576260378965e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(3.7630378809110039584589087090167134300086e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(4.9024366053167478295229968072376726113733e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(6.0977419077413494808152033458469329488504e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(7.3006799244681585851822061374869228633922e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(8.4688166097978537994426416897273261629571e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(9.5680012251889425878858427109006759208025e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.0573042095172612797274073465311804975165e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.1467347490494378889564013264379250156734e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.2241843645134648909103242014292035818067e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.2893590552391334058585042857569177979850e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(1.3424437326177596960199908290098190873555e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(1.3839693654869630047219231698100846937499e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(1.4147005730904624304827225414408254273892e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.4355473689719644244023489178894769987418e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.4474917900506196287692426319787352112082e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.4515349808026901242930744547715302970768e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.4486586769680460723812657740453107231586e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(1.4397992555143126375934136494412074358865e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.4258306051672504573735666060918464760261e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.4075555175197731811665711093274329186563e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(1.3857005962124322018678631887630985684190e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.3609162681097435993297446475829077242275e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.3337801561897486059056437521145245149797e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.3047993040012874984730313519799118661403e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.2744163087789712536487820940214737044484e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.2430141679516221323292006624868819807747e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.2109234269840548281874914831947346640462e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.1784255234232549762450971308466563946905e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.1457592061561318666497510755191101949459e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.1131267063425502820939979014232064903564e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.0806964062780093599844395091690224858679e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.0486066683946647132949031628310164766013e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.0169726643885404948740835272544471741019e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(9.8588779643541715489913258985374791366778e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(9.5542454639810000531286618128423813343092e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(9.2564152741467897521975612150421556028337e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(8.9658354336757711306768309712138380392807e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(8.6828164534650964947591079360416031164618e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(8.4075902443931295088303250029259663630817e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(8.1403042156467625568248823117724797020398e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(7.8810166122771285185187629719431688068564e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(7.6297459438555687764273254205321986964435e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(7.3864612368034417603964527852444241186846e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(7.1510742855457678593945786082911989630467e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(6.9234814655676632434786062433484900396967e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(6.7035520248014018637310866361177501065899e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(6.4911187556500824603322512204398250530514e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(6.2860184628807846426055180686451062352064e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(6.0880557775509167370433640053590375127571e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(5.8970407559735240791553612560646679163602e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(5.7127764240004535744771989410827772559447e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(5.5350488234946135246765094800609705411613e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(5.3636550389091035201063518055477613468248e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(5.1983911213278255613196103541389047387666e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(5.0390424183224083436267264881126743993253e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(4.8854080579139044874650914928082686615664e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(4.7372895511084097731068492714904963134294e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(4.5944816439627671482728727673844719613870e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(4.4567938425646178426188712969177417183730e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(4.3240398374861655382889861234304078359891e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(4.1960289941256605377474993675895348977002e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(4.0725853774165470451494999365033233884678e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(3.9535380458318463237633230618107383109500e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(3.8387132203090713845695966111914242888473e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(3.7279537404222491898690059920240636391168e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(3.6210973923392137232915557034043532924602e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(3.5179954044473699039326705265466225411809e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(3.4185041537798499765580087329074285089851e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(3.3224784422707316667239171453332392235037e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(3.2297854657842756407834910387044587550597e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(3.1402973028671435428866633283208538544417e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(3.0538848068051731877430372613526108067956e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(2.9704301232994468277415874880529069849567e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(2.8898198991240407745329868984010282757315e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(2.8119397424590844291481543988780399183148e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(2.7366854712666285093626806502071296093437e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(2.6639569769567987462563256754909885016972e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(2.5936532032262615464086716363142130643615e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(2.5256822795128983999039726640113928623923e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(2.4599575004465699308995906211197667069679e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(2.3963866276212721041173512157709515328699e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(2.3348903368298484508454712618773178109411e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(2.2753895745549616257379544911155198696932e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(2.2178085710391790553060184164339006753612e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(2.1620747052229704934690607701796761809485e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(2.1081208777536271748351880871382430785151e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.0558752896517288511460603797147930156948e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.0052765838637378941093065051019083951175e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.9562634683154158696784581346682869431774e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.9087771885483161258765429819305668333276e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.8627635549858961237614350905550071560273e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.8181642267515056675195855881133457369634e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.7749296286559781841981217209957828477051e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(1.7330101073005813435522174066361663542267e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(1.6923580429863674691627991746274935735016e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.6529277610236935759175106668442777280685e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.6146772238079064543480649210227029421044e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(1.5775607889915472960159402220259301684131e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.5415399533880096830686534022699607699698e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.5065760090585249615730969766888336548263e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.4726318038104585302171910090097570748352e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(1.4396716733081511574388135345727905685884e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.4076628640442806265487809875546024744149e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.3765694775740716224108698447774558624723e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.3463614672699831145585825858691137711192e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(1.3170085000544536377873525729417393800189e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(1.2884814343054007214423522564263915347221e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.2607535577726104090122032779714936913133e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.2337953450544472680438875038091706531813e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(1.2075822555511003465300737620702499412790e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(1.1820894213845958633153885460989368518044e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.1572929310510695406165316872252722922369e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.1331697886236558177350774232586419884828e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.1096989668028290644050496822764057437354e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.0868569725640545441554168773992785535390e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.0646244522332216017010355631382417451433e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.0429817000621073540226982444915524843010e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.0219097480924843615097006392341868640266e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.0013903352881887413205663816346511247610e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(9.8140680824675677110927094843636787359158e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(9.6194034827967226745249409830788797168950e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(9.4297559852259229677035708685192608053112e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(9.2449684386942994380564756785673043590892e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(9.0648894146673874568414384825788459998392e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(8.8893729729521118326047373472502932700511e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(8.7182864051995348758907355966556974907031e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(8.5514779531545022402511269425631852733184e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(8.3888250109443142416907647533413603519400e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(8.2302014514673166551573250188112063853455e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(8.0754856123211492637970703473180243118312e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(7.9245671479326082773762489239495500289705e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(7.7773185660105825838906239008368558450784e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(7.6336377651643209788672248038606251983226e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(7.4934192339953421962108072235539773750575e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.0141886197204473403361217924997856748743e-151) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(2.8739539709470753931571073613079307440752e-84) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(6.2135901411970236763108902954677901414156e-53) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(3.5162217979083405808616394271482399715816e-36) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(2.7931670046428655196530932757457227281406e-26) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(5.4959342404580313633971892035502364613232e-20) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(9.2871374133073217693394441244858593976608e-16) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(8.5444662958713382895064362347526511480932e-13) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.2049839468813148274810732135025169898730e-10) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(4.8188501363713144819389746249943685821022e-09) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(8.0203225327950741829400691731138147645173e-08) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(7.1263573094992812245826766924606346561173e-07) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(3.9951900327848852925895736177500362495241e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.5861568075666103234227319362184885300026e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(4.8394132907981464902523019212135392266893e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.2038371722733485439946612813603720295668e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(2.5505030469564053512719653102757514172647e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(4.7552974036811328859014015213936930213302e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(7.9992755343753603336642895070735750538829e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(1.2376489328312818859661282963150720201935e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.7879047415995099801512986681762114481170e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(2.4403336261170242452381288342992057871929e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(3.1770513405379408227396435220478547699326e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(3.9754242047725045061943328957755260322022e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(4.8107826959881494069981443700671514740683e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(5.6587808550781399262355871731948165215232e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(6.4971026668892158468657055482090680252508e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(7.3065101375880134354737031521649340941484e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(8.0714345119830507814527433467869208564917e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(8.7800490312774631114624421003044607024293e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(9.4240540301709810610952130957124283799987e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(9.9983527194020822525830144560614044546349e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.0500550577368883924100654394893430434066e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.0930475912126690308118188237239766303662e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.1289684735218584054760531057077513176959e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(1.1581058479874668393805517997215516879436e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.1808408638315686061436409073165239846014e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.1976155980210958328360558977968782450993e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(1.2089088911737063967307111257803437022745e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.2152148661867019777001492342285092316393e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.2170273333210581020484165820203630381401e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.2148285818104086377017393957731155982285e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.2090807100888064688326068222609038948936e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.2002199767663945987719873750581861028696e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.1886537545269680208930926327811558587394e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.1747580448333049140065697127317297697327e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.1588770659519543878739433313787710718059e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.1413242600169194033411678064109089385492e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.1223823752498048140169773331874174635223e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.1023044758019234236056242910365009954686e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.0813175406747685295671299741782002323837e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.0596233066052848207875494131330207511314e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.0373985972088005356058134136884905174397e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.0148003648233379854111463832314324469638e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(9.9196611783590655698335570433198697245215e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(9.6901410920261447914408575643449200560941e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(9.4604831598374368601128487810135079688360e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(9.2315845723557372621645948601975426873773e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(9.0041988466311714642110178369581948870512e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(8.7789821472847989873371078663589665312501e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(8.5564895764090272413285697112399737509176e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(8.3371712169242300145168658873225768895300e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(8.1214140899804768414303167634535319303191e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(7.9095354686578640666247189958368373268052e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(7.7017767368878669802317074413831449375028e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(7.4983457124218441218000012551234174210495e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(7.2993842545879785356273267496332711119148e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(7.1050081395717886519100278685872639237088e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(6.9152975559643723014844287626748029503894e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(6.7302889370576651507172814945388084856161e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(6.5500060282719729795959736103243297597362e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(6.3744496985523892415624444745367982851976e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(6.2035893161577419358194680206733793919008e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(6.0373904907212634358083300309813181122690e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(5.8758047120398050463818663404358455831984e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(5.7187606541885748618130528565673995240433e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(5.5661890009185534122077742582519145185864e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(5.4180122580762576109703311881496180125570e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(5.2741362452517129666514136786255332714917e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(5.1344723656974605057156188092425362698962e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(4.9989278126376344675032392986740280411927e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(4.8673974119738835896455508497866843943884e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(4.7397866131669340052420781833761487796273e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(4.6159873989155943464492642424158780199254e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(4.4959002129527898963111068096227862290847e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(4.3794250778915206540705859655267258520383e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(4.2664542086674576222839232392198591212184e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(4.1568888788053628742568017865368654146933e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(4.0506311467237353400165444383104246405184e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(3.9475769738054327597490334591965628567447e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(3.8476314824671065293290184738866702124978e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(3.7507012946003404026196849087390316653073e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(3.6566881539174259351512108674989389564472e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(3.5655027562388696970350385887235768928353e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(3.4770576835072383702112082289155914183669e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(3.3912615149120183758928595939654117412677e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(3.3080313860460080293484366376742911433581e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(3.2272883653247194075753335721221022955981e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(3.1489444717235142656683107901965470884752e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(3.0729255214204481951069977062344522471537e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(2.9991557738610187553938033363267056804508e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(2.9275617805130599439623601211537979857877e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(2.8580723596629831116558566845778538357901e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(2.7906216991174649077187783671285906116089e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.7251366902740413312713657105404352559921e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.6615559699669429100101224027282952904994e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(2.5998170578809652648218006506053968161847e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(2.5398595375744686602719761458365304529401e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(2.4816277133280250972174787654593847171089e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(2.4250596541451277418874152476437240367004e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(2.3701036162443593420515177161240291699330e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.3167069254861881176791266597970241035328e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(2.2648187103432313306253057770725871948545e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(2.2143898481124518022545607420530864218416e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(2.1653751905563439425902047761171617749316e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(2.1177243304657264306348813133502424184592e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.0713954166314707679915102935896413659497e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.0263457908509447730903495666178939179296e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.9825342817397108294726446671125237714740e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(1.9399211548085859091344932152350146821462e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.8984699919030381303605930945034076430483e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.8581398782137736003267870891531475746855e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.8188970834891945568713987459015723874489e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(1.7807071438651258318156538701084852046190e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(1.7435367999335432556147113360389675527814e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.7073556376620414426325385118609022350154e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.6721292676781476267666317505192826629260e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(1.6378295218323196762830066133285840938836e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(1.6044275434102348262682015706396136582416e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.5718954789652111964147523243814947821483e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.5402064418578822505688760242783486154103e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.5093359141700742332083988852600306817846e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.4792559272996417373903569724045221090650e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.4499437634539593196874807188737827856845e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.4213760627427941220825738195734041788261e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.3935302676912262783131999603548726876703e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.3663845937622231983109708551095148129403e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.3399192335029688413222437373407746486043e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.3141113683434229163713071302353575163759e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.2889426302818074565175093034765102926431e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.2643940526121665440308598296743193012990e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.2404473095764236355958169563641086084773e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.2170846928309040697509923320753537864815e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.1942901508005980302831861055980997875620e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.1720449932865098755682820549482615755158e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.1503343200016410751744224155954022745822e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.1291426741293691531044903543613808405950e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.1084551112661220856166290384870060241429e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.0882581220254334236450896166341847292818e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.0685358268756381217636241744315628342944e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.0492756734709865642271686234484830388489e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.0304645873395188986259450342784993865627e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(3.7556429678308691654796509849776214167356e-205) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(5.3528241011044342038192614102722425344900e-114) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.3113198423065669839859938112950397055025e-71) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(6.4663570337811693403108226414292329773488e-49) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.7501387027722689210498681357161599371121e-35) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(6.3021591208409502257535989326872638536104e-27) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(3.6331605044883489601256746739555712746984e-21) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(4.0679974117535245153087813685135830481314e-17) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(3.5853392654381843428487926282836555897445e-14) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(5.7162398930960159109319893138275753028996e-12) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(2.7708155439427234655497281425407929106977e-10) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(5.7207278296879427959921310266471338343088e-09) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(6.3090085898723171863562256835111940211070e-08) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(4.3463372169181874456909939039074627178833e-07) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(2.0897875710398897494328108822315789931942e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(7.5994165502580420558827628614388101726629e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(2.2177686786641059504850210508293723514440e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(5.4304822318877806815633844162200434550957e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.1542171980763024462834928422184469367322e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(2.1859809767465817125185662305408543555917e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.7654591284798046514169524686391950373201e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(5.9957925111927082112830289126437426953225e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(8.9403588273262198857531885927548526354958e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.2614792439346133174414926834234719157182e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.6986646326669305113426379922449680583916e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(2.1981636386135520026915317747426757488651e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.7493631073833496069522183507965271753276e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(3.3395935203001511854220821090872544616335e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(3.9552867533057323945656483918214509183697e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(4.5829210844424441856230822218586365045216e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(5.2097460518464872887202704723015521719834e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(5.8243484157708201937268975544848755664686e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(6.4169349728030678823205923520966722543096e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(6.9794843358488934439084490226707182221028e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(7.5057243374037712684943125771314708247981e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(7.9910799749353874132268189268099229004843e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(8.4324978153366257301281210760052406506481e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(8.8282448781605496657489628290547784071692e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(9.1777390127765872479944332356088779874785e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(9.4813316031403354282272367402971618148985e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(9.7401115368908346469858191895321096138515e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(9.9557563622528194720549006004007087423322e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.0130367538328259641512180505976314359935e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.0266347041361436237211465831948894113594e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.0366283517904929382766942315504534716795e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.0432873276046614687572777291695367967295e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.0468842527376168852218931244529230244376e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.0476891986826319754851951243087978805443e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.0459656951261500964388831797663023565630e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.0419671892562351798526104852364188730086e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.0359351179137439377746402607300756074742e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.0280974799020637681105208539714866577261e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.0186671728257733118035663528307853842931e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.0078426947970123793849961874007189154054e-02) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(9.9580769443811736993850897938410292890548e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(9.8273020905904201261882145315704911612150e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(9.6876482012174206968336849870785325632318e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(9.5405249210574743751151616238364042110072e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(9.3872013387269722909566269722534940418550e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(9.2288344486946242666026078963926262878170e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(9.0664672152803548003274585074246415950101e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(8.9010245856670680344328106607314122459759e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(8.7333444661891595049750677517937514857689e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(8.5641742474162389229679159651745583889690e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(8.3941660780953177928666119436038184691308e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(8.2239119680647985419203896128406991113821e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(8.0539185160065717011680807033618919018423e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(7.8846413118435475057474679473544837721739e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(7.7164787120200559752599139201360492591461e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(7.5497654870530295506045765832859918227415e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(7.3848016819367502672467332322862237924905e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(7.2218451876179213485908217178069779634458e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(7.0611046658061264101061901633566539468700e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(6.9027665193580714268199382929243962624900e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(6.7469866734169760677453532191460069401773e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(6.5938830529996658101995881286060232958831e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(6.4435605767004104227839776003593797405580e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(6.2961025140210157906889259027186808905927e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(6.1515627669982009235441999140290308531211e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(6.0099889229534434479241484427240100594355e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(5.8714134808858577788086249967151615658609e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(5.7358461396665674412211640456026167753326e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(5.6032980958172046750281153865798988938339e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(5.4737579063035595902808215539492218647081e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(5.3472148362992033913080378652600994198612e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(5.2236503203699516567259424863544099655496e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(5.1030305736644272555252190597225266669437e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(4.9853249998542526193764637487049070798756e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(4.8704979665748628271873214781368055613188e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(4.7585017276862443583123409766774508950476e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(4.6492933249736322833093274564113466021996e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(4.5428267520097079944252021725654763580473e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(4.4390462354616640488749548990873100755154e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(4.3379017562729098340241762827399875385566e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.2393416435797056286009023469424505650570e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(4.1433062397548812692636479147854844215148e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(4.0497421594211323787998839625034695521889e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(3.9585974529579726963933163044769117086546e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(3.8698071226431578322225672422955626667191e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(3.7833191239623075718869589792460772677957e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(3.6990772438942978739813277832489360601847e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(3.6170256163124122354156442940034446761815e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(3.5371088600680155064569742117935109762911e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.4592758203320376864763831806557719093904e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(3.3834650840859904783985082934739970603477e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(3.3096270879935260904637912952687208780675e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(3.2377094109606026159587250313606342230929e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(3.1676605532886020080161414956637958316539e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(3.0994331611884653353119187037252270458507e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(3.0329712800354967644733253628839621813310e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(2.9682296892005893272672677762628718461882e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.9051609701892713697191213169217673378017e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(2.8437187835095993981045057293479765892240e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(2.7838578792854513712602921286653757854943e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(2.7255368179561177692122653126175392444530e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(2.6687070412347271391607619854297143417787e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.6133293706973818453916403150925352585563e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.5593629286368777461138711417110201718155e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(2.5067679156917652025901862785546526273660e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.4555055993530059553182371685751387332659e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(2.4055406270086808168905844404993366152451e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(2.3568316454043252668800887833357189840978e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(2.3093454208310038857716771570639401512755e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(2.2630473354640757332196227483195050104034e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(2.2179037550311645230337831172268436283041e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(2.1738840590451469666098273267385976123887e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.1309523684464127133860138921260056030281e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.0890799794293297184077295012719307870169e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.0482369859758349022330392300841437736822e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.0083943605163536199474955761586659933622e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.9695239320575709142213700123796449241091e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.9316001311047385302971008895882492273496e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.8945928577887984561116494086309761447624e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.8584781903863989390318456263128458702655e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.8232311659166383965456007690379395303924e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.7888275695631908211677719117514491549483e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.7552439136101625140364818935170190641125e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.7224589445553770536739449301789631442549e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.6904474751886855170386446312426644059065e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.6591896408766423531535569089242338860023e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.6286646582909221287301994440599542363374e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.5988523711001085932130910257877561987954e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.5697332311456256548992031246273228337787e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.5412896059957082953411268075518822191392e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.5135004266998061867205971571317241476812e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.4863492183015538026148077323523576816668e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.4598186857921902102598576269080213592475e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.4338920547996886208492504705532982472236e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.4085542368787258842992114609785617586207e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.3837870613387663649036136433737741474046e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.3595764292465628616349167239558517772380e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.3359074914756242882150778282778125169795e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.2960703086602808109240810705975617400928e-266) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(3.2672007630797685465643659377416003762720e-148) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(4.0874314192662665644826215356315116632053e-93) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.3594584697328083970763518939286835104496e-63) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(4.2332173962243707195351494837610334999302e-46) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(6.0821911708560802895885010722693578634802e-35) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(2.0284465699815417006698562741165564608595e-27) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(4.0172517071370197444385113555386105239932e-22) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(2.9107417826440005631825240782517161724288e-18) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(2.2754301571481304370111189501232542250178e-15) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(3.7693643838116214702261369844827998891082e-13) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(2.0514644901419344046153779414170878048787e-11) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(4.9246657702401770993573109845556703161911e-10) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(6.3929842192845626401441391660953614033550e-09) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(5.1852333119282453877762746982381794991219e-08) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(2.9175714160376700917638478790057094395380e-07) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.2303921791864384139492747631281137953025e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(4.1214119956590898786291325246554549532490e-06) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.1462218669748484413598816380088067233221e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(2.7389087595590220553234118075467448081485e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(5.7757458293649330109594347019664137932421e-05) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(1.0979267960039528514107742322787838428136e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.9135172801158051574308777909486260890997e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(3.0997614885066125727111281185506606703566e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(4.7194623576213490893656585859542963984642e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(6.8153942057120633741580730132720810192513e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(9.4058981014302617540757104335600452570016e-04) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.2483628456608827041271275037859029352271e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(1.6017463246526210475398760901011906242943e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(1.9956230427951798137153055827688325663288e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(2.4233516751891410914360964695980888733921e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(2.8773295682749216734094757335176854212871e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(3.3494852799584305371496012620659459907587e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(3.8317347547783076604308078372185077560530e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(4.3163184396035075980724028371868125419366e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(4.7961032396678099981442579755486197020446e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(5.2647449249987163869128558924669237898303e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(5.7167741518916494902183903578318147754367e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(6.1476683920126961500995194312721949255748e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(6.5538235891618829436541298494713076307340e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(6.9324943907507732991839442450790364174304e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(7.2817523613144110255428831741815644648828e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(7.6003816094436452872941347247569469701388e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(7.8877954040517972903333576984385481245080e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(8.1439305632919023096467238747005025950601e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(8.3691785508489310622515923092438622157407e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(8.5642903495783205686843264368885105004909e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(8.7302954191797798792319920101808096669437e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(8.8684466061092885636203598159793972275378e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(8.9801591289197051091970474507768206883484e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(9.0669487936743930082608546544940635540115e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(9.1303997362379874141522447361342915918023e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(9.1721309662491842211366482631770459023975e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(9.1937586529474919494170200859881694212255e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(9.1968797006287444077947374783896393135612e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(9.1830517830994070145063525343053742609723e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(9.1537791882282136771416796071186009932577e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(9.1105045383862429066773842760995336155989e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(9.0545969817565337372816128395870262680035e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(8.9873537656862330956869666044983806243096e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(8.9099958293017520938179010495844953216397e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(8.8236602225627922705055592949226767990630e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(8.7294114957986280270452534368806744071074e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(8.6282384896453446099213159824323943723309e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(8.5210485304580770431299939705657746020997e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(8.4086872495614290211684272074412860527238e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(8.2919216268909897718328305403613344556229e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(8.1714616671404055513375653148270850828243e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(8.0479564469070821884896317549649753306014e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(7.9219886580299123410810759496056896531484e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(7.7940957814668414535830521498494630964132e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(7.6647651830531509492644942321846417480929e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(7.5344282945402195563266993418993568400565e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(7.4034823437657652484229803389745749967513e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(7.2722845434276204005734014668994169149425e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(7.1411458589797047193027059672784243022881e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(7.0103525328794676613859127787587450810916e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(6.8801595460756007873241745906997481859688e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(6.7507840506516486910165225877340591735570e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(6.6224262371153898294647381946492416645164e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(6.4952622886329293228046397663938129905581e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(6.3694376036956187143148032648752812852046e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(6.2450896661340531869057587142928301639028e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(6.1223261333730323793664169475398416299551e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(6.0012471200227443735571087809954038275282e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(5.8819377628200913664065851132642935570168e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(5.7644613752973049181104497366170448574310e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(5.6488776332175265977331738869228769669645e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(5.5352351271485962138006463971204944159863e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(5.4235646166963802093815584938784947627578e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(5.3138961117987096544734300109049958504520e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(5.2062515348864144791937568342124441641604e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(5.1006381520705655402275374384566699059444e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(4.9970645653694210127646902809078442516999e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.8955335739943582550600066743138470654253e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(4.7960358383312112652818339205750528931622e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(4.6985648189802694543511053837572041218738e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(4.6031121269098430866680623585729659767147e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(4.5096525011756337612002661661382526862902e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(4.4181712482880701715863358484731518839824e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(4.3286465274735036272714741178285508755072e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(4.2410542507879048837290983756805752266665e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(4.1553683999718243193659607116641399347989e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(4.0715652211776463749251920205200249049345e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(3.9896077612104033130071775148066287333322e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(3.9094698132101472745536196188052489777191e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(3.8311202278637275003159542776981543441913e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(3.7545270974660680151620802461122808422974e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(3.6796614148218603400622650704060889446169e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(3.6064831808812064534246587795777676650127e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(3.5349627230951206728546205446364379469714e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(3.4650666113602963971765359037220463807089e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(3.3967613359766418656738072350040210968434e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(3.3300134021427950641111750726003282123393e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.2647924543288264521083080669202549185525e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(3.2010591174870178539053112757259307238493e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(3.1387835165540447772773380322484447105461e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(3.0779329584969470451235209264184530352615e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(3.0184750936236891601562515602797123356332e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.9603779584566986275150564848288975130724e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(2.9036126591591159015860087319737346383469e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(2.8481427565897040078999769605892629446108e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(2.7939403549669707800644562724816860634426e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(2.7409753538641268552167609306984477976049e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(2.6892181751391192563125452426651825398171e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(2.6386421359945107676565128908864886721951e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.5892139748584206353048376030119499949631e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.5409081710083212776397784577215509420263e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.4936973553174370959806122864390047756079e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.4475547275290517866736373096145249256704e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(2.4024540585297028851098138838403168405966e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(2.3583717464424802827507362559924778094843e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(2.3152785470440010198727318685948079979929e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(2.2731520444951091014511703647708580684648e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(2.2319682845143787643178531642121102319524e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(2.1917038725769611707636312768771501858802e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(2.1523359682585841637046614806685929596356e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(2.1138440739849586227598307800335526992760e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(2.0762028073200295262745893587022365958907e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(2.0393927845750675500742390266463417143973e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(2.0033933105911630115973115046341572267459e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.9681842059753878599805486460594619508864e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.9337457980571256775451553423107549449305e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.9000604829099278349443488800656727998689e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.8671063962455954395591275622516110671583e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.8348669350342016072636703708623466528330e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.8033243581139069556886499621948433806594e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.7724613825863589105031151830257249244872e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.7422625827749034145929603111717978160617e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.7127087142207883003702592086383280382020e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.6837852485302191352130628592286288661656e-03) }, 
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.6554766357020603928135570330278427682312e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.2722265683018541399504448088111687369824e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(8.1333194191046675046908144276928649271282e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(2.1518147465015716398596072801593085608845e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(6.1140636300380031770543951512530202822387e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(1.8862271843935774029822447397173637838254e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(6.4042602352008092633759993753091883552544e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(2.4339984367626312713695862887699289500120e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(1.0580704201469745098186399340393289355645e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(5.4089752956507333098303731614888225674451e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(3.3715386154730328452299083607453543744412e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(2.6863872853414020696329527647117831238537e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(2.9069325383022478505507231409286795544877e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(4.5880029802050768432540294134693238331262e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(1.1196195798391992852227314391493150250461e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(4.0089841404810694922084248028712087603288e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(1.3832692655070119482088265904806482071286e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.7339323312204572654732500619134036592934e-01) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.6433239268652934765607410046647279946799e-01) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.7308887590614707121207072953474374490534e-01) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5882358551025390625000000000000000000000e+00), SC_(3.9017993834785329011341425703289831408017e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8823528289794921875000000000000000000000e+00), SC_(6.9099050627882331127325887835812050683435e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.2159646750862533651879036958047771904045e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4705886840820312500000000000000000000000e+00), SC_(2.3286595277737961462732191113302537692536e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7647056579589843750000000000000000000000e+00), SC_(4.9903334111998330968218130776864042567419e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.1995045211415139320954630479094408516027e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2352939605712890625000000000000000000000e+01), SC_(3.2105216281658449190471028934710717772107e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3647060394287109375000000000000000000000e+01), SC_(9.4715790464410909728593996123115531413179e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.0479285808538235337426890448561158045562e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6235290527343750000000000000000000000000e+01), SC_(1.0595226636693843538638032522607756327805e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7529411315917968750000000000000000000000e+01), SC_(3.9444606953071927455664753560873449173538e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8823524475097656250000000000000000000000e+01), SC_(1.5608823270532041082203633798111404380628e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0117645263671875000000000000000000000000e+01), SC_(6.5225655948832361527425123606457592046355e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.1411766052246093750000000000000000000000e+01), SC_(2.8620974518678482376296231124216598870298e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.3123500715808794811349911053226688273318e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4000000000000000000000000000000000000000e+01), SC_(6.2613955174596533409238436079890828909147e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.5294113159179687500000000000000000000000e+01), SC_(3.0970751173681390866778510353166482766024e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.5830300688092463999222286673176897389219e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.7882354736328125000000000000000000000000e+01), SC_(8.3379269090746948654027844672851038619286e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.9176467895507812500000000000000000000000e+01), SC_(4.5141806569872971089305819379349850212980e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.0470588684082031250000000000000000000000e+01), SC_(2.5066418711433700044182683878893449820385e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.4247934949886599308454972578471269847852e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.3058822631835937500000000000000000000000e+01), SC_(8.2755693187755444796012393354423295855455e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.4352935791015625000000000000000000000000e+01), SC_(4.9040578571538130204233125404185694774565e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.5647048950195312500000000000000000000000e+01), SC_(2.9608434848064029123450268679165193232144e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.8189767716308300188751343575067416558067e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.1357965885936202060906080867974218849464e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.9529403686523437500000000000000000000000e+01), SC_(7.2008595041818991940507055291207908966836e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.0823532104492187500000000000000000000000e+01), SC_(4.6309307601199067213387687174282856566643e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.2117645263671875000000000000000000000000e+01), SC_(3.0184574164028990636309354572699040829752e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.9924732066939622211234631405646089763234e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.3310036677685184308385129488826827164648e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.6000000000000000000000000000000000000000e+01), SC_(8.9920240025905577402116799048427265735760e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.7294113159179687500000000000000000000000e+01), SC_(6.1399946990921451302176785653945135231522e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.8588226318359375000000000000000000000000e+01), SC_(4.2351242591608311384655813634625604421249e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.9882354736328125000000000000000000000000e+01), SC_(2.9493468005965648292185514938934925966569e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.1176467895507812500000000000000000000000e+01), SC_(2.0727317292312560027077581661748407541565e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.2470581054687500000000000000000000000000e+01), SC_(1.4693437306168666602518510074831296244793e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.0502339543169808403479392020050957519917e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.5058822631835937500000000000000000000000e+01), SC_(7.5660263394345280833067167845969785505770e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6352935791015625000000000000000000000000e+01), SC_(5.4917616547648113606171770320799053928827e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.7647048950195312500000000000000000000000e+01), SC_(4.0148790764881604236875664982288757744367e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8941177368164062500000000000000000000000e+01), SC_(2.9553776659857287469628414284907087692393e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.0235290527343750000000000000000000000000e+01), SC_(2.1898244783708194616798042141682652703699e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.6328289089945736066184837487002825263639e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.2248806124864886428601624352851686467962e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.4117645263671875000000000000000000000000e+01), SC_(9.2420068295634592457904831435254264956274e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.5411743164062500000000000000000000000000e+01), SC_(7.0122781431557491655734612378970888105325e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.6705871582031250000000000000000000000000e+01), SC_(5.3490268118207274163286534811881089109721e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.8000000000000000000000000000000000000000e+01), SC_(4.1013610206191504113580502241878423628470e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.9294097900390625000000000000000000000000e+01), SC_(3.1603725049513654041993753313586211658160e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588226318359375000000000000000000000000e+01), SC_(2.4469304056155546780725369835501657064532e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.9032957872374376396623081642761799665963e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.4870455343782194644003521758666004232303e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.1668193808771730633530378113577865222253e-16) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.5764709472656250000000000000000000000000e+01), SC_(9.1935547499750600675485166878355007400617e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.7058807373046875000000000000000000000000e+01), SC_(7.2728704168112122341090413402804521332073e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8352935791015625000000000000000000000000e+01), SC_(5.7757535830487649028320713996578103177107e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.9647064208984375000000000000000000000000e+01), SC_(4.6040470811269135104168919858536782205489e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.0941162109375000000000000000000000000000e+01), SC_(3.6834049414157144161678566614899192315213e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.2235290527343750000000000000000000000000e+01), SC_(2.9572204955149808228449393471171398985965e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.3529418945312500000000000000000000000000e+01), SC_(2.3823060894777276736106003548397136466108e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4823516845703125000000000000000000000000e+01), SC_(1.9255203763220241885050352596091722464358e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.6117645263671875000000000000000000000000e+01), SC_(1.5613057992671540889422519911021433426160e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.7411743164062500000000000000000000000000e+01), SC_(1.2699314370155610592185025204698282065916e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.0360517303461427214150933536339294518822e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+01), SC_(8.4772685431651445145776288536817362503195e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.1294097900390625000000000000000000000000e+01), SC_(6.9561625349427344780590808270648908387182e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.2588226318359375000000000000000000000000e+01), SC_(5.7237963226786833457839090920024014083390e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.3882354736328125000000000000000000000000e+01), SC_(4.7224590085681961318167095985778940861972e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.5176452636718750000000000000000000000000e+01), SC_(3.9065369799230404289891315901042013273998e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.6470581054687500000000000000000000000000e+01), SC_(3.2398209043557959144858344421656899757683e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7764709472656250000000000000000000000000e+01), SC_(2.6935685933697984149031537272227684348457e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.9058807373046875000000000000000000000000e+01), SC_(2.2448469896109117511187864970772732421774e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.8752808309069581691265072474734570084999e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.5701552201453062690551368955573079766917e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0294116210937500000000000000000000000000e+02), SC_(1.3176264011423034602638361680480849281151e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0423529052734375000000000000000000000000e+02), SC_(1.1081223052005629522706149119358157400931e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0552941894531250000000000000000000000000e+02), SC_(9.3391505777476074991140870883458658955832e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0682351684570312500000000000000000000000e+02), SC_(7.8873416141065260953009766927738609620159e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0811764526367187500000000000000000000000e+02), SC_(6.6747109091772443158833706388694405419817e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0941174316406250000000000000000000000000e+02), SC_(5.6597258427392620266637370352375197994278e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1070587158203125000000000000000000000000e+02), SC_(4.8083488953261479585293010430056827193968e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1200000000000000000000000000000000000000e+02), SC_(4.0927619810104943714808721535407538010266e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1329409790039062500000000000000000000000e+02), SC_(3.4901156811484878961713670223352472737735e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1458822631835937500000000000000000000000e+02), SC_(2.9815672078617624544481137322281602843078e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1588235473632812500000000000000000000000e+02), SC_(2.5516139699485537677998638793864188271684e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1717645263671875000000000000000000000000e+02), SC_(2.1874370913477893397738367742489289248138e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1847058105468750000000000000000000000000e+02), SC_(1.8783948254696203937165498700570578546342e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1976470947265625000000000000000000000000e+02), SC_(1.6156774093538062914304097446737032898469e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2105880737304687500000000000000000000000e+02), SC_(1.3919545919795625186026656017248528899113e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2235293579101562500000000000000000000000e+02), SC_(1.2011029462792463168245883572613577436250e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.0380237764529696607964886143314906302191e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2494116210937500000000000000000000000000e+02), SC_(8.9844979604004990905977679030688463697952e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2623529052734375000000000000000000000000e+02), SC_(7.7879527885265752012356727960944950332102e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2752941894531250000000000000000000000000e+02), SC_(6.7605835154900322681377136828396693307033e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2882348632812500000000000000000000000000e+02), SC_(5.8771474416855169720291205336577051103476e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3011761474609375000000000000000000000000e+02), SC_(5.1162583440045205018390375508197988729911e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3141174316406250000000000000000000000000e+02), SC_(4.4599783317541214252746972285126929500561e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3270587158203125000000000000000000000000e+02), SC_(3.8931024125542654729060701362225755612694e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3400000000000000000000000000000000000000e+02), SC_(3.4027530762372491742994145388864007137967e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3529412841796875000000000000000000000000e+02), SC_(2.9780063718253789081284241078578230475510e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3658819580078125000000000000000000000000e+02), SC_(2.6095970182542561094052429187934647695764e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.2895923438973046720686213734069268988111e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.0112795746485449360974782740686070836834e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.7689131670008101998168986698937314427159e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.5575818445064357900498415409355895051376e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.3730895269607900154018600673333283808880e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.2118149040276128104684403160261313291212e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.0706734155020576752882670520971464503810e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4694116210937500000000000000000000000000e+02), SC_(9.4700554044296487931426781811103990068079e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4823529052734375000000000000000000000000e+02), SC_(8.3852205465178294343578459080160686932496e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4952941894531250000000000000000000000000e+02), SC_(7.4324987343478388098954668793863481044708e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5082348632812500000000000000000000000000e+02), SC_(6.5948989208646596140900581905608803369890e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5211761474609375000000000000000000000000e+02), SC_(5.8576283662642705515518291507921464595049e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5341174316406250000000000000000000000000e+02), SC_(5.2079983167750333004819329482314644577997e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5470587158203125000000000000000000000000e+02), SC_(4.6349804989859459052852399494388493629304e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5600000000000000000000000000000000000000e+02), SC_(4.1290099606793080523026947753415626044394e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5729412841796875000000000000000000000000e+02), SC_(3.6817810361163220826026027789459796900082e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5858819580078125000000000000000000000000e+02), SC_(3.2860906650402563777242822024502271177607e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5988232421875000000000000000000000000000e+02), SC_(2.9356172181328447727430198849235679833847e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6117645263671875000000000000000000000000e+02), SC_(2.6249044887723915850127766860080353479325e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6247058105468750000000000000000000000000e+02), SC_(2.3491756488118964780101559662107038663624e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6376470947265625000000000000000000000000e+02), SC_(2.1042592298976939105364723828664951763979e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.8865181597142929643347825267068271164533e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.6927405899939424495323792251127055812419e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6764703369140625000000000000000000000000e+02), SC_(1.5201415219093291239846579743982786055763e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6894116210937500000000000000000000000000e+02), SC_(1.3662690877726338136107970146435868995315e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.2289709284677320515588750175600924012410e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.1063557227289575830519433272607061577191e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7282348632812500000000000000000000000000e+02), SC_(9.9676478197974989795764690706949522269651e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7411761474609375000000000000000000000000e+02), SC_(8.9872315462720213321500723140354354821695e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7541174316406250000000000000000000000000e+02), SC_(8.1094552543079902471461498120746181877250e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7670587158203125000000000000000000000000e+02), SC_(7.3229329837991520882933063992831239411361e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7800000000000000000000000000000000000000e+02), SC_(6.6176118912362527685322973707695750627358e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7929412841796875000000000000000000000000e+02), SC_(5.9846080741661036710561305685058746652999e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8058819580078125000000000000000000000000e+02), SC_(5.4160890034694532689161881735605050579355e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8188232421875000000000000000000000000000e+02), SC_(4.9050446977999526682330614500498886093215e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8317645263671875000000000000000000000000e+02), SC_(4.4453393631251879133789623494775852289938e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8447058105468750000000000000000000000000e+02), SC_(4.0315065086867393422372101595913378250009e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8576470947265625000000000000000000000000e+02), SC_(3.6586941686620971028346472253832533759156e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8705883789062500000000000000000000000000e+02), SC_(3.3225922188767071893626817784725160075431e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8835290527343750000000000000000000000000e+02), SC_(3.0193822911752308748696220184857767016823e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8964703369140625000000000000000000000000e+02), SC_(2.7456263149974482374481086481253040201198e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9094116210937500000000000000000000000000e+02), SC_(2.4983030994008979343779294096507997770559e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9223529052734375000000000000000000000000e+02), SC_(2.2747067536411290345871779419663487317754e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9352941894531250000000000000000000000000e+02), SC_(2.0724239111954293106863578439534501068198e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.8893086651948107983832633611418431331646e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.7234196255882658844398062717368044794225e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.5730457722879286279253669578004043267866e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.4366483305677638206421413734382168078302e-22) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.5543659992700060334562748043161518712006e-58) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(8.9785040793964115699071696387248999360184e-58) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(2.4229509784713861001061397357309357509251e-57) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(7.0562248285530400970898927221770247303017e-57) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(2.2458202450334947331481673883940916142590e-56) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(7.9380008863041638753887966074510292210359e-56) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(3.1812756214290040574340136104322033713697e-55) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(1.4860275521985382347980707061805822721066e-54) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(8.4016543136119174098055228276455254985712e-54) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(6.0647760497208898385868188262852904726870e-53) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(6.0497399570559157603498299204162276591325e-52) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(9.4403301949596829444849392216070467836222e-51) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(2.8412216124916626457072925183662568787175e-49) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(2.4370495334708090000388898202263542536034e-47) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(1.3629507520139748732492532614915727538526e-44) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(3.5107539038250296462847466107051688607551e-40) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.2353338694680043005600061197164077252522e-32) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.9553312075037872996265908437337255862335e-23) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(2.9248727378533714561608659799739731793896e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(1.0868164632370675064618652479268586791153e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(2.1981089206648759058174836365707068629106e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.7123401219546352861685617309094880325134e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.9362358057135487174269505861924523871407e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(6.9615117710790291332844243846648899648295e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.2522967403919661013673244757388528046561e-01) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(1.4700651071154082547572323837448685140685e-01) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.3208301259301815721320154919203806683346e-01) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.0020831560915541736208933306049143697605e-01) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(6.8302274923355272510806789148147176264799e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(4.3531100255127248310561502361789261015188e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(2.6631317387850916246731069524203100564011e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.5914613166718226914055786192694179692019e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(9.3996865040877395387609670694059975283296e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(5.5309607156017225834423950153495629236767e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(3.2598589752676668544566904996016071771654e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.9315029092361580485821814786888967308152e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.1533134120040604252276861044707912996603e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(6.9510404717153455205195229752618122547424e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(4.2329260492521330891217623880447591804179e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(2.6059894371037509662591416319513797129867e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.6224647199475793553474251950001707740334e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.0216040891829255656598832809001952724398e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(6.5053405856162838274765184339747220402976e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(4.1885625307777205416567582264130255905788e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.7262380250233925955898263231307423958212e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.7932838447052529478922706048775328965228e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(1.1917470978327676333866930483366631444368e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(7.9988042081747587187224990355460909715131e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(5.4203904979551497036041786462688956316073e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(3.7072543183142159224041837260076381810710e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(2.5582650876661691717781490219329948796863e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.7805983008213078291572582102550606358762e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.2496220216457125538808817589042735994661e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(8.8399017830593682720625984793534138981137e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(6.3014553624688861097966486703689449655411e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(4.5251986060309073842745607757122425181246e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(3.2727760565117192177159166781403123541427e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(2.3831999717984078291020908251731122401129e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.7468827176413568232659531157634892290148e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.2886042880857513477577148186958134512072e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(9.5637412281965514294907892042226217516035e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(7.1398883455055444516390640052550649130900e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(5.3607083442968774338725461991214307849862e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(4.0469849074434519494376228585554763162808e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(3.0713919938304233349723958735598934437024e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(2.3429165797536206360027357237861196663722e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.7960594587697823330479029572261079620975e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.3834095794463807320646742946570154801247e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.0704859746406905073971334374572025467660e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(8.3204763899784458233189267743194807541113e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(6.4950802078809548216928826247429032268447e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(5.0913461834695637014689839710615918264110e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(4.0071690909179409726180222453902659944913e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(3.1662118328969883199625527859186401549337e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.5112480227304458420265397282110844296784e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(1.9991195863514917332882134568913302701116e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(1.5971099027601058517088094310993424720476e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.2803658484528440990302266269433393550887e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.0298993433340635471800680018703279773963e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(8.3113242290156018640126765111581754254644e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(6.7285606320808381454328091220862017446805e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(5.4640402389244670085429478626149053584788e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(4.4504490314081731248320921493084775333532e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(3.6354686043538563722769883626073187881179e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(2.9781395921938180781453789953284792399838e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(2.4463963204860753800133218344240492381887e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(2.0150038473617978879328650708902421933636e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(1.6640167617365244667355440443587341930147e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.3776688648110684048391000681194338005969e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.1434334452986689348545463970264380560703e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(9.5131587277677971191153978820047574941708e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(7.9334490493094760388525193691222534425808e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(6.6313089786008587606257943907089147887866e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(5.5553103318523512679650964364334481560678e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(4.6640962525543670895929973009812692026854e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(3.9242423848608235506868434500428223732164e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(3.3086269132868499213782251467377713029771e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(2.7952715909826334073274031157960156148557e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(2.3662775498701380744610824453829253633749e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(2.0070103750651490183115345935264625908928e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.7055327366243572088743211994027691419784e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(1.4520286313449218328797964355951154725526e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(1.2384508105689317502057082452049164166838e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(1.0581691431137252709931957350973562566757e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(9.0569963295870602747096629367698329431023e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(7.7651786027996556690741139628176873313393e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(6.6687232798229723605525258244842387111103e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(5.7364020994978020352418099969845693640203e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(4.9422979498556827209448307961113146203904e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(4.2647924471207371985048486196537820227340e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(3.6857817763290665367208671356569485786905e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(3.1901575582257476350055400704960485216384e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(2.7652464092639264072622935861932479934155e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(2.4003751610012672791433005916570394550674e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(2.0865901620960633852048002787409721644606e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.8163469286511438042751797459672642907603e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(1.5832400781631782632874830002569493351408e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.3818873493901990145141086849552900054998e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.2077177125839946026028145918239714011146e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.0568527910743319163861730603873836508725e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(9.2599675256788425316941959394660651261887e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(8.1234950085327363911247236700120038245752e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(7.1350938372548164965568129661332456202320e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(6.2744104760064704327740502963196822109545e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(5.5239958288856320812863025799710620171473e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(4.8689115995969973069841126683848379586107e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(4.2963763176050396348979825522465346127470e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(3.7953419710450140258162837506926390266982e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(3.3563860287814555111627754586820387988403e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.9713728177990876214793413195421438941920e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(2.6332900730072833272097175355002685252919e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(2.3360860521150739730322811665080058990917e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(2.0745429421705797195995542571560212036713e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(1.8441118566179923283732053758619872728078e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.6408867108332907912017382263368119812222e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.4614684436687366145779145530021092590466e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.3029056398541771195716232660217143776910e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(1.1626326006955647133308800537129971757825e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.0384218987169051329410172744461198192263e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(9.2831636635538150885667177452071879868448e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(8.3062523952502333329438410271946578414482e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(7.4386671769224868877837106658063628235850e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(6.6674551176165688512124018611334634643684e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(5.9813122549229561167661405679258336450596e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(5.3702456386697676008564955252845252329245e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(4.8255835293601404828445206352218292936542e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(4.3396842826017113227408945733213698892261e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(3.9058338504977100206550382012796896879189e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(3.5181274188853900502640939133351750682917e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(3.1713823354260537460531153080926251099006e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(2.8609857224770410101534241526282543007023e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(2.5829150888083961463930223560490956070821e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(2.3336041680213295781408366332455925136964e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(2.1099018424568891195567308360654700739337e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.9090213249092317076019679397835941466295e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.7285039310704545403399801805068253940339e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.5661473411916986909672062296494616034086e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.4200227747880897281320839437147373731204e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.2884105916732295838650523699573389843596e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.1697834445300540099831119659517624315998e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.0627836613374028556114365946821067856175e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(9.6620774415519078457305967509021443805428e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(8.7897124691358319760782811365352833893234e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(8.0012075041682170536786697683492723047851e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(7.2880178285578569140817189087976985242209e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(6.6425179527123953608642494536230527365522e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(6.0579238044534342806620810089459251998525e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(5.5280936432946222541808075863797006619937e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(5.0476121934872322545108544849802943638893e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(4.6116064475694367234785888345387853365527e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.1629888682299414510060801387884088007852e-148) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(5.4727163568347891155552957379460640278922e-148) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(1.4798338237474205553351020782214580637432e-147) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(4.3204252317482339132638556311035458254195e-147) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(1.3794607808154046896465316594356082572296e-146) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(4.8959506497469548771275023558802660375860e-146) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(1.9729251487009873612043026002171496239169e-145) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(9.2854523566498478673361087029625362405135e-145) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(5.3062337701564452400766053596412361955756e-144) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(3.8918393186156509363492928012562675158735e-143) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(3.9812504955834474995373360787309477923841e-142) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(6.4869124539466737973797149349035189213358e-141) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(2.1215563273911814084491894125515340387942e-139) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(2.2005396572632361063414660330116780711579e-137) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(2.1860314719181466203632112459268970567533e-134) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(8.6722428774458464995322440377988351640780e-129) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(5.0084289956967608529164404663995891572309e-114) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.5569748551797984505280596392179922049627e-86) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(3.6545379728652936010992600441634336858190e-58) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(2.1890471828033974702939099615917593466997e-38) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.1658436405544162222985201721691800022569e-25) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.4049513050717144296556468510225210347261e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(2.2962613489760323521279472109924262255973e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(6.3155432869378000081868746703066234050005e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.3088632675492873650376303556225812957766e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(5.0392368199803906668811220743271828282707e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(6.2902245012093753809144682292754221607178e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.6250298578515338234543581229306137225173e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(1.2147615962200684541624044739900572339383e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(2.7624320661544549584940783716764468850777e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(4.7389678520443487269704646298531200883174e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(6.6045483147454431931680021489373787801564e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(7.8832498757705180572575253196916157784990e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(8.3732955831417829197992868366580082604758e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(8.1404310001324216030088743909229053424926e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(7.3973176878202549286279635978279845228281e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(6.3833816493291159125341621908468454743507e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(5.2943788908282239363666590375981770590040e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(4.2598589418539859123231315250152366370379e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(3.3489810524398914998284677185549120904180e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(2.5870598383264668705022489818186630949822e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.9723790924153332471822839578491128117284e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.4892867635598587555714411029026911939765e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.1167846737071955373689720432192493999694e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(8.3352277186208794468252208118350981607740e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(6.2028032881585267870604446986039802856005e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(4.6088177346147623702628386672515735151818e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(3.4230153811061396058293770316620901494054e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(2.5435479786937365172982155729705927288187e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.8923167121141985148491102267935631106748e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.4103269109514088123313683086771602986111e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.0534509306530655413757891608578411461486e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(7.8892660909923331303391694884848173668080e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(5.9252596297781165879340960293808166847236e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(4.4639530531547362285993547966362960180727e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(3.3740215376064606231616499201319092685840e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(2.5588427941134469255818178523902574632604e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.9473461916516452630475412066279940401835e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.4872173250097357762192827911263088433374e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.1398581499388391051575215820945803513072e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(8.7675577541828692714808757182483906820164e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(6.7679328270828104375043508222171032054673e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(5.2429953630928243943618524403558202100501e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(4.0760248239320378507629301409736333290557e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(3.1798916931587538442843958275094046262588e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(2.4893793008026612380548631313978590151456e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.9554790629360954150189464746977065673384e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.5412505252515464169297527893473502582634e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.2187948988117653315638947118264016030656e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(9.6694878089827953398185385871304291237811e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(7.6959458833982089732702020351405791646751e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(6.1444505348056536800541810217764259694343e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(4.9208820744837404528829445075614503233543e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(3.9528568226309505804439323113823576231807e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(3.1846638370400308671901969214864004384965e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(2.5732182231168837361286873384876117677249e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.0850665124156747288779035922729650768323e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.6942210040885285982963807428235210934416e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.3803964883947446374126520732483975722880e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.1276962476564497076653344301500356910496e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(9.2366080337207978163946966877228459383227e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(7.5847784309653916819668678976281562390166e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(6.2438955191134774835594153231182073938351e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(5.1526606580363426255290344403407994456099e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(4.2623004270360525589138399377928434917169e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(3.5340525785026314272057605794720017244209e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(2.9369640588418521722192031106014702798573e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(2.4462228108648614464849586530825052062772e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(2.0419562328283886832930213585270562482577e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.7081719387246941697131949985110448905540e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.4319511399177283692001063139496286822541e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.2028708289630902325682949078423870822206e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.0124814613565149103298352054025850008672e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(8.5390739074893428270144016888291725594434e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(7.2156283334842405319923240546165288448940e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(6.1088813982600305062821834068733050315209e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(5.1814724863170488435714189090630501889309e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(4.4028514937002134004012437194491674830516e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(3.7479168167750713338674270905527153701406e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(3.1959657875992432264788453320746552474300e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(2.7299754906934674738264990885466784969984e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(2.3358336123369045141105206363300453327114e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(2.0018839860860038461213961899360130013126e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(1.7184518923627184687667690020853893771998e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.4774766655465663509636874747565314607711e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.2722633641512051793858128615566149399871e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.0972237315619993125797249098893705045249e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(9.4767533672757215686133704656816990353516e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(8.1970860542352531354721747545535221035839e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(7.1004277179548982453710329331696143631070e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(6.1591403046665576662037128975444755387652e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(5.3500327591241423578602457514536156562539e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.6535454532449390308330167064688649774174e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(4.0531163697643049011708447268000382525755e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(3.5347830305187251964558352620408387553560e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(3.0867225723294092124671717451015293879333e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(2.6988459384064427925248552791407206853303e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(2.3626389008058775589326658282033285523008e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(2.0708370110187357051225838086949380590314e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.8172495987466155557755819522274091699991e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(1.5965934745938221358423562627681707378144e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(1.4043619948850207166506366888942729045467e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(1.2366731212638115938246610405559509114369e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(1.0902251536347086627877374976780192237728e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(9.6217649676466085637533146287093298756261e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(8.5008548777018604445926737284680154685238e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(7.5185571757490718782627058924079410789347e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(6.6566824625525685344561901422668120515904e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(5.8996700146537751217520790484382682575623e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(5.2340384754024891865279190591782712664841e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(4.6481308008797153484626067885553259423305e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(4.1318553043491285613896809868027591072265e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.6764853062195126605935907341452994604760e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(3.2743880953569925542551762528582311457254e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.9189927339070778250105905644397536761428e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.6045644987009783699505835301826663256694e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(2.3261102760923880281068521299083409863770e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.0792779084714898741494305754925571920200e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.8602795613305175780450217746897018293968e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.6657775472221602824584371612435771582697e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.4928822682007314114542800911176624497094e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(1.3390548509859683274066046689319445823246e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(1.2020707525343019158654491882774522700209e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.0799843320777425666373391666959237767988e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(9.7107122510494597421638495921357210969516e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(8.7383224148306351234459093984146349047135e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(7.8694329777283385933445994960515341649635e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(7.0923860209994073555654773059142805944347e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(6.3969077703728607582238866455570596601466e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(5.7739637638764698875263524008141513051826e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(5.2154946934725350414583262543570916227657e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(4.7144615195089265443650285942686195961440e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(4.2646112186617020742994422590081954798435e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(3.8604085970254730108149221781353928813085e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(3.4969496983015800726377803090245530252075e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(3.1699007841854770354933130564125869628644e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(2.8753722143899555094149968373422584645581e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(2.6099528288034907715441207956700737827786e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(2.3705960336550365743909979432048679387385e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(2.1545915772381449933529691518850906935514e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.9595265172747111942302789682484684745314e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.7832588368952317986022143383968188049936e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.6238549422287220154600439494658207315463e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.4796128883329195956628274772533650833882e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.3490049945513680877987599634848449849890e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.2306660001510944450955014157327193649469e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.1233797236259331052969990781584048598698e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.0260433178681634020913640468755455259565e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(9.3768339187986941237894000561670181304840e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(8.5742279013661758366771172011458878470640e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(1.5672473359611427176626187782355542412260e-268) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.8623639765704434155209206128181193451658e-245) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.2286629093154109984854996218191563628056e-189) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(3.8271476859359073751758752558553744809056e-131) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(8.4158426770204986112487107255135956301733e-89) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(4.2786486015165158331298723321542465971728e-61) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(3.6237636244361314510429292579369450031605e-43) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(2.4674301281670095083762098372755115902592e-31) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(2.6361245777266155548048116779422463844186e-23) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.0437335364934342378255928672669375476913e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(1.0396312414724689355021124179646124936613e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(8.5561286069600622171714399951680066377025e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.2436192143752161377183133971241450334831e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(5.2588592812343035208245954230922626731194e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(9.0598836698740768044806867701111409061947e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(8.0238390537336305255021903900733705273255e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(4.3051852162120305716638902818352209277430e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(1.5749676189617969652785390774029613262372e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(4.2836285321052906189177795409714343481513e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(9.2381731044394788212077339158368695431648e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.6584228697459973327482834066623242372043e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(2.5720095031430503484520983126211608370664e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(3.5464010111002380642116105343408537828921e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(4.4461600917048016532863899582197336295614e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(5.1588412571158341604909766219910568122874e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(5.6182969004664765350662690545222014746351e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(5.8082981025880935633754062745425485663412e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(5.7523865296825031127894799300561461078663e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(5.4982663637895678691816024336358720948706e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(5.1029258314752141483209382333260054474614e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(4.6216780964914627403575166430665060785730e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(4.1016807631893902132699574457904284717698e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(3.5792879815923398529899135590723960345929e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(3.0799967926115031260544588018900465210346e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(2.6197808135683604740316664710524321705873e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(2.2070774330199721044447556119584754031457e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.8447894021441050095923870304891888398433e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.5320755208097903748607526954284156169228e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(1.2657487536507618509128041778765968614181e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.0413553692663227952616797603594434464588e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(8.5392723114367771728031778792384359588485e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(6.9845782536508070333419822227860873944985e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(5.7021173810962102903071855933195949153010e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(4.6489044032639246649170336534075162893577e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(3.7869349934949036745560386198094850747717e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(3.0833565387532076367613668012076491725853e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(2.5101979293092180390825252665316426553319e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(2.0439569234419977723583783764543238763872e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.6650395920573435420889202780799482939114e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.3572503615776308924625471753129887665150e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.1072885324543390700999318023029459923003e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(9.0426536262371586325692823649172046938607e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(7.3929990680057401331894105498116483139875e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(6.0518297758578059891767390954750997897689e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(4.9606417311989024220345082461210434533195e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(4.0719747681438357978841502233629882516165e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(3.3474919521355148993001111001182174510638e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(2.7561780230804583389834889923781856929649e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(2.2729183861615290259887188207273195640561e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(1.8774438548911208948775043125829669521856e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(1.5533554664783515556353624216093481019860e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(1.2873628920861239653355167830108009461244e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.0687253089497140965704489020118590199095e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(8.8873562244239019444478537489232554582727e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(7.4031964139037043314290592055034157666870e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(6.1774455352850359466108430644753870033062e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(5.1634833348280233873698908070709139186194e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(4.3232991269358638457049752822680767429300e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(3.6259940762953129745576485748751704107589e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(3.0462857761054345251788355341139148879599e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(2.5635569806441943828519908420371801701239e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(2.1609282151763674094151701722383664919249e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(1.8245389588816128075932984400520941885698e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.5430376450399933199559847607774374730825e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.3070888785519404129511812961520139070856e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.1089912382317892805326886055159155036836e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(9.4240913967635925300025663772370332113397e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(8.0210811104147039762956534933478968877106e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(6.8374929098965092316589728685893866933465e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(5.8374711955849389400138057513173285973186e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(4.9912534757760923862833739661936511840920e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(4.2740515214412104494412037285482764622762e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(3.6652882127318347570692461951613724877403e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(3.1478038253431288277061863323570159749113e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(2.7072387556302639738515861167204628128714e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(2.3316279987581155781880781425984257617803e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(2.0109166793935260974074426081319882316326e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(1.7366965627580280765194936757654515179992e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(1.5019027233846402813897807373953694665857e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.3005773947201541969412708351046784200193e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.1277172431949478977020496674799009466872e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(9.7909983610593724377428981926149805163135e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(8.5114850101292672361205592832487632653678e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(7.4084714659438813106050264262468255472995e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(6.4563959530311534587238700564921173503513e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(5.6335118443254487666573460138092123404427e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(4.9214078567014812744119060348065133700609e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.3044160021044272250196879291692450394140e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(3.7691506194666654451108515492182179768652e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(3.3042355846099905280574158756022400683559e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(2.8999602818060853158103332096111967346662e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(2.5479682786247144429387383223299045125336e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(2.2411578177352682884997382562858665977166e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.9734234519313400256816361429524304670587e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.7395248453179647003142780849600165223800e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(1.5349586933603473017828642087767733271503e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(1.3558582937378877033551359933271766736710e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(1.1988692251694219532449447082814719064310e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(1.0611220032787428215140427266334535005398e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(9.4013124072911077028204952430480602802390e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(8.3374852011650326251920972951933861012209e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(7.4011874887176487987091815908447877864900e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(6.5762238099869214893465138358463309622979e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(5.8486705962216110728940136040596062461485e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(5.2063977265272404471417283316130092633955e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(4.6388617927253751714082074679705919075940e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(4.1368888383702934288895408055896007203743e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.6925078547970632255869130171185256749936e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(3.2987098926181193659619379381577664759548e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.9494360620467986635321841713952296953527e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.6393733450141259793380409971657919408864e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(2.3638752229496987651527717029387916333471e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.1188740870586773188227273240111633409319e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.9008153701183150748417517350836876652322e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.7065524238331615922673397664842482674341e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.5333515827944558274153149159204412081604e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(1.3788011068663222289163137842058738461486e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(1.2407797700713915254446777593872193019372e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.1174256737856642237728349927990895351992e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.0070818282376553794711666453571330157428e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(9.0830327643211730993521025109318962069641e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(8.1980916359669719208310585537047427306959e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(7.4046793846000974741854059849092023744352e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(6.6927909941234719601517033253399610823686e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(6.0536013022569557639408083208341773687927e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(5.4792088906424530827970500511634668951256e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(4.9626949859342806706754892271308019812955e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(4.4978937046391292250210905061718875675938e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(4.0793308915177080571765541129725927258145e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(3.7021426817080084444223645873546602498401e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(3.3620193238782479694471859187268749258964e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(3.0550801100641113657241135414636742667707e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(2.7779143167101672086749481542628233830472e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(2.5274671311330470588330193305909191038963e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(2.3010139679124023836605418675577704472213e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(2.0961229886039014049787578100633165487924e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.9106303969299018608839747776749030557997e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.7425772392344610717352372837328941975880e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.5902360532569883386473447089752311583996e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.4520523648019656629787178280446004439296e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.3266338052622857233311150358514311992082e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.2127374733087462964999532803353708379959e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.1092332752662717986874206567370573471180e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.0151221509308660820452525353004821936858e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(9.2950175998042648950492822231670275043988e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.2708516524514024048484504214773354906726e-232) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(2.5327250374453340107165086826771142438397e-159) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(4.6212076176550335917811440365446729734892e-111) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.2739495272281758099610609525675538741726e-79) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.0534739334384756310108054925050546834792e-58) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(2.2361690021651768256408017469182285679023e-44) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(2.8187047530182272161536145329319664611677e-34) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(5.7495598971518779729170697514711492731592e-27) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.4843339440284745680433486962842669874683e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.8101276634659226370678730257699060876146e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(2.4828647449969594378496704152341762702778e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(6.8883041970560772238351058441865775011791e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(5.8037837156832062399203808493649103036516e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.9805877449372233452733423765692800559327e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(3.3700420564671824985223544383094498417246e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(3.3311631510057691728160058520960814689929e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(2.1441484837297371744855390712766051275777e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(9.7985242897963836269492457596583890840318e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(3.3974585958674390217875904349270142859314e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(9.4108797755950204968498086526963742898068e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(2.1685877821725049913727378606437563947778e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(4.2928872947923100785158480544954196100696e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(7.4904700754821346965232028932687625810692e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.1761664911534513694973345293243110445707e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.6902597810448528622203109393400046969886e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(2.2540575601407289583685290956252064004812e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.8213116909111491708799846400158319102406e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(3.3458916971254673482242111271019194819506e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(3.7893985747360897114235651623945175132394e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(4.1256769050300391006882722128031845011097e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(4.3421266785678094909312073957359659303918e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(4.4385165755623706046734692489576933490446e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(4.4242476433936638428316923525447501926865e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(4.3150921428746571319018245227026450324571e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(4.1300950628699590663411936367535409307077e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(3.8890237262845554499929881067316063107972e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(3.6105393896555541788321900941141147469068e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(3.3110730784347317982275067703239784396391e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(3.0042469369268274443297693222308451684874e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(2.7007556851307263614116400981544799119228e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(2.4085366850977823532182475259368567915242e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(2.1330732622658990598690227993687459566419e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.8778088666385168056235100266280572944574e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.6445524933604335634622110585102397886935e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.4338741384556957400537296434199691806156e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.2454252748731641752679013086656393874586e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.0782293714494209278835562832377638650684e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(9.3091180804452732749518039436704465546203e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(8.0186339308848362424304015408249832923587e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(6.8937094799543138604222415443165532504604e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(5.9172122013966437961353009095906734742980e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(5.0725558661964592526395487400345218093759e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(4.3440651696087973165993203008215537739251e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(3.7173327072872205211188478129131060265144e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(3.1792619964301257481517483159924781650906e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(2.7180661766768477591956980671856206837800e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.3233103648286951234521540556176854704159e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(1.9857952598009740254326338031929760746160e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(1.6974469806467029345310361795627643845294e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.4512603153627528176122857848887191175117e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.2411631046233515474153138641426133481298e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.0619008589341839978214783681725295533115e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(9.0896680353132778938052101539040052372591e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(7.7849215316744954509427156284843912768684e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(6.6715603211474017452526295700220341949606e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(5.7213087866906470961035029237172637847458e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(4.9099460460066792055096896196293277545713e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(4.2168878623426708329341299528165851258137e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(3.6245960205576809107520975126975263017417e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(3.1181056566537103865745594649946945014176e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(2.6847253927569020820670742142247344994214e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(2.3136578579806046691126973159208391419610e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.9956983416715718211693065757795963089397e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.7230449018763546443334150462732065698023e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.4890606075450893615337117727850864400001e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.2880857053540954166857377437421145347386e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.1153206503611486585646788954289151509766e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(9.6667914885332855765876860767124041865174e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(8.3867247936767881685128841097988398452715e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(7.2833860027042231824813534599888874225187e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(6.3315188451446097808549121189039145381269e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(5.5095225740146349406290501560612834379946e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(4.7990418191744162763062172923329060140736e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(4.1843351285658370206263465214795709724587e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(3.6519969621159869056280581174654235187297e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(3.1905577156873192429300096484445504662455e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(2.7901707773285639405597076179251798295103e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(2.4424322348517637202209979294196546210941e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(2.1401345078280847262726366347991664505489e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(1.8770739134844552806662957728108936681680e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(1.6479431574333230426155690155527758878727e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(1.4481787958967567302972172027413694086123e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(1.2738422820091932955935545753968006440497e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.1215558182219180543473777807777756883889e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(9.8840730586017816352942778309472713891445e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(8.7187634041214563832656492208445100732314e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(7.6979588713119576874863238503132133077425e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(6.8029459560946064295232791474396606545610e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(6.0174228188595148220407959866617743115200e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(5.3273960494592761934230702591289270689786e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(4.7207029100901803191374575169804415537374e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(4.1867962258453592076275596809671739346925e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(3.7165215314426902991981097123618287547277e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.3019443646245418220791634818724207850254e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.9361107639774148747679640680512611859819e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.6130233217750336980376976604277238688490e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(2.3274397506521206243531202782400000935074e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(2.0747896019153903742410763195890234226579e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.8510945735696616859961655648682640003862e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.6528504643884093279992921914684114235233e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.4770236362109224155376835404711119018520e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(1.3209501683538145313044500815115287786038e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(1.1822974008338702183176220968510470420741e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.0590209959990712083031299672528192431680e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(9.4933265965366083107598848100482844309988e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(8.5164791142271120004044931990373501676706e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(7.6458911828509813038570800149307239955226e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(6.8694005038996523145684681829473874051196e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(6.1763034636276005986606314307206390856420e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(5.5571725040845734458780205807655968273373e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(5.0037219553861213001915804131063808445478e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(4.5085684792742911978331271853928397758504e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(4.0652667191633065120870456571029090901015e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(3.6680971934722503800990421542830661326159e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(3.3120022371298711604264311340155818024404e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(2.9925202319960270367019608602430332200415e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.7056571193198561464614604170368750950844e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.4479153401743859545539755602149592127530e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.2161785001273503013718083027114887210843e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.0076803358732561719737699827131480185189e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.8199635659495783731720895977295913732635e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.6508513526806631973186461507953322911291e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.4983845753564094621984923427650865933666e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.3608416863812599176550621583740488551798e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.2366815368233523199641313869179789353291e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.1245302058125470571344967203292000009845e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.0231620025018680571570565991267102122150e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(9.3148683155267600379090185594439932608057e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(8.4851858758793232078603253486202689847224e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(7.7338799081874195469853167670576681653621e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(7.0531337352963481164784577407970001234974e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(6.4359504220162939263340167217585730085166e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(5.8760627018166719754796034996157722388619e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(5.3678760716610239007645759296268068444574e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(4.9063047416067205746781537178835825897111e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(4.4868524775733558530393342611258801232332e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(4.1054590385176706592843809743681928944915e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(3.7584760163704460734090613087342147328111e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(3.4426372495326055000133157340553682920542e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(3.1549617891159759051475695993185261942398e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(2.8928084462014219442671660566058033023665e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(2.6537840921924973318166094110507940251498e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(1.0184065653172405525472133811811018399904e-249) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(2.5230974383558293874106803919852181590783e-175) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.0519663008832714718830859952950501212620e-126) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(3.0856245092773042730900576873323518998321e-94) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(6.6639194907511334757415080227936084340053e-72) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(4.4598923755180048166211004165147330205058e-56) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(1.4754515177195381170846674616044164201616e-44) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(5.6872387203438404704549516627573521147987e-36) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.9363467178200292969124533573344153101825e-29) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(2.2150569662061494888440031818469704496787e-24) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(2.1040262125418463003944685693178161789659e-20) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(3.1083236399535772852298809972527716222017e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.1147003908507837037932394377432433257082e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(1.3389002421746555645361439368345230574855e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(6.8271101031880473100102532141715682853974e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.7647064642102131023298271283627602962645e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(2.6455457927578691672775865146375240276551e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(2.5513073162818733795318235091673402737892e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(1.7156496635874600877423751421644529782913e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(8.5718422743290190618657524807399239145716e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(3.3467445621489381950193546706161535511259e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.0632869276669889709138031293069477893340e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(2.8404842298213293610865545462846003350257e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(6.5531026649973027995678225049791519751960e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.3345924406434358848067861936624712427306e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.4433325928978554983328142974172442706004e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(4.0822686482591750263259338721754096885751e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(6.3037425543359914513699461979810528247032e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(9.0927282389031825505321334765134427373731e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(1.2362084705370789508164318474821560258697e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.5962928763514075502677073622626847786836e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.9705615467712354361210382856233886797996e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(2.3385839166495534765014976572033201140041e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(2.6809509873305744701151524570113699950315e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(2.9812803533023564002037550865018376075968e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(3.2274419630886080519432057480599764971259e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(3.4120392628262408600000659131221471646581e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(3.5322804835950658484841043156773462913905e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(3.5893718973527173655913229767509658922120e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(3.5876713927426057305410955165708063037125e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(3.5337603918703616110396612629224857492570e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(3.4355492476261911001923130057610565463465e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(3.3015049440850154738912919631116861528645e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(3.1400443672859618258355132245155764565339e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(2.9590772834368533395141691449435862623940e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(2.7657166264234895608034790963865461262684e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(2.5661236752674220669131343752579142661900e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(2.3654369525994095513957252829688218420519e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.1677854484390027126956229094897073577303e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.9763747874091456399818626842255239953942e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.7935725924271150465730184692401025462979e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.6210091395295069761144449288130226162633e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.4597198052249635895415432254237115058623e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.3102431918294439095623982279832405125061e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.1727147820123534591165121294597538395133e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(1.0469792912775022301847553924972347216658e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(9.3265716256020677361538997571505683928312e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(8.2920323981805108218611268957841370395746e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(7.3597643632654990522745547742957002430766e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(6.5227326294417813088219783964242605179352e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(5.7735625702504935911646552550985753694015e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(5.1049104847178606795724064717563583233729e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(4.5095816504336570182974112621283972442780e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(3.9806282709828739582550426584585390063194e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(3.5115320021510511862892339454150783224920e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(3.0961575733943412004561422682324926421218e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(2.7288618495042141785137107641659046999439e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(2.4044639705337484231708198115860395258225e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(2.1182216601065412073868547565423918148478e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.8658610180973245783414377377965007311942e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.6435272519198930226838581615118139992347e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.4477456297515127630182791578183039103015e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.2754236147832079621562628196738485050402e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.1238025985454878312584641552440182320005e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(9.9041984107722846198780965305791042331373e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(8.7310093995897340644188203846010071114771e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(7.6991991910812067002037405608152757187002e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(6.7916789736836428108710179423636030621705e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(5.9934377859232582079446208402447867929036e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(5.2912389822683001056123500197015029714438e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(4.6733828301394053013670894321389538899982e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(4.1296370223577369176853845861899316913344e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(3.6509565342475300227493454806304818376478e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(3.2294322853153862286486750206788586031860e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(2.8581165902482174817342540517104543134575e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(2.5308873105672735336551504441859326484559e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(2.2423975288149485121222174986215462750791e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.9879542802989227594524316885364907509954e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(1.7634244059064444376812166528065808449844e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(1.5651996132569971903998163004801853775367e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(1.3901133344288526578665923166130322325033e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(1.2353763243086463912086692461264760627039e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.0985531790008443486378275835727760073620e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(9.7750577602252712226592608749266462646023e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(8.7034955712285237482198281970584193417101e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(7.7543810615178074529060578348302055493721e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(6.9132669349972319160736391613047873424840e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(6.1673503981682518448509766724481400521300e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(5.5054922123573906708539038934525798034014e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(4.9178628153937205540005825705839302768969e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(4.3958174340330878456220591599375630803364e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(3.9317499700051366798996186258018705998058e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.5189835147269487032277222708071798394651e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(3.1515830618530535886811010809881990831269e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.8243740223105034549077881919513948762625e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(2.5327766166453865563314103145593050972960e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(2.2727515171273908540050985999807195177627e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(2.0407445271035787039716063958247618310185e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.8335866459091000249198108909747931169849e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.6485091341159462827752124963585356701762e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(1.4830544674855895646606476682671624461916e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(1.3350492199430517177781611192710357545183e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.2025701313087055605215958193883772570310e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.0839196336620386462974768465562952468083e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(9.7757799874436768915219308461637208066626e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(8.8221386991246272251804067571887794229935e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(7.9664116397126163444548388535811401540652e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(7.1980727230166334584896538379722514843892e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(6.5077749098490708964169883536926137143345e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(5.8872409887534392247242972942230009986079e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(5.3290292860317504078052496008286500146634e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(4.8266026135457416532742223392319635089818e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(4.3741148343632758071592103176456251893831e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(3.9663592904605693906102623867353922279203e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(3.5987125744544216103480677955424098329227e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(3.2670029374186684873955969885127604690059e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.9675574126350849176330823396544110946417e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.6970807862034882055672029052936749480448e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.4526296392582780844181350556867667771121e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(2.2315732538577855908380363214423414630143e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(2.0315679940421506737876809579560386695381e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.8504899524663203977412641303628160931233e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.6864642783727698932324682882688470886311e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.5378025360905455308139757134918684017978e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.4029913002060130222539374099175214448571e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.2806732420938020293543847311947754065613e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.1696353284216966075133016740947460885728e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.0687734953515536639323209229455440094423e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(9.7711073984922677742653044947253452047787e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(8.9376391673169606731701828342064970927479e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(8.1793874579475886703757335325732634754176e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(7.4892047618270804299969784141568949169368e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(6.8606839943467935221944796833760006423357e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(6.2879687434189914386964091859741095481329e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(5.7658646463741558724990593090983696219295e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(5.2896592861197265603863113901155213105669e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(4.8551006108206699479261336433264217051175e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(4.4583678028902149440946761499468427169862e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(4.0959562223048573890921594893042316907692e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(3.7647518741859399526388727283375837222735e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(3.4619213770976580662249719595149731809841e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(9.0191871893700340142050989717563216016896e-254) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(2.6450133583478899196614562343431024352873e-184) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(8.0417260394894923619374311317009273001037e-138) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(9.0517124977035871156638799388942338483228e-106) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(5.3653625907310558049698244929401870956817e-83) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.2803551633220522771411188834307768165801e-66) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(6.2472350140202482301037693531256012195711e-54) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.9762728607367959803982862108441792549711e-44) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(4.8478933635137506147254925265333944153816e-37) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(3.3521799887078906291100915455795083271606e-31) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(1.6004173974565195163677756036738099654162e-26) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(9.9656246650320508846902184858981073754390e-23) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(1.2824567796478076778526831360226833357874e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(4.7882538024654060943264742110971792011491e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(6.6878985652760660489473751506969130899347e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(4.2385464972814370142285436940322497470816e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.4143676804143846644874436106267888976668e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(2.7903084787416062900176130897990839112949e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.5657459862341667680892737246319288705644e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(3.1743092226945581191516469570370148458448e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(2.0869413841906415839618432144605827993246e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.0624393005297298620130048701519598800880e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(4.3532726894550522464874330493593609313800e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.4820624461240121642742417099969604626144e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(4.3043323181012014113850953015426267277436e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.0900910721606336070989754247172557376916e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(2.4521226613254186020003159397096765767134e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(4.9761225498800821526862692322536659105032e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(9.2303223110356439030208850391552238641796e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.5826665790987197149524923141041836808330e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(2.5326246337408079268369283375011458264773e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(3.8136261710173975515879909073938055702631e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(5.4421482859113574418799984669962406035878e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(7.4052353966562894943142338016463060303467e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(9.6596990879156342337210861750585435034539e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.2135649487978978687810198529265603731263e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(1.4743684043832268079805597834799860937545e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.7383751473430015206477544062653471023628e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.9954338063267232476163809255149503861218e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(2.2360987515603563482796764351446753400850e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(2.4522675358356934574787534326212085037253e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(2.6376117047434335612822959435369675371648e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(2.7877688392721798089269440749488629761716e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(2.9003585990054312987274874338725678825820e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(2.9748235422585923361424691774548665611062e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(3.0121738066284026056250607570460146567128e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(3.0146808922210072070537887403736331836015e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.9855439087313743288840693183328224924989e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(2.9285752442982784034772217524609021477417e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(2.8479197788328754189389220643851554450154e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(2.7478075529256074333946969236701089448167e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(2.6323757329028769610603876981916056429713e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(2.5055233667846726272432462172525522440267e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(2.3708039292532566379433764136003497223176e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.2313848050305972350216594734215651608884e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(2.0900116014628172717944914080013857546482e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(1.9489948699043806425468370984093502696593e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.8102454857177891821752036155782561472306e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.6752921803053682301421685148713362763942e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.5453077957150192843398480799627502621388e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(1.4211680876962586028837975769738079550928e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(1.3034824851705203790373045540493628342050e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(1.1926264810676137646676259451575542035787e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(1.0887985314573377173689313578467246637770e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(9.9203389771322881366210275213372273251566e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(9.0225330207031559388920850225569025230293e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(8.1928214231187441968335851811531227383171e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(7.4286888041871443989902756506223597881181e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(6.7271669759118847497827096762150395314814e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(6.0849356353411090574393346680521263350744e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(5.4984196534123361808480068946814444051659e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(4.9639894649877385060880985730415328305151e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(4.4779967821756393038561847091224376987731e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(4.0368127759820865837541516341313249105037e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(3.6369471967168765548405536901734300002968e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(3.2750463203414409490339698398102121175470e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(2.9478971588804191905907964064678321946071e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(2.6524948431800552117069857922424563070690e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(2.3860226525681929375283059131088608464625e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(2.1458398358213714488131878161157488410808e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.9295229680420216142158789482496018276577e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(1.7348159821727685697329736422579848073979e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(1.5596605193721902638675598048083243854292e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(1.4021700769262950408246867453519211992143e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.2606113810284925541845566195438567504953e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.1334164057935370097927557401601216339757e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.0191592175823900915121197270179327184811e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(9.1653892549282185140421898751202270759912e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(8.2438550164876946833440685910307297875446e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(7.4164062610475861089736711292001875355893e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(6.6734343515508354717813586549008470034472e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(6.0063319736665036199626735339237465804350e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(5.4073420870723926845909617927719427728866e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(4.8694449258382469518966964957439177057110e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(4.3863695640360862198797464130910545633093e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(3.9524881247020135421785797508369733488874e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(3.5626893766544762617434710960287772283587e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(3.2124446181460610328977205041282193557254e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(2.8976722135631021669515468393413989198558e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(2.6147122460744414706085367088581854476481e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(2.3602839257571035358113578817336441685147e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(2.1314572472792224219693940192258702543002e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(1.9255761672737024859537497564591832630242e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(1.7402917037906006630483425925633338822377e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.5734893497197914283567781631934183683397e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.4232749176725213194501925475909646731577e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.2879576421137715218342255063609226995312e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.1660047417088024339746290028075806376891e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.0560611023927247200801728828880610209966e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(9.5690654036161412332079161483595291137525e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(8.6744765011621445267985611174114416249917e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(7.8670448205266411092129777372866746838857e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(7.1380188073297656888749465100504099996474e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(6.4794542859341974765124302122446929416471e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(5.8843246998324084705521147217775260790783e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(5.3462949022218406533092531799963661195553e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(4.8596809208582501266253578898012336267323e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(4.4193816432424662639494387779902082692530e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(4.0208356200653917046789304274327553607534e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(3.6598932609560408141692059726250539558727e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(3.3328805197571085616951309017154001632850e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(3.0364783410183876059635196461100545341944e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(2.7677033978694074933754734679207613948840e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(2.5238841654471508277658723555820226534506e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.3025849239478651294607495217837836402250e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.1016467002157743790273382219043771240638e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(1.9191152904223895249679878158388739404151e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.7532310161049471679029153140498799970081e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.6024087613972304222942012228953164886718e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.4652262779954416905884846353122947992648e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.3403829626645722752260227949308786534644e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.2267242717965889414657966524738787359857e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.1232024515479540032478856842036291050412e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.0288718342607392227632978750809086993965e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(9.4287854786594734157357393975554821849701e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(8.6445482423885729173208270077988544700645e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(7.9289629454402813079426890880694678711310e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(7.2757671729640611543159251982454028498604e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(6.6792621332135603195687011498488724731571e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(6.1342916652641409758685619670543710980108e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(5.6361886382273803129752426107624118696614e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(5.1807473534880620609902639178922687229943e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(4.7640964085372850101774840278581619813994e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(4.3827884545167389061839330727721645220102e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(4.0336775497953834230923203395654976823401e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(3.7139101987431296891140400650482283576022e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(3.4209103149003854881283555240380376809634e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(3.1522997804152334785660524674992598142085e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(2.9059582969180570956221560441090250933443e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(2.6799463572937701081768259674110359472083e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(2.3358770081428775103307026901914557856707e-252) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(2.1519782373407651402562823847516412321570e-189) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(6.4687388491457587587131627836984713408483e-146) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(5.6658686838103661959054515574344898953373e-115) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.4508591114947738344159253074140313297684e-92) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(2.2718788975228760798193476484802503739269e-75) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(2.2224294052454282120562703917081953825192e-62) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(3.0061502612259940028710509694809573913317e-52) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(3.2174694781543212689017114318588183784433e-44) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(9.1500266057227599123689471552823945780395e-38) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.6346949464280243062136147967011603570774e-32) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(3.4208461724645434204916269203793980038318e-28) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.3275188091321769718490083208121315547546e-24) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.3481504840630706527255706832028392314567e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(4.6548353807779542205581099417782710698496e-19) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(6.6864755227049534766234405546685622608630e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(4.6768183872408554065035955222044428673878e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.8032648637349584743263653165415293747326e-13) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(4.2314297252852248589461996062914151112721e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(6.5425858879757743054710902395989421162628e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(7.1099747387121793243089816299856293119517e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(5.7243587410466021036697608998181577469914e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(3.5660513583246338553022063834103143871177e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.7819351170355280691595760420631599783853e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(7.3598440019115212886392604643249983497285e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(2.5767739555388981546243712773889285048675e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(7.8119998790372898174488347622368914546308e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(2.0881217857435774392087054461483194952290e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(4.9974401938361988610124835587929557307835e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.0850813206023527226716179929159148113760e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(2.1618574098530604328472160449509424993677e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(3.9910488054930142517796526072190135312708e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(6.8854475676504262197853881452122322990372e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.1183348242762662373514238548431757838244e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.7210792447451728963855938646011300677290e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(2.5239105229296320463326753546493731653762e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(3.5444344563091983300045309303106423063304e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(4.7875620945376579073667297040058170839606e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(6.2438887762114597465763918777896850174152e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(7.8895947588225483348053638915847765542777e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(9.6879812155667628859044918731423159134274e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.1592130511836868065989816478153855426359e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.3548574516590450394384455261967052736466e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.5501079204634992904059490105808536902123e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.7394280273385369052883030379965203869433e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.9177026667632624043582222945995995938479e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.0804908182958435417736152352767384453252e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(2.2241806341702705536100674771884135893863e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(2.3460928776348813613307937056827942142928e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(2.4445063220466890335925087733283963741795e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(2.5185996366443089823635306290484833811166e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(2.5683771353622497112745907319643582217088e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(2.5945547432556668139805020976257844439491e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.5984221375473437492816526367335235125449e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(2.5817134669053363213023607489431328862804e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.5464732845520687020069849476224012139184e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(2.4949394364505192663617585920894944716066e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(2.4294390484307531989924340710499928587543e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(2.3522946198955417389428491670708096156412e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(2.2657632998600091283158076916363178499165e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(2.1719799714317686176865554720257766248318e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(2.0729116784495019725408847594814673076879e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(1.9703489141093757543487400961007469983492e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.8658739679267776999249280238052109256789e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(1.7608736826308313667195594444576543692850e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(1.6565355172487751924228968343419902829071e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(1.5538487423185017557039746872352687870660e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.4536316701830362758236974602386882393833e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.3565389036121025098114030171241203252975e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.2630709749424708345871582536682888590627e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.1736048530713597210305428770250465191338e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.0884032454033486404446866650343888366534e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.0076249428463795128267468891921799674204e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(9.3135185794101250005537294773740298012038e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(8.5959631017605182274258085045767488079270e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(7.9230890998237733820246416278337408515668e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(7.2939984688775075040966043969426411015601e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(6.7074315066534553144974082752817621148243e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(6.1618152237529383550079973724968877557214e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(5.6554308958316019131892464275453718468448e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(5.1863729510637018356047264587115587600279e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(4.7526868269047080338947572808539576174125e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(4.3523723374622962368128624596058269823742e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(3.9833941021994310138279099292294828453994e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(3.6437661750617680838651854426232793565913e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(3.3315426716975026055233077767984002592899e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(3.0448157339733531106987985399269165247557e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(2.7817722375858393135180141137595182199360e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(2.5406781470117918250758579020166104792684e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(2.3198699169059819761439019606902110738025e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(2.1177920152568640697728540639850247313244e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(1.9329793416808399880888391599977394740033e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(1.7640460088012054774640549310909371581301e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(1.6097100538786085408251300855107628390044e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.4687796328695430016080682426318289357714e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(1.3401285511391890484820294173519038992681e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.2227324720970158584019472717979668566752e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.1156378125171059657603999466694274604220e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.0179645296253153306550801512280792269458e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(9.2890184467410710524551357072482347880306e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(8.4770759845330634718918411941985061564888e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(7.7368905242580020686796740054698306934793e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(7.0622165892551939000969737816802215083062e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(6.4472938785873562315165833813444137221753e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(5.8868487557653562169965983467041559242412e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(5.3760804585477531940189142364204916544274e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(4.9105322664896969052751821088708093154846e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(4.4862029107331653214761848450312938432375e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(4.0994173336102078232928864759095919194127e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(3.7468231388513456776748019393345680801241e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(3.4253637913346397572393495875919044626843e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.1322669262492365128634434477008049674746e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(2.8649673524804466586855823721233315574449e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.6211685186419197121985169337809530262494e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.3987663862452615048167782413695767964269e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(2.1958458231046652948567084374428343710470e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.0106639907377670549310528085764823540253e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.8416427152579912139037329342388314248338e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.6873233999263974544053370366234329184832e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.5464019698546419869368118640368352766418e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(1.4176846160090891463535447196883847827877e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(1.3000854576250125236629785286578814879753e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.1926216400052359625816750250147019328418e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.0943846536595309344399253716647107195898e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(1.0045625811616242087903278511789355049118e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(9.2241201804789892743389872355137199300801e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(8.4725665499660184483615384449804740813337e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(7.7848116482172027365189905768190283525082e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(7.1552848228638285374507539882860434362802e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(6.5788314854952454094328542373352332028794e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(6.0508449471760716992274996589268451226594e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(5.5671034384545950577067672981309268699559e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(5.1237631876911264708174756155640834313580e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(4.7173239534426051152829532725748483028468e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(4.3446145500903941660168667042497033319736e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(4.0026957070821460375038176165113420739274e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(3.6889395226619829669554451551149762383868e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(3.4009342856120327125962038313346323309493e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(3.1364815416580793906219894893008530802778e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(2.8935767685955986472044631243023268663595e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(2.6704019176342062539313915448046911983929e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(2.4652683149082436714319845555178561585992e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(2.2766652332043250168319664841468713716458e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(2.1032038157646150762563426539248544468652e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.9436161215355015551469935103132656068718e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.7967509313620161966361552987111840431103e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.6615368001564866724389531074551517007682e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.5370145996584709936004685882035603992965e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.4223011448206024182543165183783224109992e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(6.4612356006204537882015053550939560661721e-249) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(2.6573600430746402850828996275570364353411e-192) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(5.7377553350932549841170953987658271136413e-152) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.0010543893800980750626148354244801203024e-122) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(2.9878427145878213692941092455309701856196e-100) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.0079693243909331915129638679789105487206e-83) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(5.7688766938318266265612541274787423044039e-70) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(2.0320529727889602964142889684307360431280e-59) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(6.3446429167430177776807670470502684556002e-51) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(5.3735474404335408593324568971984203315204e-44) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(2.7753700502682242638178773577275712079055e-38) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.5889952295576384382790387849195736248747e-33) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.5787353296680224143568281507749284548140e-29) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(3.8270527530899811631721964809658073574201e-26) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(2.9440922056707247494151127361747347458051e-23) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(8.8227608425041280613533172754648625368824e-21) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.2108215117808692884138638466626504589982e-18) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(8.6579033325731591959033465664032270636414e-17) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(3.5780185681904716449953528711155757654289e-15) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(9.2973047941308436473344289945540998943684e-14) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.6272387743404436419342739860918139557796e-12) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(2.0304018291747272967718947144123970157122e-11) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.8932576845269478142474883440105882492649e-10) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.3721033948923656682752470604076564724527e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(7.9885445214982787890135016975163200582941e-09) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(3.8421436685004791553349860549339523349625e-08) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(1.5630529383233255617584373790318579280919e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(5.4884720297855568872929737334284416227104e-07) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.6924976184572975016027173564158288935096e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(4.6524616009017687782129114390613957561148e-06) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.1547856144534889416046087392456276849397e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(2.6172469393439010808148721143575285614912e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(5.4694627468388607209447116097989587215347e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.0628906155579866022549385540327465455058e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(1.9351721454208573215932469785424188632057e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(3.3226837799321444281508508657573693529541e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(5.4113272123627648866850066290506446176874e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(8.4021253155397096290005154096863406227065e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.2494414970032671317862984918427142465054e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.7866444778159328492203985203946744260313e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(2.4655506351126012757524130542407248236835e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(3.2941274961357175953195664823071800094714e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(4.2733453257929635356437829026082249212310e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(5.3965324738242001613489317437067651959019e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(6.6494976537709128784078098693930010645662e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(8.0112595898198718110527397710187004708714e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(9.4551321620628577212828234597225803878625e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.0950360582059230691690849006792470513623e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.2463986258616792370170062835387079616467e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.3962399326273157620705030435442661142095e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.5413084235595400484187963392694242986911e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.6786126107843500018763887086112175629015e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(1.8055110220861759574919678192428018819336e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(1.9198012590734041545999477940159497586144e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.0197720718081016661080684914721048645645e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(2.1042022588085992016488533965084024909689e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(2.1723598690151076786025723633536898188598e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(2.2239743993803589705403117067907244814298e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(2.2591811152633524173960933244006292135516e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(2.2784717575133309939071971210791104224580e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(2.2826331807076071439125170215947685301674e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(2.2726828295280037250312240000521202679890e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(2.2498093237685252967562844309832787650471e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(2.2153171623049183045356109634737255004743e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(2.1705769116947710233102002283108546615546e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(2.1169771476533365379993426491403632360818e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(2.0558942223307074446575922929393248680608e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.9886602897671890696593969150619798191804e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.9165348050916071784048775519777878505629e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.8406972285181955435772758037988952640748e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.7622312199276382618218939494724944538326e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.6821119054068210006768663102785543826163e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.6012141316288714008581049784594653954603e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(1.5203072914651626881877791322613859934776e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(1.4400523028433910053353776059521810946782e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(1.3610177580679477344049080958846544227912e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(1.2836801091504741033294132956132942479440e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.2084252638779820092894055148081840152539e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.1355686981806516428089628693001313556202e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(1.0653489822916945236159575473545729094916e-02) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(9.9794761143213400740391885675765507997930e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(9.3349101554790984498393185258035350717431e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(8.7205341550275245085905658065252884069335e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(8.1367262696453231814440060117611222347318e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(7.5835135884662857793084000628437837728708e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(7.0605927208027549354769859605110291653469e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(6.5674591090813859648682912809340186413419e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(6.1034103845099741510674272792935281511759e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(5.6675571157845614560343144769109903104960e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(5.2589238976405425896214514931849836382259e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.8764444509413052321920348262957960930541e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(4.5189639789368862648237671303567121324669e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(4.1853158633593571906725699465071885755534e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(3.8743182384074387250330664797310165216383e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(3.5847416414362720652223148707987425215588e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(3.3154100557527476043926596927857862661969e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(3.0651518855161582532994249289107547533290e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(2.8328236427198475031245747496270659038018e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(2.6173165740661765293804436194822650128252e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(2.4175707483201271131841458886247662743854e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.2325417736630325600458104134582705808308e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.0612597454844841532963778125564682478646e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.9027923999150882513250510544260051677558e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.7562556150057799241897498778280812379431e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.6208196045812151010124407775789618164919e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.4956834131648457037749762888663470498022e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.3801122778091899441483508803493817921963e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(1.2734103529193878824820923357817711260462e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(1.1749258518030674672141828616265987014450e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.0840493556687233836999001469599139481321e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.0002157859769121622044176965518750083706e-03) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(9.2288701277561062575076228537517910018425e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(8.5157358343702725544312621285352315341225e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(7.8581663089440636938727774498378470558422e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(7.2519002506357574372134414975870810323345e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(6.6929843864251297809559993288990318405574e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(6.1777779140566656512872426936750013273027e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(5.7028390836015866115791689074480762694701e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(5.2650531341694275100626877665877972885888e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(4.8615163449890857552944432601206653528305e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(4.4895452361906166010984170852051915633620e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(4.1466767970458319512771569546670106169771e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(3.8305907081533188028936678096450525119487e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(3.5391925502324131078298891309114202893294e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(3.2705350254926115264276062608924147257265e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(3.0228227325454978410978532233044037578808e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(2.7944008678373140727899562179384708931467e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(2.5837542035608832271003545008767382471283e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(2.3894583382994171958542352738493186555169e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(2.2102300300973928798698700987010781208226e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(2.0448781601702228598424497409583810885578e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.8923061436352671173321463531365751211792e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.7515045697979014151600650089731994763415e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.6215502681676921234894063879981602944433e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.5015759906900074172024450949939084399861e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.3908012842257423169105210383739292866678e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.2885021097717684336603741845532461709109e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.1940122311850237533753037581226299070450e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.1067186096580998039047825348309184404031e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.0260608111666077673172210141416515190671e-04) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(9.5151218752531414481585985790517585231758e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(8.8259905507192570685185210513220376184244e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(8.1888186912312583709489016401049385052184e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(7.5995611807623647086108905131347508492303e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(7.0545197661922733517858960160375632558579e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(6.5502163931905748740625555282328740035121e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(6.0835233457498648993472630878138315473640e-05) }, 
      { SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(5.6515365858251011794934770260826522279079e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8202939335253768878212580667400147320466e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(1.3828402285104806991430005909985041743606e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(7.5223571217309540913932833485344738684734e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(4.6020329618721782789332769795403082526469e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(3.2182640590757427185401946234393727020645e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(2.6230900291996942737291501176788350216212e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(2.5507586223254478260693027706851896099083e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(3.0434532435781565562168438282316634957573e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(4.6064118404298510457259955842854946561771e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(9.1905560093828434552980994407806052139469e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(2.5188071997501261558583382497488779380953e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(9.8268755329237944888920949827397898226153e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(5.4975874066872868322635258787519738319900e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(4.0897836408839081550345002571544889257931e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(3.1142684985319012348174941222068541401744e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(1.3916229512026142385809804033409899188569e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.7309736226222540851637822518578046310902e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.7923222105322634553048387821113676216780e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.7412528175919922146499666211007142049690e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5882358551025390625000000000000000000000e+00), SC_(2.8861285130994204803646363453383725937291e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8823528289794921875000000000000000000000e+00), SC_(2.8728432334055698728295707016036301293739e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1764717102050781250000000000000000000000e+00), SC_(2.3876559703644818493870673588573274350726e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.9802159442548739882174631752708190090231e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7647056579589843750000000000000000000000e+00), SC_(1.7857404415989895146944375524677040635958e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.8153784840807440252050119210049257963825e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.1032382629816496852546392068246903110464e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3647060394287109375000000000000000000000e+01), SC_(2.7733851758239988755765080148830179065863e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4941177368164062500000000000000000000000e+01), SC_(4.1339779170929428314212361666029526162495e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6235290527343750000000000000000000000000e+01), SC_(6.9032759060594849720353354422974813989882e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7529411315917968750000000000000000000000e+01), SC_(1.2792181337278214159443132409614423822674e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8823524475097656250000000000000000000000e+01), SC_(2.6064924766297283598058982441076503812743e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0117645263671875000000000000000000000000e+01), SC_(5.7899839979670976436381956064267649501757e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.1411766052246093750000000000000000000000e+01), SC_(1.3913692077648987834729273821158454130701e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.2705879211425781250000000000000000000000e+01), SC_(3.5919186661593863403163886107636444887142e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4000000000000000000000000000000000000000e+01), SC_(9.8995709514384134376879685178028908007242e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.5294113159179687500000000000000000000000e+01), SC_(2.8967176951319714754765898573860458772561e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.6588233947753906250000000000000000000000e+01), SC_(8.9544766401278726573243912157651915620459e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.7882354736328125000000000000000000000000e+01), SC_(2.9114225835416200175161187252049875183242e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.9176467895507812500000000000000000000000e+01), SC_(9.9172807176831420369858311360311169859250e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.0470588684082031250000000000000000000000e+01), SC_(3.5266748806879199502792505217590258934263e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.3051353792686923890715775910336817391577e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.3058822631835937500000000000000000000000e+01), SC_(5.0121383152264854362170634109795248356989e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.9923224935885524974403801977220129007517e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.5647048950195312500000000000000000000000e+01), SC_(8.1781833010353547984329418494473795954284e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.6941177368164062500000000000000000000000e+01), SC_(3.4593843329624346623741057377081215218734e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.5051035779818115654155166348727661767042e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.9529403686523437500000000000000000000000e+01), SC_(6.7235885889618468265762420421249919703721e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.0823532104492187500000000000000000000000e+01), SC_(3.0790087349455266205957770330773704508648e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.2117645263671875000000000000000000000000e+01), SC_(1.4433582531508691059337719650590691853214e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.3411758422851562500000000000000000000000e+01), SC_(6.9168669327364254067950124426772222483804e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.4705871582031250000000000000000000000000e+01), SC_(3.3844357771756946485007451052453640772149e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.6889341846163453397614913272803858693141e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.7294113159179687500000000000000000000000e+01), SC_(8.5870738767796819460497779818510875628437e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.8588226318359375000000000000000000000000e+01), SC_(4.4438918243087557671001315867538122491762e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.9882354736328125000000000000000000000000e+01), SC_(2.3387214425605601338344815527546433037273e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.2506589307417662639352742552910677134016e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.2470581054687500000000000000000000000000e+01), SC_(6.7906084499206380545821360149588883590877e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.3764709472656250000000000000000000000000e+01), SC_(3.7408927926581132956625034511572581706583e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.5058822631835937500000000000000000000000e+01), SC_(2.0895658343647910015625520710141470388505e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.1827105807905037022340996805354575597163e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.7647048950195312500000000000000000000000e+01), SC_(6.7793887127483292417945112708876481655863e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8941177368164062500000000000000000000000e+01), SC_(3.9332677447688738018247075749621257745452e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.0235290527343750000000000000000000000000e+01), SC_(2.3086162860703503070518773855924198650593e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.3701709861734247944179444095822634317772e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.2823532104492187500000000000000000000000e+01), SC_(8.2191090275115205097907744724460016382865e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.4117645263671875000000000000000000000000e+01), SC_(4.9810763349869260967507214100712255511889e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.5411743164062500000000000000000000000000e+01), SC_(3.0485750496059538897463529030695191416650e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.8835410587916520996530603528065757732649e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.1743801851031093757990783972508188581097e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.9294097900390625000000000000000000000000e+01), SC_(7.3868069335504173024505157532092459194132e-26) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588226318359375000000000000000000000000e+01), SC_(4.6856713641330585106197463998690038595521e-26) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1882354736328125000000000000000000000000e+01), SC_(2.9965957816405593725893908994783438955667e-26) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.9315521573310719041211564308695144535918e-26) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.2545275793063795466411271665344383593487e-26) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.5764709472656250000000000000000000000000e+01), SC_(8.2080971194584576142449321919468617671874e-27) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.7058807373046875000000000000000000000000e+01), SC_(5.4086824667994327231378811203549104989694e-27) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8352935791015625000000000000000000000000e+01), SC_(3.5885402905273761790729649113398496180552e-27) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.9647064208984375000000000000000000000000e+01), SC_(2.3967890664129224224223377312346419765716e-27) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.6111650031598523838784915590399776997932e-27) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.0898157972174329738582771069953866220938e-27) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.3529418945312500000000000000000000000000e+01), SC_(7.4163452912167834161458690143649180268509e-28) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4823516845703125000000000000000000000000e+01), SC_(5.0766234163034001008342997290896851020016e-28) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.6117645263671875000000000000000000000000e+01), SC_(3.4948170262305894255068989154222757704154e-28) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.7411743164062500000000000000000000000000e+01), SC_(2.4192095695095502710948399476181070461632e-28) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.6836240406677179787964100076153471616932e-28) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+01), SC_(1.1778137959815704628391286731160634173959e-28) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.1294097900390625000000000000000000000000e+01), SC_(8.2814797640960010413670054353301234538120e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.2588226318359375000000000000000000000000e+01), SC_(5.8515482131680257277217341842576644916631e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.3882354736328125000000000000000000000000e+01), SC_(4.1544186205798572848977800330834011918605e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.5176452636718750000000000000000000000000e+01), SC_(2.9632862829753229110367607613746545943438e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.6470581054687500000000000000000000000000e+01), SC_(2.1232444380834595940080591561446199229301e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.5280623663612477730934390797767687752502e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.1044609576968015294503716518585072362716e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0035293579101562500000000000000000000000e+02), SC_(8.0162881999441472323749445860366113557582e-30) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0164706420898437500000000000000000000000e+02), SC_(5.8420761633741766166934587712394403153733e-30) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0294116210937500000000000000000000000000e+02), SC_(4.2745546539401934332123312016979260556859e-30) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0423529052734375000000000000000000000000e+02), SC_(3.1397508972251411494956738418151398895928e-30) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0552941894531250000000000000000000000000e+02), SC_(2.3149533364128052590715861152494941593220e-30) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0682351684570312500000000000000000000000e+02), SC_(1.7131501093015955667087961995339561679619e-30) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.2723608840610192257616369889463138093617e-30) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0941174316406250000000000000000000000000e+02), SC_(9.4832261540810279696438866431854225392716e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1070587158203125000000000000000000000000e+02), SC_(7.0923666481999684748510763433493719760572e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1200000000000000000000000000000000000000e+02), SC_(5.3221138862424316011383350508657116416186e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1329409790039062500000000000000000000000e+02), SC_(4.0068652446342507053093165888463613093996e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1458822631835937500000000000000000000000e+02), SC_(3.0263209774383220120543397362744253201373e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1588235473632812500000000000000000000000e+02), SC_(2.2929089773957385507108196160050736848868e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.7425811323474469504897022727462107630081e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1847058105468750000000000000000000000000e+02), SC_(1.3283084015793688222952055572757475274977e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1976470947265625000000000000000000000000e+02), SC_(1.0154985045785955486747688450852357134724e-31) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2105880737304687500000000000000000000000e+02), SC_(7.7859144382549695820388752542246178278766e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2235293579101562500000000000000000000000e+02), SC_(5.9862956373835339823122095543713768607877e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2364706420898437500000000000000000000000e+02), SC_(4.6153231631923761866119051830549009670661e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2494116210937500000000000000000000000000e+02), SC_(3.5679551956189479996613287469190817442954e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2623529052734375000000000000000000000000e+02), SC_(2.7655451635433828418755230034812841093847e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2752941894531250000000000000000000000000e+02), SC_(2.1491445049061113857065127062988139680485e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.6743896382269822563481030965574972040685e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3011761474609375000000000000000000000000e+02), SC_(1.3077399485392277320243157549357060428524e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.0238683541291544157878315969345963505855e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3270587158203125000000000000000000000000e+02), SC_(8.0353372484182146974593864550153431998263e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3400000000000000000000000000000000000000e+02), SC_(6.3209353238370631106115096223301231976573e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3529412841796875000000000000000000000000e+02), SC_(4.9837516619867688567471509157917510391488e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.9383577251831081595899964834230364089041e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3788232421875000000000000000000000000000e+02), SC_(3.1191025052778520390235234027309400469428e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.4756363503929528288753376048336454958529e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.9691074526371517862621003130764632698715e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.5694968959753516866869729996434415429017e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.2535687161643239868419855039195451406757e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.0032456327324333019538358270725838994287e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4564703369140625000000000000000000000000e+02), SC_(8.0450162308310072823004207602540225308659e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4694116210937500000000000000000000000000e+02), SC_(6.4638599351104192466387513196558664688072e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4823529052734375000000000000000000000000e+02), SC_(5.2034041963105643795512581274666132207251e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4952941894531250000000000000000000000000e+02), SC_(4.1966179244124652963443956270445810644429e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.3909226947291949058435138861093922331363e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5211761474609375000000000000000000000000e+02), SC_(2.7448622767874301141213392666854648519181e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.2258634885815694769279471483061819955379e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.8081681838477911994994542959678446213135e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.4713934095799814767829020315072915805068e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5729412841796875000000000000000000000000e+02), SC_(1.1993781765941537666190574370912581683973e-34) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5858819580078125000000000000000000000000e+02), SC_(9.7929364143593833034926503801010463260459e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5988232421875000000000000000000000000000e+02), SC_(8.0090155826732253441779544924211792274564e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6117645263671875000000000000000000000000e+02), SC_(6.5606590150521123692635029677195290030133e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6247058105468750000000000000000000000000e+02), SC_(5.3827812765820708702811326601954424198519e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6376470947265625000000000000000000000000e+02), SC_(4.4232961732462139806520669783200447980662e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6505877685546875000000000000000000000000e+02), SC_(3.6404798940058544931745020566530393860684e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6635290527343750000000000000000000000000e+02), SC_(3.0007249638069100655452270991304867995673e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.4770941558201823634790426666026048273023e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.0478477572887980380480647116775814667923e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.6954380828212943575771960914625762720620e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.4056779168302934437905018532522032172485e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.1670886510987151691660391171854113001596e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7411761474609375000000000000000000000000e+02), SC_(9.7032967040393849257217939718225974559985e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7541174316406250000000000000000000000000e+02), SC_(8.0784337710421758524126826744271513588110e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7670587158203125000000000000000000000000e+02), SC_(6.7347075230849971637614340960357857008197e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7800000000000000000000000000000000000000e+02), SC_(5.6219313003653863735029343162477350364824e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7929412841796875000000000000000000000000e+02), SC_(4.6991493282761021175459665654203989718681e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8058819580078125000000000000000000000000e+02), SC_(3.9329224296125521679716848483470487968524e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8188232421875000000000000000000000000000e+02), SC_(3.2957836274635428889876875310738760052991e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8317645263671875000000000000000000000000e+02), SC_(2.7653178247244221752322267135637080271103e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8447058105468750000000000000000000000000e+02), SC_(2.3230943140675790241370745074883224123892e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.9539641686017219834315512353170918134560e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.6454587736749296243167568957724684131466e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.3873128166073855355118539557054130719281e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.1710212386722590907385598814720985718129e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9094116210937500000000000000000000000000e+02), SC_(9.8958878495152819113102666166196808598193e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9223529052734375000000000000000000000000e+02), SC_(8.3721624591996804086478824738184825504748e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9352941894531250000000000000000000000000e+02), SC_(7.0909891974781343417563657606596989725672e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9482348632812500000000000000000000000000e+02), SC_(6.0125568965236983661460973352827157849839e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9611761474609375000000000000000000000000e+02), SC_(5.1036593477274502350949455699360869934924e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9741174316406250000000000000000000000000e+02), SC_(4.3368204544668211533222002462651160754166e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9870587158203125000000000000000000000000e+02), SC_(3.6891167537420368840895626619883701780617e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2561150314383309702508234912826015871355e-68) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(6.5081533121564541999885932439205872614790e-68) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(3.7868744794613964363292929693363789764503e-67) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(2.5180521607578390175208469448513605495446e-66) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(1.9553289644756971828271344669545665448078e-65) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(1.8222071744854507888589179382868774805976e-64) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(2.1107036167235817460155372716316965230110e-63) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(3.1820369885251656883887497522492993192245e-62) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(6.6427060817034426620755851766423316412044e-61) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(2.0924819496534959277652668796205366874242e-59) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(1.1252063788467234073734665762757416278394e-57) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(1.2421475596716401831411962570909588314552e-55) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(3.7574224498814175361392872338491710221651e-53) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(4.9935123319169284231851188799398558936918e-50) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(6.3674616785170047388261937672965827786061e-46) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(2.4236077578180044178671678382472786765282e-40) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(5.6590901228417702974182376214375479505188e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3864690786927129504774834541835974530627e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(6.7793514762794818386008902942632719694854e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(5.1024739652098776325686903241900712026226e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(5.2089223357723484583163807748530743246862e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.8761214234877994937235043509735127958651e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(6.6146083809847666795409244888196531393366e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(4.9641259813355833316462755459310276116253e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.3471591249113217669629279749420542557809e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(1.8731659316757954219766040263522487258165e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.6754501749886154850500365404322795770187e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.1193354450819207128383498554108250004022e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(6.1674622494505090040666549775507217125068e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(2.9955039530835785053944504430199826754976e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(1.3417979404367720983198847313204695933802e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(5.7177776136779764707033053305231748940810e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(2.3681781402509923049807472024479909408409e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(9.6769332245841889458535581487859025189550e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(3.9420265040267542972776848234538341177819e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.6125775868296259947607521375460491975007e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(6.6577158554413221572611052333190250850982e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(2.7837870791004157135494800140547807234972e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.1815767309161443283623516330878807694688e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(5.0985905504268633157959743142186967386359e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(2.2387197566644172152373180030678077982980e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.0007269221161521817837184731628144592796e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(4.5548776396402298442498457971685322814209e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(2.1108598105873872746383484682583161262790e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(9.9579339728204777539537398550598650459004e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(4.7805167761281630588103521041801862612702e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(2.3345314126289995877344614458746760880882e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(1.1591654524453116413201158136875904382271e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(5.8493850746088907788806761000350170927286e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(2.9982899389694178021188269143599678282831e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.5603265057107842502015694783805909056203e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(8.2397174590607315283854339035314209538355e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(4.4131917536337967825895507173032256775470e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(2.3961822383973413188834361779536296339561e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.3182627485520430518056841404760985346986e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(7.3451896283862033910486410088465226905255e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(4.1430885593144676441492468410603452106191e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(2.3646894264642576289506190013516162295486e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.3651391782953519287071863807598640035877e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(7.9681122068434005030085642453710961354304e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(4.7004820913019276345916972415708820146801e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(2.8013986760072860998589252949175451880128e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.6861833998387364325241597079715032803194e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.0246664022250849564999404614611772776423e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(6.2844163003408374936135897246990922259921e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(3.8888636408907942991552288310324012816677e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(2.4273202043936469677877652057823627880746e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.5277343339723169429840942491272383875177e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(9.6933129990983019688700246690785661137612e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(6.1985805757481792329476200287056582935169e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(3.9938434320317178732350381393788234644085e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(2.5922097882302352228756009843630862678903e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.6944753021574043287024937648511953786330e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.1152780387095247511104609135208054293700e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(7.3897163940579972109448367371025224202765e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(4.9281795358335487788614898575218598331804e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(3.3072574340939325181290750886900383305581e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(2.2330410804151208090554425869367055201962e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.5167016434426432636028402049669364468252e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.0360890286649151580253887434661136295587e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(7.1173948207846524704518426153195079914868e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(4.9159591503671433785923907152462582064119e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(3.4133920601570578220438007813900000286944e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(2.3823186125773247314414148363870667727395e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.6710209825364186231808091228323116320455e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(1.1778184352849225423780135629112242701950e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(8.3413655946475141823999251913959239512781e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(5.9346869213915943211548780416445129852211e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(4.2414310161748537408284276081872850867259e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(3.0446315008791425757527487548369068669153e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(2.1948772355270872212139516497970670887320e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.5888988976761473521572430850483498941163e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.1549193518288285146963204174803126426978e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(8.4280487462780695988544964036554966982946e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(6.1742518977906500425237385724026361405771e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(4.5403233639995654038447257400010638337422e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(3.3511164126743195393841775599170054518870e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(2.4823239591649506675539058230951769252202e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(1.8452730765889612010690123699182654863064e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.3764334078516515409429644261858400862317e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.0301832780680300039646481138512023073799e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(7.7357073938346326487404165373185796183906e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(5.8275137259273033542624570347436462797338e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(4.4038921247843062796597492197891551920663e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(3.3382962545967795546701013061335828124090e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(2.5381787435795349743054520084165166589467e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.9355469466251645519396809430179445064593e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(1.4802565513560497839579702164141870138583e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(1.1352690765129023650104546654711736255509e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(8.7310522934579979492049316618707983789213e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(6.7330287593238057835522609764050778549605e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(5.2060626678573675560059203396080208336459e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.0359231602430371100156061352879457768084e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(3.1367749405169385380745035973637239322538e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(2.4440589883494929706356440644531927186631e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.9090257177857695398085313171783581063484e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(1.4946964668891761077603267781450186311501e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.1730607834567120451917927976450496894479e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(9.2277308893124182354036017103004867973754e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(7.2754083570989343312221379018377143978170e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(5.7489634645011296645883416927940804618812e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(4.5527978561290356251069890083873287610707e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(3.6132409785043229541080619656381267011690e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.8736451617142103691655215096406122352857e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(2.2901850233107913197939244634498072279987e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.8289136928758975548298247098544599549973e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.4634908840375910610018693738665325179840e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.1733746070954035071461259182025283766838e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(9.4259036151282749928429314085773589752630e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(7.5863789239457653609364009408291980191952e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(6.1172642477951376930239031394920011189495e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(4.9417119091036244625173044548608975533488e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.9993188736054555334934947406695765862415e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(3.2423610224796514278729071190504746803740e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.6332680836203132774715774585831129660688e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.1422726588465479497953977975314683615035e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.7457750177542636281192343159902639261321e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(1.4250294773980643387904825591809228326893e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.1651290727826057634780385749205097494574e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(9.5415589027643786274712067140566605228758e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(7.8262349052519592867938964238651485852779e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(6.4293034633175814647780924814484773809458e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(5.2898331752945974709778968947673414368153e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(4.3589383286317747787577757099639378766895e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(3.5971803907002210351076821583341472153323e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.9729022929036466110861684124439313985688e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.4605171783070316566305677374237011314835e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.0393423934123999031623309789902433755651e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.6926326498227989246386391877485695012473e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.4068212391647074829925591384241834752932e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.1708531097004269889929546937333937042589e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(9.7577218360199088877510663929791858642743e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(8.1427028120130885188473251511738282380937e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(6.8038488037050062814486108966870633327597e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(5.6924418605849155088383308532559841303129e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(4.7686580100827527715677713676776186538922e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(3.9997460326852591951538800590244601019958e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(3.3589490308779544706812970525332466049995e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(2.8242411706196438671548848857176033559283e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(2.3774986250841180049370394139611751322031e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(2.0037881586108944939185732060988860671496e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.6908025404107548897083459990127588797358e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.4283339689941910848524305449347103831849e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.2079786035841395416232527350449942188077e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.0227624642926797118703865880775173863940e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(8.6690192756063921319168169793156133218455e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(7.3560025349047510579129257100703644568765e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(6.2485261512264098791364309370943956109922e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(5.3134238615444154991689447194739417864246e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(4.5229996004982290067344887812899056584710e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.1410308997221293330832972989343537904877e-161) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(1.1182928870149537445935632688054214935585e-160) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(6.5717568532682073760581453318138105469625e-160) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(4.4241286270434426147078218645777259717521e-159) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(3.4896494326316360487693590437297523925538e-158) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(3.3185957708952407895852514551528781354303e-157) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(3.9485000181153504557100881455458437999860e-156) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(6.1742028570451553382776416316467656006438e-155) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(1.3570691782844405920293511737738958395620e-153) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(4.6116569894668245896850411459505048384962e-152) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(2.7899370506160532762864491507966802006163e-150) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(3.7479529189414504074309086210555861653303e-148) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(1.6235772948423008269640616725361370806816e-145) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(4.5463837794175297288347651316921531880923e-142) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(3.5987886782996957363585311055816523312825e-137) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(2.7601619359300186012402781167697308708637e-129) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(2.4780757902000089618573411930087437925793e-115) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.1837244396734090370819656290170798041707e-94) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(3.5688201398493087971997780596465711157411e-71) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(1.7787822916670360042940451501469339628854e-51) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.1618129662288755111288529927280730323402e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(4.1846116476432451537712995274114133519299e-26) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.0408679030370764126639173644605804651371e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(1.5700100958865648819992562997365862972434e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(6.9371981702447079373352640983883229950317e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.6442759855486079965432064274039885377047e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.8050983307161841803448834391454444890696e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.6230712688659550726977997130289306288949e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(3.0049870917435237102991274001416619512014e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(1.3053346013184752867055283428279582213041e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(3.5112479670460134626224701103946263611033e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(6.5958624767139294547211017463999483468791e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(9.4437251814878692653602635233640828440781e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.0992488439774768833810989720098852678172e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.0915573571500263024707699946480139892324e-01) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(9.5892172764779018607705734290137879420612e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(7.6620277252742726811473688991872108533488e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(5.6884265223742680731042284290796093724272e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.9894840941144821498322937114219377116030e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(2.6775228040686829372441909396063792073380e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.7372525794195337404002388520407397580657e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.0985023454066732055557703405001203064724e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(6.8128805754674462876048065585583793584492e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(4.1655520335907103718012572049495622558443e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.5211832381615214220814840678673366483629e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.5155244227032822096545963483548925729078e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(9.0719115086082597689162503949170039094685e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(5.4192558715076674711831126067133561058023e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(3.2362466883368115894133246526260730816714e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.9346740521888990617442007229495540929591e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.1591141050312621908273181554507587071204e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(6.9660436335769919976504460502501058419003e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(4.2024893744900244692872135839411530307542e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(2.5464444602172940525302476821027976432153e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.5504685206808535511882407309169578218649e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(9.4896680211932789325403419118704786039622e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(5.8400034453499257729170875038616736032364e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(3.6143852056001074877540629419591142024073e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(2.2500034128586519196105878831234428659849e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.4089640619954241947576303395496298467161e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(8.8758722636087387033724533721302471200585e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(5.6250562963664019402590156626188084572621e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(3.5863558154661600029257209356982850007829e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(2.3002772317445864700357506116712741062301e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.4841896912183311075079359238191494602012e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(9.6330469503616106968663988600316878106146e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(6.2889185060403950450176826419507641755247e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(4.1294174878676974807501407317611927266512e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(2.7269196123149050992163125688465558528240e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.8108980704222549507926093647708384230932e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.2092238698461334101078388430834908514945e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(8.1184757421286106499065876558083868873986e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(5.4797422346470797696878998552181404778325e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(3.7180361831809841840061518027185579674409e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.5356927171090461971170388088150787863178e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(1.7380827383490861944405529900568256597263e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(1.1972498692603578285204028303884477536900e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(8.2870737323503127765351486380424705026649e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(5.7634336894924154589593173782859045617680e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(4.0269480449957259624539804307975763036718e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(2.8264936534575791428980960085120421282847e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(1.9927843630713416618670765312592931682523e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(1.4111262842259583872361860732440790558451e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(1.0035352811579266928232384015469197349348e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(7.1666333952321183896471120093418202401753e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(5.1390087451691688651723525399964329532864e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(3.6999138068327161296940620894897370271866e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(2.6742938000816639278576499960048136897937e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.9404389437757448282546448104134728421212e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.4132953831078518494985231068497489966822e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.0331605481408399720353814215740775410077e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(7.5801008204247177170508040792324692625432e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(5.5811727600193337672096358558994787157119e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(4.1236489089520429566297285923430715957673e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(3.0571464309968311018041779133148937689414e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(2.2740623768640446257245444334268947103046e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(1.6970904080468751611580246574240770191518e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(1.2705705884381866457922786616825186429127e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(9.5424337670120066479186761357065509583004e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(7.1887485200297391182740226665326949278217e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(5.4320130226113849885450605830393031208070e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(4.1167112597095962746525724484798243117416e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(3.1289606394578778643421620740054077254243e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(2.3850000392785761909191133838332303721314e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.8229975278948452118548589771225504735148e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.3972461639548583668390724218011227449487e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.0738142449841713912614489053599877016179e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(8.2742285050200748919414894828412156226009e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(6.3921853097242254998238220770495119985315e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(4.9508129067807711745011238283319980048293e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(3.8440009290320654084099774568050028925504e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(2.9919417723263151946020177879221306969475e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(2.3343648768461462177082528381432964884862e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(1.8256033558162366609115094234285943353967e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(1.4310355705831835073858347857882134618650e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.1243144786978854241476900932727066452152e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(8.8530158394485041931223870771013807142701e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(6.9863237522155140945905381659590686519110e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(5.5251441967636744780991780605248516333160e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(4.3788471639305775197854897041957817363470e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(3.4776144071182640879985572429544254707097e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(2.7675646787148592466002422271694889376633e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.2069091029567407015769620310439164854246e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(1.7633212411385962399723056898688091832478e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.4116415058655675917349469417977434978262e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.1322683938718810423461570232420674554686e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(9.0990723915504547639679073987077072739345e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(7.3256356352929963092370584285639218248922e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(5.9086112341893058488279587621927333401825e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(4.7742447564662815921666726154478096043229e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(3.8644763207450566434046018883594961048091e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(3.1335105163577124685167365356319162637860e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(2.5451802469670864067211160613555716231863e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(2.0707738195759473566972380046149096126040e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.6875880057602360359129422705251863112456e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.3775542841746809961633776828181851997588e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.1262859618427434657190709740875809953387e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(9.2230730244854050062536020521320099530973e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(7.5645534640139816835182885649451050280650e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(6.2137435645126064491356205101260391799164e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(5.1118706984088154286282074452975795897542e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(4.2116585937071889912882073716542664653911e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(3.4750710827494549248276176570258229203628e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(2.8714815180679147575760602021896830488006e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.3760917712942985640929874278756312135415e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(1.9689297913352962646606103948992785101381e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(1.6337978932025274607411941746659986616558e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.3575597178270547964113222592468012022221e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.1295453414652127931330376234994947663159e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(9.4108318136474144110735270027985725760112e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(7.8508456545740731147250424708048505946060e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(6.5579003241443494941917854029358685965254e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(5.4848580839306641485131916636181992819338e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(4.5931498269932769930786744227641214196572e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(3.8511730658186473175020753755748979513010e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(3.2330242085745438268872123404426555257654e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(2.7173405585393517777250413024186154029730e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(2.2866251621233014064927546844325327700835e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.9264370277692816619954198860324231323064e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.6248634137132988258592350833361902718997e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.3720644377156177309991511092857876802573e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.1599111372822480191695598306131980343209e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(9.8164455265005305779464448287778926666094e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(8.3168785327031388919198776900763973128981e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(7.0540234655032689072605043978989717844041e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(5.9893251054991300362310398264203219870706e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(5.0907380985947427335529379775351274814839e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(4.3314476017572111819790496407084746655429e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(3.6892024536851096295236133306201353314174e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(3.1453824496128082510777984151639192155345e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(1.8554673660047370386421627999697115662606e-269) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.7322495109209078111074765992279364148772e-248) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.5182845969021706669140167881312137939716e-209) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.8157627444427743979390131493064948510566e-162) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(4.3351706316606809500001633593835901462997e-121) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(3.1940616330447357392293698103702543868032e-89) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(5.2153263554659369915501714262640587593873e-66) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(2.3857244609399062098878956806903802209827e-49) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(2.3869509679075578463508881426027198591840e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.3090191499162429905100040511075765880013e-28) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(3.6806994212729230726013105046200972391702e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(2.4412259861917785373522217148122474052464e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.0852657967774315145178141785126189494078e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(6.6610367906660823883357823731599258132197e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(9.3735888054768682707506768997683450038604e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(4.3411230334465834585695842762572852208310e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(8.5959500600796267553519099147759989122768e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(8.8197157008020291041998430401195039940518e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(5.4108687257097269515216698416629413153957e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(2.2113943072695021127707749305578548131107e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(6.5385511623698393668858541807456316380188e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.4907031149641350445434533766067111986152e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(2.7540959289398368694950456208352304395330e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(4.2878814887760454628979183670356019864313e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(5.8034432888006234425034522285266846692234e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(7.0002799700672915568210201113270522880372e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(7.6780348419154473975208302287339188967987e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(7.7833621396092505242363983469654127626820e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(7.3900944264930151517772751571674872454813e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(6.6443028042068957772693717961920454247361e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(5.7081046104965988075303250541179535790500e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(4.7210160059656487294124004570031202553017e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(3.7826469727029486282747983211354490057168e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(2.9515496425048185095118235125861396841745e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(2.2527302477762812843429777486531353274770e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.6880511386541277763401543608587755548887e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.2457818240382763412893100319456267413586e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(9.0790216876516382422115234878438976789422e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(6.5487741351421192074810903768079694729395e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(4.6842795217263551401291873715932000631399e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(3.3281915317617679474473118371136751846341e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(2.3521713753809903116494787081283390125352e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.6555771449896691786316847920023381888548e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.1617300357500904150650590984195873194916e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(8.1343502135801295093280557504954169938713e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(5.6876944712222898560107206459693563959594e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(3.9740267108854667734540575014421897468281e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(2.7762413226464046625000073315766997931208e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.9401096061843282361357969370596845370378e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.3568093226335511572591722160609917250562e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(9.4993839995455617164960832775966893516623e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(6.6602521691908934763293771857007243744752e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(4.6775045157588167420038764898474147338271e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(3.2913041221451278938390235374196477085987e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(2.3208082560894534996393051266723613727573e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.6401805011989684397801025336665608803508e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.1619527104870137993285328260923663990255e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(8.2524546648644995447705991295992455553881e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(5.8763842467244079355008317533947706414734e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(4.1957260739542305014196896372640365947801e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(3.0040345294969481835798526341385443440819e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.1568432441800926342317985243741385176385e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.5529892060158131806607613055510105170193e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.1214252823382508476652878671365929363820e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(8.1213151866099554465852848335199347905613e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(5.8985499941557630855891071219463474741152e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(4.2966776803816233618425338627944575790422e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(3.1389354134670221482082776516547171267137e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(2.2998434206751180391660743258978672878598e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.6899346564840320590596820791635056608583e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(1.2453593336497719320711327852356618374567e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(9.2038255423156379944315199926307057547362e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(6.8214435101861677429947886190156331217509e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(5.0700462063399396106435906536530490703008e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(3.7789203848815087722958062492316425580760e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(2.8244014983568189390481059855128213692864e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(2.1167961698656865821480717686764131708069e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.5908013270935496213255316199623734399449e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.1987215004585576784738287967489570380403e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(9.0568182365640876222331675092001668822497e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(6.8608378901151994361402811087112897130774e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(5.2107854724091551179701459210134183658880e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(3.9677335470610312491990678469382899875144e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(3.0288905126722229119483037221577434732706e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(2.3179632529561516675107354519073234039573e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.7782896499197206404255361692655703218704e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(1.3675764006689802146839831052594009238905e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(1.0542465010137238974127268517114635995638e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(8.1463391153615807181746693499806885956491e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(6.3094713819652297839975297338120121028294e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(4.8980372507237767719603617318148674067547e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(3.8109940018253258995966676646965958220826e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(2.9718192562943546261066454016633902716082e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(2.3225399387300534997169604142988583830406e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(1.8190701126731535184352355490497758299599e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(1.4277841917882969020954229000433465657446e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.1230308736490023664466471560622141476708e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(8.8516862488717959289010580700072122578862e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(6.9911332889630217167112529384146909713501e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(5.5328127566223956655628265151758208796848e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(4.3874604462863461453062485252453151142009e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(3.4859992439584287079106989582595721547546e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(2.7751127847269482469419346734881770585572e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(2.2134062012843910713806535631824799754368e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.7687106455607496177137735204951389121019e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(1.4159759559152991188417151634596660486216e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(1.1356678151279154137128703090714250340392e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(9.1247860048036357283354736395732530772516e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(7.3445185610816875372206073788424436445430e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(5.9219160391267868944409865302352533870330e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(4.7830905992154441923080612452791267505266e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(3.8698675812649329202860074830309582687296e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(3.1362134037945405569240349744862925026855e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(2.5458405456926078319092524211532758856310e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.0699639836334292773501145434320138006650e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(1.6857394917255218816994051469050481623224e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.3750056213203832102437242816984163727651e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.1233093722744870945719394207209885561420e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(9.1908886513687298500386568595345196022573e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(7.5313661802008119765927086439614181694316e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(6.1807202974488569010577290749945032969573e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(5.0797761706434884526196599798078331545324e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(4.1810125629120416797831804123454198326831e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(3.4462369113170787081141845769298362167041e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(2.8445868017719087473953791625552266150341e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(2.3512528759312022029753695215927936932304e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(1.9461550415476388912734206873490284437499e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(1.6130412816504540232258169811367298517373e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.3387498344347500489127348023235531461645e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.1125612520255243000282674160132120801796e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(9.2579586769102236821344086287898761858953e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(7.7137562445628672838239758157564119778358e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(6.4352976583420624569589642423077071074127e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(5.3754675337394930145792557652575925710401e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(4.4957827461087403782547188242459117332406e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(3.7646240184334263126860191032165014315681e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(3.1561816208281471950489001695028851193317e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(2.6492305944571495877573921984329487095219e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(2.2263239792234630653943283824440653177345e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(1.8731016102279623501394411947032800705749e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.5777414717386697144374459348523108551691e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.3304501700702749470551654721467043049650e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.1231740341608908260901620603270093877627e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(9.4923806647266898690575111132316815814270e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(8.0311358329647522675146702036878294014410e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(6.8021580132578917007013874719489027634620e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(5.7674260602047564921119465915289151442619e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(4.8952012536985424795447266070380979598109e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(4.1592031484188039037979735846834787772762e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(3.5374910712095117173940302421403155341133e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(3.0117635448407009061664019594841524953266e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(2.5667567360661000678009493391786545326886e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(2.1896523031389283940055060549192693295674e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.8697796469528038052953135024484128910015e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.5981794100945080498682822164249830050003e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(5.8304776291439667568664240138906535246588e-219) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.0027927054418001615307902936617319765731e-163) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(3.6845679427253216488164114478294966351747e-123) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(8.5423588428794202531659224319244657112732e-94) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(1.9401299470670623088389138747542663538640e-72) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.0320154799027721245346901586788560370853e-56) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(5.8634576156955435696616028441095371104148e-45) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(4.8737199959008209309364813005413059946045e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.5732908849921754043392986830553167515110e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(8.0405894043665401957853592325017377879123e-24) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(1.3358512873878553950875111663813779664521e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(3.0688680058969882137439374080294005003664e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.5378156667850491421326599510588026572647e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(2.3517820285550487168085115487415592360672e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.4109196608408252025635940613215469563176e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(4.0164778191160837597625314285128979586008e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(6.2769347593150570828622385407395555806684e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(6.0303463136328307394537566692531704688806e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(3.8914725896401898260091815346103168908161e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.8093259305662540465189211736174985111526e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(6.4102479754643334117052889761919897871781e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.8103224534504806472059527558741976040536e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(4.2271159279320765315394603495522951002436e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(8.4082893026767591422438536461067002557754e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.4602164711817630321860450065757400192992e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.2594494113952924831937967594572759770150e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(3.1681506644270828748590027664790482270686e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(4.0829661140347473081948735102833309166479e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(4.8941949526014066110422979188101686427830e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(5.5117068833481507052629479335220433626933e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(5.8815973441199716118635027559433581717422e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(5.9905128045755072519638009838984185212371e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(5.8598987406855990330845970653622214864858e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(5.5346385929220941852711150331933607906200e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(5.0705503243688189421123589244432347179058e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(4.5238577321872266632938693183263537958314e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(3.9440614887144950973221955231066980747884e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(3.3701913955377328303700840186406613476286e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(2.8298873203252975786074268920687349366467e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(2.3403151996114518159096464913438130210725e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.9099908925179309045476692838162855968022e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.5409754670789530492527672404490262650306e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.2309216118211706008549814143122247792326e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(9.7481442708017468526774980263667975403444e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(7.6627452496101146656069762058832684120536e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(5.9850981619223302943845555735400077754404e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(4.6492974581408936230005555093623995320012e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(3.5949156913568273826462659931679884051281e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.7687711466776798941580446130148393419297e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(2.1255194816014245580340880152735405252582e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.6273250970603802791248438358496054010793e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.2431697309455798604929268857255444741147e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(9.4805349850617196995294378776156037691165e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(7.2203701217347640629110712880915056340097e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(5.4936451050459473706688418447956152863527e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(4.1771293066605512970902167467753716208204e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(3.1749577278986823661864540228563380370541e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.4129331179329606023070733084466124988473e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.8340067208040511318231589004184649657973e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.3944248184671775106288477603359959456845e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.0607182510289021369255189604944489325461e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(8.0739819464122392579136519178290595771732e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(6.1506726054239090752284316345194091600692e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(4.6897921702587785426799424367822988930659e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(3.5796017144429945387794889551254704968498e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(2.7352892623794978470127996821134990912614e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(2.0926658038388604655270230447375612914294e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(1.6031000485695997488948202412839307751437e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(1.2297288005208342369556453323447288660157e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(9.4465757093130519377487535590800021868797e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(7.2674299873957790587351428573118044009218e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(5.5994156210233760446585513645041548581875e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(4.3209512305450630334604099298124333060824e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(3.3397024297333467599851494529473212931020e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(2.5854418938654976684102655288179253090479e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(2.0048099294466891353779525188456169360758e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(1.5571627798401055845817745954691008974436e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(1.2114871989232819775854305259184387318739e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(9.4413826040703533086855794703924750638543e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(7.3703972145261652952302492164739633702239e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(5.7634498828895991967019799388715810675176e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(4.5145797632802006739773838060258832570773e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(3.5423476427384215864965900703360683900542e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(2.7842394365811789331172438729962881503948e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(2.1921244127506469363786591648021133227090e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.7288633500145754563533866934650174610364e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.3658196355592876974142515718368513798121e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.0808439226304359019158930978081798673492e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(8.5676480344348774267181014561569262421288e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(6.8028054079120492926086721185784475976936e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(5.4105399656201998902058687919825733945232e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(4.3103272813005783732657137868061128494917e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(3.4394946316302867128592884418636430206532e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(2.7491035697961134216414382123742518816132e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(2.2008469800696517320845125056578101712870e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(1.7647685397814465088080372170023135861508e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.4173714355143580279609692431736480390735e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(1.1401522722489249157864446853438494005416e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(9.1859458452995362647451047886632621417235e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(7.4124316792225325871620426568789649544521e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(5.9905566416177739547755887964511581712171e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(4.8488313024393636063134478216183715171723e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.9306861924910476810473161989896364831601e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(3.1911418983773337464132735548968133542394e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.5945868771128326535385840381343353415724e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(2.1126533520896712252123889333070613994917e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.7227400073063793410873020947402288016138e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.4068259660283175595181013458833993299075e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.1504702267912390118439110992930680077411e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(9.4215523515967762345343155994392699814677e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(7.7263640902328826040218294704739832413963e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(6.3449333356674157658311490014373388693553e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(5.2176115087473827288645326324169743315122e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(4.2964205457650156918288943775345584912690e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(3.5425655731273977471119296981815556254800e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.9248443975335365736109508687903893994166e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.4179934941187534450127536120277433078442e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(2.0015607016972549101021341428840411837690e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(1.6589660977671390923899620655998946099881e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.3767625816163781678908908481335911073021e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.1439833222347663704261970008167071772974e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(9.5173765701887832194811528399216971191988e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(7.9276740338279748523923014633129214340568e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(6.6114907873157953233197056570421443843055e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(5.5204685776745567946288129278502453870617e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(4.6148996681346740358275219486474023387622e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(3.8623921114693382113760806849516114634937e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(3.2363284666329698383950894202339067679156e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.7148471333547548119053420119964837251875e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(2.2799704009318853170210789697668633486670e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.9169119760362004174123052514814143981357e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.6134361229715026573306272965715921256193e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.3594907917945828720143703841722895399182e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.1467543593750843609463548473362339596721e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(9.6834246144577490265511874193527190198492e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(8.1855313367031010837597472580922929774910e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(6.9266373444791886075700652792011690158008e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(5.8673752546521182304601014465358031156535e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(4.9751894414465192678856651354608027738455e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(4.2229394702850442964645312896140228215994e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(3.5880192663946724120057292458408680063560e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(3.0515789708521529387200083436257732495661e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(2.5979034628168555763488624504065862901195e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(2.2138018463901678599570872592393463118907e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.8882981947569168118762186728186259577038e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.6121818061696399999176630952238469167186e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.3777316272539681189118015350085411386206e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.1784773368405312457559770134814203523241e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.0089580861499943250719885902941365510617e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(8.6460801085112920085982478104011605450002e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(7.4157559570087318335811929916486693249942e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(8.9455662945635509120278090206461417792014e-260) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(3.7409472893316489870555919742716499397709e-197) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.2249356499453133097121396953624415629388e-151) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(2.1767135094536041943433749415110959820187e-118) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(8.8193020030372599713087274437618481322547e-94) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.7828311233234680030453727392359639893055e-75) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(3.7484626083382627886175220955010370619720e-61) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.3813212833645102161846034763236228556814e-50) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(1.3839670975877286751268464686515758955972e-41) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(9.9042583442752374537722200120847741751850e-35) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(3.2548666982022524226295081632713182852611e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(9.9168059343317896295895685887736457922338e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(4.7044464425756289519295932112434257843478e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(5.1234666790552332457429685672993595399800e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.7200271099027538063166863727061685935181e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(2.2319967432991232395632550531456137393886e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.3348954208968391656682462769428446766846e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(4.2244143835865427613244740176568258753048e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(7.8924593742629776656606612409781625204740e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(9.5030917275635157013887475148974321461424e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(7.9146031248732610911682602098802414437976e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(4.8294616565050136366639188329569149784592e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(2.2632396960397367028663029972761407940482e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(8.4685529275914635347560241283394562163998e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.6130602576927408000974707333183300884350e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(6.8302331952256946870889593134626922025023e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(1.5470049191881619164092389184422832845716e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(3.0946052374988019753698468134037347798660e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(5.5563910381560036941900784873801401756636e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(9.0790440207289605050734088021117964063468e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.3660408030445081296256203711341719069229e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(1.9118716787502979214473511962856449198042e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(2.5107834893475011996290635041512213183614e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(3.1174062504509122494928824359961732820634e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(3.6834565690829770780119748759984600457104e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(4.1655279021967539269006989781204417393107e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(4.5310642374021525214068216432109471371288e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(4.7614588142649981557438822407210353271388e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(4.8523489551570433056095063790981888931637e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(4.8117231973650489663987065699814799684332e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(4.6566964276140213917434103517811272468749e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(4.4098763491605294736251465698346251659993e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(4.0959976603979032097324243070270320723951e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(3.7391887129969761525693683528757644650561e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(3.3610864784676552402614408057667226948421e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(2.9797628558739958353877156995977232373243e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(2.6092839243318889062222436682134738877359e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.2597842548451228793899047278298488635306e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.9378989620527065545985611467982437738282e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.6473058212439988787619317084689259718297e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.3893292249407243624236628698181747115489e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.1635806109694946595790413985720294725789e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(9.6846562827614795313871536638127957573230e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(8.0161532097058011258344087809919846329748e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(6.6026133000384579110039229781615649758792e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(5.4147923919799447429607394275535172701660e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(4.4236661263676979132729106798148832487523e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(3.6018116936743639933777579758438093705550e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(2.9240352255843041727608225019169140187547e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(2.3677100880777988951641955915580683694209e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(1.9129836659504493187943840831249019393922e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(1.5426577516278044092430502141326637738948e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(1.2420045390077065452185510525996599860641e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(9.9859482999213076359162609643690179768928e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(8.0198478542829609639595049440150252132807e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(6.4350101469495366423509593591620606676153e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(5.1597170818860907608832669465997849140072e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(4.1349373806426054039137467729526909931740e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(3.3124634196907381190931139958687621926064e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(2.6530093430393008204195297060888176729356e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(2.1246425442448273492439110918042068896236e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.7015622401421976982915564026901578655827e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.3629357229412503756507090141294450413290e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.0919632137193969074425908672864472733920e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(8.7516131715268928611974787847857108212435e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(7.0170475095225337427782559028125097774902e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(5.6290555836271598090413148346680610279066e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(4.5181832309555050965096581861933329372023e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(3.6288488598060161144843325296749947551650e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(2.9165601116518822505800662927358218579949e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(2.3458319105323952470594596567933580677661e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(1.8882633647913192946613761372323402706049e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(1.5212076551229672480070729277881403401008e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(1.2265729688675092578136343051960375846423e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(9.8989162985985597923164860753391110082668e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(7.9962581308724682234197047233198313590975e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(6.4655417958711400390982360675924472570045e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(5.2329702629991729783227931364262369086274e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(4.2396347474446486102971810375285227404795e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(3.4383962706493079057876095991600319895376e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(2.7914751110334162014211546583120209310838e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(2.2686656739156057915682466917392022744436e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(1.8457539745040006883065277099823208999595e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(1.5032951166486704426181465285019220867999e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(1.2257107006779431650781574346424296468347e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.0004895253181535576896039597751175757049e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(8.1754641553207090143673278808975899811399e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(6.6879649599079488089709817682899994289204e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(5.4772046067336577224192213288514840203423e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(4.4906435032048204512683778224576002071552e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(3.6859006915145463410232173500501104635113e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.0287855441450701109984498885300504410556e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.4915823470634315009914752309176184791633e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.0519535145865515608734754781309797257118e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.6917832549333331198236018962607872823935e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.3963875019220299643134877221312902773641e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.1538621894317781275035095616712074965735e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(9.5450777526850993768577411814024062020568e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(7.9046898476027911503673527343225302892857e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(6.5534231741416360371388004689876656922085e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(5.4391069835787715677417195276733654596986e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(4.5191923927777308719174795461087594277668e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.7589741769484486239519109202048673987847e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(3.1299913167424621856046203184075990018431e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(2.6090560203902179805274159148817434522767e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(2.1771455408490708468523691123112547809266e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.8186641738782685714130360664428066679078e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(1.5208124717677710027496511156959183411543e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.2730855433390244933229274735542560964830e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.0668121411543808736236899520579631043937e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(8.9488515029054452432850425506797747334255e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(7.5143683215218954348479681439895189531733e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(6.3162638984979522509695673514776420337254e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(5.3146043130820223398388994914919755583785e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(4.4762477480728933277911751976525209500138e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(3.7738968520134321041928708594184122936179e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(3.1848964115085097851828080486826826518580e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.6904603417600523964416444593437792998432e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(2.2749951752703632578283789351811100465581e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.9255595901438437126815490859876145455935e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.6313449125390161075968720023097124458750e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.3833974402013920332760859982458414719624e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.1742405050536902727713757106520405955284e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(9.9763718873496481900490977404090284363669e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(8.4837967763063460232177466463427666129213e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(7.2212071643027352197594535351780283735781e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(6.1520697938776662018355221307833594643917e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(5.2459543411151543231861992810510197664675e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(4.4772996807723582129233553760394374571613e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(3.8246600740510852439458204652953726122754e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(3.2700257303504421292231998103777147051229e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(2.7982787530114291459151138084972095527985e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(2.3966385326471651618241123512948278123854e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(2.0544034656026135820759639535928343916338e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.7625330941564241356376421779640190840827e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.5134005342586756244764592341986623259922e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.3005749541240802796341289451932794109209e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.1185936451001969602869451783952349112558e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(9.6286337893679140577732651495122936624180e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6444442749023437500000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(8.2948619848351036435838628490600143467183e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.1152186647682560959035560360817769332321e-222) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(5.3554063181324822728130657890262300087905e-175) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.2996803536109863786698823140713099969174e-139) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(6.2662163487441644098900260350500824304285e-113) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.7700090271066302877207918407786661225259e-92) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.4662778191192222526136971501289882905230e-76) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(5.4183083699843691460939509633213652148098e-64) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(6.0960603717924567353889506342507577193051e-54) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(8.2667344930178002714428965044253613307105e-46) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(3.6800781412434241380090010047538408826927e-39) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(1.1272669037906675425249672927047836250853e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(4.1376533871463880036684581788471263711725e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(2.7739106763741947459212118631479430739077e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(4.6959350563677853887734881120529501131000e-22) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(2.5831432420022019785090231023609704922770e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(5.6287671795353760025911081723496765621824e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(5.6863793278910298884130937963763611277037e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(3.0212628919415649579185075708047499941851e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(9.3473926956885417790051690649983302671802e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.8297407594436887443760360452493533056488e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(2.4256594141938305089552294649199745834011e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(2.3037528594572286341266970881537040960277e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.6425337911443839529127376912559826891377e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(9.1415230748155102944972949357158655282745e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(4.1042379106938217390016143736255952475833e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(1.5283673709286327791093396554643982348478e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(4.8332564163289917500815436024262763955829e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.3244092867662865837025884721024628312168e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(3.1994198545235960420913782296497577587566e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(6.9157919582195280513604162132450060495683e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.3548771234255852231533091362358283187248e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(2.4326636954314844755941214826409787390994e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(4.0419933663057048331843129099509990425703e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(6.2676644711521309892865204842744383879594e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(9.1375383312793812505354048264668272849530e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(1.2606368515814086243076473901480282421572e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.6552760902556392367197159429960572459632e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(2.0790603564075989308473976269245963693083e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(2.5091280023990142000592716009265258739609e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(2.9212066072228920053674581625134961116879e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(3.2924348375749485981410474596468149091087e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(3.6037532116420031776339969654034423407054e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(3.8414635198371715792127403342313926192880e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(3.9979184109567278272391200902143058834715e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(4.0714254155965642093185793452504843794942e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(4.0655030834332173770170205541137584459872e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(3.9877573709251915410276427198111888164878e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(3.8486084202011883472828257916659154515018e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(3.6600130424154714277954743637983135103587e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(3.4343773961889796318063743650169186231375e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(3.1836688478752108436884305257512206022420e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(2.9187615750950376532766668371334809874231e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.6490783090940354119338086917464240354579e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(2.3823847550170827894359295606201601953094e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.1247440550326039024148044688135202569757e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(1.8806455604162739404745371494626624178759e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.6531506900305565638826208300269081194449e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.4440848125676072891642412717414113164723e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(1.2542896253609748288037646325351188207305e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(1.0838195095398050455645851911032853044259e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(9.3212790356855528776513730478715972911288e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(7.9826579141616779599710627531238908478893e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(6.8099663256964318728316953692768606192605e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(5.7893548798778356526519649740070133747949e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(4.9062820320216978856900981464688323119980e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(4.1461432400173537485263887108789234085068e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(3.4948782672798224291042722451192001677093e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(2.9392222195129691511634232598852333132157e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(2.4668778120383046859213766392981474375079e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(2.0666975277331324222130418305655801952152e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(1.7286693498301956703410398694635963861997e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.4438825016019308759708752627916877984140e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.2045225341738871418022521669723934175397e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(1.0037685027010730863975558321121029171549e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(8.3569756659077275646713949024286192121340e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(6.9522222434253813168932524643585046712399e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(5.7798229344469349345036474995590777065732e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(4.8025217140383857907659544955733245050217e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(3.9887725690229586397861392307183474843984e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(3.3118020790340441550297319352052282343055e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(2.7490779228015860354666349253418588799911e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(2.2816375673567977873443529476144068530462e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.8935378776527063606665168959856832320526e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.5714586785074080655768780187102315758269e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.3042625988405237489837604844337434650664e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(1.0826391424286869250563469556861546009116e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(8.9884781605092115789577051573180112736832e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(7.4644460084808692269741069924813735428344e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(6.2006280569683821551026846523005236839922e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(5.1525502220028400257956073729274350633002e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.2832897064195323254621744319372246509510e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(3.5621682943959152747781341202229031940574e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(2.9638119260055483768562996228693312928058e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(2.4671988156707394088191544434990405474553e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(2.0548523253318287056710854776355486569449e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.7123633163653007790927428750762664257051e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.4277795565316726284046228580330371049514e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.1912050781297921910844417464459233752430e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(9.9444638501418723108443908028016296542954e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(8.3072613606042957086545899448158871650795e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(6.9441076975819620755221969716070028947740e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(5.8085518143920041729664167135890234348932e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(4.8620404610758001316843817794613459126376e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(4.0726246027022603561934412581807387943476e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(3.4138479738752760654781952611896703693255e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(2.8636864961765868679149975580275762011099e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(2.4039539154703255636087353769313779628952e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.0195284320458961953477095197365529695070e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(1.6978540057385547617661429053760548310705e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.4284999403648634925065640948225630523977e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.2028064228246041489224930584179760482903e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(1.0135427984166800338629965489819126225676e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(8.5472174698013477560558765715614425789736e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(7.2134887678712371050361416646946127958419e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(6.0926364709370404659570824589421020212048e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(5.1499802919961919417558990156767462290727e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(4.3566285605084311643032638276559064373264e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(3.6883653975166676865135927895322227746994e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(3.1250691418543688261853421485779818847084e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(2.6498898776301719113304127321679093592240e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(2.2487364549148220545419505971658363915488e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.9098314250326719123283694214681707359033e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.6232681344265411000820242731318408772016e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(1.3807884860553560830138651561738082795034e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(1.1754526422622039533677152238673130075628e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.0014366819422514093274290353230707691809e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(8.5384965624160310993240212967516327636984e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(7.2858660290105516205942624418479002860872e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(6.2217890064426578770212656567369056608252e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(5.3172346771357647099696262288679474735548e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(4.5476979357397377003698522476319924183299e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(3.8925242481762533891533324851594954591563e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(3.3342917912972584119000670985301479225106e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(2.8583153745883095441247228085982512929792e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(2.4521280056266834797377610168039737314166e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(2.1052524362151634547947018582539708485849e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.8088045913870253089466390949593890067544e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.5552631810071115925426584975803730056252e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.3382559552994220070942450845408083517451e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.1523882921271759294619296437642361188064e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(9.9305873097138518068664310617558812429966e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(8.5638435143086877705254310595221478460787e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(7.3905770818955994666223350880427913775715e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(6.3826633427960061662781423431725983949848e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(5.5162070657893255034237040477470918515722e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(4.7707462150363557656068849755383910975400e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(4.1289559572152357162595351417371888955345e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.7333312988281250000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(3.5760238383238503829838688982392445694682e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(3.7410459153730457511193316884841896770402e-242) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(4.2793769521182627267065587623428348084276e-194) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(8.6778233919797294975805163809144306998020e-158) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(6.6540722403979791165723153157897546076292e-130) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.7795369662607869794934769970037674257543e-108) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(6.2600299509476843037361567448604716178712e-91) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(4.0419334720151325675806037896343494868024e-77) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(6.5251386591802182495119537999919644040839e-66) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(1.0200424229933590915367633180335605470086e-56) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(4.2000132714550909778929842157842970844063e-49) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(9.6472999916166205553570052533855938079387e-43) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(2.1871501079702454430623690212419390069239e-37) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(7.5896087132711022832935842875229790717339e-33) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(5.6735287723298998318101089363820097432411e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(1.1953079500529566901683959363103522267732e-25) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(8.7867574203656514389909077238443584959265e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(2.6748594486230989676097742287795934022499e-20) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(3.8726443334944211391034635213572711753626e-18) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(2.9853496240356804342885940216514909908052e-16) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(1.3442921562499860746083392891803988726146e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(3.8176328196644166736881584326808810183075e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(7.2878920072978188111990856367164111375783e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(9.8643064652545827699766384222468016904717e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(9.9018478661080640612831740451637896997008e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(7.6572439780517281345260492928309609771584e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(4.7114670219209494565476527356239550125988e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(2.3712387419394570023034094014566217920228e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(9.9959657292487168085325626205658310042672e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(3.6023152611246629708340711551073087370155e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.1295538668285207202800025665672895474528e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(3.1294660443687139419664694900144087139432e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(7.7639249122434437654836753230180025254732e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.7450420872427542094629416997862768075170e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(3.5900407863022355910145055276605312571152e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(6.8214920267281819399158914102663090295607e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.2066803947866530258956792964630382332994e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(2.0012230584004653158515177336070910085909e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(3.1311021217804715389302103412289106549157e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(4.6473642018391292676513524032077636290602e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(6.5760469791647338313562319727644319011226e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(8.9102423080144009298332893797848869221724e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.1606360785878882977236294671054541921409e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.4585428076571962007279958709123181431583e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.7739472243346508101794816107326178974076e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.0941455346313057033496426293363286444193e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(2.4056749990710634800516488675339145686156e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(2.6955229489671818246723744413338534579163e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(2.9521888851433036382807924199988352135066e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(3.1664295784813365222329001035579212373725e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(3.3317609627360631239493460787212290573970e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(3.4446310462579760160001342024284574703480e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(3.5042887488986773527639338527114930334442e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(3.5124829387413152367422305293098498005770e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(3.4730011667006840153159260247547147773492e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(3.3911447823234179629831597850487129047729e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(3.2732028194496229839339537681749368959453e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(3.1259465291753163318666692679750845618601e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(2.9562224633592981591127179894676910333699e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(2.7706075209202004939953458717656531790511e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(2.5751435167953567661947206831682060916375e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(2.3752031492247625401506256374561656250330e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(2.1753630732387261231644659811845682119714e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(1.9794074363015617731658118125436160678641e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(1.7903317112344673443706743610738523932805e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(1.6103821095977357009767135215338692353837e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.4411568712213145324392724467467300666978e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.2836782692433798352684419195216595007389e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(1.1384732510595632813818726484952517530988e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(1.0056847083875624298913291438717427310706e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(8.8514226411198230327748924310998179868352e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(7.7643004021200913776096214463714220153250e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(6.7896913014895114822233463251670410115987e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(5.9206335552205372500704494393927896466761e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(5.1494007959240861679909896784440587423257e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(4.4679922367311958378557055349439811484350e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(3.8683481917446130748233839286136148552771e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(3.3425332997537944367570782741217870064054e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(2.8829876513002267276324409554262834894448e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(2.4825338597591421737434340333051113744862e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(2.1345241604333560158957518132361235564413e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(1.8328381670347007059340260982778092141676e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.5718788467832964111043016724259641320331e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.3466087908576103491238037784278790781515e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.1525059744777695045911898319579180096599e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(9.8552596234272934657760622766176502955449e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(8.4209584191395343736138693866388512694961e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(7.1906158371512089118846526915281716992031e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(6.1364434215510933826461016296087313037000e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(5.2342054123210921479147851333707290649191e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(4.4627559179233905563628845822813311419729e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(3.8036602678137633548790855034662143636500e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(3.2409866219247118540597703269547437016843e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(2.7609602493401610766765414808009199083041e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(2.3516316409049447234604869150231569125064e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(2.0027727484039783662917748887897062483559e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.7055696661546256681406789088125696611185e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.4524573350069532805708640929192731040607e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(1.2369518470057158921376671691455656150890e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(1.0535109709448102890476626870246029295395e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(8.9737198439035475558337320587234698171831e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(7.6449067253583341723057896216818060193356e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(6.5140763503007734615084454542666315745990e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(5.5517284692891927829453388078053152387181e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(4.7327591655546446582121012070048275711754e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(4.0356810835703291429774784047156154240565e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(3.4423097812003264042275648172899607649223e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.9371365795881408210903287231648110299623e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(2.5069698001003190069569648574572308228384e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(2.1405917756850013945288167781159510163251e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.8284791384080002989818897494100581493887e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(1.5624960222508266632729330341822692900743e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.3357680933618729169072778983297470670012e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.1424394011957812950257016604441320121850e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(9.7753311967441280856257857900855801301855e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(8.3681945044659824800661368939869716928838e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(7.1670847927108413399235125048511467474119e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(6.1413295053055641679413885592582568231643e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(5.2650084127257267782179415360302895980916e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(4.5160292445675046457998198928051782989759e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(3.8756029872650811180770401692237487480798e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(3.3277702075464784431297002995336115442554e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.8588796819337061143677089088500351240616e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.4573838883033948383403968095586569070767e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.1134277184645828916830504706321381759355e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.8186180181291623705104554219306842895753e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.5658042794828446820450044377502478697116e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.3489019459864531985012851744604877843945e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.1626951567073525833204541051870302058042e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.0027635775482175470034334264747668437557e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(8.6532614863379435539051901439466619074463e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(7.4715533372381799127558533724379578403735e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(6.4549490060043463824450539714254296551580e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(5.5799388322220399853875679625348682177358e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(4.8263136704979899221487775099339807786249e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(4.1769062621287167069167446208653076147705e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(3.6169913464359606441020715070917350539786e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(3.1339648525874535128042222079178728705369e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(2.7170330757349812937085949132177422984378e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(2.3569638440469522077365118024778695182593e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(2.0457959524547243158774339951547308952259e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.7767485275765099421386673763589891605169e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.5439872715676840493020435107010984622026e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.3425032120103431086231421390620426320100e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.1680013599486409937165769082221132614994e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.0167675264926985546932059089097278120944e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(8.8563075455686035207862105759158337486657e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8222229003906250000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(7.7185530135359907325820766946234804200715e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(3.6961670976922246055403918709946339712302e-257) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(8.6775150256832991219856595820048688238517e-210) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(2.3382116341783570217651558305686449288520e-173) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(6.7990474846780134185373354800871134856214e-145) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(2.5058642899453332341907153764434160353819e-122) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(3.3894871000962046738115271152268248281177e-104) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(1.8792789958657757524416671655370364430825e-89) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(2.4793888660623319643860979540588952511735e-77) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(2.8567223555302939871920370097916646763085e-67) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(7.6243946857362815170046941539309214638129e-59) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(9.8987150451462986690506223395755712695339e-52) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.1062913293975005852153844095162639761184e-45) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.6605217593928981920342565957496552508802e-40) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(4.7495029558570296027233770876369252446901e-36) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.4187868579697965969760380841241175199303e-32) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(7.7425274734485916696194117026225768224874e-29) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(6.6078520740569827196975015099043365264813e-26) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(2.4626052935082280078658086908098573764850e-23) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(4.5227302844985452638668913950477534062864e-21) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(4.5244115846540771728315806250569150833950e-19) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(2.6797229650365568108015741885279798801785e-17) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.0075270617319416321427606454259080855307e-15) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(2.5504667570135769206633928592051554484220e-14) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(4.5689445482136120113219862800287377637977e-13) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(6.0425169731665318695808121889943637282204e-12) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(6.1175162361851117463402671893680745135901e-11) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(4.8910237947395504776112280679388115581465e-10) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(3.1721477654371611429751655475182324481801e-09) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(1.7080690030594603851814488487257774961428e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(7.7917090410612456889551955045985075423180e-08) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(3.0646956588720401735968443758044442405679e-07) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.0554677439477681170264507836389785921454e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(3.2261530809933300216503100401605673135728e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(8.8569101047442984866188668224980257036176e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(2.2069443734456553929863360649465939015211e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(5.0380167820889243264232299109047948522722e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.0623675763077703880688221146267197408763e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(2.0846503422582912772331225357115791221640e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(3.8315654008983943416315551389113277943128e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(6.6352008558619683311964533019120305686817e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.0883057247946251812430146125905555290505e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.6986759128610155343707918880236953932189e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(2.5338269233518831130724104883521587586797e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(3.6259144830589600967815410736398043136516e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(4.9949208813078114460059159069641951694648e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(6.6445393116747550618557211253422196900346e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(8.5597747648844935064717807955621487139565e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.0706178903653654363629420063905172481864e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.3031504448704983468316355508861678197888e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.5469302089498147908929764856655991194956e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(1.7943348875720337621518085770201821936841e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(2.0373286547190641955552938273986400811764e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(2.2680337985479791529025734978322941822877e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(2.4791987762386924108705422551159393602376e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(2.6646254981745057654461833525199123661648e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(2.8194679806567404503974374582226166768615e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(2.9403645130554774604555649108452891418492e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(3.0254901115004958345016391956644429407448e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(3.0744890219053176004536124993808262795872e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(3.0883106197709828706972457336950528530722e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(3.0690106099730816223683075856506661100392e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(3.0195079171723327117964916100514587572322e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(2.9433417973949027212689663771006495626036e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(2.8444259581123265584507757878396764257300e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(2.7268450464687404694269499757654426283607e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(2.5946680710567913328546766323643446875370e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(2.4517893088294430099408910897161716665489e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(2.3018355169986548609649552902071804570032e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(2.1480800069693280578759521217383161059361e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.9933843799829859194252195136788904225101e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.8401998883704886834991136992156344049736e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(1.6905570608313694767923118459077094388330e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(1.5460721232654611161533315899123141460052e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(1.4079967198133096748821350260839750773664e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(1.2772427481190186396347267031574418693357e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.1544140906734080276888955742952961535462e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.0398695541464060517297566824905667879324e-02) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(9.3374097219056759218040922284521494022068e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(8.3599174162340956285054901207517438354097e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(7.4644388540184265402261817010263085371956e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(6.6480494868629546317254237361163640286688e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(5.9070901711111978226463953490885888462227e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(5.2373391425666116101961825839853335346716e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(4.6341770754531301199539143574127692698794e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(4.0928498856248004508229299637588764645661e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(3.6085500775188986519268596949931087681422e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(3.1764951513408172734069842403474179911383e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(2.7920767258864381361398492688045250143072e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(2.4508803845770587094692901098278198970472e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(2.1487077010067020565095617304050575388171e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(1.8816506325248223301372451753702480782823e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(1.6460831656583929556330656539340309515823e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(1.4386317861957120010053287622819713152676e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.2562395075247734867620132347846121899330e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.0961122973867994852515081801175841309104e-03) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(9.5571914274517120895576914771259040596934e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(8.3277761091444258921995094399888131161273e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(7.2524247027629489923193118529910925429145e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(6.3126912983296048152913695246958303482439e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(5.4922665601465046428509306985366085137720e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(4.7765976348820991654650214929089937406654e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(4.1527765395665788307565025785198991770192e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(3.6094058443530737122595344047253805540797e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(3.1363509603376419438495127341720342517798e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(2.7247542972241696231259300981793806453042e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.3668012366425506980742952304587145548313e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(2.0556299327646063445161333399768251813940e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.7852241610590925902485656075152696530460e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.5503265887272785305916204345849744600362e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(1.3463086904459283052677431800239982521667e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.1691584233999052136449482438992646169951e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.0153643668762655197034381491854255959850e-04) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(8.8186511987540302359880701727895516072959e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(7.6599381857540136998409535652283437091050e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(6.6543341790443223512524585584520849566237e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(5.7815504572103940593239481705504040936930e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(5.0240806320147615378853653476008022292039e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(4.3666683959786192599938126108994749375908e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(3.7960629128561126769864294900875143920795e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(3.3007815426745066566145613971197584875685e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(2.8707932596137945512391972200453968602115e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.4974599165486100684617747725901565880715e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.1732667996888739183859024669401440784642e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.8916967538871366018653143149094262200168e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.6470986784795053190471856209731159828996e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.4345823826601737425553686024758723281053e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.2498804364020136632445331447295818932421e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.0893214505341476687018320538847739695072e-05) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(9.4971352526511440425560234339521339193341e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(8.2828970471178726030796117225384253145277e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(7.2265131857667581803400213273588384019562e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(6.3072287695062474749293072358932767662947e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(5.5069276378399958567977546239864227939590e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(4.8100218489262136157083132016753219215759e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(4.2029527285656996082547102872229675947671e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(3.6739599502188144807031970760245754305328e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(3.2128412765159924556815921810211012363823e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(2.8107621657618968323950827118063166546688e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(2.4600025152846757319375011424851262002482e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(2.1539138543876398134320362398992735751770e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(1.8867060307595977616498083812903251659801e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.6533504910308930208050408406387116049345e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.4494879404498189879552622023766714804783e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.2713035454288071676141785363590883558700e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.1155083745135081498336694599245129099993e-06) }, 
      { SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.9111114501953125000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(9.7923396274458951640460762189654477104983e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.7826163232983656559199356248255669077186e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(3.5472927835268311656316215937683058544220e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(3.8224743077306126052684789931620400145673e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(4.8117811520537853195444214737614610053093e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(7.2128551168174709538921992953177150124151e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(1.3162172193142656883404079206518175015601e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(2.9984899448954695451739013526567591598227e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(8.7709475071911049461000875241495195174410e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(3.3943816806444080735799735957030255288398e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(1.7884557854584546755009552873527968615670e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(1.3087313465887144883154319918268680541179e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(1.3237348258706464715774623027516369858362e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(1.7410930653401839908230907846157241346395e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(2.5089153786452360475359766823095433201893e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(2.7936399876334102558093913915403329814735e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(1.3945157060786382495879365161415822312137e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.7297455758959887633243731274859349191290e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.8516302049473194687768449147063014913856e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.7408023412870928877581017417387724533594e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.5882358551025390625000000000000000000000e+00), SC_(2.4479827377790408178862662990507919742204e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.7090154847162019742131201623409875215128e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1764717102050781250000000000000000000000e+00), SC_(8.4836349078189720337887554163642421874135e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4705886840820312500000000000000000000000e+00), SC_(3.7711578936172970043225023451845373299735e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7647056579589843750000000000000000000000e+00), SC_(1.7144686465241163318886997245256118410115e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1058822631835937500000000000000000000000e+01), SC_(8.5523323440014203262496733302561307915064e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2352939605712890625000000000000000000000e+01), SC_(4.8400948807263068442923619783361307501869e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3647060394287109375000000000000000000000e+01), SC_(3.1471776368527207309096961946478773654482e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4941177368164062500000000000000000000000e+01), SC_(2.3543632863261750807655050509508354294304e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6235290527343750000000000000000000000000e+01), SC_(2.0171414779126408930630226219988609069215e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7529411315917968750000000000000000000000e+01), SC_(1.9647049663234571716330612534467545485999e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8823524475097656250000000000000000000000e+01), SC_(2.1570968033210135446378282278679758188402e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0117645263671875000000000000000000000000e+01), SC_(2.6463518383472866053921543149986613984719e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.1411766052246093750000000000000000000000e+01), SC_(3.5971398037364172188408158001629732041239e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.2705879211425781250000000000000000000000e+01), SC_(5.3745471933492661137595004017017912526941e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4000000000000000000000000000000000000000e+01), SC_(8.7617559292259198378916978565483018720903e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.5480522456175556018986409935651831507300e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.6588233947753906250000000000000000000000e+01), SC_(2.9461288739745299820476261485148536187450e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.7882354736328125000000000000000000000000e+01), SC_(6.0058898605488094773263780191010401076332e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.3049009215041594866963160667346478044219e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.0470588684082031250000000000000000000000e+01), SC_(3.0078943007547660751934899964553358311615e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.1764701843261718750000000000000000000000e+01), SC_(7.3256215462537407671794089671593717515323e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.8779655843369326591222093230653729543249e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.4352935791015625000000000000000000000000e+01), SC_(5.0503338696799223118858512521702207535537e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.4203421797078344042240524242517932490127e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.6941177368164062500000000000000000000000e+01), SC_(4.1655671974425825759288383764303976014298e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.2707403156711885816947824074243198146063e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(3.9529403686523437500000000000000000000000e+01), SC_(4.0226359704802395000282995724654552526160e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.0823532104492187500000000000000000000000e+01), SC_(1.3185359091445891560779874707079893513255e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.2117645263671875000000000000000000000000e+01), SC_(4.4663251067386580052030475189572891562767e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.5605851036621784957928276158168685105573e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.4705871582031250000000000000000000000000e+01), SC_(5.6152988199108002387259020952925550779625e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.6000000000000000000000000000000000000000e+01), SC_(2.0774335305769766578070297738750121404583e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.7294113159179687500000000000000000000000e+01), SC_(7.8910839998495352471994371774379995580193e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.8588226318359375000000000000000000000000e+01), SC_(3.0733951849209934245320393127918353113777e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.2258333442837620039342869936955956766506e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.1176467895507812500000000000000000000000e+01), SC_(5.0013435737218842891561365670098948536266e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.2470581054687500000000000000000000000000e+01), SC_(2.0850448401522775227115160302944538468525e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.3764709472656250000000000000000000000000e+01), SC_(8.8732073068872720256676428780561912123343e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.5058822631835937500000000000000000000000e+01), SC_(3.8511214935359547005022681677355605411523e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.7031508550666901580851165439713993139056e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.7647048950195312500000000000000000000000e+01), SC_(7.6687534619526148461748140445874872500183e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.8941177368164062500000000000000000000000e+01), SC_(3.5129083403634255476247883660941213697173e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.0235290527343750000000000000000000000000e+01), SC_(1.6359730896570728103596601016646998435228e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.1529403686523437500000000000000000000000e+01), SC_(7.7402752938929867000804227349977965232300e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.2823532104492187500000000000000000000000e+01), SC_(3.7181662523295450515257881260930087959032e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.4117645263671875000000000000000000000000e+01), SC_(1.8123487577446009861663749681026192021993e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.5411743164062500000000000000000000000000e+01), SC_(8.9588196278291384360396896379188429696166e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.6705871582031250000000000000000000000000e+01), SC_(4.4886374208907319596627424214253088648049e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.8000000000000000000000000000000000000000e+01), SC_(2.2783599359393759832546156609894048544499e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.1710483977837150134442896679795858476628e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.0588226318359375000000000000000000000000e+01), SC_(6.0920472366580652266870119978433158561658e-35) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.1882354736328125000000000000000000000000e+01), SC_(3.2063396009807471724554457007588822082884e-35) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.7066504802306687262655277664233224659769e-35) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.4470581054687500000000000000000000000000e+01), SC_(9.1830935482829881320002022883806888223840e-36) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.5764709472656250000000000000000000000000e+01), SC_(4.9933390163705885834492073980700626271841e-36) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.7058807373046875000000000000000000000000e+01), SC_(2.7428769422930236361889585283857813833652e-36) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.8352935791015625000000000000000000000000e+01), SC_(1.5215258610964449386134441191065442976466e-36) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(7.9647064208984375000000000000000000000000e+01), SC_(8.5207903943001121310742399980175427107031e-37) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.0941162109375000000000000000000000000000e+01), SC_(4.8159696367752899780915539398505079867834e-37) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.2235290527343750000000000000000000000000e+01), SC_(2.7463457788235053612299737632930091987213e-37) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.3529418945312500000000000000000000000000e+01), SC_(1.5797262263810645388560416330857593501382e-37) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.4823516845703125000000000000000000000000e+01), SC_(9.1633873533734043218258933746073911246423e-38) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.6117645263671875000000000000000000000000e+01), SC_(5.3586901081248415167602256337378051703883e-38) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.7411743164062500000000000000000000000000e+01), SC_(3.1586190487652330835342610359599716356270e-38) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.8761265036285769044645646035566728956027e-38) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+01), SC_(1.1227006354049520835754338369435879849791e-38) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.1294097900390625000000000000000000000000e+01), SC_(6.7673271691692463316457431804450253459877e-39) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.2588226318359375000000000000000000000000e+01), SC_(4.1079422913112330396485747997762423290358e-39) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.3882354736328125000000000000000000000000e+01), SC_(2.5107714496720741606365253797077709843706e-39) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.5448649445466697409630555948814895629885e-39) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.6470581054687500000000000000000000000000e+01), SC_(9.5672569270349522946889921654014449046121e-40) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.7764709472656250000000000000000000000000e+01), SC_(5.9625082839726518761191705855139173968943e-40) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(9.9058807373046875000000000000000000000000e+01), SC_(3.7389430507632029135347031203116912228804e-40) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0035293579101562500000000000000000000000e+02), SC_(2.3586802176358579525045945524817449149721e-40) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.4966789392048358917906190513117994102355e-40) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0294116210937500000000000000000000000000e+02), SC_(9.5514392614497401038812641040463242215941e-41) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0423529052734375000000000000000000000000e+02), SC_(6.1294196644798356516132487413408828296081e-41) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0552941894531250000000000000000000000000e+02), SC_(3.9548142490055877828990410155087889632262e-41) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0682351684570312500000000000000000000000e+02), SC_(2.5652915631918081864386982906362183287549e-41) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.6725832450544975061346091442220909223185e-41) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.0960620021116664003598914397546804105765e-41) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1070587158203125000000000000000000000000e+02), SC_(7.2180400734486184555552752324596686941886e-42) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1200000000000000000000000000000000000000e+02), SC_(4.7763419987980766887936784489241329540460e-42) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1329409790039062500000000000000000000000e+02), SC_(3.1755587195208153290659577957864284024386e-42) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1458822631835937500000000000000000000000e+02), SC_(2.1209928593438822307452454280114710792134e-42) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.4230245824171449221977735840022520165885e-42) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1717645263671875000000000000000000000000e+02), SC_(9.5896072296359995520789454994866514886398e-43) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1847058105468750000000000000000000000000e+02), SC_(6.4901514726167178908683267249015713109404e-43) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.1976470947265625000000000000000000000000e+02), SC_(4.4110126163619449480987313717239184674017e-43) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2105880737304687500000000000000000000000e+02), SC_(3.0103444079108989488332452610208018304726e-43) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2235293579101562500000000000000000000000e+02), SC_(2.0627327381445028881957482465069162901749e-43) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.4190118893603545634819605232548164146306e-43) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2494116210937500000000000000000000000000e+02), SC_(9.7997224121825395781715123550117447963296e-44) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2623529052734375000000000000000000000000e+02), SC_(6.7933544950565399448759742309013088425373e-44) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2752941894531250000000000000000000000000e+02), SC_(4.7268092114414908776820489712540298747025e-44) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.2882348632812500000000000000000000000000e+02), SC_(3.3009594573690214366391486760830509891662e-44) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3011761474609375000000000000000000000000e+02), SC_(2.3134205602187410131412278796963824334636e-44) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.6270026319502100283360241108720257811945e-44) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.1481844387050766129654672771968510897004e-44) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3400000000000000000000000000000000000000e+02), SC_(8.1301043031813363834280188712409757811584e-45) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3529412841796875000000000000000000000000e+02), SC_(5.7758217053672072486084542940906951977555e-45) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3658819580078125000000000000000000000000e+02), SC_(4.1166549990861752329387932682887599650797e-45) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.9433913661553675474604438752637750130853e-45) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.3917645263671875000000000000000000000000e+02), SC_(2.1110853052937947965373390823861920007008e-45) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.5187731278128691988458971801068523504498e-45) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.0959359502951022724657936008184325030822e-45) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4305877685546875000000000000000000000000e+02), SC_(7.9316881954987954478398123811757670050085e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4435290527343750000000000000000000000000e+02), SC_(5.7570250500261905026770279525346912948383e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4564703369140625000000000000000000000000e+02), SC_(4.1905108808041623070827097534388774851233e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4694116210937500000000000000000000000000e+02), SC_(3.0587956840806856135948383184540921814845e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4823529052734375000000000000000000000000e+02), SC_(2.2388626374058768978830957946973220254236e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.6431503404727635094237285177599762135116e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.2091667529144897750447866806605945824141e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5211761474609375000000000000000000000000e+02), SC_(8.9211738171219361767494497312693922469804e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5341174316406250000000000000000000000000e+02), SC_(6.5989059923510705012090841325889338745386e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5470587158203125000000000000000000000000e+02), SC_(4.8934754679518165713346503596673827050297e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5600000000000000000000000000000000000000e+02), SC_(3.6378122504629685153113541930027201653587e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.7109583332563235976702860892071385722203e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5858819580078125000000000000000000000000e+02), SC_(2.0251340964038656637929191036179216385272e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.5163669695869690406718526746419252044498e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.1380569340990970568908699440510424871490e-47) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6247058105468750000000000000000000000000e+02), SC_(8.5608473943085096482478437050269021117805e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6376470947265625000000000000000000000000e+02), SC_(6.4542672276925671768904953999635241222736e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6505877685546875000000000000000000000000e+02), SC_(4.8769125096349223399999320123455197073229e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6635290527343750000000000000000000000000e+02), SC_(3.6930432456734981062112927290562689672997e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.8025694815184909834982909063779897270816e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.1313102891082671935178856935226264742622e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.6242068151005705672527083687679878797026e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.2402998743893439661801254045161402866756e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7282348632812500000000000000000000000000e+02), SC_(9.4906276069926992419255970788552015157733e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7411761474609375000000000000000000000000e+02), SC_(7.2764916682130991062221221938952970876600e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7541174316406250000000000000000000000000e+02), SC_(5.5898579621376049901268774639129339863601e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7670587158203125000000000000000000000000e+02), SC_(4.3024782195077490415537912699012367083354e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7800000000000000000000000000000000000000e+02), SC_(3.3179021193944335931321010112822818146976e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.7929412841796875000000000000000000000000e+02), SC_(2.5634421089475439529251541069594905415698e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.9842302654448866635453689769778760361936e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.5386765039110306608993442184413582373901e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.1953177135766932004939773684275151649100e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8447058105468750000000000000000000000000e+02), SC_(9.3022760589366069460934638075621737767549e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8576470947265625000000000000000000000000e+02), SC_(7.2519401126705443963734352886161211911301e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8705883789062500000000000000000000000000e+02), SC_(5.6632771455834872521051661569534950187722e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8835290527343750000000000000000000000000e+02), SC_(4.4302147161608319358235187521711380526892e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8964703369140625000000000000000000000000e+02), SC_(3.4714024028889101564760181430899840145372e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9094116210937500000000000000000000000000e+02), SC_(2.7246050042498437699384808928333870710979e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9223529052734375000000000000000000000000e+02), SC_(2.1419576465636488527707325177792654093788e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.6866208864406486786969398826258325478764e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.3302059822048182566109301265878414583390e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.0507425517712288796276005599359495032738e-50) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9741174316406250000000000000000000000000e+02), SC_(8.3127687852830383316480206761026419332420e-51) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9870587158203125000000000000000000000000e+02), SC_(6.5865545120177237467010821682898854633581e-51) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(3.4828749019564034201410668342247958360920e-77) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(3.6597278525773053833811121983115577385320e-76) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(4.5285224798286701931533089718681975127063e-75) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(6.7586104868528029799772921841014835396505e-74) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(1.2531131889784333555734714454715112899932e-72) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(2.9948615825031295300011059517944743668588e-71) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(9.6686834473953707640957100593061067816221e-70) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(4.4800862320805850400929513742665991737372e-68) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(3.2274662859000229862082675490672542093822e-66) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(4.0266661459090616292009662421831173286417e-64) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(1.0098685296692442787704422098222168865020e-61) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(6.2847824379927701744630038986930412050330e-59) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(1.3132184072274493712414537203610653630053e-55) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(1.4166966071541242468741956158414477155334e-51) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(1.3860150408816807059712967784359120389613e-46) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(2.0801981993728461557049364515517757498253e-40) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(4.2686044779624428410760507758535748916165e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.6461946144165670176472546090898611071692e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(4.2414610058758057210297969107745673969909e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(2.8679562485120847812109329034458282109839e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(5.2603925919017366316507558987950655682444e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(4.1523156099278068871060669101560746025777e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(2.9351006436530703004292241815770336715255e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(3.6464639712003912693398819100586052239526e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.3420034600208789773591951604587195422995e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.1311346247406702938193343573094515393110e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(1.8995677150076941650930813633647065337276e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.1400990812506578929483073526665301624822e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(5.2261229479545274651459204425397550408861e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(1.9969968462141009975438540670420275565252e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(6.7627004345364203482846387404325797548417e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(2.1188755615900105694534446477991320786566e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(6.3324479837803696662673426156676525532790e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.8447131675007994651498511910870030718413e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(5.3195204525370382545066512198730762939935e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.5352624568016576971275075438003042011249e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(4.4693236099454045607313888369152877308671e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(1.3195937858827742413633395221046085865887e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.9667888408712063256021904141064177188458e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(1.2171861834611258235852760147380817989397e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(3.8188606449019540641176516807514182820511e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.2263364096316548670739705787734926588243e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(4.0329683838874475704937599580057338886672e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.3584877454815094781236269935821748407368e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(4.6866523623547399922592934778910957384028e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(1.6555421981331679205467848937655342431062e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(5.9855949812569917981681114494202101019938e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(2.2138189921717200896867424000461431846058e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(8.3716254510799540544710943173247610416802e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(3.2347592464697040487278059628136240333449e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.2763346914209881462685197600531680192107e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(5.1391790514680335236069288521336695985168e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(2.1103694654021377609672713853146456468200e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(8.8323411619168938004024625522231655386529e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(3.7650217465091474411010684260767875502832e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.6337069068802021530575811606111371145015e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(7.2115799084959570417609339513899140207026e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(3.2365261404338180387599237970753691927110e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(1.4759907557745832930941473783479150407799e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(6.8360247122828069465821120650089849893835e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(3.2137462538305166454007510959393747085468e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(1.5327981447989203511127350600074524934796e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(7.4134635466842360654500451540357338291544e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(3.6342480102335109317617992114163412867230e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.8049620627233728538697250625263984729894e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(9.0782739722236210317789468395640368638991e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(4.6221293592624071351354203867311009402078e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.3812431458438346822760698797233938129346e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.2408858160792705988783746824632319584782e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(6.5384720756138940827153171692483696335531e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(3.4823622549222605441374856309997413640744e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.8740780090800917432245844837923480441526e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.0187926003841245237005727446510570756952e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(5.5927275975046675546504123292467348122370e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(3.0994232347226992181281978215720735166087e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(1.7335715838900230249051662759846360896744e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(9.7831298784415693931378295300450217390615e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(5.5690749004860185347413642531966355112251e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(3.1970959406602105459851751067489811804651e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.8504658327989669011306547583049045517155e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(1.0796073522890907836601904872623152528310e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(6.3477536724284663049091129161936855033693e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(3.7604626488237940877011732985056748270463e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(2.2441511358062564215110560347423373509876e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.3488299567353217936656594446556874735564e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(8.1635740537490952648461285702764504708192e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(4.9744837091261578397502061873843537231681e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(3.0512265623567399210756182893857799558617e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.8836140076018993539720387384480222652732e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.1701323847176508259413339768101897165336e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(7.3135168606893969104442087174566985972345e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(4.5983849771880458212539221315595949909923e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(2.9081302186649543251826872846504448724998e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(1.8496163258178319420464627182799974254716e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.1829183143784037516352345388224608747281e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(7.6064317662056907890137326030291564006902e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(4.9169579552363632875235433479145241155528e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(3.1948681650190215750561883684332035625816e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(2.0864284114710295333330527075372630115927e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.3692726277702494854003865294369004456349e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(9.0296937729729305667889723860668034164294e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(5.9827097144049469315582662374019622921196e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(3.9822095437791528976923916014161976633767e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(2.6626387338118126022326836158648877658872e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(1.7881833719223736728206446138860442416762e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.2061100588996003452412263937972132347512e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(8.1696113944473212879629331303421929507040e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(5.5566006074768942606376846774092915235670e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(3.7946977610173974242479677817460848390495e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(2.6017962084735266457775442126843545545067e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(1.7908317511910148189976391788681957587545e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.2373475762119677543126511575574390211154e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(8.5813355267492091006351953315462691759760e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(5.9731697378943034052269970796009360859762e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(4.1726731655366721174931866908241347562834e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(2.9252333467143224684113781040031014685908e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(2.0577824178254216839511985423072074304783e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(1.4524795139695308788195379259861905553002e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.0286426384720513980930846090931434775448e-28) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(7.3086312438668768252055094937154295430549e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(5.2095284217500007457470660868013292039860e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(3.7250573815554109668359811181696280224054e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(2.6717829954299833859783239209276602334987e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(1.9221435653385161800949366707921698207632e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(1.3869582587664640015461048401623582769348e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.0037163649295680545387525495420771397236e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(7.2847208120283457130228052642813653331201e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(5.3019333906034952513554167944258357432748e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(3.8695503821254366366866728051717963960416e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(2.8318549423444248534758625912682410268325e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(2.0780005397145763974300624094561552106906e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(1.5288499378807369353688510339386748700385e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.1277574476960853630589467139587282809731e-30) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(8.3400196589403132905085878914857890052423e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(6.1831109102562020865291266326377918812329e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(4.5953419871161978004593652538756664547551e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(3.4235931455151708610486695384880922626406e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(2.5567193279314949208619178524875102743072e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(1.9138590484463349118981091044686426436691e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(1.4359352031234016754298521833406381884562e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.0798114733194711663012035364966673171142e-31) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(8.1383028471768693114778978978858538301072e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(6.1472027349514609603032495019715261445744e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(4.6533958112562119958904572358474163113544e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(3.5300873941523087635347228328169229027346e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(2.6835865861479772212429047938892775667230e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(2.0443099187931761333036746245987833585246e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(1.5605058726060100507917034014695063791049e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(1.1935991531872411103940119621762727573844e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(9.1478410640916946312837920082672701973396e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(7.0246109141324865760502899015523232247277e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(5.4045889968588536925897127621800215629107e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(4.1660816682488263639151146283519197337966e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(3.2174056635548369007408560006149552065776e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(2.4893460753009647252513663320780431414599e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(1.9295678890591267230427181213932427023411e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(1.4983342146106581535673436217307924447330e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(1.1655357410230022785528532415781461056117e-33) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(9.0823903426390661087040555538298282249229e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(7.0896046645968534138723360489368607122824e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(5.5434609371997767616226718633772330616289e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(4.3418228974609621786547591133333880272545e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(3.4062426511370986076222757921358407119081e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(2.6766209646203450017200893904045758652269e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(2.1066704303506946516345543529130845001122e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(1.6607167132596294745015783623851011904359e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(1.3112320334012175420179392013695573465323e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.0368837244532191820784349906143191616696e-34) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(8.2118925671333240403918918925693994196319e-35) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2888889312744140625000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(6.5134434418244141853993570125766543883051e-35) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.3828576711026908152578327567442645888934e-172) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.8705886840820312500000000000000000000000e+01), SC_(2.5574287962486404204636331667822247605072e-171) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.7411766052246093750000000000000000000000e+01), SC_(3.2477003825374854234843789022827273161811e-170) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.6117652893066406250000000000000000000000e+01), SC_(5.0058442765427520181353191042002737406632e-169) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.4823532104492187500000000000000000000000e+01), SC_(9.6671962739016299158214147461957057562432e-168) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.3529411315917968750000000000000000000000e+01), SC_(2.4348405242577423079038793598572376770217e-166) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.2235294342041015625000000000000000000000e+01), SC_(8.4230087632855438207366679923126009983984e-165) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.0941177368164062500000000000000000000000e+01), SC_(4.2851266381319147697411934038380447214381e-163) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-9.6470603942871093750000000000000000000000e+00), SC_(3.5170441455918418329864937281079954005773e-161) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-8.3529434204101562500000000000000000000000e+00), SC_(5.3017362313337655639927790621949872701870e-159) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-7.0588245391845703125000000000000000000000e+00), SC_(1.7728699665718767287887963855337969256606e-156) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-5.7647056579589843750000000000000000000000e+00), SC_(1.7546768422423938863397057273659725816639e-153) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-4.4705886840820312500000000000000000000000e+00), SC_(8.2001436515893425027096903240572794911263e-150) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-3.1764707565307617187500000000000000000000e+00), SC_(4.0672110488770839102538579147880408353266e-145) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-1.8823523521423339843750000000000000000000e+00), SC_(9.5735681267531838992022684956108209200673e-139) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(1.6743277130434096886702251926390864214118e-129) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(8.6739539029766913435717823043942389638078e-116) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.9074008973987377072958478706989489867674e-97) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(2.6960706869978257669101176525769871846174e-77) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(8.7788054405448347038460517495525865868155e-59) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.1806591449746231147066308676510080755650e-43) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(4.5709446223174401043798990606322468967151e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(1.8141279513095930262594599548121177289972e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(3.5745121624473889574637296922819655729700e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.3772143238213235799822740764213563130259e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.9824558495203728813569195286644953721166e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(7.8780875596417223549359738096943476552507e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(4.4368649604371053918618061731169630759084e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(7.9586239530859338466582808550133385725078e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(6.0742081338631677428063553487821583899002e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(2.4349974859835303712397804464920225091885e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(5.9846957784848804443253554059913240322517e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(1.0114370539325552508182400135593484068636e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(1.2809093709875718176861519703856251289548e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(1.2972536356157069542192803702649045058656e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(1.1041394113767131565790875195581277711864e-01) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(8.2058560569788569795672810874314320851457e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(5.4855333551816590090345884723509826781008e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.3759227475780724962271868852566118453702e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(1.9479526332779313400610756068027719101821e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(1.0692105023033684225822339110253917840127e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(5.6473674118686086759048557331529088205637e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(2.8968804078593919595449443958536243308259e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(1.4538763436841210010551793684502400391244e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(7.1816023907271968307888119461772236862627e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(3.5084130809772978735071925453932336987185e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(1.7017089217010633854010977077866894443551e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(8.2208044362437321448665561835383922714548e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(3.9656960532080730006028233383240020280629e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.9142594781629555096001944378687927568145e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(9.2617080502778170423153374907220496059271e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(4.4975823603350497216710848257453935965543e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(2.1945726152174025953519752046198819093492e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(1.0769188505969011847482835269586777097496e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(5.3183849748271447214590769544114270147320e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(2.6447725849093697163999888639038859720239e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(1.3249287409792034708357360719708131823505e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(6.6885529107627973456199863970135218955974e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(3.4034624061211486679340933497864029006431e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.7459494269025319690021866073802076791330e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(9.0305735396698366943516166484814108516064e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(4.7097603098670328632391315318077023772128e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(2.4768604917881888647391109734348952727517e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(1.3134654873139991341263137938060338846154e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(7.0231770698516091455047151621947609263857e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(3.7864282048483745374721896988786072054496e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(2.0581442895558386991344380476948550240873e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.1277817690303401177757963244610946999616e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(6.2293253982430415083746164824590086137077e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(3.4680288142038906496106359784804904420759e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(1.9457538640804936781225253939198872399681e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(1.1000436405998661422797008190769924454182e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(6.2661356585447921103914372217826038999017e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(3.5957538531918256876845164082208633580680e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(2.0784003395779940670077256234966956881985e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(1.2099445936366236179238009723793567818283e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(7.0929988498211563998154774187295646326792e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(4.1866840313597764839597317853210505939290e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(2.4879066415565852810602157327322843315977e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(1.4881740431806383212700705395452300380699e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(8.9593779438916386305198880835955416589959e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(5.4281972630405042356379725975510842792473e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(3.3091890451188491340331874287161393756755e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(2.0296985644394096709667418795191805615285e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(1.2523395864503702483141414007397922677375e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(7.7722341548900618326407809485709714804013e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(4.8512786406811712772642164215422451959875e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(3.0450406575835722673889885068903367044871e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.9218169632120395187445785599796529611036e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.2194650490039953088749291686192853455846e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(7.7787279150928998348462659022109912904340e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(4.9875612714785928827575840489750097224023e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(3.2141619218618960606884771056346038612880e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(2.0815847292918292518191450714169842995892e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.3546553877369109583547029607768088896630e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(8.8579729997167029607449296234165012423600e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(5.8191700455688461026990339659225756830084e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(3.8403727297284758253080738053055394508817e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(2.5458721739698741382439029986643737575735e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.6951350751704296407893540551009993213630e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.1335686594875041606679333630623734401104e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(7.6124211493656261010792731240775122421638e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(5.1333181256379350846112721623104647431305e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(3.4757104914907760837148086633802564160980e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(2.3627490572968781869049846917167047296764e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(1.6124697412961101291315689354456952360534e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.1046827122015828654612883844826274705616e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(7.5965566515411796707072648840827968760044e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(5.2432780219789935264131968427580776224412e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(3.6322030380722816724480706760591044724059e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(2.5251209637848536507844348590546678274960e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(1.7616304955865278024855823209907483104551e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(1.2332305806450729013267180524142813162762e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(8.6623672028816309245291712108407489356634e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(6.1047708275930316279328417722298691106123e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(4.3164257786042111924836793686587440217559e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(3.0616979438255748272472707812728948467454e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(2.1785448716913862656941348712355256189889e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(1.5549383593718076112323688739189728964027e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.1132156713309042365887847341887088317415e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(7.9936002747455010690270393965026191900260e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(5.7568812227751938732196257889083880987487e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(4.1579471054731010695752350419030129112494e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(3.0116418868541810791399397429626537062939e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(2.1874590908190705879619653562166532656035e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(1.5931946316469482524625893627544579089821e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.1635282369823906168388888407139111754555e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(8.5198568605123063493264559260382646667026e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(6.2549350424172447970160452032512704875892e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(4.6039464139839797828770283016106596257353e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(3.3973234460662645966344330436370150488391e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(2.5131901153708699963564585662009515836326e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(1.8637373971024292490088787944499974537306e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(1.3854350776725677345065902976560784254548e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.0323325933493430583805158347106620816575e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(7.7102636177339357027562333628981544604464e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(5.7719082419815051527509409518722523373449e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(4.3306693695410999151217300809730236542964e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(3.2566194876870522722379050310647226864309e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(2.4543086329245363617336087069899749478508e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(1.8536730681077512616008958222637111332390e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(1.4030236581971326654843616778547187477811e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(1.0641702520183290727737795342958845598155e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(8.0884212912209627921721404325207090760679e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(6.1602544045933697331196416284658977212757e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(4.7011988883363420973666159159758127095075e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(3.5948533358762777650471086463405398924216e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(2.7542543488837024073360931940518858312738e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(2.1142932274483391400008294398514838863248e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(1.6261413596885823450246716163563564540069e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(1.2530286391969589296035314423935613031646e-24) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(9.6731389788977671554722309121616661622574e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(7.4811182774218441976526047079931880838073e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(5.7962543252531130348941317914777483668397e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(4.4988294923146297409123284567337132102064e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(3.4979817471479878181404714481912249133478e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(2.7244630676274462518907835905048473797065e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(2.1256161797796531312503447265944442846056e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(1.6611906677708914246012600762566890405778e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(1.3003947222089607198312960986672517757098e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(1.0196298594091468733229139793619520256496e-25) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(8.0078731913006909019550400507006685372082e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(6.2991236634993107407267769454535395196866e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(4.9628075073361129353147495077212439016346e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(3.9160688730522612842042333343876567161361e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(3.0948543539534998015624665614753759040802e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(2.4495903132047845376396912806165704972896e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(1.9417449632918694156084930071110352596899e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(1.5414629480436263091518565256379149566655e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.3777778625488281250000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(1.2254855309578926297672062788834644831189e-26) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(-5.8823466300964355468750000000000000000000e-01), SC_(6.9117146021641599822878581747187872425140e-270) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.0588302612304687500000000000000000000000e-01), SC_(1.5848793404817911224027444812928094480522e-249) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0000000000000000000000000000000000000000e+00), SC_(5.3751025850280201359243866206079833948345e-217) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.2941179275512695312500000000000000000000e+00), SC_(1.2994539029103320617798763490565428183003e-177) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(1.3310223144249320236229298945917600389658e-139) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.5159618724318047705954437644618936667877e-107) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(2.4636904205520699698483574191059430705199e-82) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(4.0220115796405723321391671143818774239529e-63) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(1.2376912787805902326791423698634045872428e-48) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.0465425412338027855477855783373973647701e-37) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(2.0150564851711658001853881763030169405677e-29) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(4.2728726350967780055315759139898481740448e-23) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(3.1500281823810912884812627918749564496065e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(1.8600759388139629998328690319086420447689e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(1.6159429838109002712906603019083484585753e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(3.2268288416219604428790247842908696569420e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(2.0618334783020661764862808874016752969779e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(5.4004060974579220916485471655703093116092e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(6.9938774333789111714727896790532431415843e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(5.1691174738128990647774424215832632375922e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(2.4356372314720627860348093037956334531718e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(7.9766415074152703679472198279424329973208e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(1.9432923573073693128995204203606734479123e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(3.7167881541337432845400798717675887996947e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(5.8266541636946500692245383606003532407776e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(7.7508922324197445731662528111688207120975e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(8.9986010055182325853548017424529362247578e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(9.3292276773787524937933349738552654521792e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(8.8010158510938644945009627341877842894835e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(7.6731293922739220888381247798424078176760e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(6.2625400174179639232932380198378694464671e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(4.8363337141400632007249676438434789840505e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(3.5657977238565824574313126565002046720099e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(2.5289469089148955456822167253926738131338e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(1.7362598384471530800773987760754134410127e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(1.1601319697105074460466699362095235415704e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(7.5785776844688537472504634131260428619887e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(4.8588909790163770713078007792164885411350e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(3.0674918426829933945766846415888770074567e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(1.9122548863590607322141632937181127928525e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(1.1799813890346439162778801187636596490543e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(7.2221484721786231564211952389359291415396e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(4.3922573397860576154483244622457662407307e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(2.6583206560042318209646118170393055150855e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.6032215612277744047852171508808021434625e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(9.6458005715608542249611612826646993983354e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(5.7951290951456552095629541980142004894462e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(3.4796779854995244938383290493339504978897e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(2.0896757464073225687084238994140249340042e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(1.2558908856437770745241683238603000243709e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(7.5578353751229978940120203826382157649768e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(4.5563475243026596657841075515145534226588e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(2.7528043808936959752832002056869268225122e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(1.6673484004162218509022966702778465335926e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(1.0127484419890009330698685961288701295765e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(6.1701911975701273798540785415085408523407e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(3.7714986288334011637831184009891805161640e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(2.3132871903970394180477553097376686056958e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.4239666215328071365958480356464860602883e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(8.7979833788303878895349180254894459695309e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(5.4566757742924072554060280412166631575689e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(3.3975068896130311045869248874352317559050e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(2.1237945959031784068684649911582874195461e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.3329405221955539133871217536906111302678e-08) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.2235290527343750000000000000000000000000e+01), SC_(8.3996514319864670316864479458082371550316e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.3529418945312500000000000000000000000000e+01), SC_(5.3147087974534485346913626082275301263579e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.4823516845703125000000000000000000000000e+01), SC_(3.3765745823661166162295644665533983273247e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.6117645263671875000000000000000000000000e+01), SC_(2.1539969861699283510039620601317479625976e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.7411743164062500000000000000000000000000e+01), SC_(1.3797298865588148160507777401054332581573e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(8.8705871582031250000000000000000000000000e+01), SC_(8.8738156844890152740419015534713064580056e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+01), SC_(5.7304980286503735406269535312218467367108e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.1294097900390625000000000000000000000000e+01), SC_(3.7156591179416642378167384096819476998611e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.2588226318359375000000000000000000000000e+01), SC_(2.4189204483304537908537511187569634087960e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.3882354736328125000000000000000000000000e+01), SC_(1.5810365014062668905563161668414490950298e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.5176452636718750000000000000000000000000e+01), SC_(1.0374987112726438526705873675651170655567e-10) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.6470581054687500000000000000000000000000e+01), SC_(6.8349479635770608538974615118125995565073e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.7764709472656250000000000000000000000000e+01), SC_(4.5203636109152171975821640505621601766873e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(9.9058807373046875000000000000000000000000e+01), SC_(3.0011625907856452898092053383136885211827e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0035293579101562500000000000000000000000e+02), SC_(2.0001282684536904584344000390834343760417e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0164706420898437500000000000000000000000e+02), SC_(1.3380258216577259614379645397293066078415e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0294116210937500000000000000000000000000e+02), SC_(8.9845214898728132140457784476658518384210e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0423529052734375000000000000000000000000e+02), SC_(6.0551105235491015343741749179665215112224e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0552941894531250000000000000000000000000e+02), SC_(4.0957236613001457838557376553144928119154e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0682351684570312500000000000000000000000e+02), SC_(2.7803857439516883437497822193114285512210e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0811764526367187500000000000000000000000e+02), SC_(1.8941641451132300688737144258386240903147e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.0941174316406250000000000000000000000000e+02), SC_(1.2949598856140328035559624174625471363566e-12) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1070587158203125000000000000000000000000e+02), SC_(8.8836908343652021939326487079728954704977e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1200000000000000000000000000000000000000e+02), SC_(6.1152318105577683142956187690909722019965e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1329409790039062500000000000000000000000e+02), SC_(4.2237539433326748921126994206252323365042e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1458822631835937500000000000000000000000e+02), SC_(2.9270020378451030218535959970439854543717e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1588235473632812500000000000000000000000e+02), SC_(2.0350269863941934298177605310412935601693e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1717645263671875000000000000000000000000e+02), SC_(1.4194628753927750563070258839641421281254e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1847058105468750000000000000000000000000e+02), SC_(9.9324798638546018839392570301580780479790e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.1976470947265625000000000000000000000000e+02), SC_(6.9719690697221024288709494016498921661909e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2105880737304687500000000000000000000000e+02), SC_(4.9090977196169465697596058523844578397739e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2235293579101562500000000000000000000000e+02), SC_(3.4671303008355779254609391026444965575385e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2364706420898437500000000000000000000000e+02), SC_(2.4560980769733873441174214890123576042591e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2494116210937500000000000000000000000000e+02), SC_(1.7450713591904455802320861651258399929662e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2623529052734375000000000000000000000000e+02), SC_(1.2435041852755791666703955920245435765901e-14) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2752941894531250000000000000000000000000e+02), SC_(8.8865516378479888526318722154938972119901e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.2882348632812500000000000000000000000000e+02), SC_(6.3688371871362749591241780673492683729427e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3011761474609375000000000000000000000000e+02), SC_(4.5771652778439910632279201267277314865700e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3141174316406250000000000000000000000000e+02), SC_(3.2986183691822508119745409033047598990198e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3270587158203125000000000000000000000000e+02), SC_(2.3836881879908525503710361815725724961512e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3400000000000000000000000000000000000000e+02), SC_(1.7271570440849570855227155490344969602356e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3529412841796875000000000000000000000000e+02), SC_(1.2547655965379801765036440599673213464430e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3658819580078125000000000000000000000000e+02), SC_(9.1396985137665788850557874605318401726428e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3788232421875000000000000000000000000000e+02), SC_(6.6743741046675121700634263930566155447433e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.3917645263671875000000000000000000000000e+02), SC_(4.8864032365670015126610015765775809526766e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4047058105468750000000000000000000000000e+02), SC_(3.5863490559689309689570085962278918004295e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4176470947265625000000000000000000000000e+02), SC_(2.6386693834343124520745523831442668999556e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4305877685546875000000000000000000000000e+02), SC_(1.9461562445048380210175089008100338723084e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4435290527343750000000000000000000000000e+02), SC_(1.4388099884269639410496858184471539110475e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4564703369140625000000000000000000000000e+02), SC_(1.0662373431835655745840142277495230207633e-16) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4694116210937500000000000000000000000000e+02), SC_(7.9198091717947994420619842247256870984375e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4823529052734375000000000000000000000000e+02), SC_(5.8961952149964356197856553817289096429668e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.4952941894531250000000000000000000000000e+02), SC_(4.3995824996666269617238857180393359200623e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5082348632812500000000000000000000000000e+02), SC_(3.2902272024145521578636548062348910468956e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5211761474609375000000000000000000000000e+02), SC_(2.4659817748655338544777500175443572359851e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5341174316406250000000000000000000000000e+02), SC_(1.8522356461089005054988719505997962613603e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5470587158203125000000000000000000000000e+02), SC_(1.3942226058036677502415587693253845014359e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5600000000000000000000000000000000000000e+02), SC_(1.0516829678014193850390490157089157827647e-17) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5729412841796875000000000000000000000000e+02), SC_(7.9495391602901684712065638080525194733541e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5858819580078125000000000000000000000000e+02), SC_(6.0213919817848045401547949859339867131793e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.5988232421875000000000000000000000000000e+02), SC_(4.5701061641906050289978412286615672056424e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6117645263671875000000000000000000000000e+02), SC_(3.4755539211048853556206122041700583535584e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6247058105468750000000000000000000000000e+02), SC_(2.6483692256223501643108836636076156663822e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6376470947265625000000000000000000000000e+02), SC_(2.0219872204246062652396860448674740824892e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6505877685546875000000000000000000000000e+02), SC_(1.5467421930394315348702418150219087104683e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6635290527343750000000000000000000000000e+02), SC_(1.1854279003194261237204582769683713816934e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6764703369140625000000000000000000000000e+02), SC_(9.1021660151919587519923569375005676733829e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.6894116210937500000000000000000000000000e+02), SC_(7.0019039352275048784518993988755298015621e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7023529052734375000000000000000000000000e+02), SC_(5.3960865863699129177650571401024606851949e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7152941894531250000000000000000000000000e+02), SC_(4.1660338900967325048174620109362003727931e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7282348632812500000000000000000000000000e+02), SC_(3.2221295582334924089849102119683837561230e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7411761474609375000000000000000000000000e+02), SC_(2.4964283254577323374957306169839775612634e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7541174316406250000000000000000000000000e+02), SC_(1.9375221466692285718731406169173928176714e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7670587158203125000000000000000000000000e+02), SC_(1.5063163050036944584443748584767937957613e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7800000000000000000000000000000000000000e+02), SC_(1.1730546066723459946465149381315458788014e-19) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.7929412841796875000000000000000000000000e+02), SC_(9.1504745409027225667626990075597547694227e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8058819580078125000000000000000000000000e+02), SC_(7.1497082686278342334406213662911768141880e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8188232421875000000000000000000000000000e+02), SC_(5.5954283028624614542247327623193530391607e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8317645263671875000000000000000000000000e+02), SC_(4.3860641775669060180430564469145369768459e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8447058105468750000000000000000000000000e+02), SC_(3.4435362945940884787212351006000946314451e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8576470947265625000000000000000000000000e+02), SC_(2.7077834731989410715272993896885743499793e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8705883789062500000000000000000000000000e+02), SC_(2.1325267183111494500243512554441652518177e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8835290527343750000000000000000000000000e+02), SC_(1.6820658289516593069710618072349691117996e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.8964703369140625000000000000000000000000e+02), SC_(1.3287451949445303282506260265200304976290e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9094116210937500000000000000000000000000e+02), SC_(1.0512054939957646147626278082938675337786e-20) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9223529052734375000000000000000000000000e+02), SC_(8.3286185995150697843972088575655403212301e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9352941894531250000000000000000000000000e+02), SC_(6.6083058606068525233064513480660622844672e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9482348632812500000000000000000000000000e+02), SC_(5.2509308590514398685281991518802959496870e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9611761474609375000000000000000000000000e+02), SC_(4.1782524001342735390025762231232723433164e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9741174316406250000000000000000000000000e+02), SC_(3.3293750512236876243529478562041180484902e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(3.4666656494140625000000000000000000000000e+01), SC_(1.9870587158203125000000000000000000000000e+02), SC_(2.6566437133531385756043835227267613995637e-21) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.5882358551025390625000000000000000000000e+00), SC_(1.0193205615891214669104517421181936572255e-253) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8823528289794921875000000000000000000000e+00), SC_(1.5795471601035238427972160774015471034727e-198) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1764717102050781250000000000000000000000e+00), SC_(1.1291869673219556877608208053092452303569e-154) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.4705886840820312500000000000000000000000e+00), SC_(6.3272685550688083200112276260294000809690e-121) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(9.7647056579589843750000000000000000000000e+00), SC_(3.2687253856604788536100809024725794121975e-95) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.1058822631835937500000000000000000000000e+01), SC_(1.3520627427384147190871368480907282134990e-75) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.2352939605712890625000000000000000000000e+01), SC_(1.5777824538708036672963916618070741114484e-60) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.3647060394287109375000000000000000000000e+01), SC_(7.5207148039985319036538171344420378116082e-49) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.4941177368164062500000000000000000000000e+01), SC_(1.0384340368538795403224523748663672519413e-39) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.6235290527343750000000000000000000000000e+01), SC_(1.7321157659690597537603284612753304425504e-32) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.7529411315917968750000000000000000000000e+01), SC_(9.9160594239826130944575167454311193776079e-27) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(1.8823524475097656250000000000000000000000e+01), SC_(4.2036095346420410091568709278911159683897e-22) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.0117645263671875000000000000000000000000e+01), SC_(2.3384418983882646395977749874904898218640e-18) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.1411766052246093750000000000000000000000e+01), SC_(2.6239986187840968311020767181577176587962e-15) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.2705879211425781250000000000000000000000e+01), SC_(8.2336434606489011832793707608163398821597e-13) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.4000000000000000000000000000000000000000e+01), SC_(9.2845959379503449450833995026134614104184e-11) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.5294113159179687500000000000000000000000e+01), SC_(4.5701137703076079080042890079635620584404e-09) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.6588233947753906250000000000000000000000e+01), SC_(1.1435469306776585311120232967129648970383e-07) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.7882354736328125000000000000000000000000e+01), SC_(1.6406143442083775651268830086394024830887e-06) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(2.9176467895507812500000000000000000000000e+01), SC_(1.4853949464065391208152600615492103639622e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.0470588684082031250000000000000000000000e+01), SC_(9.1673584366715592040080401450617184454851e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.1764701843261718750000000000000000000000e+01), SC_(4.1048682608545755757413863180334712538636e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.3058822631835937500000000000000000000000e+01), SC_(1.4031446519247928325823170121698547610856e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.4352935791015625000000000000000000000000e+01), SC_(3.8174355116928636246818665809754497116841e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.5647048950195312500000000000000000000000e+01), SC_(8.5560616640336365840412767754776072356471e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.6941177368164062500000000000000000000000e+01), SC_(1.6256877268153219237953311458371350112016e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.8235290527343750000000000000000000000000e+01), SC_(2.6818103185363437046903897222415314345511e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(3.9529403686523437500000000000000000000000e+01), SC_(3.9188094860855204259456375041481328596518e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.0823532104492187500000000000000000000000e+01), SC_(5.1588652096084792857654581232159579332746e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.2117645263671875000000000000000000000000e+01), SC_(6.2063850737003346236102255184172107516579e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.3411758422851562500000000000000000000000e+01), SC_(6.9070503830690158778550355040758266461342e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.4705871582031250000000000000000000000000e+01), SC_(7.1849832657728963542312659946349311770876e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.6000000000000000000000000000000000000000e+01), SC_(7.0485815339888002306387792830708746813210e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.7294113159179687500000000000000000000000e+01), SC_(6.5711668143353588864895052018791048552227e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.8588226318359375000000000000000000000000e+01), SC_(5.8602079838759929686338077193462393177452e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(4.9882354736328125000000000000000000000000e+01), SC_(5.0279495500443754125245653152670321626947e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.1176467895507812500000000000000000000000e+01), SC_(4.1708823005796634620749651676828133872754e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.2470581054687500000000000000000000000000e+01), SC_(3.3596484893232948890895855436793376473252e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.3764709472656250000000000000000000000000e+01), SC_(2.6376579433279746863583571942522121288572e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.5058822631835937500000000000000000000000e+01), SC_(2.0250238479191193132493821623779637908995e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.6352935791015625000000000000000000000000e+01), SC_(1.5246731203053434315191299136530470430262e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.7647048950195312500000000000000000000000e+01), SC_(1.1286382979116622396884596732740705645403e-02) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(5.8941177368164062500000000000000000000000e+01), SC_(8.2324106688419808069745595355563259346059e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.0235290527343750000000000000000000000000e+01), SC_(5.9285225480878701284764439632610528072217e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.1529403686523437500000000000000000000000e+01), SC_(4.2224209979096774023444511380991489164341e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.2823532104492187500000000000000000000000e+01), SC_(2.9787450005836775766710203182493078613702e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.4117645263671875000000000000000000000000e+01), SC_(2.0842617813706204143678559251529251912357e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.5411743164062500000000000000000000000000e+01), SC_(1.4482335277636977022677184597575347245330e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.6705871582031250000000000000000000000000e+01), SC_(1.0003414060479000801422888858267158100955e-03) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.8000000000000000000000000000000000000000e+01), SC_(6.8753521035881288213035223381023599406334e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(6.9294097900390625000000000000000000000000e+01), SC_(4.7059488139813643094948230627503656416627e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.0588226318359375000000000000000000000000e+01), SC_(3.2101232807764873214304962242756207907604e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.1882354736328125000000000000000000000000e+01), SC_(2.1837922089518353273320136722937945362515e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.3176452636718750000000000000000000000000e+01), SC_(1.4824412183901368540481988520322217399682e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.4470581054687500000000000000000000000000e+01), SC_(1.0047126164502202517293324137735316277528e-04) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.5764709472656250000000000000000000000000e+01), SC_(6.8016321511475239423987724615124285506988e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.7058807373046875000000000000000000000000e+01), SC_(4.6012728687642498216377136314342322812808e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.8352935791015625000000000000000000000000e+01), SC_(3.1116542900615295025505995755017438002090e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(7.9647064208984375000000000000000000000000e+01), SC_(2.1042753031018284650296643607435605723099e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.5555557250976562500000000000000000000000e+01), SC_(8.0941162109375000000000000000000000000000e+01), SC_(1.4234600873975132620845820848468976056965e-05) }, 
      { SC_(3.4666656494140625000000000000000000000000e+01), SC_(4.555555725097656250