function(TEST variable)
  if(ARGC GREATER 2)
    set(i 0)
    foreach(value IN LISTS ${variable})
      math(EXPR j "${i} + 1")
      set(${variable}[${i}] "${value}")
      TEST(${variable}[${i}] "${ARGV${j}}")
      set(i ${j})
    endforeach()
  else()
    set(expected "${ARGN}")
    if("${expected}" STREQUAL "UNDEFINED")
      if(DEFINED ${variable})
        message(FATAL_ERROR "'${variable}' shall be undefined but has value '${${variable}}'")
      endif()
    elseif(NOT DEFINED ${variable})
        message(FATAL_ERROR "'${variable}' should be defined but is not")
    elseif("${expected}" STREQUAL "FALSE")
      if(NOT ${variable} STREQUAL "FALSE")
        message(FATAL_ERROR "'${variable}' shall be FALSE")
      endif()
    elseif("${expected}" STREQUAL "TRUE")
      if(NOT ${variable} STREQUAL "TRUE")
        message(FATAL_ERROR "'${variable}' shall be TRUE")
      endif()
    else()
      if(NOT ${variable} STREQUAL "${expected}")
        message(FATAL_ERROR "'${variable}' shall be '${expected}' but has value '${${variable}}'")
      endif()
    endif()
  endif()
endfunction()
