/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright 2013 Freescale Semiconductor, Inc.
 */

#ifndef __DTS_IMX35_PINFUNC_H
#define __DTS_IMX35_PINFUNC_H

/*
 * The pin function ID is a tuple of
 * <mux_reg conf_reg input_reg mux_mode input_val>
 */
#define MX35_PAD_CAPTURE__GPT_CAPIN1				0x004 0x328 0x000 0x0 0x0
#define MX35_PAD_CAPTURE__GPT_CMPOUT2				0x004 0x328 0x000 0x1 0x0
#define MX35_PAD_CAPTURE__CSPI2_SS1				0x004 0x328 0x7f4 0x2 0x0
#define MX35_PAD_CAPTURE__EPIT1_EPITO				0x004 0x328 0x000 0x3 0x0
#define MX35_PAD_CAPTURE__CCM_CLK32K				0x004 0x328 0x7d0 0x4 0x0
#define MX35_PAD_CAPTURE__GPIO1_4				0x004 0x328 0x850 0x5 0x0
#define MX35_PAD_COMPARE__GPT_CMPOUT1				0x008 0x32c 0x000 0x0 0x0
#define MX35_PAD_COMPARE__GPT_CAPIN2				0x008 0x32c 0x000 0x1 0x0
#define MX35_PAD_COMPARE__GPT_CMPOUT3				0x008 0x32c 0x000 0x2 0x0
#define MX35_PAD_COMPARE__EPIT2_EPITO				0x008 0x32c 0x000 0x3 0x0
#define MX35_PAD_COMPARE__GPIO1_5				0x008 0x32c 0x854 0x5 0x0
#define MX35_PAD_COMPARE__SDMA_EXTDMA_2				0x008 0x32c 0x000 0x7 0x0
#define MX35_PAD_WDOG_RST__WDOG_WDOG_B				0x00c 0x330 0x000 0x0 0x0
#define MX35_PAD_WDOG_RST__IPU_FLASH_STROBE			0x00c 0x330 0x000 0x3 0x0
#define MX35_PAD_WDOG_RST__GPIO1_6				0x00c 0x330 0x858 0x5 0x0
#define MX35_PAD_GPIO1_0__GPIO1_0				0x010 0x334 0x82c 0x0 0x0
#define MX35_PAD_GPIO1_0__CCM_PMIC_RDY				0x010 0x334 0x7d4 0x1 0x0
#define MX35_PAD_GPIO1_0__OWIRE_LINE				0x010 0x334 0x990 0x2 0x0
#define MX35_PAD_GPIO1_0__SDMA_EXTDMA_0				0x010 0x334 0x000 0x7 0x0
#define MX35_PAD_GPIO1_1__GPIO1_1				0x014 0x338 0x838 0x0 0x0
#define MX35_PAD_GPIO1_1__PWM_PWMO				0x014 0x338 0x000 0x2 0x0
#define MX35_PAD_GPIO1_1__CSPI1_SS2				0x014 0x338 0x7d8 0x3 0x0
#define MX35_PAD_GPIO1_1__SCC_TAMPER_DETECT			0x014 0x338 0x000 0x6 0x0
#define MX35_PAD_GPIO1_1__SDMA_EXTDMA_1				0x014 0x338 0x000 0x7 0x0
#define MX35_PAD_GPIO2_0__GPIO2_0				0x018 0x33c 0x868 0x0 0x0
#define MX35_PAD_GPIO2_0__USB_TOP_USBOTG_CLK			0x018 0x33c 0x000 0x1 0x0
#define MX35_PAD_GPIO3_0__GPIO3_0				0x01c 0x340 0x8e8 0x0 0x0
#define MX35_PAD_GPIO3_0__USB_TOP_USBH2_CLK			0x01c 0x340 0x000 0x1 0x0
#define MX35_PAD_RESET_IN_B__CCM_RESET_IN_B			0x000 0x344 0x000 0x0 0x0
#define MX35_PAD_POR_B__CCM_POR_B				0x000 0x348 0x000 0x0 0x0
#define MX35_PAD_CLKO__CCM_CLKO					0x020 0x34c 0x000 0x0 0x0
#define MX35_PAD_CLKO__GPIO1_8					0x020 0x34c 0x860 0x5 0x0
#define MX35_PAD_BOOT_MODE0__CCM_BOOT_MODE_0			0x000 0x350 0x000 0x0 0x0
#define MX35_PAD_BOOT_MODE1__CCM_BOOT_MODE_1			0x000 0x354 0x000 0x0 0x0
#define MX35_PAD_CLK_MODE0__CCM_CLK_MODE_0			0x000 0x358 0x000 0x0 0x0
#define MX35_PAD_CLK_MODE1__CCM_CLK_MODE_1			0x000 0x35c 0x000 0x0 0x0
#define MX35_PAD_POWER_FAIL__CCM_DSM_WAKEUP_INT_26		0x000 0x360 0x000 0x0 0x0
#define MX35_PAD_VSTBY__CCM_VSTBY				0x024 0x364 0x000 0x0 0x0
#define MX35_PAD_VSTBY__GPIO1_7					0x024 0x364 0x85c 0x5 0x0
#define MX35_PAD_A0__EMI_EIM_DA_L_0				0x028 0x368 0x000 0x0 0x0
#define MX35_PAD_A1__EMI_EIM_DA_L_1				0x02c 0x36c 0x000 0x0 0x0
#define MX35_PAD_A2__EMI_EIM_DA_L_2				0x030 0x370 0x000 0x0 0x0
#define MX35_PAD_A3__EMI_EIM_DA_L_3				0x034 0x374 0x000 0x0 0x0
#define MX35_PAD_A4__EMI_EIM_DA_L_4				0x038 0x378 0x000 0x0 0x0
#define MX35_PAD_A5__EMI_EIM_DA_L_5				0x03c 0x37c 0x000 0x0 0x0
#define MX35_PAD_A6__EMI_EIM_DA_L_6				0x040 0x380 0x000 0x0 0x0
#define MX35_PAD_A7__EMI_EIM_DA_L_7				0x044 0x384 0x000 0x0 0x0
#define MX35_PAD_A8__EMI_EIM_DA_H_8				0x048 0x388 0x000 0x0 0x0
#define MX35_PAD_A9__EMI_EIM_DA_H_9				0x04c 0x38c 0x000 0x0 0x0
#define MX35_PAD_A10__EMI_EIM_DA_H_10				0x050 0x390 0x000 0x0 0x0
#define MX35_PAD_MA10__EMI_MA10					0x054 0x394 0x000 0x0 0x0
#define MX35_PAD_A11__EMI_EIM_DA_H_11				0x058 0x398 0x000 0x0 0x0
#define MX35_PAD_A12__EMI_EIM_DA_H_12				0x05c 0x39c 0x000 0x0 0x0
#define MX35_PAD_A13__EMI_EIM_DA_H_13				0x060 0x3a0 0x000 0x0 0x0
#define MX35_PAD_A14__EMI_EIM_DA_H2_14				0x064 0x3a4 0x000 0x0 0x0
#define MX35_PAD_A15__EMI_EIM_DA_H2_15				0x068 0x3a8 0x000 0x0 0x0
#define MX35_PAD_A16__EMI_EIM_A_16				0x06c 0x3ac 0x000 0x0 0x0
#define MX35_PAD_A17__EMI_EIM_A_17				0x070 0x3b0 0x000 0x0 0x0
#define MX35_PAD_A18__EMI_EIM_A_18				0x074 0x3b4 0x000 0x0 0x0
#define MX35_PAD_A19__EMI_EIM_A_19				0x078 0x3b8 0x000 0x0 0x0
#define MX35_PAD_A20__EMI_EIM_A_20				0x07c 0x3bc 0x000 0x0 0x0
#define MX35_PAD_A21__EMI_EIM_A_21				0x080 0x3c0 0x000 0x0 0x0
#define MX35_PAD_A22__EMI_EIM_A_22				0x084 0x3c4 0x000 0x0 0x0
#define MX35_PAD_A23__EMI_EIM_A_23				0x088 0x3c8 0x000 0x0 0x0
#define MX35_PAD_A24__EMI_EIM_A_24				0x08c 0x3cc 0x000 0x0 0x0
#define MX35_PAD_A25__EMI_EIM_A_25				0x090 0x3d0 0x000 0x0 0x0
#define MX35_PAD_SDBA1__EMI_EIM_SDBA1				0x000 0x3d4 0x000 0x0 0x0
#define MX35_PAD_SDBA0__EMI_EIM_SDBA0				0x000 0x3d8 0x000 0x0 0x0
#define MX35_PAD_SD0__EMI_DRAM_D_0				0x000 0x3dc 0x000 0x0 0x0
#define MX35_PAD_SD1__EMI_DRAM_D_1				0x000 0x3e0 0x000 0x0 0x0
#define MX35_PAD_SD2__EMI_DRAM_D_2				0x000 0x3e4 0x000 0x0 0x0
#define MX35_PAD_SD3__EMI_DRAM_D_3				0x000 0x3e8 0x000 0x0 0x0
#define MX35_PAD_SD4__EMI_DRAM_D_4				0x000 0x3ec 0x000 0x0 0x0
#define MX35_PAD_SD5__EMI_DRAM_D_5				0x000 0x3f0 0x000 0x0 0x0
#define MX35_PAD_SD6__EMI_DRAM_D_6				0x000 0x3f4 0x000 0x0 0x0
#define MX35_PAD_SD7__EMI_DRAM_D_7				0x000 0x3f8 0x000 0x0 0x0
#define MX35_PAD_SD8__EMI_DRAM_D_8				0x000 0x3fc 0x000 0x0 0x0
#define MX35_PAD_SD9__EMI_DRAM_D_9				0x000 0x400 0x000 0x0 0x0
#define MX35_PAD_SD10__EMI_DRAM_D_10				0x000 0x404 0x000 0x0 0x0
#define MX35_PAD_SD11__EMI_DRAM_D_11				0x000 0x408 0x000 0x0 0x0
#define MX35_PAD_SD12__EMI_DRAM_D_12				0x000 0x40c 0x000 0x0 0x0
#define MX35_PAD_SD13__EMI_DRAM_D_13				0x000 0x410 0x000 0x0 0x0
#define MX35_PAD_SD14__EMI_DRAM_D_14				0x000 0x414 0x000 0x0 0x0
#define MX35_PAD_SD15__EMI_DRAM_D_15				0x000 0x418 0x000 0x0 0x0
#define MX35_PAD_SD16__EMI_DRAM_D_16				0x000 0x41c 0x000 0x0 0x0
#define MX35_PAD_SD17__EMI_DRAM_D_17				0x000 0x420 0x000 0x0 0x0
#define MX35_PAD_SD18__EMI_DRAM_D_18				0x000 0x424 0x000 0x0 0x0
#define MX35_PAD_SD19__EMI_DRAM_D_19				0x000 0x428 0x000 0x0 0x0
#define MX35_PAD_SD20__EMI_DRAM_D_20				0x000 0x42c 0x000 0x0 0x0
#define MX35_PAD_SD21__EMI_DRAM_D_21				0x000 0x430 0x000 0x0 0x0
#define MX35_PAD_SD22__EMI_DRAM_D_22				0x000 0x434 0x000 0x0 0x0
#define MX35_PAD_SD23__EMI_DRAM_D_23				0x000 0x438 0x000 0x0 0x0
#define MX35_PAD_SD24__EMI_DRAM_D_24				0x000 0x43c 0x000 0x0 0x0
#define MX35_PAD_SD25__EMI_DRAM_D_25				0x000 0x440 0x000 0x0 0x0
#define MX35_PAD_SD26__EMI_DRAM_D_26				0x000 0x444 0x000 0x0 0x0
#define MX35_PAD_SD27__EMI_DRAM_D_27				0x000 0x448 0x000 0x0 0x0
#define MX35_PAD_SD28__EMI_DRAM_D_28				0x000 0x44c 0x000 0x0 0x0
#define MX35_PAD_SD29__EMI_DRAM_D_29				0x000 0x450 0x000 0x0 0x0
#define MX35_PAD_SD30__EMI_DRAM_D_30				0x000 0x454 0x000 0x0 0x0
#define MX35_PAD_SD31__EMI_DRAM_D_31				0x000 0x458 0x000 0x0 0x0
#define MX35_PAD_DQM0__EMI_DRAM_DQM_0				0x000 0x45c 0x000 0x0 0x0
#define MX35_PAD_DQM1__EMI_DRAM_DQM_1				0x000 0x460 0x000 0x0 0x0
#define MX35_PAD_DQM2__EMI_DRAM_DQM_2				0x000 0x464 0x000 0x0 0x0
#define MX35_PAD_DQM3__EMI_DRAM_DQM_3				0x000 0x468 0x000 0x0 0x0
#define MX35_PAD_EB0__EMI_EIM_EB0_B				0x094 0x46c 0x000 0x0 0x0
#define MX35_PAD_EB1__EMI_EIM_EB1_B				0x098 0x470 0x000 0x0 0x0
#define MX35_PAD_OE__EMI_EIM_OE					0x09c 0x474 0x000 0x0 0x0
#define MX35_PAD_CS0__EMI_EIM_CS0				0x0a0 0x478 0x000 0x0 0x0
#define MX35_PAD_CS1__EMI_EIM_CS1				0x0a4 0x47c 0x000 0x0 0x0
#define MX35_PAD_CS1__EMI_NANDF_CE3				0x0a4 0x47c 0x000 0x3 0x0
#define MX35_PAD_CS2__EMI_EIM_CS2				0x0a8 0x480 0x000 0x0 0x0
#define MX35_PAD_CS3__EMI_EIM_CS3				0x0ac 0x484 0x000 0x0 0x0
#define MX35_PAD_CS4__EMI_EIM_CS4				0x0b0 0x488 0x000 0x0 0x0
#define MX35_PAD_CS4__EMI_DTACK_B				0x0b0 0x488 0x800 0x1 0x0
#define MX35_PAD_CS4__EMI_NANDF_CE1				0x0b0 0x488 0x000 0x3 0x0
#define MX35_PAD_CS4__GPIO1_20					0x0b0 0x488 0x83c 0x5 0x0
#define MX35_PAD_CS5__EMI_EIM_CS5				0x0b4 0x48c 0x000 0x0 0x0
#define MX35_PAD_CS5__CSPI2_SS2					0x0b4 0x48c 0x7f8 0x1 0x0
#define MX35_PAD_CS5__CSPI1_SS2					0x0b4 0x48c 0x7d8 0x2 0x1
#define MX35_PAD_CS5__EMI_NANDF_CE2				0x0b4 0x48c 0x000 0x3 0x0
#define MX35_PAD_CS5__GPIO1_21					0x0b4 0x48c 0x840 0x5 0x0
#define MX35_PAD_NF_CE0__EMI_NANDF_CE0				0x0b8 0x490 0x000 0x0 0x0
#define MX35_PAD_NF_CE0__GPIO1_22				0x0b8 0x490 0x844 0x5 0x0
#define MX35_PAD_ECB__EMI_EIM_ECB				0x000 0x494 0x000 0x0 0x0
#define MX35_PAD_LBA__EMI_EIM_LBA				0x0bc 0x498 0x000 0x0 0x0
#define MX35_PAD_BCLK__EMI_EIM_BCLK				0x0c0 0x49c 0x000 0x0 0x0
#define MX35_PAD_RW__EMI_EIM_RW					0x0c4 0x4a0 0x000 0x0 0x0
#define MX35_PAD_RAS__EMI_DRAM_RAS				0x000 0x4a4 0x000 0x0 0x0
#define MX35_PAD_CAS__EMI_DRAM_CAS				0x000 0x4a8 0x000 0x0 0x0
#define MX35_PAD_SDWE__EMI_DRAM_SDWE				0x000 0x4ac 0x000 0x0 0x0
#define MX35_PAD_SDCKE0__EMI_DRAM_SDCKE_0			0x000 0x4b0 0x000 0x0 0x0
#define MX35_PAD_SDCKE1__EMI_DRAM_SDCKE_1			0x000 0x4b4 0x000 0x0 0x0
#define MX35_PAD_SDCLK__EMI_DRAM_SDCLK				0x000 0x4b8 0x000 0x0 0x0
#define MX35_PAD_SDQS0__EMI_DRAM_SDQS_0				0x000 0x4bc 0x000 0x0 0x0
#define MX35_PAD_SDQS1__EMI_DRAM_SDQS_1				0x000 0x4c0 0x000 0x0 0x0
#define MX35_PAD_SDQS2__EMI_DRAM_SDQS_2				0x000 0x4c4 0x000 0x0 0x0
#define MX35_PAD_SDQS3__EMI_DRAM_SDQS_3				0x000 0x4c8 0x000 0x0 0x0
#define MX35_PAD_NFWE_B__EMI_NANDF_WE_B				0x0c8 0x4cc 0x000 0x0 0x0
#define MX35_PAD_NFWE_B__USB_TOP_USBH2_DATA_3			0x0c8 0x4cc 0x9d8 0x1 0x0
#define MX35_PAD_NFWE_B__IPU_DISPB_D0_VSYNC			0x0c8 0x4cc 0x924 0x2 0x0
#define MX35_PAD_NFWE_B__GPIO2_18				0x0c8 0x4cc 0x88c 0x5 0x0
#define MX35_PAD_NFWE_B__ARM11P_TOP_TRACE_0			0x0c8 0x4cc 0x000 0x7 0x0
#define MX35_PAD_NFRE_B__EMI_NANDF_RE_B				0x0cc 0x4d0 0x000 0x0 0x0
#define MX35_PAD_NFRE_B__USB_TOP_USBH2_DIR			0x0cc 0x4d0 0x9ec 0x1 0x0
#define MX35_PAD_NFRE_B__IPU_DISPB_BCLK				0x0cc 0x4d0 0x000 0x2 0x0
#define MX35_PAD_NFRE_B__GPIO2_19				0x0cc 0x4d0 0x890 0x5 0x0
#define MX35_PAD_NFRE_B__ARM11P_TOP_TRACE_1			0x0cc 0x4d0 0x000 0x7 0x0
#define MX35_PAD_NFALE__EMI_NANDF_ALE				0x0d0 0x4d4 0x000 0x0 0x0
#define MX35_PAD_NFALE__USB_TOP_USBH2_STP			0x0d0 0x4d4 0x000 0x1 0x0
#define MX35_PAD_NFALE__IPU_DISPB_CS0				0x0d0 0x4d4 0x000 0x2 0x0
#define MX35_PAD_NFALE__GPIO2_20				0x0d0 0x4d4 0x898 0x5 0x0
#define MX35_PAD_NFALE__ARM11P_TOP_TRACE_2			0x0d0 0x4d4 0x000 0x7 0x0
#define MX35_PAD_NFCLE__EMI_NANDF_CLE				0x0d4 0x4d8 0x000 0x0 0x0
#define MX35_PAD_NFCLE__USB_TOP_USBH2_NXT			0x0d4 0x4d8 0x9f0 0x1 0x0
#define MX35_PAD_NFCLE__IPU_DISPB_PAR_RS			0x0d4 0x4d8 0x000 0x2 0x0
#define MX35_PAD_NFCLE__GPIO2_21				0x0d4 0x4d8 0x89c 0x5 0x0
#define MX35_PAD_NFCLE__ARM11P_TOP_TRACE_3			0x0d4 0x4d8 0x000 0x7 0x0
#define MX35_PAD_NFWP_B__EMI_NANDF_WP_B				0x0d8 0x4dc 0x000 0x0 0x0
#define MX35_PAD_NFWP_B__USB_TOP_USBH2_DATA_7			0x0d8 0x4dc 0x9e8 0x1 0x0
#define MX35_PAD_NFWP_B__IPU_DISPB_WR				0x0d8 0x4dc 0x000 0x2 0x0
#define MX35_PAD_NFWP_B__GPIO2_22				0x0d8 0x4dc 0x8a0 0x5 0x0
#define MX35_PAD_NFWP_B__ARM11P_TOP_TRCTL			0x0d8 0x4dc 0x000 0x7 0x0
#define MX35_PAD_NFRB__EMI_NANDF_RB				0x0dc 0x4e0 0x000 0x0 0x0
#define MX35_PAD_NFRB__IPU_DISPB_RD				0x0dc 0x4e0 0x000 0x2 0x0
#define MX35_PAD_NFRB__GPIO2_23					0x0dc 0x4e0 0x8a4 0x5 0x0
#define MX35_PAD_NFRB__ARM11P_TOP_TRCLK				0x0dc 0x4e0 0x000 0x7 0x0
#define MX35_PAD_D15__EMI_EIM_D_15				0x000 0x4e4 0x000 0x0 0x0
#define MX35_PAD_D14__EMI_EIM_D_14				0x000 0x4e8 0x000 0x0 0x0
#define MX35_PAD_D13__EMI_EIM_D_13				0x000 0x4ec 0x000 0x0 0x0
#define MX35_PAD_D12__EMI_EIM_D_12				0x000 0x4f0 0x000 0x0 0x0
#define MX35_PAD_D11__EMI_EIM_D_11				0x000 0x4f4 0x000 0x0 0x0
#define MX35_PAD_D10__EMI_EIM_D_10				0x000 0x4f8 0x000 0x0 0x0
#define MX35_PAD_D9__EMI_EIM_D_9				0x000 0x4fc 0x000 0x0 0x0
#define MX35_PAD_D8__EMI_EIM_D_8				0x000 0x500 0x000 0x0 0x0
#define MX35_PAD_D7__EMI_EIM_D_7				0x000 0x504 0x000 0x0 0x0
#define MX35_PAD_D6__EMI_EIM_D_6				0x000 0x508 0x000 0x0 0x0
#define MX35_PAD_D5__EMI_EIM_D_5				0x000 0x50c 0x000 0x0 0x0
#define MX35_PAD_D4__EMI_EIM_D_4				0x000 0x510 0x000 0x0 0x0
#define MX35_PAD_D3__EMI_EIM_D_3				0x000 0x514 0x000 0x0 0x0
#define MX35_PAD_D2__EMI_EIM_D_2				0x000 0x518 0x000 0x0 0x0
#define MX35_PAD_D1__EMI_EIM_D_1				0x000 0x51c 0x000 0x0 0x0
#define MX35_PAD_D0__EMI_EIM_D_0				0x000 0x520 0x000 0x0 0x0
#define MX35_PAD_CSI_D8__IPU_CSI_D_8				0x0e0 0x524 0x000 0x0 0x0
#define MX35_PAD_CSI_D8__KPP_COL_0				0x0e0 0x524 0x950 0x1 0x0
#define MX35_PAD_CSI_D8__GPIO1_20				0x0e0 0x524 0x83c 0x5 0x1
#define MX35_PAD_CSI_D8__ARM11P_TOP_EVNTBUS_13			0x0e0 0x524 0x000 0x7 0x0
#define MX35_PAD_CSI_D9__IPU_CSI_D_9				0x0e4 0x528 0x000 0x0 0x0
#define MX35_PAD_CSI_D9__KPP_COL_1				0x0e4 0x528 0x954 0x1 0x0
#define MX35_PAD_CSI_D9__GPIO1_21				0x0e4 0x528 0x840 0x5 0x1
#define MX35_PAD_CSI_D9__ARM11P_TOP_EVNTBUS_14			0x0e4 0x528 0x000 0x7 0x0
#define MX35_PAD_CSI_D10__IPU_CSI_D_10				0x0e8 0x52c 0x000 0x0 0x0
#define MX35_PAD_CSI_D10__KPP_COL_2				0x0e8 0x52c 0x958 0x1 0x0
#define MX35_PAD_CSI_D10__GPIO1_22				0x0e8 0x52c 0x844 0x5 0x1
#define MX35_PAD_CSI_D10__ARM11P_TOP_EVNTBUS_15			0x0e8 0x52c 0x000 0x7 0x0
#define MX35_PAD_CSI_D11__IPU_CSI_D_11				0x0ec 0x530 0x000 0x0 0x0
#define MX35_PAD_CSI_D11__KPP_COL_3				0x0ec 0x530 0x95c 0x1 0x0
#define MX35_PAD_CSI_D11__GPIO1_23				0x0ec 0x530 0x000 0x5 0x0
#define MX35_PAD_CSI_D12__IPU_CSI_D_12				0x0f0 0x534 0x000 0x0 0x0
#define MX35_PAD_CSI_D12__KPP_ROW_0				0x0f0 0x534 0x970 0x1 0x0
#define MX35_PAD_CSI_D12__GPIO1_24				0x0f0 0x534 0x000 0x5 0x0
#define MX35_PAD_CSI_D13__IPU_CSI_D_13				0x0f4 0x538 0x000 0x0 0x0
#define MX35_PAD_CSI_D13__KPP_ROW_1				0x0f4 0x538 0x974 0x1 0x0
#define MX35_PAD_CSI_D13__GPIO1_25				0x0f4 0x538 0x000 0x5 0x0
#define MX35_PAD_CSI_D14__IPU_CSI_D_14				0x0f8 0x53c 0x000 0x0 0x0
#define MX35_PAD_CSI_D14__KPP_ROW_2				0x0f8 0x53c 0x978 0x1 0x0
#define MX35_PAD_CSI_D14__GPIO1_26				0x0f8 0x53c 0x000 0x5 0x0
#define MX35_PAD_CSI_D15__IPU_CSI_D_15				0x0fc 0x540 0x97c 0x0 0x0
#define MX35_PAD_CSI_D15__KPP_ROW_3				0x0fc 0x540 0x000 0x1 0x0
#define MX35_PAD_CSI_D15__GPIO1_27				0x0fc 0x540 0x000 0x5 0x0
#define MX35_PAD_CSI_MCLK__IPU_CSI_MCLK				0x100 0x544 0x000 0x0 0x0
#define MX35_PAD_CSI_MCLK__GPIO1_28				0x100 0x544 0x000 0x5 0x0
#define MX35_PAD_CSI_VSYNC__IPU_CSI_VSYNC			0x104 0x548 0x000 0x0 0x0
#define MX35_PAD_CSI_VSYNC__GPIO1_29				0x104 0x548 0x000 0x5 0x0
#define MX35_PAD_CSI_HSYNC__IPU_CSI_HSYNC			0x108 0x54c 0x000 0x0 0x0
#define MX35_PAD_CSI_HSYNC__GPIO1_30				0x108 0x54c 0x000 0x5 0x0
#define MX35_PAD_CSI_PIXCLK__IPU_CSI_PIXCLK			0x10c 0x550 0x000 0x0 0x0
#define MX35_PAD_CSI_PIXCLK__GPIO1_31				0x10c 0x550 0x000 0x5 0x0
#define MX35_PAD_I2C1_CLK__I2C1_SCL				0x110 0x554 0x000 0x0 0x0
#define MX35_PAD_I2C1_CLK__GPIO2_24				0x110 0x554 0x8a8 0x5 0x0
#define MX35_PAD_I2C1_CLK__CCM_USB_BYP_CLK			0x110 0x554 0x000 0x6 0x0
#define MX35_PAD_I2C1_DAT__I2C1_SDA				0x114 0x558 0x000 0x0 0x0
#define MX35_PAD_I2C1_DAT__GPIO2_25				0x114 0x558 0x8ac 0x5 0x0
#define MX35_PAD_I2C2_CLK__I2C2_SCL				0x118 0x55c 0x000 0x0 0x0
#define MX35_PAD_I2C2_CLK__CAN1_TXCAN				0x118 0x55c 0x000 0x1 0x0
#define MX35_PAD_I2C2_CLK__USB_TOP_USBH2_PWR			0x118 0x55c 0x000 0x2 0x0
#define MX35_PAD_I2C2_CLK__GPIO2_26				0x118 0x55c 0x8b0 0x5 0x0
#define MX35_PAD_I2C2_CLK__SDMA_DEBUG_BUS_DEVICE_2		0x118 0x55c 0x000 0x6 0x0
#define MX35_PAD_I2C2_DAT__I2C2_SDA				0x11c 0x560 0x000 0x0 0x0
#define MX35_PAD_I2C2_DAT__CAN1_RXCAN				0x11c 0x560 0x7c8 0x1 0x0
#define MX35_PAD_I2C2_DAT__USB_TOP_USBH2_OC			0x11c 0x560 0x9f4 0x2 0x0
#define MX35_PAD_I2C2_DAT__GPIO2_27				0x11c 0x560 0x8b4 0x5 0x0
#define MX35_PAD_I2C2_DAT__SDMA_DEBUG_BUS_DEVICE_3		0x11c 0x560 0x000 0x6 0x0
#define MX35_PAD_STXD4__AUDMUX_AUD4_TXD				0x120 0x564 0x000 0x0 0x0
#define MX35_PAD_STXD4__GPIO2_28				0x120 0x564 0x8b8 0x5 0x0
#define MX35_PAD_STXD4__ARM11P_TOP_ARM_COREASID0		0x120 0x564 0x000 0x7 0x0
#define MX35_PAD_SRXD4__AUDMUX_AUD4_RXD				0x124 0x568 0x000 0x0 0x0
#define MX35_PAD_SRXD4__GPIO2_29				0x124 0x568 0x8bc 0x5 0x0
#define MX35_PAD_SRXD4__ARM11P_TOP_ARM_COREASID1		0x124 0x568 0x000 0x7 0x0
#define MX35_PAD_SCK4__AUDMUX_AUD4_TXC				0x128 0x56c 0x000 0x0 0x0
#define MX35_PAD_SCK4__GPIO2_30					0x128 0x56c 0x8c4 0x5 0x0
#define MX35_PAD_SCK4__ARM11P_TOP_ARM_COREASID2			0x128 0x56c 0x000 0x7 0x0
#define MX35_PAD_STXFS4__AUDMUX_AUD4_TXFS			0x12c 0x570 0x000 0x0 0x0
#define MX35_PAD_STXFS4__GPIO2_31				0x12c 0x570 0x8c8 0x5 0x0
#define MX35_PAD_STXFS4__ARM11P_TOP_ARM_COREASID3		0x12c 0x570 0x000 0x7 0x0
#define MX35_PAD_STXD5__AUDMUX_AUD5_TXD				0x130 0x574 0x000 0x0 0x0
#define MX35_PAD_STXD5__SPDIF_SPDIF_OUT1			0x130 0x574 0x000 0x1 0x0
#define MX35_PAD_STXD5__CSPI2_MOSI				0x130 0x574 0x7ec 0x2 0x0
#define MX35_PAD_STXD5__GPIO1_0					0x130 0x574 0x82c 0x5 0x1
#define MX35_PAD_STXD5__ARM11P_TOP_ARM_COREASID4		0x130 0x574 0x000 0x7 0x0
#define MX35_PAD_SRXD5__AUDMUX_AUD5_RXD				0x134 0x578 0x000 0x0 0x0
#define MX35_PAD_SRXD5__SPDIF_SPDIF_IN1				0x134 0x578 0x998 0x1 0x0
#define MX35_PAD_SRXD5__CSPI2_MISO				0x134 0x578 0x7e8 0x2 0x0
#define MX35_PAD_SRXD5__GPIO1_1					0x134 0x578 0x838 0x5 0x1
#define MX35_PAD_SRXD5__ARM11P_TOP_ARM_COREASID5		0x134 0x578 0x000 0x7 0x0
#define MX35_PAD_SCK5__AUDMUX_AUD5_TXC				0x138 0x57c 0x000 0x0 0x0
#define MX35_PAD_SCK5__SPDIF_SPDIF_EXTCLK			0x138 0x57c 0x994 0x1 0x0
#define MX35_PAD_SCK5__CSPI2_SCLK				0x138 0x57c 0x7e0 0x2 0x0
#define MX35_PAD_SCK5__GPIO1_2					0x138 0x57c 0x848 0x5 0x0
#define MX35_PAD_SCK5__ARM11P_TOP_ARM_COREASID6			0x138 0x57c 0x000 0x7 0x0
#define MX35_PAD_STXFS5__AUDMUX_AUD5_TXFS			0x13c 0x580 0x000 0x0 0x0
#define MX35_PAD_STXFS5__CSPI2_RDY				0x13c 0x580 0x7e4 0x2 0x0
#define MX35_PAD_STXFS5__GPIO1_3				0x13c 0x580 0x84c 0x5 0x0
#define MX35_PAD_STXFS5__ARM11P_TOP_ARM_COREASID7		0x13c 0x580 0x000 0x7 0x0
#define MX35_PAD_SCKR__ESAI_SCKR				0x140 0x584 0x000 0x0 0x0
#define MX35_PAD_SCKR__GPIO1_4					0x140 0x584 0x850 0x5 0x1
#define MX35_PAD_SCKR__ARM11P_TOP_EVNTBUS_10			0x140 0x584 0x000 0x7 0x0
#define MX35_PAD_FSR__ESAI_FSR					0x144 0x588 0x000 0x0 0x0
#define MX35_PAD_FSR__GPIO1_5					0x144 0x588 0x854 0x5 0x1
#define MX35_PAD_FSR__ARM11P_TOP_EVNTBUS_11			0x144 0x588 0x000 0x7 0x0
#define MX35_PAD_HCKR__ESAI_HCKR				0x148 0x58c 0x000 0x0 0x0
#define MX35_PAD_HCKR__AUDMUX_AUD5_RXFS				0x148 0x58c 0x000 0x1 0x0
#define MX35_PAD_HCKR__CSPI2_SS0				0x148 0x58c 0x7f0 0x2 0x0
#define MX35_PAD_HCKR__IPU_FLASH_STROBE				0x148 0x58c 0x000 0x3 0x0
#define MX35_PAD_HCKR__GPIO1_6					0x148 0x58c 0x858 0x5 0x1
#define MX35_PAD_HCKR__ARM11P_TOP_EVNTBUS_12			0x148 0x58c 0x000 0x7 0x0
#define MX35_PAD_SCKT__ESAI_SCKT				0x14c 0x590 0x000 0x0 0x0
#define MX35_PAD_SCKT__GPIO1_7					0x14c 0x590 0x85c 0x5 0x1
#define MX35_PAD_SCKT__IPU_CSI_D_0				0x14c 0x590 0x930 0x6 0x0
#define MX35_PAD_SCKT__KPP_ROW_2				0x14c 0x590 0x978 0x7 0x1
#define MX35_PAD_FST__ESAI_FST					0x150 0x594 0x000 0x0 0x0
#define MX35_PAD_FST__GPIO1_8					0x150 0x594 0x860 0x5 0x1
#define MX35_PAD_FST__IPU_CSI_D_1				0x150 0x594 0x934 0x6 0x0
#define MX35_PAD_FST__KPP_ROW_3					0x150 0x594 0x97c 0x7 0x1
#define MX35_PAD_HCKT__ESAI_HCKT				0x154 0x598 0x000 0x0 0x0
#define MX35_PAD_HCKT__AUDMUX_AUD5_RXC				0x154 0x598 0x7a8 0x1 0x0
#define MX35_PAD_HCKT__GPIO1_9					0x154 0x598 0x864 0x5 0x0
#define MX35_PAD_HCKT__IPU_CSI_D_2				0x154 0x598 0x938 0x6 0x0
#define MX35_PAD_HCKT__KPP_COL_3				0x154 0x598 0x95c 0x7 0x1
#define MX35_PAD_TX5_RX0__ESAI_TX5_RX0				0x158 0x59c 0x000 0x0 0x0
#define MX35_PAD_TX5_RX0__AUDMUX_AUD4_RXC			0x158 0x59c 0x000 0x1 0x0
#define MX35_PAD_TX5_RX0__CSPI2_SS2				0x158 0x59c 0x7f8 0x2 0x1
#define MX35_PAD_TX5_RX0__CAN2_TXCAN				0x158 0x59c 0x000 0x3 0x0
#define MX35_PAD_TX5_RX0__UART2_DTR				0x158 0x59c 0x000 0x4 0x0
#define MX35_PAD_TX5_RX0__GPIO1_10				0x158 0x59c 0x830 0x5 0x0
#define MX35_PAD_TX5_RX0__EMI_M3IF_CHOSEN_MASTER_0		0x158 0x59c 0x000 0x7 0x0
#define MX35_PAD_TX4_RX1__ESAI_TX4_RX1				0x15c 0x5a0 0x000 0x0 0x0
#define MX35_PAD_TX4_RX1__AUDMUX_AUD4_RXFS			0x15c 0x5a0 0x000 0x1 0x0
#define MX35_PAD_TX4_RX1__CSPI2_SS3				0x15c 0x5a0 0x7fc 0x2 0x0
#define MX35_PAD_TX4_RX1__CAN2_RXCAN				0x15c 0x5a0 0x7cc 0x3 0x0
#define MX35_PAD_TX4_RX1__UART2_DSR				0x15c 0x5a0 0x000 0x4 0x0
#define MX35_PAD_TX4_RX1__GPIO1_11				0x15c 0x5a0 0x834 0x5 0x0
#define MX35_PAD_TX4_RX1__IPU_CSI_D_3				0x15c 0x5a0 0x93c 0x6 0x0
#define MX35_PAD_TX4_RX1__KPP_ROW_0				0x15c 0x5a0 0x970 0x7 0x1
#define MX35_PAD_TX3_RX2__ESAI_TX3_RX2				0x160 0x5a4 0x000 0x0 0x0
#define MX35_PAD_TX3_RX2__I2C3_SCL				0x160 0x5a4 0x91c 0x1 0x0
#define MX35_PAD_TX3_RX2__EMI_NANDF_CE1				0x160 0x5a4 0x000 0x3 0x0
#define MX35_PAD_TX3_RX2__GPIO1_12				0x160 0x5a4 0x000 0x5 0x0
#define MX35_PAD_TX3_RX2__IPU_CSI_D_4				0x160 0x5a4 0x940 0x6 0x0
#define MX35_PAD_TX3_RX2__KPP_ROW_1				0x160 0x5a4 0x974 0x7 0x1
#define MX35_PAD_TX2_RX3__ESAI_TX2_RX3				0x164 0x5a8 0x000 0x0 0x0
#define MX35_PAD_TX2_RX3__I2C3_SDA				0x164 0x5a8 0x920 0x1 0x0
#define MX35_PAD_TX2_RX3__EMI_NANDF_CE2				0x164 0x5a8 0x000 0x3 0x0
#define MX35_PAD_TX2_RX3__GPIO1_13				0x164 0x5a8 0x000 0x5 0x0
#define MX35_PAD_TX2_RX3__IPU_CSI_D_5				0x164 0x5a8 0x944 0x6 0x0
#define MX35_PAD_TX2_RX3__KPP_COL_0				0x164 0x5a8 0x950 0x7 0x1
#define MX35_PAD_TX1__ESAI_TX1					0x168 0x5ac 0x000 0x0 0x0
#define MX35_PAD_TX1__CCM_PMIC_RDY				0x168 0x5ac 0x7d4 0x1 0x1
#define MX35_PAD_TX1__CSPI1_SS2					0x168 0x5ac 0x7d8 0x2 0x2
#define MX35_PAD_TX1__EMI_NANDF_CE3				0x168 0x5ac 0x000 0x3 0x0
#define MX35_PAD_TX1__UART2_RI					0x168 0x5ac 0x000 0x4 0x0
#define MX35_PAD_TX1__GPIO1_14					0x168 0x5ac 0x000 0x5 0x0
#define MX35_PAD_TX1__IPU_CSI_D_6				0x168 0x5ac 0x948 0x6 0x0
#define MX35_PAD_TX1__KPP_COL_1					0x168 0x5ac 0x954 0x7 0x1
#define MX35_PAD_TX0__ESAI_TX0					0x16c 0x5b0 0x000 0x0 0x0
#define MX35_PAD_TX0__SPDIF_SPDIF_EXTCLK			0x16c 0x5b0 0x994 0x1 0x1
#define MX35_PAD_TX0__CSPI1_SS3					0x16c 0x5b0 0x7dc 0x2 0x0
#define MX35_PAD_TX0__EMI_DTACK_B				0x16c 0x5b0 0x800 0x3 0x1
#define MX35_PAD_TX0__UART2_DCD					0x16c 0x5b0 0x000 0x4 0x0
#define MX35_PAD_TX0__GPIO1_15					0x16c 0x5b0 0x000 0x5 0x0
#define MX35_PAD_TX0__IPU_CSI_D_7				0x16c 0x5b0 0x94c 0x6 0x0
#define MX35_PAD_TX0__KPP_COL_2					0x16c 0x5b0 0x958 0x7 0x1
#define MX35_PAD_CSPI1_MOSI__CSPI1_MOSI				0x170 0x5b4 0x000 0x0 0x0
#define MX35_PAD_CSPI1_MOSI__GPIO1_16				0x170 0x5b4 0x000 0x5 0x0
#define MX35_PAD_CSPI1_MOSI__ECT_CTI_TRIG_OUT1_2		0x170 0x5b4 0x000 0x7 0x0
#define MX35_PAD_CSPI1_MISO__CSPI1_MISO				0x174 0x5b8 0x000 0x0 0x0
#define MX35_PAD_CSPI1_MISO__GPIO1_17				0x174 0x5b8 0x000 0x5 0x0
#define MX35_PAD_CSPI1_MISO__ECT_CTI_TRIG_OUT1_3		0x174 0x5b8 0x000 0x7 0x0
#define MX35_PAD_CSPI1_SS0__CSPI1_SS0				0x178 0x5bc 0x000 0x0 0x0
#define MX35_PAD_CSPI1_SS0__OWIRE_LINE				0x178 0x5bc 0x990 0x1 0x1
#define MX35_PAD_CSPI1_SS0__CSPI2_SS3				0x178 0x5bc 0x7fc 0x2 0x1
#define MX35_PAD_CSPI1_SS0__GPIO1_18				0x178 0x5bc 0x000 0x5 0x0
#define MX35_PAD_CSPI1_SS0__ECT_CTI_TRIG_OUT1_4			0x178 0x5bc 0x000 0x7 0x0
#define MX35_PAD_CSPI1_SS1__CSPI1_SS1				0x17c 0x5c0 0x000 0x0 0x0
#define MX35_PAD_CSPI1_SS1__PWM_PWMO				0x17c 0x5c0 0x000 0x1 0x0
#define MX35_PAD_CSPI1_SS1__CCM_CLK32K				0x17c 0x5c0 0x7d0 0x2 0x1
#define MX35_PAD_CSPI1_SS1__GPIO1_19				0x17c 0x5c0 0x000 0x5 0x0
#define MX35_PAD_CSPI1_SS1__IPU_DIAGB_29			0x17c 0x5c0 0x000 0x6 0x0
#define MX35_PAD_CSPI1_SS1__ECT_CTI_TRIG_OUT1_5			0x17c 0x5c0 0x000 0x7 0x0
#define MX35_PAD_CSPI1_SCLK__CSPI1_SCLK				0x180 0x5c4 0x000 0x0 0x0
#define MX35_PAD_CSPI1_SCLK__GPIO3_4				0x180 0x5c4 0x904 0x5 0x0
#define MX35_PAD_CSPI1_SCLK__IPU_DIAGB_30			0x180 0x5c4 0x000 0x6 0x0
#define MX35_PAD_CSPI1_SCLK__EMI_M3IF_CHOSEN_MASTER_1		0x180 0x5c4 0x000 0x7 0x0
#define MX35_PAD_CSPI1_SPI_RDY__CSPI1_RDY			0x184 0x5c8 0x000 0x0 0x0
#define MX35_PAD_CSPI1_SPI_RDY__GPIO3_5				0x184 0x5c8 0x908 0x5 0x0
#define MX35_PAD_CSPI1_SPI_RDY__IPU_DIAGB_31			0x184 0x5c8 0x000 0x6 0x0
#define MX35_PAD_CSPI1_SPI_RDY__EMI_M3IF_CHOSEN_MASTER_2	0x184 0x5c8 0x000 0x7 0x0
#define MX35_PAD_RXD1__UART1_RXD_MUX				0x188 0x5cc 0x000 0x0 0x0
#define MX35_PAD_RXD1__CSPI2_MOSI				0x188 0x5cc 0x7ec 0x1 0x1
#define MX35_PAD_RXD1__KPP_COL_4				0x188 0x5cc 0x960 0x4 0x0
#define MX35_PAD_RXD1__GPIO3_6					0x188 0x5cc 0x90c 0x5 0x0
#define MX35_PAD_RXD1__ARM11P_TOP_EVNTBUS_16			0x188 0x5cc 0x000 0x7 0x0
#define MX35_PAD_TXD1__UART1_TXD_MUX				0x18c 0x5d0 0x000 0x0 0x0
#define MX35_PAD_TXD1__CSPI2_MISO				0x18c 0x5d0 0x7e8 0x1 0x1
#define MX35_PAD_TXD1__KPP_COL_5				0x18c 0x5d0 0x964 0x4 0x0
#define MX35_PAD_TXD1__GPIO3_7					0x18c 0x5d0 0x910 0x5 0x0
#define MX35_PAD_TXD1__ARM11P_TOP_EVNTBUS_17			0x18c 0x5d0 0x000 0x7 0x0
#define MX35_PAD_RTS1__UART1_RTS				0x190 0x5d4 0x000 0x0 0x0
#define MX35_PAD_RTS1__CSPI2_SCLK				0x190 0x5d4 0x7e0 0x1 0x1
#define MX35_PAD_RTS1__I2C3_SCL					0x190 0x5d4 0x91c 0x2 0x1
#define MX35_PAD_RTS1__IPU_CSI_D_0				0x190 0x5d4 0x930 0x3 0x1
#define MX35_PAD_RTS1__KPP_COL_6				0x190 0x5d4 0x968 0x4 0x0
#define MX35_PAD_RTS1__GPIO3_8					0x190 0x5d4 0x914 0x5 0x0
#define MX35_PAD_RTS1__EMI_NANDF_CE1				0x190 0x5d4 0x000 0x6 0x0
#define MX35_PAD_RTS1__ARM11P_TOP_EVNTBUS_18			0x190 0x5d4 0x000 0x7 0x0
#define MX35_PAD_CTS1__UART1_CTS				0x194 0x5d8 0x000 0x0 0x0
#define MX35_PAD_CTS1__CSPI2_RDY				0x194 0x5d8 0x7e4 0x1 0x1
#define MX35_PAD_CTS1__I2C3_SDA					0x194 0x5d8 0x920 0x2 0x1
#define MX35_PAD_CTS1__IPU_CSI_D_1				0x194 0x5d8 0x934 0x3 0x1
#define MX35_PAD_CTS1__KPP_COL_7				0x194 0x5d8 0x96c 0x4 0x0
#define MX35_PAD_CTS1__GPIO3_9					0x194 0x5d8 0x918 0x5 0x0
#define MX35_PAD_CTS1__EMI_NANDF_CE2				0x194 0x5d8 0x000 0x6 0x0
#define MX35_PAD_CTS1__ARM11P_TOP_EVNTBUS_19			0x194 0x5d8 0x000 0x7 0x0
#define MX35_PAD_RXD2__UART2_RXD_MUX				0x198 0x5dc 0x000 0x0 0x0
#define MX35_PAD_RXD2__KPP_ROW_4				0x198 0x5dc 0x980 0x4 0x0
#define MX35_PAD_RXD2__GPIO3_10					0x198 0x5dc 0x8ec 0x5 0x0
#define MX35_PAD_TXD2__UART2_TXD_MUX				0x19c 0x5e0 0x000 0x0 0x0
#define MX35_PAD_TXD2__SPDIF_SPDIF_EXTCLK			0x19c 0x5e0 0x994 0x1 0x2
#define MX35_PAD_TXD2__KPP_ROW_5				0x19c 0x5e0 0x984 0x4 0x0
#define MX35_PAD_TXD2__GPIO3_11					0x19c 0x5e0 0x8f0 0x5 0x0
#define MX35_PAD_RTS2__UART2_RTS				0x1a0 0x5e4 0x000 0x0 0x0
#define MX35_PAD_RTS2__SPDIF_SPDIF_IN1				0x1a0 0x5e4 0x998 0x1 0x1
#define MX35_PAD_RTS2__CAN2_RXCAN				0x1a0 0x5e4 0x7cc 0x2 0x1
#define MX35_PAD_RTS2__IPU_CSI_D_2				0x1a0 0x5e4 0x938 0x3 0x1
#define MX35_PAD_RTS2__KPP_ROW_6				0x1a0 0x5e4 0x988 0x4 0x0
#define MX35_PAD_RTS2__GPIO3_12					0x1a0 0x5e4 0x8f4 0x5 0x0
#define MX35_PAD_RTS2__AUDMUX_AUD5_RXC				0x1a0 0x5e4 0x000 0x6 0x0
#define MX35_PAD_RTS2__UART3_RXD_MUX				0x1a0 0x5e4 0x9a0 0x7 0x0
#define MX35_PAD_CTS2__UART2_CTS				0x1a4 0x5e8 0x000 0x0 0x0
#define MX35_PAD_CTS2__SPDIF_SPDIF_OUT1				0x1a4 0x5e8 0x000 0x1 0x0
#define MX35_PAD_CTS2__CAN2_TXCAN				0x1a4 0x5e8 0x000 0x2 0x0
#define MX35_PAD_CTS2__IPU_CSI_D_3				0x1a4 0x5e8 0x93c 0x3 0x1
#define MX35_PAD_CTS2__KPP_ROW_7				0x1a4 0x5e8 0x98c 0x4 0x0
#define MX35_PAD_CTS2__GPIO3_13					0x1a4 0x5e8 0x8f8 0x5 0x0
#define MX35_PAD_CTS2__AUDMUX_AUD5_RXFS				0x1a4 0x5e8 0x000 0x6 0x0
#define MX35_PAD_CTS2__UART3_TXD_MUX				0x1a4 0x5e8 0x000 0x7 0x0
#define MX35_PAD_RTCK__ARM11P_TOP_RTCK				0x000 0x5ec 0x000 0x0 0x0
#define MX35_PAD_TCK__SJC_TCK					0x000 0x5f0 0x000 0x0 0x0
#define MX35_PAD_TMS__SJC_TMS					0x000 0x5f4 0x000 0x0 0x0
#define MX35_PAD_TDI__SJC_TDI					0x000 0x5f8 0x000 0x0 0x0
#define MX35_PAD_TDO__SJC_TDO					0x000 0x5fc 0x000 0x0 0x0
#define MX35_PAD_TRSTB__SJC_TRSTB				0x000 0x600 0x000 0x0 0x0
#define MX35_PAD_DE_B__SJC_DE_B					0x000 0x604 0x000 0x0 0x0
#define MX35_PAD_SJC_MOD__SJC_MOD				0x000 0x608 0x000 0x0 0x0
#define MX35_PAD_USBOTG_PWR__USB_TOP_USBOTG_PWR			0x1a8 0x60c 0x000 0x0 0x0
#define MX35_PAD_USBOTG_PWR__USB_TOP_USBH2_PWR			0x1a8 0x60c 0x000 0x1 0x0
#define MX35_PAD_USBOTG_PWR__GPIO3_14				0x1a8 0x60c 0x8fc 0x5 0x0
#define MX35_PAD_USBOTG_OC__USB_TOP_USBOTG_OC			0x1ac 0x610 0x000 0x0 0x0
#define MX35_PAD_USBOTG_OC__USB_TOP_USBH2_OC			0x1ac 0x610 0x9f4 0x1 0x1
#define MX35_PAD_USBOTG_OC__GPIO3_15				0x1ac 0x610 0x900 0x5 0x0
#define MX35_PAD_LD0__IPU_DISPB_DAT_0				0x1b0 0x614 0x000 0x0 0x0
#define MX35_PAD_LD0__GPIO2_0					0x1b0 0x614 0x868 0x5 0x1
#define MX35_PAD_LD0__SDMA_SDMA_DEBUG_PC_0			0x1b0 0x614 0x000 0x6 0x0
#define MX35_PAD_LD1__IPU_DISPB_DAT_1				0x1b4 0x618 0x000 0x0 0x0
#define MX35_PAD_LD1__GPIO2_1					0x1b4 0x618 0x894 0x5 0x0
#define MX35_PAD_LD1__SDMA_SDMA_DEBUG_PC_1			0x1b4 0x618 0x000 0x6 0x0
#define MX35_PAD_LD2__IPU_DISPB_DAT_2				0x1b8 0x61c 0x000 0x0 0x0
#define MX35_PAD_LD2__GPIO2_2					0x1b8 0x61c 0x8c0 0x5 0x0
#define MX35_PAD_LD2__SDMA_SDMA_DEBUG_PC_2			0x1b8 0x61c 0x000 0x6 0x0
#define MX35_PAD_LD3__IPU_DISPB_DAT_3				0x1bc 0x620 0x000 0x0 0x0
#define MX35_PAD_LD3__GPIO2_3					0x1bc 0x620 0x8cc 0x5 0x0
#define MX35_PAD_LD3__SDMA_SDMA_DEBUG_PC_3			0x1bc 0x620 0x000 0x6 0x0
#define MX35_PAD_LD4__IPU_DISPB_DAT_4				0x1c0 0x624 0x000 0x0 0x0
#define MX35_PAD_LD4__GPIO2_4					0x1c0 0x624 0x8d0 0x5 0x0
#define MX35_PAD_LD4__SDMA_SDMA_DEBUG_PC_4			0x1c0 0x624 0x000 0x6 0x0
#define MX35_PAD_LD5__IPU_DISPB_DAT_5				0x1c4 0x628 0x000 0x0 0x0
#define MX35_PAD_LD5__GPIO2_5					0x1c4 0x628 0x8d4 0x5 0x0
#define MX35_PAD_LD5__SDMA_SDMA_DEBUG_PC_5			0x1c4 0x628 0x000 0x6 0x0
#define MX35_PAD_LD6__IPU_DISPB_DAT_6				0x1c8 0x62c 0x000 0x0 0x0
#define MX35_PAD_LD6__GPIO2_6					0x1c8 0x62c 0x8d8 0x5 0x0
#define MX35_PAD_LD6__SDMA_SDMA_DEBUG_PC_6			0x1c8 0x62c 0x000 0x6 0x0
#define MX35_PAD_LD7__IPU_DISPB_DAT_7				0x1cc 0x630 0x000 0x0 0x0
#define MX35_PAD_LD7__GPIO2_7					0x1cc 0x630 0x8dc 0x5 0x0
#define MX35_PAD_LD7__SDMA_SDMA_DEBUG_PC_7			0x1cc 0x630 0x000 0x6 0x0
#define MX35_PAD_LD8__IPU_DISPB_DAT_8				0x1d0 0x634 0x000 0x0 0x0
#define MX35_PAD_LD8__GPIO2_8					0x1d0 0x634 0x8e0 0x5 0x0
#define MX35_PAD_LD8__SDMA_SDMA_DEBUG_PC_8			0x1d0 0x634 0x000 0x6 0x0
#define MX35_PAD_LD9__IPU_DISPB_DAT_9				0x1d4 0x638 0x000 0x0 0x0
#define MX35_PAD_LD9__GPIO2_9					0x1d4 0x638 0x8e4 0x5 0x0
#define MX35_PAD_LD9__SDMA_SDMA_DEBUG_PC_9			0x1d4 0x638 0x000 0x6 0x0
#define MX35_PAD_LD10__IPU_DISPB_DAT_10				0x1d8 0x63c 0x000 0x0 0x0
#define MX35_PAD_LD10__GPIO2_10					0x1d8 0x63c 0x86c 0x5 0x0
#define MX35_PAD_LD10__SDMA_SDMA_DEBUG_PC_10			0x1d8 0x63c 0x000 0x6 0x0
#define MX35_PAD_LD11__IPU_DISPB_DAT_11				0x1dc 0x640 0x000 0x0 0x0
#define MX35_PAD_LD11__GPIO2_11					0x1dc 0x640 0x870 0x5 0x0
#define MX35_PAD_LD11__SDMA_SDMA_DEBUG_PC_11			0x1dc 0x640 0x000 0x6 0x0
#define MX35_PAD_LD11__ARM11P_TOP_TRACE_4			0x1dc 0x640 0x000 0x7 0x0
#define MX35_PAD_LD12__IPU_DISPB_DAT_12				0x1e0 0x644 0x000 0x0 0x0
#define MX35_PAD_LD12__GPIO2_12					0x1e0 0x644 0x874 0x5 0x0
#define MX35_PAD_LD12__SDMA_SDMA_DEBUG_PC_12			0x1e0 0x644 0x000 0x6 0x0
#define MX35_PAD_LD12__ARM11P_TOP_TRACE_5			0x1e0 0x644 0x000 0x7 0x0
#define MX35_PAD_LD13__IPU_DISPB_DAT_13				0x1e4 0x648 0x000 0x0 0x0
#define MX35_PAD_LD13__GPIO2_13					0x1e4 0x648 0x878 0x5 0x0
#define MX35_PAD_LD13__SDMA_SDMA_DEBUG_PC_13			0x1e4 0x648 0x000 0x6 0x0
#define MX35_PAD_LD13__ARM11P_TOP_TRACE_6			0x1e4 0x648 0x000 0x7 0x0
#define MX35_PAD_LD14__IPU_DISPB_DAT_14				0x1e8 0x64c 0x000 0x0 0x0
#define MX35_PAD_LD14__GPIO2_14					0x1e8 0x64c 0x87c 0x5 0x0
#define MX35_PAD_LD14__SDMA_SDMA_DEBUG_EVENT_CHANNEL_0		0x1e8 0x64c 0x000 0x6 0x0
#define MX35_PAD_LD14__ARM11P_TOP_TRACE_7			0x1e8 0x64c 0x000 0x7 0x0
#define MX35_PAD_LD15__IPU_DISPB_DAT_15				0x1ec 0x650 0x000 0x0 0x0
#define MX35_PAD_LD15__GPIO2_15					0x1ec 0x650 0x880 0x5 0x0
#define MX35_PAD_LD15__SDMA_SDMA_DEBUG_EVENT_CHANNEL_1		0x1ec 0x650 0x000 0x6 0x0
#define MX35_PAD_LD15__ARM11P_TOP_TRACE_8			0x1ec 0x650 0x000 0x7 0x0
#define MX35_PAD_LD16__IPU_DISPB_DAT_16				0x1f0 0x654 0x000 0x0 0x0
#define MX35_PAD_LD16__IPU_DISPB_D12_VSYNC			0x1f0 0x654 0x928 0x2 0x0
#define MX35_PAD_LD16__GPIO2_16					0x1f0 0x654 0x884 0x5 0x0
#define MX35_PAD_LD16__SDMA_SDMA_DEBUG_EVENT_CHANNEL_2		0x1f0 0x654 0x000 0x6 0x0
#define MX35_PAD_LD16__ARM11P_TOP_TRACE_9			0x1f0 0x654 0x000 0x7 0x0
#define MX35_PAD_LD17__IPU_DISPB_DAT_17				0x1f4 0x658 0x000 0x0 0x0
#define MX35_PAD_LD17__IPU_DISPB_CS2				0x1f4 0x658 0x000 0x2 0x0
#define MX35_PAD_LD17__GPIO2_17					0x1f4 0x658 0x888 0x5 0x0
#define MX35_PAD_LD17__SDMA_SDMA_DEBUG_EVENT_CHANNEL_3		0x1f4 0x658 0x000 0x6 0x0
#define MX35_PAD_LD17__ARM11P_TOP_TRACE_10			0x1f4 0x658 0x000 0x7 0x0
#define MX35_PAD_LD18__IPU_DISPB_DAT_18				0x1f8 0x65c 0x000 0x0 0x0
#define MX35_PAD_LD18__IPU_DISPB_D0_VSYNC			0x1f8 0x65c 0x924 0x1 0x1
#define MX35_PAD_LD18__IPU_DISPB_D12_VSYNC			0x1f8 0x65c 0x928 0x2 0x1
#define MX35_PAD_LD18__ESDHC3_CMD				0x1f8 0x65c 0x818 0x3 0x0
#define MX35_PAD_LD18__USB_TOP_USBOTG_DATA_3			0x1f8 0x65c 0x9b0 0x4 0x0
#define MX35_PAD_LD18__GPIO3_24					0x1f8 0x65c 0x000 0x5 0x0
#define MX35_PAD_LD18__SDMA_SDMA_DEBUG_EVENT_CHANNEL_4		0x1f8 0x65c 0x000 0x6 0x0
#define MX35_PAD_LD18__ARM11P_TOP_TRACE_11			0x1f8 0x65c 0x000 0x7 0x0
#define MX35_PAD_LD19__IPU_DISPB_DAT_19				0x1fc 0x660 0x000 0x0 0x0
#define MX35_PAD_LD19__IPU_DISPB_BCLK				0x1fc 0x660 0x000 0x1 0x0
#define MX35_PAD_LD19__IPU_DISPB_CS1				0x1fc 0x660 0x000 0x2 0x0
#define MX35_PAD_LD19__ESDHC3_CLK				0x1fc 0x660 0x814 0x3 0x0
#define MX35_PAD_LD19__USB_TOP_USBOTG_DIR			0x1fc 0x660 0x9c4 0x4 0x0
#define MX35_PAD_LD19__GPIO3_25					0x1fc 0x660 0x000 0x5 0x0
#define MX35_PAD_LD19__SDMA_SDMA_DEBUG_EVENT_CHANNEL_5		0x1fc 0x660 0x000 0x6 0x0
#define MX35_PAD_LD19__ARM11P_TOP_TRACE_12			0x1fc 0x660 0x000 0x7 0x0
#define MX35_PAD_LD20__IPU_DISPB_DAT_20				0x200 0x664 0x000 0x0 0x0
#define MX35_PAD_LD20__IPU_DISPB_CS0				0x200 0x664 0x000 0x1 0x0
#define MX35_PAD_LD20__IPU_DISPB_SD_CLK				0x200 0x664 0x000 0x2 0x0
#define MX35_PAD_LD20__ESDHC3_DAT0				0x200 0x664 0x81c 0x3 0x0
#define MX35_PAD_LD20__GPIO3_26					0x200 0x664 0x000 0x5 0x0
#define MX35_PAD_LD20__SDMA_SDMA_DEBUG_CORE_STATUS_3		0x200 0x664 0x000 0x6 0x0
#define MX35_PAD_LD20__ARM11P_TOP_TRACE_13			0x200 0x664 0x000 0x7 0x0
#define MX35_PAD_LD21__IPU_DISPB_DAT_21				0x204 0x668 0x000 0x0 0x0
#define MX35_PAD_LD21__IPU_DISPB_PAR_RS				0x204 0x668 0x000 0x1 0x0
#define MX35_PAD_LD21__IPU_DISPB_SER_RS				0x204 0x668 0x000 0x2 0x0
#define MX35_PAD_LD21__ESDHC3_DAT1				0x204 0x668 0x820 0x3 0x0
#define MX35_PAD_LD21__USB_TOP_USBOTG_STP			0x204 0x668 0x000 0x4 0x0
#define MX35_PAD_LD21__GPIO3_27					0x204 0x668 0x000 0x5 0x0
#define MX35_PAD_LD21__SDMA_DEBUG_EVENT_CHANNEL_SEL		0x204 0x668 0x000 0x6 0x0
#define MX35_PAD_LD21__ARM11P_TOP_TRACE_14			0x204 0x668 0x000 0x7 0x0
#define MX35_PAD_LD22__IPU_DISPB_DAT_22				0x208 0x66c 0x000 0x0 0x0
#define MX35_PAD_LD22__IPU_DISPB_WR				0x208 0x66c 0x000 0x1 0x0
#define MX35_PAD_LD22__IPU_DISPB_SD_D_I				0x208 0x66c 0x92c 0x2 0x0
#define MX35_PAD_LD22__ESDHC3_DAT2				0x208 0x66c 0x824 0x3 0x0
#define MX35_PAD_LD22__USB_TOP_USBOTG_NXT			0x208 0x66c 0x9c8 0x4 0x0
#define MX35_PAD_LD22__GPIO3_28					0x208 0x66c 0x000 0x5 0x0
#define MX35_PAD_LD22__SDMA_DEBUG_BUS_ERROR			0x208 0x66c 0x000 0x6 0x0
#define MX35_PAD_LD22__ARM11P_TOP_TRCTL				0x208 0x66c 0x000 0x7 0x0
#define MX35_PAD_LD23__IPU_DISPB_DAT_23				0x20c 0x670 0x000 0x0 0x0
#define MX35_PAD_LD23__IPU_DISPB_RD				0x20c 0x670 0x000 0x1 0x0
#define MX35_PAD_LD23__IPU_DISPB_SD_D_IO			0x20c 0x670 0x92c 0x2 0x1
#define MX35_PAD_LD23__ESDHC3_DAT3				0x20c 0x670 0x828 0x3 0x0
#define MX35_PAD_LD23__USB_TOP_USBOTG_DATA_7			0x20c 0x670 0x9c0 0x4 0x0
#define MX35_PAD_LD23__GPIO3_29					0x20c 0x670 0x000 0x5 0x0
#define MX35_PAD_LD23__SDMA_DEBUG_MATCHED_DMBUS			0x20c 0x670 0x000 0x6 0x0
#define MX35_PAD_LD23__ARM11P_TOP_TRCLK				0x20c 0x670 0x000 0x7 0x0
#define MX35_PAD_D3_HSYNC__IPU_DISPB_D3_HSYNC			0x210 0x674 0x000 0x0 0x0
#define MX35_PAD_D3_HSYNC__IPU_DISPB_SD_D_IO			0x210 0x674 0x92c 0x2 0x2
#define MX35_PAD_D3_HSYNC__GPIO3_30				0x210 0x674 0x000 0x5 0x0
#define MX35_PAD_D3_HSYNC__SDMA_DEBUG_RTBUFFER_WRITE		0x210 0x674 0x000 0x6 0x0
#define MX35_PAD_D3_HSYNC__ARM11P_TOP_TRACE_15			0x210 0x674 0x000 0x7 0x0
#define MX35_PAD_D3_FPSHIFT__IPU_DISPB_D3_CLK			0x214 0x678 0x000 0x0 0x0
#define MX35_PAD_D3_FPSHIFT__IPU_DISPB_SD_CLK			0x214 0x678 0x000 0x2 0x0
#define MX35_PAD_D3_FPSHIFT__GPIO3_31				0x214 0x678 0x000 0x5 0x0
#define MX35_PAD_D3_FPSHIFT__SDMA_SDMA_DEBUG_CORE_STATUS_0	0x214 0x678 0x000 0x6 0x0
#define MX35_PAD_D3_FPSHIFT__ARM11P_TOP_TRACE_16		0x214 0x678 0x000 0x7 0x0
#define MX35_PAD_D3_DRDY__IPU_DISPB_D3_DRDY			0x218 0x67c 0x000 0x0 0x0
#define MX35_PAD_D3_DRDY__IPU_DISPB_SD_D_O			0x218 0x67c 0x000 0x2 0x0
#define MX35_PAD_D3_DRDY__GPIO1_0				0x218 0x67c 0x82c 0x5 0x2
#define MX35_PAD_D3_DRDY__SDMA_SDMA_DEBUG_CORE_STATUS_1		0x218 0x67c 0x000 0x6 0x0
#define MX35_PAD_D3_DRDY__ARM11P_TOP_TRACE_17			0x218 0x67c 0x000 0x7 0x0
#define MX35_PAD_CONTRAST__IPU_DISPB_CONTR			0x21c 0x680 0x000 0x0 0x0
#define MX35_PAD_CONTRAST__GPIO1_1				0x21c 0x680 0x838 0x5 0x2
#define MX35_PAD_CONTRAST__SDMA_SDMA_DEBUG_CORE_STATUS_2	0x21c 0x680 0x000 0x6 0x0
#define MX35_PAD_CONTRAST__ARM11P_TOP_TRACE_18			0x21c 0x680 0x000 0x7 0x0
#define MX35_PAD_D3_VSYNC__IPU_DISPB_D3_VSYNC			0x220 0x684 0x000 0x0 0x0
#define MX35_PAD_D3_VSYNC__IPU_DISPB_CS1			0x220 0x684 0x000 0x2 0x0
#define MX35_PAD_D3_VSYNC__GPIO1_2				0x220 0x684 0x848 0x5 0x1
#define MX35_PAD_D3_VSYNC__SDMA_DEBUG_YIELD			0x220 0x684 0x000 0x6 0x0
#define MX35_PAD_D3_VSYNC__ARM11P_TOP_TRACE_19			0x220 0x684 0x000 0x7 0x0
#define MX35_PAD_D3_REV__IPU_DISPB_D3_REV			0x224 0x688 0x000 0x0 0x0
#define MX35_PAD_D3_REV__IPU_DISPB_SER_RS			0x224 0x688 0x000 0x2 0x0
#define MX35_PAD_D3_REV__GPIO1_3				0x224 0x688 0x84c 0x5 0x1
#define MX35_PAD_D3_REV__SDMA_DEBUG_BUS_RWB			0x224 0x688 0x000 0x6 0x0
#define MX35_PAD_D3_REV__ARM11P_TOP_TRACE_20			0x224 0x688 0x000 0x7 0x0
#define MX35_PAD_D3_CLS__IPU_DISPB_D3_CLS			0x228 0x68c 0x000 0x0 0x0
#define MX35_PAD_D3_CLS__IPU_DISPB_CS2				0x228 0x68c 0x000 0x2 0x0
#define MX35_PAD_D3_CLS__GPIO1_4				0x228 0x68c 0x850 0x5 0x2
#define MX35_PAD_D3_CLS__SDMA_DEBUG_BUS_DEVICE_0		0x228 0x68c 0x000 0x6 0x0
#define MX35_PAD_D3_CLS__ARM11P_TOP_TRACE_21			0x228 0x68c 0x000 0x7 0x0
#define MX35_PAD_D3_SPL__IPU_DISPB_D3_SPL			0x22c 0x690 0x000 0x0 0x0
#define MX35_PAD_D3_SPL__IPU_DISPB_D12_VSYNC			0x22c 0x690 0x928 0x2 0x2
#define MX35_PAD_D3_SPL__GPIO1_5				0x22c 0x690 0x854 0x5 0x2
#define MX35_PAD_D3_SPL__SDMA_DEBUG_BUS_DEVICE_1		0x22c 0x690 0x000 0x6 0x0
#define MX35_PAD_D3_SPL__ARM11P_TOP_TRACE_22			0x22c 0x690 0x000 0x7 0x0
#define MX35_PAD_SD1_CMD__ESDHC1_CMD				0x230 0x694 0x000 0x0 0x0
#define MX35_PAD_SD1_CMD__MSHC_SCLK				0x230 0x694 0x000 0x1 0x0
#define MX35_PAD_SD1_CMD__IPU_DISPB_D0_VSYNC			0x230 0x694 0x924 0x3 0x2
#define MX35_PAD_SD1_CMD__USB_TOP_USBOTG_DATA_4			0x230 0x694 0x9b4 0x4 0x0
#define MX35_PAD_SD1_CMD__GPIO1_6				0x230 0x694 0x858 0x5 0x2
#define MX35_PAD_SD1_CMD__ARM11P_TOP_TRCTL			0x230 0x694 0x000 0x7 0x0
#define MX35_PAD_SD1_CLK__ESDHC1_CLK				0x234 0x698 0x000 0x0 0x0
#define MX35_PAD_SD1_CLK__MSHC_BS				0x234 0x698 0x000 0x1 0x0
#define MX35_PAD_SD1_CLK__IPU_DISPB_BCLK			0x234 0x698 0x000 0x3 0x0
#define MX35_PAD_SD1_CLK__USB_TOP_USBOTG_DATA_5			0x234 0x698 0x9b8 0x4 0x0
#define MX35_PAD_SD1_CLK__GPIO1_7				0x234 0x698 0x85c 0x5 0x2
#define MX35_PAD_SD1_CLK__ARM11P_TOP_TRCLK			0x234 0x698 0x000 0x7 0x0
#define MX35_PAD_SD1_DATA0__ESDHC1_DAT0				0x238 0x69c 0x000 0x0 0x0
#define MX35_PAD_SD1_DATA0__MSHC_DATA_0				0x238 0x69c 0x000 0x1 0x0
#define MX35_PAD_SD1_DATA0__IPU_DISPB_CS0			0x238 0x69c 0x000 0x3 0x0
#define MX35_PAD_SD1_DATA0__USB_TOP_USBOTG_DATA_6		0x238 0x69c 0x9bc 0x4 0x0
#define MX35_PAD_SD1_DATA0__GPIO1_8				0x238 0x69c 0x860 0x5 0x2
#define MX35_PAD_SD1_DATA0__ARM11P_TOP_TRACE_23			0x238 0x69c 0x000 0x7 0x0
#define MX35_PAD_SD1_DATA1__ESDHC1_DAT1				0x23c 0x6a0 0x000 0x0 0x0
#define MX35_PAD_SD1_DATA1__MSHC_DATA_1				0x23c 0x6a0 0x000 0x1 0x0
#define MX35_PAD_SD1_DATA1__IPU_DISPB_PAR_RS			0x23c 0x6a0 0x000 0x3 0x0
#define MX35_PAD_SD1_DATA1__USB_TOP_USBOTG_DATA_0		0x23c 0x6a0 0x9a4 0x4 0x0
#define MX35_PAD_SD1_DATA1__GPIO1_9				0x23c 0x6a0 0x864 0x5 0x1
#define MX35_PAD_SD1_DATA1__ARM11P_TOP_TRACE_24			0x23c 0x6a0 0x000 0x7 0x0
#define MX35_PAD_SD1_DATA2__ESDHC1_DAT2				0x240 0x6a4 0x000 0x0 0x0
#define MX35_PAD_SD1_DATA2__MSHC_DATA_2				0x240 0x6a4 0x000 0x1 0x0
#define MX35_PAD_SD1_DATA2__IPU_DISPB_WR			0x240 0x6a4 0x000 0x3 0x0
#define MX35_PAD_SD1_DATA2__USB_TOP_USBOTG_DATA_1		0x240 0x6a4 0x9a8 0x4 0x0
#define MX35_PAD_SD1_DATA2__GPIO1_10				0x240 0x6a4 0x830 0x5 0x1
#define MX35_PAD_SD1_DATA2__ARM11P_TOP_TRACE_25			0x240 0x6a4 0x000 0x7 0x0
#define MX35_PAD_SD1_DATA3__ESDHC1_DAT3				0x244 0x6a8 0x000 0x0 0x0
#define MX35_PAD_SD1_DATA3__MSHC_DATA_3				0x244 0x6a8 0x000 0x1 0x0
#define MX35_PAD_SD1_DATA3__IPU_DISPB_RD			0x244 0x6a8 0x000 0x3 0x0
#define MX35_PAD_SD1_DATA3__USB_TOP_USBOTG_DATA_2		0x244 0x6a8 0x9ac 0x4 0x0
#define MX35_PAD_SD1_DATA3__GPIO1_11				0x244 0x6a8 0x834 0x5 0x1
#define MX35_PAD_SD1_DATA3__ARM11P_TOP_TRACE_26			0x244 0x6a8 0x000 0x7 0x0
#define MX35_PAD_SD2_CMD__ESDHC2_CMD				0x248 0x6ac 0x000 0x0 0x0
#define MX35_PAD_SD2_CMD__I2C3_SCL				0x248 0x6ac 0x91c 0x1 0x2
#define MX35_PAD_SD2_CMD__ESDHC1_DAT4				0x248 0x6ac 0x804 0x2 0x0
#define MX35_PAD_SD2_CMD__IPU_CSI_D_2				0x248 0x6ac 0x938 0x3 0x2
#define MX35_PAD_SD2_CMD__USB_TOP_USBH2_DATA_4			0x248 0x6ac 0x9dc 0x4 0x0
#define MX35_PAD_SD2_CMD__GPIO2_0				0x248 0x6ac 0x868 0x5 0x2
#define MX35_PAD_SD2_CMD__SPDIF_SPDIF_OUT1			0x248 0x6ac 0x000 0x6 0x0
#define MX35_PAD_SD2_CMD__IPU_DISPB_D12_VSYNC			0x248 0x6ac 0x928 0x7 0x3
#define MX35_PAD_SD2_CLK__ESDHC2_CLK				0x24c 0x6b0 0x000 0x0 0x0
#define MX35_PAD_SD2_CLK__I2C3_SDA				0x24c 0x6b0 0x920 0x1 0x2
#define MX35_PAD_SD2_CLK__ESDHC1_DAT5				0x24c 0x6b0 0x808 0x2 0x0
#define MX35_PAD_SD2_CLK__IPU_CSI_D_3				0x24c 0x6b0 0x93c 0x3 0x2
#define MX35_PAD_SD2_CLK__USB_TOP_USBH2_DATA_5			0x24c 0x6b0 0x9e0 0x4 0x0
#define MX35_PAD_SD2_CLK__GPIO2_1				0x24c 0x6b0 0x894 0x5 0x1
#define MX35_PAD_SD2_CLK__SPDIF_SPDIF_IN1			0x24c 0x6b0 0x998 0x6 0x2
#define MX35_PAD_SD2_CLK__IPU_DISPB_CS2				0x24c 0x6b0 0x000 0x7 0x0
#define MX35_PAD_SD2_DATA0__ESDHC2_DAT0				0x250 0x6b4 0x000 0x0 0x0
#define MX35_PAD_SD2_DATA0__UART3_RXD_MUX			0x250 0x6b4 0x9a0 0x1 0x1
#define MX35_PAD_SD2_DATA0__ESDHC1_DAT6				0x250 0x6b4 0x80c 0x2 0x0
#define MX35_PAD_SD2_DATA0__IPU_CSI_D_4				0x250 0x6b4 0x940 0x3 0x1
#define MX35_PAD_SD2_DATA0__USB_TOP_USBH2_DATA_6		0x250 0x6b4 0x9e4 0x4 0x0
#define MX35_PAD_SD2_DATA0__GPIO2_2				0x250 0x6b4 0x8c0 0x5 0x1
#define MX35_PAD_SD2_DATA0__SPDIF_SPDIF_EXTCLK			0x250 0x6b4 0x994 0x6 0x3
#define MX35_PAD_SD2_DATA1__ESDHC2_DAT1				0x254 0x6b8 0x000 0x0 0x0
#define MX35_PAD_SD2_DATA1__UART3_TXD_MUX			0x254 0x6b8 0x000 0x1 0x0
#define MX35_PAD_SD2_DATA1__ESDHC1_DAT7				0x254 0x6b8 0x810 0x2 0x0
#define MX35_PAD_SD2_DATA1__IPU_CSI_D_5				0x254 0x6b8 0x944 0x3 0x1
#define MX35_PAD_SD2_DATA1__USB_TOP_USBH2_DATA_0		0x254 0x6b8 0x9cc 0x4 0x0
#define MX35_PAD_SD2_DATA1__GPIO2_3				0x254 0x6b8 0x8cc 0x5 0x1
#define MX35_PAD_SD2_DATA2__ESDHC2_DAT2				0x258 0x6bc 0x000 0x0 0x0
#define MX35_PAD_SD2_DATA2__UART3_RTS				0x258 0x6bc 0x99c 0x1 0x0
#define MX35_PAD_SD2_DATA2__CAN1_RXCAN				0x258 0x6bc 0x7c8 0x2 0x1
#define MX35_PAD_SD2_DATA2__IPU_CSI_D_6				0x258 0x6bc 0x948 0x3 0x1
#define MX35_PAD_SD2_DATA2__USB_TOP_USBH2_DATA_1		0x258 0x6bc 0x9d0 0x4 0x0
#define MX35_PAD_SD2_DATA2__GPIO2_4				0x258 0x6bc 0x8d0 0x5 0x1
#define MX35_PAD_SD2_DATA3__ESDHC2_DAT3				0x25c 0x6c0 0x000 0x0 0x0
#define MX35_PAD_SD2_DATA3__UART3_CTS				0x25c 0x6c0 0x000 0x1 0x0
#define MX35_PAD_SD2_DATA3__CAN1_TXCAN				0x25c 0x6c0 0x000 0x2 0x0
#define MX35_PAD_SD2_DATA3__IPU_CSI_D_7				0x25c 0x6c0 0x94c 0x3 0x1
#define MX35_PAD_SD2_DATA3__USB_TOP_USBH2_DATA_2		0x25c 0x6c0 0x9d4 0x4 0x0
#define MX35_PAD_SD2_DATA3__GPIO2_5				0x25c 0x6c0 0x8d4 0x5 0x1
#define MX35_PAD_ATA_CS0__ATA_CS0				0x260 0x6c4 0x000 0x0 0x0
#define MX35_PAD_ATA_CS0__CSPI1_SS3				0x260 0x6c4 0x7dc 0x1 0x1
#define MX35_PAD_ATA_CS0__IPU_DISPB_CS1				0x260 0x6c4 0x000 0x3 0x0
#define MX35_PAD_ATA_CS0__GPIO2_6				0x260 0x6c4 0x8d8 0x5 0x1
#define MX35_PAD_ATA_CS0__IPU_DIAGB_0				0x260 0x6c4 0x000 0x6 0x0
#define MX35_PAD_ATA_CS0__ARM11P_TOP_MAX1_HMASTER_0		0x260 0x6c4 0x000 0x7 0x0
#define MX35_PAD_ATA_CS1__ATA_CS1				0x264 0x6c8 0x000 0x0 0x0
#define MX35_PAD_ATA_CS1__IPU_DISPB_CS2				0x264 0x6c8 0x000 0x3 0x0
#define MX35_PAD_ATA_CS1__CSPI2_SS0				0x264 0x6c8 0x7f0 0x4 0x1
#define MX35_PAD_ATA_CS1__GPIO2_7				0x264 0x6c8 0x8dc 0x5 0x1
#define MX35_PAD_ATA_CS1__IPU_DIAGB_1				0x264 0x6c8 0x000 0x6 0x0
#define MX35_PAD_ATA_CS1__ARM11P_TOP_MAX1_HMASTER_1		0x264 0x6c8 0x000 0x7 0x0
#define MX35_PAD_ATA_DIOR__ATA_DIOR				0x268 0x6cc 0x000 0x0 0x0
#define MX35_PAD_ATA_DIOR__ESDHC3_DAT0				0x268 0x6cc 0x81c 0x1 0x1
#define MX35_PAD_ATA_DIOR__USB_TOP_USBOTG_DIR			0x268 0x6cc 0x9c4 0x2 0x1
#define MX35_PAD_ATA_DIOR__IPU_DISPB_BE0			0x268 0x6cc 0x000 0x3 0x0
#define MX35_PAD_ATA_DIOR__CSPI2_SS1				0x268 0x6cc 0x7f4 0x4 0x1
#define MX35_PAD_ATA_DIOR__GPIO2_8				0x268 0x6cc 0x8e0 0x5 0x1
#define MX35_PAD_ATA_DIOR__IPU_DIAGB_2				0x268 0x6cc 0x000 0x6 0x0
#define MX35_PAD_ATA_DIOR__ARM11P_TOP_MAX1_HMASTER_2		0x268 0x6cc 0x000 0x7 0x0
#define MX35_PAD_ATA_DIOW__ATA_DIOW				0x26c 0x6d0 0x000 0x0 0x0
#define MX35_PAD_ATA_DIOW__ESDHC3_DAT1				0x26c 0x6d0 0x820 0x1 0x1
#define MX35_PAD_ATA_DIOW__USB_TOP_USBOTG_STP			0x26c 0x6d0 0x000 0x2 0x0
#define MX35_PAD_ATA_DIOW__IPU_DISPB_BE1			0x26c 0x6d0 0x000 0x3 0x0
#define MX35_PAD_ATA_DIOW__CSPI2_MOSI				0x26c 0x6d0 0x7ec 0x4 0x2
#define MX35_PAD_ATA_DIOW__GPIO2_9				0x26c 0x6d0 0x8e4 0x5 0x1
#define MX35_PAD_ATA_DIOW__IPU_DIAGB_3				0x26c 0x6d0 0x000 0x6 0x0
#define MX35_PAD_ATA_DIOW__ARM11P_TOP_MAX1_HMASTER_3		0x26c 0x6d0 0x000 0x7 0x0
#define MX35_PAD_ATA_DMACK__ATA_DMACK				0x270 0x6d4 0x000 0x0 0x0
#define MX35_PAD_ATA_DMACK__ESDHC3_DAT2				0x270 0x6d4 0x824 0x1 0x1
#define MX35_PAD_ATA_DMACK__USB_TOP_USBOTG_NXT			0x270 0x6d4 0x9c8 0x2 0x1
#define MX35_PAD_ATA_DMACK__CSPI2_MISO				0x270 0x6d4 0x7e8 0x4 0x2
#define MX35_PAD_ATA_DMACK__GPIO2_10				0x270 0x6d4 0x86c 0x5 0x1
#define MX35_PAD_ATA_DMACK__IPU_DIAGB_4				0x270 0x6d4 0x000 0x6 0x0
#define MX35_PAD_ATA_DMACK__ARM11P_TOP_MAX0_HMASTER_0		0x270 0x6d4 0x000 0x7 0x0
#define MX35_PAD_ATA_RESET_B__ATA_RESET_B			0x274 0x6d8 0x000 0x0 0x0
#define MX35_PAD_ATA_RESET_B__ESDHC3_DAT3			0x274 0x6d8 0x828 0x1 0x1
#define MX35_PAD_ATA_RESET_B__USB_TOP_USBOTG_DATA_0		0x274 0x6d8 0x9a4 0x2 0x1
#define MX35_PAD_ATA_RESET_B__IPU_DISPB_SD_D_O			0x274 0x6d8 0x000 0x3 0x0
#define MX35_PAD_ATA_RESET_B__CSPI2_RDY				0x274 0x6d8 0x7e4 0x4 0x2
#define MX35_PAD_ATA_RESET_B__GPIO2_11				0x274 0x6d8 0x870 0x5 0x1
#define MX35_PAD_ATA_RESET_B__IPU_DIAGB_5			0x274 0x6d8 0x000 0x6 0x0
#define MX35_PAD_ATA_RESET_B__ARM11P_TOP_MAX0_HMASTER_1		0x274 0x6d8 0x000 0x7 0x0
#define MX35_PAD_ATA_IORDY__ATA_IORDY				0x278 0x6dc 0x000 0x0 0x0
#define MX35_PAD_ATA_IORDY__ESDHC3_DAT4				0x278 0x6dc 0x000 0x1 0x0
#define MX35_PAD_ATA_IORDY__USB_TOP_USBOTG_DATA_1		0x278 0x6dc 0x9a8 0x2 0x1
#define MX35_PAD_ATA_IORDY__IPU_DISPB_SD_D_IO			0x278 0x6dc 0x92c 0x3 0x3
#define MX35_PAD_ATA_IORDY__ESDHC2_DAT4				0x278 0x6dc 0x000 0x4 0x0
#define MX35_PAD_ATA_IORDY__GPIO2_12				0x278 0x6dc 0x874 0x5 0x1
#define MX35_PAD_ATA_IORDY__IPU_DIAGB_6				0x278 0x6dc 0x000 0x6 0x0
#define MX35_PAD_ATA_IORDY__ARM11P_TOP_MAX0_HMASTER_2		0x278 0x6dc 0x000 0x7 0x0
#define MX35_PAD_ATA_DATA0__ATA_DATA_0				0x27c 0x6e0 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA0__ESDHC3_DAT5				0x27c 0x6e0 0x000 0x1 0x0
#define MX35_PAD_ATA_DATA0__USB_TOP_USBOTG_DATA_2		0x27c 0x6e0 0x9ac 0x2 0x1
#define MX35_PAD_ATA_DATA0__IPU_DISPB_D12_VSYNC			0x27c 0x6e0 0x928 0x3 0x4
#define MX35_PAD_ATA_DATA0__ESDHC2_DAT5				0x27c 0x6e0 0x000 0x4 0x0
#define MX35_PAD_ATA_DATA0__GPIO2_13				0x27c 0x6e0 0x878 0x5 0x1
#define MX35_PAD_ATA_DATA0__IPU_DIAGB_7				0x27c 0x6e0 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA0__ARM11P_TOP_MAX0_HMASTER_3		0x27c 0x6e0 0x000 0x7 0x0
#define MX35_PAD_ATA_DATA1__ATA_DATA_1				0x280 0x6e4 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA1__ESDHC3_DAT6				0x280 0x6e4 0x000 0x1 0x0
#define MX35_PAD_ATA_DATA1__USB_TOP_USBOTG_DATA_3		0x280 0x6e4 0x9b0 0x2 0x1
#define MX35_PAD_ATA_DATA1__IPU_DISPB_SD_CLK			0x280 0x6e4 0x000 0x3 0x0
#define MX35_PAD_ATA_DATA1__ESDHC2_DAT6				0x280 0x6e4 0x000 0x4 0x0
#define MX35_PAD_ATA_DATA1__GPIO2_14				0x280 0x6e4 0x87c 0x5 0x1
#define MX35_PAD_ATA_DATA1__IPU_DIAGB_8				0x280 0x6e4 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA1__ARM11P_TOP_TRACE_27			0x280 0x6e4 0x000 0x7 0x0
#define MX35_PAD_ATA_DATA2__ATA_DATA_2				0x284 0x6e8 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA2__ESDHC3_DAT7				0x284 0x6e8 0x000 0x1 0x0
#define MX35_PAD_ATA_DATA2__USB_TOP_USBOTG_DATA_4		0x284 0x6e8 0x9b4 0x2 0x1
#define MX35_PAD_ATA_DATA2__IPU_DISPB_SER_RS			0x284 0x6e8 0x000 0x3 0x0
#define MX35_PAD_ATA_DATA2__ESDHC2_DAT7				0x284 0x6e8 0x000 0x4 0x0
#define MX35_PAD_ATA_DATA2__GPIO2_15				0x284 0x6e8 0x880 0x5 0x1
#define MX35_PAD_ATA_DATA2__IPU_DIAGB_9				0x284 0x6e8 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA2__ARM11P_TOP_TRACE_28			0x284 0x6e8 0x000 0x7 0x0
#define MX35_PAD_ATA_DATA3__ATA_DATA_3				0x288 0x6ec 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA3__ESDHC3_CLK				0x288 0x6ec 0x814 0x1 0x1
#define MX35_PAD_ATA_DATA3__USB_TOP_USBOTG_DATA_5		0x288 0x6ec 0x9b8 0x2 0x1
#define MX35_PAD_ATA_DATA3__CSPI2_SCLK				0x288 0x6ec 0x7e0 0x4 0x2
#define MX35_PAD_ATA_DATA3__GPIO2_16				0x288 0x6ec 0x884 0x5 0x1
#define MX35_PAD_ATA_DATA3__IPU_DIAGB_10			0x288 0x6ec 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA3__ARM11P_TOP_TRACE_29			0x288 0x6ec 0x000 0x7 0x0
#define MX35_PAD_ATA_DATA4__ATA_DATA_4				0x28c 0x6f0 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA4__ESDHC3_CMD				0x28c 0x6f0 0x818 0x1 0x1
#define MX35_PAD_ATA_DATA4__USB_TOP_USBOTG_DATA_6		0x28c 0x6f0 0x9bc 0x2 0x1
#define MX35_PAD_ATA_DATA4__GPIO2_17				0x28c 0x6f0 0x888 0x5 0x1
#define MX35_PAD_ATA_DATA4__IPU_DIAGB_11			0x28c 0x6f0 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA4__ARM11P_TOP_TRACE_30			0x28c 0x6f0 0x000 0x7 0x0
#define MX35_PAD_ATA_DATA5__ATA_DATA_5				0x290 0x6f4 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA5__USB_TOP_USBOTG_DATA_7		0x290 0x6f4 0x9c0 0x2 0x1
#define MX35_PAD_ATA_DATA5__GPIO2_18				0x290 0x6f4 0x88c 0x5 0x1
#define MX35_PAD_ATA_DATA5__IPU_DIAGB_12			0x290 0x6f4 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA5__ARM11P_TOP_TRACE_31			0x290 0x6f4 0x000 0x7 0x0
#define MX35_PAD_ATA_DATA6__ATA_DATA_6				0x294 0x6f8 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA6__CAN1_TXCAN				0x294 0x6f8 0x000 0x1 0x0
#define MX35_PAD_ATA_DATA6__UART1_DTR				0x294 0x6f8 0x000 0x2 0x0
#define MX35_PAD_ATA_DATA6__AUDMUX_AUD6_TXD			0x294 0x6f8 0x7b4 0x3 0x0
#define MX35_PAD_ATA_DATA6__GPIO2_19				0x294 0x6f8 0x890 0x5 0x1
#define MX35_PAD_ATA_DATA6__IPU_DIAGB_13			0x294 0x6f8 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA7__ATA_DATA_7				0x298 0x6fc 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA7__CAN1_RXCAN				0x298 0x6fc 0x7c8 0x1 0x2
#define MX35_PAD_ATA_DATA7__UART1_DSR				0x298 0x6fc 0x000 0x2 0x0
#define MX35_PAD_ATA_DATA7__AUDMUX_AUD6_RXD			0x298 0x6fc 0x7b0 0x3 0x0
#define MX35_PAD_ATA_DATA7__GPIO2_20				0x298 0x6fc 0x898 0x5 0x1
#define MX35_PAD_ATA_DATA7__IPU_DIAGB_14			0x298 0x6fc 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA8__ATA_DATA_8				0x29c 0x700 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA8__UART3_RTS				0x29c 0x700 0x99c 0x1 0x1
#define MX35_PAD_ATA_DATA8__UART1_RI				0x29c 0x700 0x000 0x2 0x0
#define MX35_PAD_ATA_DATA8__AUDMUX_AUD6_TXC			0x29c 0x700 0x7c0 0x3 0x0
#define MX35_PAD_ATA_DATA8__GPIO2_21				0x29c 0x700 0x89c 0x5 0x1
#define MX35_PAD_ATA_DATA8__IPU_DIAGB_15			0x29c 0x700 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA9__ATA_DATA_9				0x2a0 0x704 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA9__UART3_CTS				0x2a0 0x704 0x000 0x1 0x0
#define MX35_PAD_ATA_DATA9__UART1_DCD				0x2a0 0x704 0x000 0x2 0x0
#define MX35_PAD_ATA_DATA9__AUDMUX_AUD6_TXFS			0x2a0 0x704 0x7c4 0x3 0x0
#define MX35_PAD_ATA_DATA9__GPIO2_22				0x2a0 0x704 0x8a0 0x5 0x1
#define MX35_PAD_ATA_DATA9__IPU_DIAGB_16			0x2a0 0x704 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA10__ATA_DATA_10			0x2a4 0x708 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA10__UART3_RXD_MUX			0x2a4 0x708 0x9a0 0x1 0x2
#define MX35_PAD_ATA_DATA10__AUDMUX_AUD6_RXC			0x2a4 0x708 0x7b8 0x3 0x0
#define MX35_PAD_ATA_DATA10__GPIO2_23				0x2a4 0x708 0x8a4 0x5 0x1
#define MX35_PAD_ATA_DATA10__IPU_DIAGB_17			0x2a4 0x708 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA11__ATA_DATA_11			0x2a8 0x70c 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA11__UART3_TXD_MUX			0x2a8 0x70c 0x000 0x1 0x0
#define MX35_PAD_ATA_DATA11__AUDMUX_AUD6_RXFS			0x2a8 0x70c 0x7bc 0x3 0x0
#define MX35_PAD_ATA_DATA11__GPIO2_24				0x2a8 0x70c 0x8a8 0x5 0x1
#define MX35_PAD_ATA_DATA11__IPU_DIAGB_18			0x2a8 0x70c 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA12__ATA_DATA_12			0x2ac 0x710 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA12__I2C3_SCL				0x2ac 0x710 0x91c 0x1 0x3
#define MX35_PAD_ATA_DATA12__GPIO2_25				0x2ac 0x710 0x8ac 0x5 0x1
#define MX35_PAD_ATA_DATA12__IPU_DIAGB_19			0x2ac 0x710 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA13__ATA_DATA_13			0x2b0 0x714 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA13__I2C3_SDA				0x2b0 0x714 0x920 0x1 0x3
#define MX35_PAD_ATA_DATA13__GPIO2_26				0x2b0 0x714 0x8b0 0x5 0x1
#define MX35_PAD_ATA_DATA13__IPU_DIAGB_20			0x2b0 0x714 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA14__ATA_DATA_14			0x2b4 0x718 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA14__IPU_CSI_D_0			0x2b4 0x718 0x930 0x1 0x2
#define MX35_PAD_ATA_DATA14__KPP_ROW_0				0x2b4 0x718 0x970 0x3 0x2
#define MX35_PAD_ATA_DATA14__GPIO2_27				0x2b4 0x718 0x8b4 0x5 0x1
#define MX35_PAD_ATA_DATA14__IPU_DIAGB_21			0x2b4 0x718 0x000 0x6 0x0
#define MX35_PAD_ATA_DATA15__ATA_DATA_15			0x2b8 0x71c 0x000 0x0 0x0
#define MX35_PAD_ATA_DATA15__IPU_CSI_D_1			0x2b8 0x71c 0x934 0x1 0x2
#define MX35_PAD_ATA_DATA15__KPP_ROW_1				0x2b8 0x71c 0x974 0x3 0x2
#define MX35_PAD_ATA_DATA15__GPIO2_28				0x2b8 0x71c 0x8b8 0x5 0x1
#define MX35_PAD_ATA_DATA15__IPU_DIAGB_22			0x2b8 0x71c 0x000 0x6 0x0
#define MX35_PAD_ATA_INTRQ__ATA_INTRQ				0x2bc 0x720 0x000 0x0 0x0
#define MX35_PAD_ATA_INTRQ__IPU_CSI_D_2				0x2bc 0x720 0x938 0x1 0x3
#define MX35_PAD_ATA_INTRQ__KPP_ROW_2				0x2bc 0x720 0x978 0x3 0x2
#define MX35_PAD_ATA_INTRQ__GPIO2_29				0x2bc 0x720 0x8bc 0x5 0x1
#define MX35_PAD_ATA_INTRQ__IPU_DIAGB_23			0x2bc 0x720 0x000 0x6 0x0
#define MX35_PAD_ATA_BUFF_EN__ATA_BUFFER_EN			0x2c0 0x724 0x000 0x0 0x0
#define MX35_PAD_ATA_BUFF_EN__IPU_CSI_D_3			0x2c0 0x724 0x93c 0x1 0x3
#define MX35_PAD_ATA_BUFF_EN__KPP_ROW_3				0x2c0 0x724 0x97c 0x3 0x2
#define MX35_PAD_ATA_BUFF_EN__GPIO2_30				0x2c0 0x724 0x8c4 0x5 0x1
#define MX35_PAD_ATA_BUFF_EN__IPU_DIAGB_24			0x2c0 0x724 0x000 0x6 0x0
#define MX35_PAD_ATA_DMARQ__ATA_DMARQ				0x2c4 0x728 0x000 0x0 0x0
#define MX35_PAD_ATA_DMARQ__IPU_CSI_D_4				0x2c4 0x728 0x940 0x1 0x2
#define MX35_PAD_ATA_DMARQ__KPP_COL_0				0x2c4 0x728 0x950 0x3 0x2
#define MX35_PAD_ATA_DMARQ__GPIO2_31				0x2c4 0x728 0x8c8 0x5 0x1
#define MX35_PAD_ATA_DMARQ__IPU_DIAGB_25			0x2c4 0x728 0x000 0x6 0x0
#define MX35_PAD_ATA_DMARQ__ECT_CTI_TRIG_IN1_4			0x2c4 0x728 0x000 0x7 0x0
#define MX35_PAD_ATA_DA0__ATA_DA_0				0x2c8 0x72c 0x000 0x0 0x0
#define MX35_PAD_ATA_DA0__IPU_CSI_D_5				0x2c8 0x72c 0x944 0x1 0x2
#define MX35_PAD_ATA_DA0__KPP_COL_1				0x2c8 0x72c 0x954 0x3 0x2
#define MX35_PAD_ATA_DA0__GPIO3_0				0x2c8 0x72c 0x8e8 0x5 0x1
#define MX35_PAD_ATA_DA0__IPU_DIAGB_26				0x2c8 0x72c 0x000 0x6 0x0
#define MX35_PAD_ATA_DA0__ECT_CTI_TRIG_IN1_5			0x2c8 0x72c 0x000 0x7 0x0
#define MX35_PAD_ATA_DA1__ATA_DA_1				0x2cc 0x730 0x000 0x0 0x0
#define MX35_PAD_ATA_DA1__IPU_CSI_D_6				0x2cc 0x730 0x948 0x1 0x2
#define MX35_PAD_ATA_DA1__KPP_COL_2				0x2cc 0x730 0x958 0x3 0x2
#define MX35_PAD_ATA_DA1__GPIO3_1				0x2cc 0x730 0x000 0x5 0x0
#define MX35_PAD_ATA_DA1__IPU_DIAGB_27				0x2cc 0x730 0x000 0x6 0x0
#define MX35_PAD_ATA_DA1__ECT_CTI_TRIG_IN1_6			0x2cc 0x730 0x000 0x7 0x0
#define MX35_PAD_ATA_DA2__ATA_DA_2				0x2d0 0x734 0x000 0x0 0x0
#define MX35_PAD_ATA_DA2__IPU_CSI_D_7				0x2d0 0x734 0x94c 0x1 0x2
#define MX35_PAD_ATA_DA2__KPP_COL_3				0x2d0 0x734 0x95c 0x3 0x2
#define MX35_PAD_ATA_DA2__GPIO3_2				0x2d0 0x734 0x000 0x5 0x0
#define MX35_PAD_ATA_DA2__IPU_DIAGB_28				0x2d0 0x734 0x000 0x6 0x0
#define MX35_PAD_ATA_DA2__ECT_CTI_TRIG_IN1_7			0x2d0 0x734 0x000 0x7 0x0
#define MX35_PAD_MLB_CLK__MLB_MLBCLK				0x2d4 0x738 0x000 0x0 0x0
#define MX35_PAD_MLB_CLK__GPIO3_3				0x2d4 0x738 0x000 0x5 0x0
#define MX35_PAD_MLB_DAT__MLB_MLBDAT				0x2d8 0x73c 0x000 0x0 0x0
#define MX35_PAD_MLB_DAT__GPIO3_4				0x2d8 0x73c 0x904 0x5 0x1
#define MX35_PAD_MLB_SIG__MLB_MLBSIG				0x2dc 0x740 0x000 0x0 0x0
#define MX35_PAD_MLB_SIG__GPIO3_5				0x2dc 0x740 0x908 0x5 0x1
#define MX35_PAD_FEC_TX_CLK__FEC_TX_CLK				0x2e0 0x744 0x000 0x0 0x0
#define MX35_PAD_FEC_TX_CLK__ESDHC1_DAT4			0x2e0 0x744 0x804 0x1 0x1
#define MX35_PAD_FEC_TX_CLK__UART3_RXD_MUX			0x2e0 0x744 0x9a0 0x2 0x3
#define MX35_PAD_FEC_TX_CLK__USB_TOP_USBH2_DIR			0x2e0 0x744 0x9ec 0x3 0x1
#define MX35_PAD_FEC_TX_CLK__CSPI2_MOSI				0x2e0 0x744 0x7ec 0x4 0x3
#define MX35_PAD_FEC_TX_CLK__GPIO3_6				0x2e0 0x744 0x90c 0x5 0x1
#define MX35_PAD_FEC_TX_CLK__IPU_DISPB_D12_VSYNC		0x2e0 0x744 0x928 0x6 0x5
#define MX35_PAD_FEC_TX_CLK__ARM11P_TOP_EVNTBUS_0		0x2e0 0x744 0x000 0x7 0x0
#define MX35_PAD_FEC_RX_CLK__FEC_RX_CLK				0x2e4 0x748 0x000 0x0 0x0
#define MX35_PAD_FEC_RX_CLK__ESDHC1_DAT5			0x2e4 0x748 0x808 0x1 0x1
#define MX35_PAD_FEC_RX_CLK__UART3_TXD_MUX			0x2e4 0x748 0x000 0x2 0x0
#define MX35_PAD_FEC_RX_CLK__USB_TOP_USBH2_STP			0x2e4 0x748 0x000 0x3 0x0
#define MX35_PAD_FEC_RX_CLK__CSPI2_MISO				0x2e4 0x748 0x7e8 0x4 0x3
#define MX35_PAD_FEC_RX_CLK__GPIO3_7				0x2e4 0x748 0x910 0x5 0x1
#define MX35_PAD_FEC_RX_CLK__IPU_DISPB_SD_D_I			0x2e4 0x748 0x92c 0x6 0x4
#define MX35_PAD_FEC_RX_CLK__ARM11P_TOP_EVNTBUS_1		0x2e4 0x748 0x000 0x7 0x0
#define MX35_PAD_FEC_RX_DV__FEC_RX_DV				0x2e8 0x74c 0x000 0x0 0x0
#define MX35_PAD_FEC_RX_DV__ESDHC1_DAT6				0x2e8 0x74c 0x80c 0x1 0x1
#define MX35_PAD_FEC_RX_DV__UART3_RTS				0x2e8 0x74c 0x99c 0x2 0x2
#define MX35_PAD_FEC_RX_DV__USB_TOP_USBH2_NXT			0x2e8 0x74c 0x9f0 0x3 0x1
#define MX35_PAD_FEC_RX_DV__CSPI2_SCLK				0x2e8 0x74c 0x7e0 0x4 0x3
#define MX35_PAD_FEC_RX_DV__GPIO3_8				0x2e8 0x74c 0x914 0x5 0x1
#define MX35_PAD_FEC_RX_DV__IPU_DISPB_SD_CLK			0x2e8 0x74c 0x000 0x6 0x0
#define MX35_PAD_FEC_RX_DV__ARM11P_TOP_EVNTBUS_2		0x2e8 0x74c 0x000 0x7 0x0
#define MX35_PAD_FEC_COL__FEC_COL				0x2ec 0x750 0x000 0x0 0x0
#define MX35_PAD_FEC_COL__ESDHC1_DAT7				0x2ec 0x750 0x810 0x1 0x1
#define MX35_PAD_FEC_COL__UART3_CTS				0x2ec 0x750 0x000 0x2 0x0
#define MX35_PAD_FEC_COL__USB_TOP_USBH2_DATA_0			0x2ec 0x750 0x9cc 0x3 0x1
#define MX35_PAD_FEC_COL__CSPI2_RDY				0x2ec 0x750 0x7e4 0x4 0x3
#define MX35_PAD_FEC_COL__GPIO3_9				0x2ec 0x750 0x918 0x5 0x1
#define MX35_PAD_FEC_COL__IPU_DISPB_SER_RS			0x2ec 0x750 0x000 0x6 0x0
#define MX35_PAD_FEC_COL__ARM11P_TOP_EVNTBUS_3			0x2ec 0x750 0x000 0x7 0x0
#define MX35_PAD_FEC_RDATA0__FEC_RDATA_0			0x2f0 0x754 0x000 0x0 0x0
#define MX35_PAD_FEC_RDATA0__PWM_PWMO				0x2f0 0x754 0x000 0x1 0x0
#define MX35_PAD_FEC_RDATA0__UART3_DTR				0x2f0 0x754 0x000 0x2 0x0
#define MX35_PAD_FEC_RDATA0__USB_TOP_USBH2_DATA_1		0x2f0 0x754 0x9d0 0x3 0x1
#define MX35_PAD_FEC_RDATA0__CSPI2_SS0				0x2f0 0x754 0x7f0 0x4 0x2
#define MX35_PAD_FEC_RDATA0__GPIO3_10				0x2f0 0x754 0x8ec 0x5 0x1
#define MX35_PAD_FEC_RDATA0__IPU_DISPB_CS1			0x2f0 0x754 0x000 0x6 0x0
#define MX35_PAD_FEC_RDATA0__ARM11P_TOP_EVNTBUS_4		0x2f0 0x754 0x000 0x7 0x0
#define MX35_PAD_FEC_TDATA0__FEC_TDATA_0			0x2f4 0x758 0x000 0x0 0x0
#define MX35_PAD_FEC_TDATA0__SPDIF_SPDIF_OUT1			0x2f4 0x758 0x000 0x1 0x0
#define MX35_PAD_FEC_TDATA0__UART3_DSR				0x2f4 0x758 0x000 0x2 0x0
#define MX35_PAD_FEC_TDATA0__USB_TOP_USBH2_DATA_2		0x2f4 0x758 0x9d4 0x3 0x1
#define MX35_PAD_FEC_TDATA0__CSPI2_SS1				0x2f4 0x758 0x7f4 0x4 0x2
#define MX35_PAD_FEC_TDATA0__GPIO3_11				0x2f4 0x758 0x8f0 0x5 0x1
#define MX35_PAD_FEC_TDATA0__IPU_DISPB_CS0			0x2f4 0x758 0x000 0x6 0x0
#define MX35_PAD_FEC_TDATA0__ARM11P_TOP_EVNTBUS_5		0x2f4 0x758 0x000 0x7 0x0
#define MX35_PAD_FEC_TX_EN__FEC_TX_EN				0x2f8 0x75c 0x000 0x0 0x0
#define MX35_PAD_FEC_TX_EN__SPDIF_SPDIF_IN1			0x2f8 0x75c 0x998 0x1 0x3
#define MX35_PAD_FEC_TX_EN__UART3_RI				0x2f8 0x75c 0x000 0x2 0x0
#define MX35_PAD_FEC_TX_EN__USB_TOP_USBH2_DATA_3		0x2f8 0x75c 0x9d8 0x3 0x1
#define MX35_PAD_FEC_TX_EN__GPIO3_12				0x2f8 0x75c 0x8f4 0x5 0x1
#define MX35_PAD_FEC_TX_EN__IPU_DISPB_PAR_RS			0x2f8 0x75c 0x000 0x6 0x0
#define MX35_PAD_FEC_TX_EN__ARM11P_TOP_EVNTBUS_6		0x2f8 0x75c 0x000 0x7 0x0
#define MX35_PAD_FEC_MDC__FEC_MDC				0x2fc 0x760 0x000 0x0 0x0
#define MX35_PAD_FEC_MDC__CAN2_TXCAN				0x2fc 0x760 0x000 0x1 0x0
#define MX35_PAD_FEC_MDC__UART3_DCD				0x2fc 0x760 0x000 0x2 0x0
#define MX35_PAD_FEC_MDC__USB_TOP_USBH2_DATA_4			0x2fc 0x760 0x9dc 0x3 0x1
#define MX35_PAD_FEC_MDC__GPIO3_13				0x2fc 0x760 0x8f8 0x5 0x1
#define MX35_PAD_FEC_MDC__IPU_DISPB_WR				0x2fc 0x760 0x000 0x6 0x0
#define MX35_PAD_FEC_MDC__ARM11P_TOP_EVNTBUS_7			0x2fc 0x760 0x000 0x7 0x0
#define MX35_PAD_FEC_MDIO__FEC_MDIO				0x300 0x764 0x000 0x0 0x0
#define MX35_PAD_FEC_MDIO__CAN2_RXCAN				0x300 0x764 0x7cc 0x1 0x2
#define MX35_PAD_FEC_MDIO__USB_TOP_USBH2_DATA_5			0x300 0x764 0x9e0 0x3 0x1
#define MX35_PAD_FEC_MDIO__GPIO3_14				0x300 0x764 0x8fc 0x5 0x1
#define MX35_PAD_FEC_MDIO__IPU_DISPB_RD				0x300 0x764 0x000 0x6 0x0
#define MX35_PAD_FEC_MDIO__ARM11P_TOP_EVNTBUS_8			0x300 0x764 0x000 0x7 0x0
#define MX35_PAD_FEC_TX_ERR__FEC_TX_ERR				0x304 0x768 0x000 0x0 0x0
#define MX35_PAD_FEC_TX_ERR__OWIRE_LINE				0x304 0x768 0x990 0x1 0x2
#define MX35_PAD_FEC_TX_ERR__SPDIF_SPDIF_EXTCLK			0x304 0x768 0x994 0x2 0x4
#define MX35_PAD_FEC_TX_ERR__USB_TOP_USBH2_DATA_6		0x304 0x768 0x9e4 0x3 0x1
#define MX35_PAD_FEC_TX_ERR__GPIO3_15				0x304 0x768 0x900 0x5 0x1
#define MX35_PAD_FEC_TX_ERR__IPU_DISPB_D0_VSYNC			0x304 0x768 0x924 0x6 0x3
#define MX35_PAD_FEC_TX_ERR__ARM11P_TOP_EVNTBUS_9		0x304 0x768 0x000 0x7 0x0
#define MX35_PAD_FEC_RX_ERR__FEC_RX_ERR				0x308 0x76c 0x000 0x0 0x0
#define MX35_PAD_FEC_RX_ERR__IPU_CSI_D_0			0x308 0x76c 0x930 0x1 0x3
#define MX35_PAD_FEC_RX_ERR__USB_TOP_USBH2_DATA_7		0x308 0x76c 0x9e8 0x3 0x1
#define MX35_PAD_FEC_RX_ERR__KPP_COL_4				0x308 0x76c 0x960 0x4 0x1
#define MX35_PAD_FEC_RX_ERR__GPIO3_16				0x308 0x76c 0x000 0x5 0x0
#define MX35_PAD_FEC_RX_ERR__IPU_DISPB_SD_D_IO			0x308 0x76c 0x92c 0x6 0x5
#define MX35_PAD_FEC_CRS__FEC_CRS				0x30c 0x770 0x000 0x0 0x0
#define MX35_PAD_FEC_CRS__IPU_CSI_D_1				0x30c 0x770 0x934 0x1 0x3
#define MX35_PAD_FEC_CRS__USB_TOP_USBH2_PWR			0x30c 0x770 0x000 0x3 0x0
#define MX35_PAD_FEC_CRS__KPP_COL_5				0x30c 0x770 0x964 0x4 0x1
#define MX35_PAD_FEC_CRS__GPIO3_17				0x30c 0x770 0x000 0x5 0x0
#define MX35_PAD_FEC_CRS__IPU_FLASH_STROBE			0x30c 0x770 0x000 0x6 0x0
#define MX35_PAD_FEC_RDATA1__FEC_RDATA_1			0x310 0x774 0x000 0x0 0x0
#define MX35_PAD_FEC_RDATA1__IPU_CSI_D_2			0x310 0x774 0x938 0x1 0x4
#define MX35_PAD_FEC_RDATA1__AUDMUX_AUD6_RXC			0x310 0x774 0x000 0x2 0x0
#define MX35_PAD_FEC_RDATA1__USB_TOP_USBH2_OC			0x310 0x774 0x9f4 0x3 0x2
#define MX35_PAD_FEC_RDATA1__KPP_COL_6				0x310 0x774 0x968 0x4 0x1
#define MX35_PAD_FEC_RDATA1__GPIO3_18				0x310 0x774 0x000 0x5 0x0
#define MX35_PAD_FEC_RDATA1__IPU_DISPB_BE0			0x310 0x774 0x000 0x6 0x0
#define MX35_PAD_FEC_TDATA1__FEC_TDATA_1			0x314 0x778 0x000 0x0 0x0
#define MX35_PAD_FEC_TDATA1__IPU_CSI_D_3			0x314 0x778 0x93c 0x1 0x4
#define MX35_PAD_FEC_TDATA1__AUDMUX_AUD6_RXFS			0x314 0x778 0x7bc 0x2 0x1
#define MX35_PAD_FEC_TDATA1__KPP_COL_7				0x314 0x778 0x96c 0x4 0x1
#define MX35_PAD_FEC_TDATA1__GPIO3_19				0x314 0x778 0x000 0x5 0x0
#define MX35_PAD_FEC_TDATA1__IPU_DISPB_BE1			0x314 0x778 0x000 0x6 0x0
#define MX35_PAD_FEC_RDATA2__FEC_RDATA_2			0x318 0x77c 0x000 0x0 0x0
#define MX35_PAD_FEC_RDATA2__IPU_CSI_D_4			0x318 0x77c 0x940 0x1 0x3
#define MX35_PAD_FEC_RDATA2__AUDMUX_AUD6_TXD			0x318 0x77c 0x7b4 0x2 0x1
#define MX35_PAD_FEC_RDATA2__KPP_ROW_4				0x318 0x77c 0x980 0x4 0x1
#define MX35_PAD_FEC_RDATA2__GPIO3_20				0x318 0x77c 0x000 0x5 0x0
#define MX35_PAD_FEC_TDATA2__FEC_TDATA_2			0x31c 0x780 0x000 0x0 0x0
#define MX35_PAD_FEC_TDATA2__IPU_CSI_D_5			0x31c 0x780 0x944 0x1 0x3
#define MX35_PAD_FEC_TDATA2__AUDMUX_AUD6_RXD			0x31c 0x780 0x7b0 0x2 0x1
#define MX35_PAD_FEC_TDATA2__KPP_ROW_5				0x31c 0x780 0x984 0x4 0x1
#define MX35_PAD_FEC_TDATA2__GPIO3_21				0x31c 0x780 0x000 0x5 0x0
#define MX35_PAD_FEC_RDATA3__FEC_RDATA_3			0x320 0x784 0x000 0x0 0x0
#define MX35_PAD_FEC_RDATA3__IPU_CSI_D_6			0x320 0x784 0x948 0x1 0x3
#define MX35_PAD_FEC_RDATA3__AUDMUX_AUD6_TXC			0x320 0x784 0x7c0 0x2 0x1
#define MX35_PAD_FEC_RDATA3__KPP_ROW_6				0x320 0x784 0x988 0x4 0x1
#define MX35_PAD_FEC_RDATA3__GPIO3_22				0x320 0x784 0x000 0x6 0x0
#define MX35_PAD_FEC_TDATA3__FEC_TDATA_3			0x324 0x788 0x000 0x0 0x0
#define MX35_PAD_FEC_TDATA3__IPU_CSI_D_7			0x324 0x788 0x94c 0x1 0x3
#define MX35_PAD_FEC_TDATA3__AUDMUX_AUD6_TXFS			0x324 0x788 0x7c4 0x2 0x1
#define MX35_PAD_FEC_TDATA3__KPP_ROW_7				0x324 0x788 0x98c 0x4 0x1
#define MX35_PAD_FEC_TDATA3__GPIO3_23				0x324 0x788 0x000 0x5 0x0
#define MX35_PAD_EXT_ARMCLK__CCM_EXT_ARMCLK			0x000 0x78c 0x000 0x0 0x0
#define MX35_PAD_TEST_MODE__TCU_TEST_MODE			0x000 0x790 0x000 0x0 0x0

#endif /* __DTS_IMX35_PINFUNC_H */
