/*
 *  Class TestFrequencies
 *
 *  Copyright (c) David Hampton 2020
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef LIBMYTHTV_TEST_FREQUENCIES_H
#define LIBMYTHTV_TEST_FREQUENCIES_H

#include <QTest>
#include <iostream>

#include "libmythtv/frequencies.h"
#include "libmythtv/frequencytables.h"

class TestFrequencies : public QObject
{
    Q_OBJECT

private slots:
    static void initTestCase();
    static void test_gchanlists_data(void);
    static void test_gchanlists(void);
    static void test_get_tables_data(void);
    static void test_get_tables(void);
    static void test_get_closest_data(void);
    static void test_get_closest(void);
    static void cleanupTestCase();
};

#endif // LIBMYTHTV_TEST_FREQUENCIES_H
