// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file module_structCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__MODULE_STRUCTCDRAUX_IPP
#define FAST_DDS_GENERATED__MODULE_STRUCTCDRAUX_IPP

#include "module_structCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const TrialModule::BitsetModule::BitsetType&,
        size_t& current_alignment)
{
    using namespace TrialModule::BitsetModule;

    return calculator.calculate_serialized_size(std::bitset<25>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const TrialModule::BitsetModule::BitsetType& data)
{
    using namespace TrialModule::BitsetModule;

    std::bitset<25> bitset;

        bitset <<= 12;
        bitset |= (data.flag3 & 0xFFF);

        bitset <<= 10;
        bitset |= (data.flag2 & 0x3FF);

        bitset <<= 3;
        bitset |= (data.flag1 & 0x7);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        TrialModule::BitsetModule::BitsetType& data)
{
    using namespace TrialModule::BitsetModule;

    std::bitset<25> bitset;
    dcdr >> bitset;

        data.flag1 = static_cast<uint8_t>(bitset.to_ullong() & 0x7);
        bitset >>= 3;

        data.flag2 = static_cast<uint16_t>(bitset.to_ullong() & 0x3FF);
        bitset >>= 10;

        data.flag3 = static_cast<int32_t>(bitset.to_ullong() & 0xFFF);
        bitset >>= 12;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const TrialModule::StructModule::StructType& data,
        size_t& current_alignment)
{
    using namespace TrialModule::StructModule;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.struct_data(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const TrialModule::StructModule::StructType& data)
{
    using namespace TrialModule::StructModule;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.struct_data()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        TrialModule::StructModule::StructType& data)
{
    using namespace TrialModule::StructModule;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.struct_data();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const TrialModule::StructModule::StructType& data)
{
    using namespace TrialModule::StructModule;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.struct_data();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const TrialModule::UnionModule::UnionType& data,
        size_t& current_alignment)
{
    using namespace TrialModule::UnionModule;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case 0:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.case_long(), current_alignment);
                    break;

                case 1:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.case_float(), current_alignment);
                    break;

                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                                data.case_string(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const TrialModule::UnionModule::UnionType& data)
{
    using namespace TrialModule::UnionModule;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case 0:
                    scdr << eprosima::fastcdr::MemberId(1) << data.case_long();
                    break;

                case 1:
                    scdr << eprosima::fastcdr::MemberId(2) << data.case_float();
                    break;

                default:
                    scdr << eprosima::fastcdr::MemberId(3) << data.case_string();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        TrialModule::UnionModule::UnionType& data)
{
    using namespace TrialModule::UnionModule;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    int32_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case 0:
                                                    {
                                                        int32_t case_long_value{0};
                                                        data.case_long(std::move(case_long_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case 1:
                                                    {
                                                        float case_float_value{0.0};
                                                        data.case_float(std::move(case_float_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                default:
                                                    {
                                                        std::string case_string_value;
                                                        data.case_string(std::move(case_string_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case 0:
                                                    dcdr >> data.case_long();
                                                    break;

                                                case 1:
                                                    dcdr >> data.case_float();
                                                    break;

                                                default:
                                                    dcdr >> data.case_string();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ModuleStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.alias_member(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.bitset_member(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.bitmask_member(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.enum_member(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.struct_member(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.union_member(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ModuleStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.alias_member()
        << eprosima::fastcdr::MemberId(1) << data.bitset_member()
        << eprosima::fastcdr::MemberId(2) << data.bitmask_member()
        << eprosima::fastcdr::MemberId(3) << data.enum_member()
        << eprosima::fastcdr::MemberId(4) << data.struct_member()
        << eprosima::fastcdr::MemberId(5) << data.union_member()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ModuleStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.alias_member();
                                            break;

                                        case 1:
                                                dcdr >> data.bitset_member();
                                            break;

                                        case 2:
                                                dcdr >> data.bitmask_member();
                                            break;

                                        case 3:
                                                dcdr >> data.enum_member();
                                            break;

                                        case 4:
                                                dcdr >> data.struct_member();
                                            break;

                                        case 5:
                                                dcdr >> data.union_member();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ModuleStruct& data)
{
            extern void serialize_key(
                    Cdr& scdr,
                    const TrialModule::StructModule::StructType& data);



    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.alias_member();

                        scdr << data.bitset_member();

                        scdr << data.bitmask_member();

                        scdr << data.enum_member();

                        serialize_key(scdr, data.struct_member());

                        scdr << data.union_member();

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__MODULE_STRUCTCDRAUX_IPP

