find_package(PkgConfig)
if (NOT BUILTIN_GTKGLEXT OR BUILTIN_GTKGLEXT_BUILT)
if (PKG_CONFIG_FOUND)
    if (GtkGLExt_FIND_REQUIRED)
        set(_pkgconfig_REQUIRED REQUIRED)
    endif ()
    if (APPLE)
        pkg_check_modules(GtkGLExt ${_pkgconfig_REQUIRED} gtkglext-1.0 gtkglext-quartz-1.0)
    elseif (XWINDOWS)
        pkg_check_modules(GtkGLExt ${_pkgconfig_REQUIRED} gtkglext-x11-1.0)
    elseif (WIN32)
        pkg_check_modules(GtkGLExt ${_pkgconfig_REQUIRED} gtkglext-win32-1.0)
    endif ()
    if (GtkGLExt_LINK_LIBRARIES)
        set(GtkGLExt_LIBRARIES ${GtkGLExt_LINK_LIBRARIES}) # HACK
    endif ()
else ()
    find_path(GtkGLExt_INCLUDE_DIRS gtkglwidget.h)
    # find_library(GtkGLExt_LIBRARIES)
    if (GtkGLExt_INCLUDE_DIRS AND GtkGLExt_LIBRARIES)
        set(GtkGLExt_FOUND 1)
        if (NOT GtkGLExt_FIND_QUIETLY)
            message(STATUS "Found GtkGLExt: ${GtkGLExt_LIBRARIES}")
        endif ()
    elseif (GtkGLExt_FIND_REQUIRED)
        message(SEND_ERROR "Could not find GtkGLExt")
    elseif (NOT GtkGLExt_FIND_QUIETLY)
        message(STATUS "Could not find GtkGLExt")
    endif ()
endif ()
mark_as_advanced(GtkGLExt_INCLUDE_DIRS GtkGLExt_LIBRARIES)
endif()
