discard """
disabled: true
"""

## JSON tests based on https://github.com/nst/JSONTestSuite

import unittest,
  json,
  strutils

let parsing_testdata = {
  "i_number_neg_int_huge_exp": """[-1e+9999]""",
  "i_number_pos_double_huge_exp": """[1.5e+9999]""",
  "i_object_key_lone_2nd_surrogate": """{"\uDFAA":0}""",
  "i_string_1st_surrogate_but_2nd_missing": """["\uDADA"]""",
  "i_string_1st_valid_surrogate_2nd_invalid": """["\uD888\u1234"]""",
  "i_string_incomplete_surrogate_and_escape_valid": """["\uD800\n"]""",
  "i_string_incomplete_surrogate_pair": """["\uDd1ea"]""",
  "i_string_incomplete_surrogates_escape_valid": """["\uD800\uD800\n"]""",
  "i_string_inverted_surrogates_U+1D11E": """["\uDd1e\uD834"]""",
  "i_string_lone_second_surrogate": """["\uDFAA"]""",
  "i_string_not_in_unicode_range": """[""]""",
  "i_string_truncated-utf-8": """[""]""",
  "i_string_unicode_U+10FFFE_nonchar": """["\uDBFF\uDFFE"]""",
  "i_string_unicode_U+1FFFE_nonchar": """["\uD83F\uDFFE"]""",
  "i_string_unicode_U+FDD0_nonchar": """["\uFDD0"]""",
  "i_string_unicode_U+FFFE_nonchar": """["\uFFFE"]""",
  "i_string_UTF-16_invalid_lonely_surrogate": """["\ud800"]""",
  "i_string_UTF-16_invalid_surrogate": """["\ud800abc"]""",
  "i_string_UTF-8_invalid_sequence": """["日ш"]""",
  "i_structure_500_nested_arrays": """[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]""",
  "i_structure_UTF-8_BOM_empty_object": """﻿{}""",
  "n_array_1_true_without_comma": """[1 true]""",
  "n_array_a_invalid_utf8": """[a]""",
  "n_array_colon_instead_of_comma": """["": 1]""",
  "n_array_comma_after_close": """[""],""",
  "n_array_comma_and_number": """[,1]""",
  "n_array_double_comma": """[1,,2]""",
  "n_array_double_extra_comma": """["x",,]""",
  "n_array_extra_close": """["x"]]""",
  "n_array_extra_comma": """["",]""",
  "n_array_incomplete_invalid_value": """[x""",
  "n_array_incomplete": """["x"""",
  "n_array_inner_array_no_comma": """[3[4]]""",
  "n_array_invalid_utf8": """[]""",
  "n_array_items_separated_by_semicolon": """[1:2]""",
  "n_array_just_comma": """[,]""",
  "n_array_just_minus": """[-]""",
  "n_array_missing_value": """[   , ""]""",
  "n_array_newlines_unclosed": """["a",""",
  "n_array_newlines_unclosed": """4""",
  "n_array_newlines_unclosed": """,1,""",
  "n_array_number_and_comma": """[1,]""",
  "n_array_number_and_several_commas": """[1,,]""",
  "n_array_spaces_vertical_tab_formfeed": """["a"\f]""",
  "n_array_star_inside": """[*]""",
  "n_array_unclosed": """[""""",
  "n_array_unclosed_trailing_comma": """[1,""",
  "n_array_unclosed_with_new_lines": """[1,""",
  "n_array_unclosed_with_new_lines": """1""",
  "n_array_unclosed_with_new_lines": """,1""",
  "n_array_unclosed_with_object_inside": """[{}""",
  "n_incomplete_false": """[fals]""",
  "n_incomplete_null": """[nul]""",
  "n_incomplete_true": """[tru]""",
  "n_number_0.1.2": """[0.1.2]""",
  "n_number_-01": """[-01]""",
  "n_number_0.3e": """[0.3e]""",
  "n_number_0.3e+": """[0.3e+]""",
  "n_number_0_capital_E": """[0E]""",
  "n_number_0_capital_E+": """[0E+]""",
  "n_number_0.e1": """[0.e1]""",
  "n_number_0e": """[0e]""",
  "n_number_0e+": """[0e+]""",
  "n_number_1_000": """[1 000.0]""",
  "n_number_1.0e-": """[1.0e-]""",
  "n_number_1.0e": """[1.0e]""",
  "n_number_1.0e+": """[1.0e+]""",
  "n_number_-1.0.": """[-1.0.]""",
  "n_number_1eE2": """[1eE2]""",
  "n_number_.-1": """[.-1]""",
  "n_number_+1": """[+1]""",
  "n_number_.2e-3": """[.2e-3]""",
  "n_number_2.e-3": """[2.e-3]""",
  "n_number_2.e+3": """[2.e+3]""",
  "n_number_2.e3": """[2.e3]""",
  "n_number_-2.": """[-2.]""",
  "n_number_9.e+": """[9.e+]""",
  "n_number_expression": """[1+2]""",
  "n_number_hex_1_digit": """[0x1]""",
  "n_number_hex_2_digits": """[0x42]""",
  "n_number_infinity": """[Infinity]""",
  "n_number_+Inf": """[+Inf]""",
  "n_number_Inf": """[Inf]""",
  "n_number_invalid+-": """[0e+-1]""",
  "n_number_invalid-negative-real": """[-123.123foo]""",
  "n_number_invalid-utf-8-in-bigger-int": """[123]""",
  "n_number_invalid-utf-8-in-exponent": """[1e1]""",
  "n_number_invalid-utf-8-in-int": """[0]""",
  "n_number_++": """[++1234]""",
  "n_number_minus_infinity": """[-Infinity]""",
  "n_number_minus_sign_with_trailing_garbage": """[-foo]""",
  "n_number_minus_space_1": """[- 1]""",
  "n_number_-NaN": """[-NaN]""",
  "n_number_NaN": """[NaN]""",
  "n_number_neg_int_starting_with_zero": """[-012]""",
  "n_number_neg_real_without_int_part": """[-.123]""",
  "n_number_neg_with_garbage_at_end": """[-1x]""",
  "n_number_real_garbage_after_e": """[1ea]""",
  "n_number_real_with_invalid_utf8_after_e": """[1e]""",
  "n_number_real_without_fractional_part": """[1.]""",
  "n_number_starting_with_dot": """[.123]""",
  "n_number_then_00": """1\x00""",
  "n_number_U+FF11_fullwidth_digit_one": """[１]""",
  "n_number_with_alpha_char": """[1.8011670033376514H-308]""",
  "n_number_with_alpha": """[1.2a-3]""",
  "n_number_with_leading_zero": """[012]""",
  "n_object_bad_value": """["x", truth]""",
  "n_object_bracket_key": """{[: "x"}""",
  "n_object_comma_instead_of_colon": """{"x", null}""",
  "n_object_double_colon": """{"x"::"b"}""",
  "n_object_emoji": """{🇨🇭}""",
  "n_object_garbage_at_end": """{"a":"a" 123}""",
  "n_object_key_with_single_quotes": """{key: 'value'}""",
  "n_object_missing_colon": """{"a" b}""",
  "n_object_missing_key": """{:"b"}""",
  "n_object_missing_semicolon": """{"a" "b"}""",
  "n_object_missing_value": """{"a":""",
  "n_object_no-colon": """{"a"""",
  "n_object_non_string_key_but_huge_number_instead": """{9999E9999:1}""",
  "n_object_non_string_key": """{1:1}""",
  "n_object_pi_in_key_and_trailing_comma": """{"":"0",}""",
  "n_object_repeated_null_null": """{null:null,null:null}""",
  "n_object_several_trailing_commas": """{"id":0,,,,,}""",
  "n_object_single_quote": """{'a':0}""",
  "n_object_trailing_comma": """{"id":0,}""",
  "n_object_trailing_comment": """{"a":"b"}/**/""",
  "n_object_trailing_comment_open": """{"a":"b"}/**//""",
  "n_object_trailing_comment_slash_open_incomplete": """{"a":"b"}/""",
  "n_object_trailing_comment_slash_open": """{"a":"b"}//""",
  "n_object_two_commas_in_a_row": """{"a":"b",,"c":"d"}""",
  "n_object_unquoted_key": """{a: "b"}""",
  "n_object_unterminated-value": """{"a":"a""",
  "n_object_with_single_string": """{ "foo" : "bar", "a" }""",
  "n_object_with_trailing_garbage": """{"a":"b"}#""",
  "n_single_space": """ """,
  "n_string_1_surrogate_then_escape": """["\uD800\"]""",
  "n_string_1_surrogate_then_escape u1": """["\uD800\u1"]""",
  "n_string_1_surrogate_then_escape u1x": """["\uD800\u1x"]""",
  "n_string_1_surrogate_then_escape u": """["\uD800\u"]""",
  "n_string_accentuated_char_no_quotes": """[é]""",
  "n_string_backslash_00": """["\\x00"]""",
  "n_string_escaped_backslash_bad": """["\\\"]""",
  "n_string_escaped_ctrl_char_tab": """["\	"]""",
  "n_string_escaped_emoji": """["\🌀"]""",
  "n_string_escape_x": """["\x00"]""",
  "n_string_incomplete_escaped_character": """["\u00A"]""",
  "n_string_incomplete_escape": """["\"]""",
  "n_string_incomplete_surrogate_escape_invalid": """["\uD800\uD800\x"]""",
  "n_string_invalid_backslash_esc": """["\a"]""",
  "n_string_invalid_unicode_escape": """["\uqqqq"]""",
  "n_string_invalid_utf8_after_escape": """["\"]""",
  "n_string_invalid-utf-8-in-escape": """["\u"]""",
  "n_string_invalid_utf-8": """[""]""",
  "n_string_iso_latin_1": """[""]""",
  "n_string_leading_uescaped_thinspace": """[\u0020"asd"]""",
  "n_string_lone_utf8_continuation_byte": """[""]""",
  "n_string_no_quotes_with_bad_escape": """[\n]""",
  "n_string_overlong_sequence_2_bytes": """[""]""",
  "n_string_overlong_sequence_6_bytes": """[""]""",
  "n_string_overlong_sequence_6_bytes_null": """[""]""",
  "n_string_single_doublequote": """"""",
  "n_string_single_quote": """['single quote']""",
  "n_string_single_string_no_double_quotes": """abc""",
  "n_string_start_escape_unclosed": """["\""",
  "n_string_unescaped_ctrl_char": """["a\x00a"]""",
  "n_string_unescaped_newline": """["new
line"]""",
  "n_string_unescaped_tab": """["	"]""",
  "n_string_unicode_CapitalU": """"\UA66D"""",
  "n_string_UTF-16_incomplete_surrogate": """["\uD834\uDd"]""",
  "n_string_UTF8_surrogate_U+D800": """[""]""",
  "n_string_with_trailing_garbage": """""x""",
  "n_structure_array_trailing_garbage": """[1]x""",
  "n_structure_array_with_extra_array_close": """[1]]""",
  "n_structure_array_with_unclosed_string": """["asd]""",
  "n_structure_ascii-unicode-identifier": """aå""",
  "n_structure_capitalized_True": """[True]""",
  "n_structure_close_unopened_array": """1]""",
  "n_structure_comma_instead_of_closing_brace": """{"x": true,""",
  "n_structure_double_array": """[][]""",
  "n_structure_end_array": """]""",
  "n_structure_incomplete_UTF8_BOM": """{}""",
  "n_structure_<.>": """<.>""",
  "n_structure_lone-invalid-utf-8": """""",
  "n_structure_lone-open-bracket": """[""",
  "n_structure_null-byte-outside-string": """[\00]""",
  "n_structure_<null>": """[<null>]""",
  "n_structure_number_with_trailing_garbage": """2@""",
  "n_structure_object_followed_by_closing_object": """{}}""",
  "n_structure_object_unclosed_no_value": """{"":""",
  "n_structure_object_with_comment": """{"a":/*comment*/"b"}""",
  "n_structure_object_with_trailing_garbage": """{"a": true} "x"""",
  "n_structure_open_array_apostrophe": """['""",
  "n_structure_open_array_comma": """[,""",
  "n_structure_open_array_open_object": """[{""",
  "n_structure_open_array_open_string": """["a""",
  "n_structure_open_array_string": """["a"""",
  "n_structure_open_object_close_array": """{]""",
  "n_structure_open_object_comma": """{,""",
  "n_structure_open_object": """{""",
  "n_structure_open_object_open_array": """{[""",
  "n_structure_open_object_open_string": """{"a""",
  "n_structure_open_object_string_with_apostrophes": """{'a'""",
  "n_structure_open_open": """["\{["\{["\{["\{""",
  "n_structure_single_point": """""",
  "n_structure_single_star": """*""",
  "n_structure_trailing_#": """{"a":"b"}#{}""",
  "n_structure_U+2060_word_joined": """[⁠]""",
  "n_structure_uescaped_LF_before_string": """[\u000A""]""",
  "n_structure_unclosed_array": """[1""",
  "n_structure_unclosed_array_partial_null": """[ false, nul""",
  "n_structure_unclosed_array_unfinished_false": """[ true, fals""",
  "n_structure_unclosed_array_unfinished_true": """[ false, tru""",
  "n_structure_unclosed_object": """{"asd":"asd"""",
  "n_structure_unicode-identifier": """å""",
  "n_structure_UTF8_BOM_no_data": """﻿""",
  "n_structure_whitespace_formfeed": """[]""",
  "n_structure_whitespace_U+2060_word_joiner": """[⁠]""",
  "y_array_arraysWithSpaces": """[[]   ]""",
  "y_array_empty": """[]""",
  "y_array_empty-string": """[""]""",
  "y_array_ending_with_newline": """["a"]""",
  "y_array_false": """[false]""",
  "y_array_heterogeneous": """[null, 1, "1", {}]""",
  "y_array_null": """[null]""",
  "y_array_with_1_and_newline": """[1
]""",
  "y_array_with_leading_space": """ [1]""",
  "y_array_with_several_null": """[1,null,null,null,2]""",
  "y_array_with_trailing_space": """[2] """,
  "y_number_0e+1": """[0e+1]""",
  "y_number_0e1": """[0e1]""",
  "y_number_after_space": """[ 4]""",
  "y_number_double_close_to_zero": """[-0.000000000000000000000000000000000000000000000000000000000000000000000000000001]""",
  "y_number_double_huge_neg_exp": """[123.456e-789]""",
  "y_number_huge_exp": """[0.4e00669999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999969999999006]""",
  "y_number_int_with_exp": """[20e1]""",
  "y_number": """[123e65]""",
  "y_number_minus_zero": """[-0]""",
  "y_number_negative_int": """[-123]""",
  "y_number_negative_one": """[-1]""",
  "y_number_negative_zero": """[-0]""",
  "y_number_real_capital_e": """[1E22]""",
  "y_number_real_capital_e_neg_exp": """[1E-2]""",
  "y_number_real_capital_e_pos_exp": """[1E+2]""",
  "y_number_real_exponent": """[123e45]""",
  "y_number_real_fraction_exponent": """[123.456e78]""",
  "y_number_real_neg_exp": """[1e-2]""",
  "y_number_real_neg_overflow": """[-123123e100000]""",
  "y_number_real_pos_exponent": """[1e+2]""",
  "y_number_real_pos_overflow": """[123123e100000]""",
  "y_number_real_underflow": """[123e-10000000]""",
  "y_number_simple_int": """[123]""",
  "y_number_simple_real": """[123.456789]""",
  "y_number_too_big_neg_int": """[-123123123123123123123123123123]""",
  "y_number_too_big_pos_int": """[100000000000000000000]""",
  "y_number_very_big_negative_int": """[-237462374673276894279832749832423479823246327846]""",
  "y_object_basic": """{"asd":"sdf"}""",
  "y_object_duplicated_key_and_value": """{"a":"b","a":"b"}""",
  "y_object_duplicated_key": """{"a":"b","a":"c"}""",
  "y_object_empty": """{}""",
  "y_object_empty_key": """{"":0}""",
  "y_object_escaped_null_in_key": """{"foo\u0000bar": 42}""",
  "y_object_extreme_numbers": """{ "min": -1.0e+28, "max": 1.0e+28 }""",
  "y_object": """{"asd":"sdf", "dfg":"fgh"}""",
  "y_object_long_strings": """{"x":[{"id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"}], "id": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"}""",
  "y_object_simple": """{"a":[]}""",
  "y_object_string_unicode": """{"title":"\u041f\u043e\u043b\u0442\u043e\u0440\u0430 \u0417\u0435\u043c\u043b\u0435\u043a\u043e\u043f\u0430" }""",
  "y_object_with_newlines": """{
"a": "b"
}""",
  "y_string_1_2_3_bytes_UTF-8_sequences": """["\u0060\u012a\u12AB"]""",
  "y_string_accepted_surrogate_pair": """["\uD801\udc37"]""",
  "y_string_accepted_surrogate_pairs": """["\ud83d\ude39\ud83d\udc8d"]""",
  "y_string_allowed_escapes": """["\"\\\/\b\f\n\r\t"]""",
  "y_string_backslash_and_u_escaped_zero": """["\\u0000"]""",
  "y_string_backslash_doublequotes": """["\""]""",
  "y_string_comments": """["a/*b*/c/*d//e"]""",
  "y_string_double_escape_a": """["\\a"]""",
  "y_string_double_escape_n": """["\\n"]""",
  "y_string_escaped_control_character": """["\u0012"]""",
  "y_string_escaped_noncharacter": """["\uFFFF"]""",
  "y_string_in_array": """["asd"]""",
  "y_string_in_array_with_leading_space": """[ "asd"]""",
  "y_string_last_surrogates_1_and_2": """["\uDBFF\uDFFF"]""",
  "y_string_newline_uescaped": """["new\u00A0line"]""",
  "y_string_nonCharacterInUTF-8_U+10FFFF": """["􏿿"]""",
  "y_string_nonCharacterInUTF-8_U+1FFFF": """["𛿿"]""",
  "y_string_nonCharacterInUTF-8_U+FFFF": """["￿"]""",
  "y_string_null_escape": """["\u0000"]""",
  "y_string_one-byte-utf-8": """["\u002c"]""",
  "y_string_pi": """["π"]""",
  "y_string_simple_ascii": """["asd "]""",
  "y_string_space": """" """",
  "y_string_three-byte-utf-8": """["\u0821"]""",
  "y_string_two-byte-utf-8": """["\u0123"]""",
  "y_string_u+2028_line_sep": """[" "]""",
  "y_string_u+2029_par_sep": """[" "]""",
  "y_string_uEscape": """["\u0061\u30af\u30EA\u30b9"]""",
  "y_string_unescaped_char_delete": """[""]""",
  "y_string_unicode_2": """["⍂㈴⍂"]""",
  "y_string_unicodeEscapedBackslash": """["\u005C"]""",
  "y_string_unicode_escaped_double_quote": """["\u0022"]""",
  "y_string_unicode": """["\uA66D"]""",
  "y_string_unicode_U+200B_ZERO_WIDTH_SPACE": """["\u200B"]""",
  "y_string_unicode_U+2064_invisible_plus": """["\u2064"]""",
  "y_string_UTF-16_Surrogates_U+1D11E_MUSICAL_SYMBOL_G_CLEF": """["\uD834\uDd1e"]""",
  "y_string_utf8": """["€𝄞"]""",
  "y_string_with_del_character": """["aa"]""",
  "y_structure_lonely_false": """false""",
  "y_structure_lonely_int": """42""",
  "y_structure_lonely_negative_real": """-0.1""",
  "y_structure_lonely_null": """null""",
  "y_structure_lonely_string": """"asd"""",
  "y_structure_lonely_true": """true""",
  "y_structure_string_empty": """""""",
  "y_structure_trailing_newline": """["a"]""",
  "y_structure_true_in_array": """[true]""",
  "y_structure_whitespace_array": """ [] """,
}


suite "JSON":

  test "Multiple parsing tests":
    var test_is_failed = false
    for test_item in parsing_testdata:

      let name = test_item[0]
      let data = test_item[1]
      var
        parsed_successfully = false
        parsed: JsonNode
        exception_while_parsing = ""
        exception_while_rendering = ""

      try:
        parsed = parseJson(data)
        parsed_successfully = true
      except:
        exception_while_parsing = getCurrentExceptionMsg()


      proc echo_summary(msg: string) =
        var rendered = ""
        var render_successfully = false
        if parsed_successfully:
          try:
            rendered = $parsed
            render_successfully = true
          except:
            rendered = "[Fail to render:<$#>]" % getCurrentExceptionMsg()
        else:
          rendered = "<$#>" % exception_while_parsing

        echo name, repeat(' ', 60 - name.len), "[$#]" % msg, " ", rendered

      case name[0]
      of 'y':
        # Tests starting with y_ must parse
        if not parsed_successfully:
          echo_summary "Failed to parse"
          test_is_failed = true
      of 'n':
        # Tests starting with n_ should not parse
        if parsed_successfully:
          echo_summary "Failed to raise exception"
      of 'i':
        if parsed_successfully:
          echo_summary "OK"
        else:
          echo_summary "Not parsed"

      else: discard

    # FIXME: temporarily disabled until "y_" tests will succeed
    # if test_is_failed: fail()
