## TFSA-2022-008: OOM in `ThreadPoolHandle`

### CVE Number
CVE-2022-21732

### Impact
The [implementation of `ThreadPoolHandle`](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/kernels/data/experimental/threadpool_dataset_op.cc#L79-L135) can be used to trigger a denial of service attack by allocating too much memory:

```python
import tensorflow as tf
y = tf.raw_ops.ThreadPoolHandle(num_threads=0x60000000,display_name='tf')
```

This is because the `num_threads` argument is only checked to not be negative, but there is no upper bound on its value.

### Patches
We have patched the issue in GitHub commit [e3749a6d5d1e8d11806d4a2e9cc3123d1a90b75e](https://github.com/tensorflow/tensorflow/commit/e3749a6d5d1e8d11806d4a2e9cc3123d1a90b75e).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Yu Tian of Qihoo 360 AIVul Team.
