---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, lignes, 
              empêcher les coupures de ligne, bloc de texte, 
              empêcher les sauts de ligne, espaces insécables
---

# À quoi sert la commande `\mbox` ?

Cette commande permet à LaTeX de considérer un ensemble de caractères, 
commandes, etc., comme une seule entité, et ainsi de ne pas la couper. 
C'est intéressant, par exemple, pour empêcher un saut de ligne indésirable, 
comme dans un numéro de téléphone. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\section{Avant}
Pour votre information, mon numéro de téléphone est désormais le
01 02 03 04 05. Il remplace mon ancien numéro de téléphone
qui ne doit maintenant plus être utilisé.

\section{Après}
Pour votre information, mon numéro de téléphone est désormais le
\mbox{01 02 03 04 05}. Il remplace mon ancien numéro de téléphone
qui ne doit maintenant plus être utilisé.
\end{document}
```

Une autre idée est d'utiliser l'espace insécable `~`, 
ce qui donne un résultat à l'espacement légèrement différent. 
Dans l'exemple suivant, l'espacement est moins important entre les composantes
du numéro de téléphone :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\section{Avant}
Pour votre information, mon numéro de téléphone est désormais le
01 02 03 04 05. Il remplace mon ancien numéro de téléphone
qui ne doit maintenant plus être utilisé.

\section{Après}
Pour votre information, mon numéro de téléphone est désormais le
01~02~03~04~05. Il remplace mon ancien numéro de téléphone qui ne
doit maintenant plus être utilisé.

\section{Après, avec une correction}
\tolerance=3000
Pour votre information, mon numéro de téléphone est désormais le
01~02~03~04~05. Il remplace mon ancien numéro de téléphone qui ne
doit maintenant plus être utilisé.
\end{document}
```

Notez que ces méthodes peuvent entraîner l'apparition de lignes empiétant 
dans les marges (comme c'est le cas dans les exemples de cette page 
pour la ligne donnant le numéro de téléphone). Cela pourra demander 
d'autres réglages décrits à la question 
"[](/3_composition/texte/paragraphes/latex_fait_des_lignes_trop_longues)", 
à l'image de celui avec la modification du paramètre `\tolerance` fait
ci-dessus.