/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.function.Predicate;

public abstract class FilterStack<T>
implements Predicate<T> {
    private final Predicate<T> other;
    private final boolean subFilterLast;

    public FilterStack(Predicate<T> other) {
        this(other, false);
    }

    public FilterStack(Predicate<T> other, boolean callOldFilterFirst) {
        this.other = other;
        this.subFilterLast = callOldFilterFirst;
    }

    @Override
    public final boolean test(T item) {
        if (this.subFilterLast) {
            return this.acceptAdditionaOther(item);
        }
        return this.acceptOtherAdditional(item);
    }

    private boolean acceptAdditionaOther(T item) {
        if (!this.acceptAdditional(item)) {
            return false;
        }
        return this.other == null || this.other.test(item);
    }

    private boolean acceptOtherAdditional(T item) {
        if (this.other != null && !this.other.test(item)) {
            return false;
        }
        return this.acceptAdditional(item);
    }

    public abstract boolean acceptAdditional(T var1);
}

