#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Vanishing of Ethan Carter
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250520.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='the-vanishing-of-ethan-carter'
GAME_NAME='The Vanishing of Ethan Carter'

ARCHIVE_BASE_0_NAME='setup_the_vanishing_of_ethan_carter_1.04_(18494).exe'
ARCHIVE_BASE_0_MD5='ac039c2c1dcfc093840b0a5ce15008c0'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_vanishing_of_ethan_carter_1.04_(18494)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='77dbaf659c02d6fbb77917be36bf463d'
ARCHIVE_BASE_0_PART2_NAME='setup_the_vanishing_of_ethan_carter_1.04_(18494)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='35e0cc8447e782b57525aed48837bd1a'
ARCHIVE_BASE_0_SIZE='10000000'
ARCHIVE_BASE_0_VERSION='1.04-gog18494'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_vanishing_of_ethan_carter'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN64_FILES='
binaries/win64'
CONTENT_GAME_BIN32_FILES='
binaries/win32'
CONTENT_GAME_DATA_FILES='
astronautsgame
engine
binaries/game
binaries/build.properties'

WINE_DIRECT3D_RENDERER='dxvk'

WINE_PERSISTENT_DIRECTORIES="
users/${USER}/Documents/My Games/The Vanishing of Ethan Carter/AstronautsGame"
## Without a virtual desktop, the game fails to register keyboard inputs. (WINE 10.0)
WINE_VIRTUAL_DESKTOP='auto'
## Cursor is prevented from leaving the game window, avoiding problems with mouse look. (WINE 10.0)
WINE_WINETRICKS_VERBS='grabfullscreen=y'

APP_MAIN_EXE_BIN64="binaries/win64/astronautsgame-win64-shipping.exe"
APP_MAIN_EXE_BIN32="binaries/win32/astronautsgame-win32-shipping.exe"
APP_MAIN_ICON="binaries/win32/astronautsgame-win32-shipping.exe"

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'
PKG_BIN64_DEPENDENCIES_GSTREAMER_PLUGINS="$PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS"
PKG_BIN32_DEPENDENCIES_GSTREAMER_PLUGINS="$PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
