#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Aven Colony
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250123.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='aven-colony'
GAME_NAME='Aven Colony'

ARCHIVE_BASE_0_NAME='setup_aven_colony_1.0.1_(64bit)_(25959).exe'
ARCHIVE_BASE_0_MD5='959a44c1bb18e8c3342b10d396ae8a53'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_aven_colony_1.0.1_(64bit)_(25959)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='4f24fb8c38d99916a623c46aafc4eeeb'
ARCHIVE_BASE_0_PART2_NAME='setup_aven_colony_1.0.1_(64bit)_(25959)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='db96cef3e5ce8e2f160b703d6d81777b'
ARCHIVE_BASE_0_PART3_NAME='setup_aven_colony_1.0.1_(64bit)_(25959)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='0ab31c5b95332e6ab160f55c5fbe0db3'
ARCHIVE_BASE_0_PART4_NAME='setup_aven_colony_1.0.1_(64bit)_(25959)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='2537b2db5c65a3b1ded96e938a864c52'
ARCHIVE_BASE_0_SIZE='15000000'
ARCHIVE_BASE_0_VERSION='1.0.25697-gog25959'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/aven_colony'

UNREALENGINE4_NAME='avencolony'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_DATA_TILESETS_1_FILES="
${UNREALENGINE4_NAME}/content/granitesdk/importedtilesets/city-*"
CONTENT_GAME_DATA_TILESETS_2_FILES="
${UNREALENGINE4_NAME}/content/granitesdk/importedtilesets"

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"

PACKAGES_LIST='
PKG_BIN
PKG_DATA_TILESETS_1
PKG_DATA_TILESETS_2
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_TILESETS_1
PKG_DATA_TILESETS_2'

PKG_DATA_TILESETS_ID="${PKG_DATA_ID}-tilesets"
PKG_DATA_TILESETS_1_ID="${PKG_DATA_TILESETS_ID}-1"
PKG_DATA_TILESETS_2_ID="${PKG_DATA_TILESETS_ID}-2"
PKG_DATA_TILESETS_DESCRIPTION="$PKG_DATA_DESCRIPTION - tilesets"
PKG_DATA_TILESETS_1_DESCRIPTION="$PKG_TILESETS_DESCRIPTION - 1"
PKG_DATA_TILESETS_2_DESCRIPTION="$PKG_TILESETS_DESCRIPTION - 2"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Installing Visual C++ 2019 libraries can cause problems with this game
wine_winetricks_verbs() { true ; }

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
