local layout = require("which-key.layout")

describe("dim", function()
  local tests = {
    { 100, { 200 }, 100 },
    { 0.2, { 100 }, 20 },
    { -0.2, { 100 }, 80 },
    { -20, { 100 }, 80 },
    { 1, { 100 }, 1 },
    { 100, { 200, { min = 50 } }, 100 },
    { 100, { 200, { max = 150 } }, 100 },
    { 100, { 200, { max = 150, min = 50 } }, 100 },
    { 100, { 200, { max = 150, min = 150 } }, 150 },
    { 0.2, { 100, { max = 150, min = 20 } }, 20 },
    { 0.2, { 100, { max = 50, min = 20 } }, 20 },
    { math.huge, { 200 }, 200 },
    { -0.5, { 200 }, 100 },
    { 0.5, { 200 }, 100 },
    { 0.5, { 200, { min = 150 } }, 150 },
    { -0.5, { 200, { max = 50 } }, 50 },
    { 300, { 200, { max = 250 } }, 200 },
    { 300, { 200, { min = 250 } }, 200 },
    { -100, { 100, { max = 90, min = 20 } }, 20 },
    { -200, { 100, { max = -50, min = -50 } }, 0 },
    { 0.2, { 100, { min = 0.5 } }, 50 },
    { -200, { 100 }, 0 },
    { -1, { 100 }, 99 },
    { -0.1, { 100 }, 90 },
    { 0.1, { 100 }, 10 },
    { 14, { 212, 0.9 }, 191 },
  }

  for _, test in ipairs(tests) do
    it("size=" .. test[1] .. ", parent=" .. test[2][1] .. ", result = " .. test[3], function()
      assert.are.equal(test[3], layout.dim(test[1], unpack(test[2])))
    end)
  end
end)
