/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: icx_unc_cha (IcelakeX Uncore CHA)
 * Based on Intel JSON event table version   : 1.21
 * Based on Intel JSON event table published : 06/06/2023
 */
static const intel_x86_umask_t icx_unc_cha_2lm_nm_setconflicts[]={
  { .uname   = "LLC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_2lm_nm_setconflicts2[]={
  { .uname   = "MEMWR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEMWRNI",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag0_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag0_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag0_bl_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag0_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag1_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag1_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag1_bl_crd_acquired0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ag1_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_bypass_cha_imc[]={
  { .uname   = "INTERMEDIATE",
    .udesc   = "Intermediate bypass Taken (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_TAKEN",
    .udesc   = "Not Taken (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TAKEN",
    .udesc   = "Taken (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_core_snp[]={
  { .uname   = "ANY_GTONE",
    .udesc   = "Any Cycle with Multiple Snoops (experimental)",
    .ucode   = 0xf200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY_ONE",
    .udesc   = "Any Single Snoop (experimental)",
    .ucode   = 0xf100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CORE_GTONE",
    .udesc   = "Multiple Core Requests (experimental)",
    .ucode   = 0x4200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CORE_ONE",
    .udesc   = "Single Core Requests (experimental)",
    .ucode   = 0x4100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EVICT_GTONE",
    .udesc   = "Multiple Eviction (experimental)",
    .ucode   = 0x8200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EVICT_ONE",
    .udesc   = "Single Eviction (experimental)",
    .ucode   = 0x8100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EXT_GTONE",
    .udesc   = "Multiple External Snoops (experimental)",
    .ucode   = 0x2200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EXT_ONE",
    .udesc   = "Single External Snoops (experimental)",
    .ucode   = 0x2100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_GTONE",
    .udesc   = "Multiple Snoop Targets from Remote (experimental)",
    .ucode   = 0x1200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_ONE",
    .udesc   = "Single Snoop Target from Remote (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_direct_go[]={
  { .uname   = "HA_SUPPRESS_DRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA_SUPPRESS_NO_D2C",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA_TOR_DEALLOC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_direct_go_opc[]={
  { .uname   = "EXTCMP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FAST_GO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FAST_GO_PULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GO_PULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IDLE_DUE_SUPPRESS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_dir_lookup[]={
  { .uname   = "NO_SNP",
    .udesc   = "Snoop Not Needed (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNP",
    .udesc   = "Snoop Needed (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_dir_update[]={
  { .uname   = "HA",
    .udesc   = "TBD",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOR",
    .udesc   = "TBD",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_distress_asserted[]={
  { .uname   = "DPT_LOCAL",
    .udesc   = "DPT Local (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_NONLOCAL",
    .udesc   = "DPT Remote (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_IV",
    .udesc   = "DPT Stalled - IV (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_NOCRD",
    .udesc   = "DPT Stalled -  No Credit (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HORZ",
    .udesc   = "Horizontal (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_LOCAL",
    .udesc   = "PMM Local (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_NONLOCAL",
    .udesc   = "PMM Remote (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VERT",
    .udesc   = "Vertical (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_egress_ordering[]={
  { .uname   = "IV_SNOOPGO_DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_SNOOPGO_UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_hitme_hit[]={
  { .uname   = "EX_RDS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SHARED_OWNREQ",
    .udesc   = "Remote socket ownership read requests that hit in S state. (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBMTOE",
    .udesc   = "Remote socket WBMtoE requests (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBMTOI_OR_S",
    .udesc   = "Remote socket writeback to I or S requests (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_hitme_lookup[]={
  { .uname   = "READ",
    .udesc   = "Remote socket read requests (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITE",
    .udesc   = "Remote socket write (i.e. writeback) requests (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_hitme_miss[]={
  { .uname   = "NOTSHARED_RDINVOWN",
    .udesc   = "Remote socket RdInvOwn requests that are not to shared line (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_OR_INV",
    .udesc   = "Remote socket read or invalidate requests (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SHARED_RDINVOWN",
    .udesc   = "Remote socket RdInvOwn requests to shared line (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_hitme_update[]={
  { .uname   = "DEALLOCATE",
    .udesc   = "Deallocate HitME$ on Reads without RspFwdI* (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DEALLOCATE_RSPFWDI_LOC",
    .udesc   = "op is RspIFwd or RspIFwdWb for a local request (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RDINVOWN",
    .udesc   = "Update HitMe Cache on RdInvOwn even if not RspFwdI* (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWDI_REM",
    .udesc   = "op is RspIFwd or RspIFwdWb for a remote request (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SHARED",
    .udesc   = "Update HitMe Cache to SHARed (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_horz_ring_akc_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_horz_ring_bl_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_horz_ring_iv_in_use[]={
  { .uname   = "LEFT",
    .udesc   = "Left (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT",
    .udesc   = "Right (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_imc_reads_count[]={
  { .uname   = "NORMAL",
    .udesc   = "TBD",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRIORITY",
    .udesc   = "ISOCH (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_imc_writes_count[]={
  { .uname   = "FULL",
    .udesc   = "Full Line Non-ISOCH",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FULL_PRIORITY",
    .udesc   = "ISOCH Full Line (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARTIAL",
    .udesc   = "Partial Non-ISOCH (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARTIAL_PRIORITY",
    .udesc   = "ISOCH Partial (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_llc_lookup[]={
  { .uname   = "ALL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1fff0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "ALL_REMOTE",
    .udesc   = "All transactions from Remote Agents (experimental)",
    .ucode   = 0x1e200000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY_F",
    .udesc   = "All Request Filter (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1bd00000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x19d00000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_READ",
    .udesc   = "Code Reads (experimental)",
    .ucode   = 0x1bd00000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_READ_F",
    .udesc   = "CRd Request Filter (experimental)",
    .ucode   = 0x1000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_READ_LOCAL",
    .udesc   = "CRd Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19d00000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_READ_MISS",
    .udesc   = "Code Read Misses (experimental)",
    .ucode   = 0x1bd000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_READ_REMOTE",
    .udesc   = "CRd Requests that come from a Remote socket. (experimental)",
    .ucode   = 0x1a100000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_REMOTE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1a100000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "COREPREF_OR_DMND_LOCAL_F",
    .udesc   = "Local request Filter (experimental)",
    .ucode   = 0x4000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_RD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1bc10000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ",
    .udesc   = "TBD",
    .ucode   = 0x1bc10000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_ALL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1fc10000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_F",
    .udesc   = "Data Read Request Filter (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x19c10000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_MISS",
    .udesc   = "Data Read Misses (experimental)",
    .ucode   = 0x1bc100000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_REMOTE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1a010000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DMND_READ_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8410000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "E",
    .udesc   = "E State (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "F",
    .udesc   = "F State (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLUSH_INV",
    .udesc   = "Flush or Invalidate Requests (experimental)",
    .ucode   = 0x1a440000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLUSH_INV_LOCAL",
    .udesc   = "Flush or Invalidate Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x18440000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLUSH_INV_REMOTE",
    .udesc   = "Flush or Invalidate requests that come from a Remote socket. (experimental)",
    .ucode   = 0x1a040000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLUSH_OR_INV_F",
    .udesc   = "Flush or Invalidate Filter (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "I",
    .udesc   = "I State (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCPREF_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x189d0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCPREF_LOCAL_F",
    .udesc   = "Local LLC prefetch requests (from LLC) Filter (experimental)",
    .ucode   = 0x8000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_PF_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x189d0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCALLY_HOMED_ADDRESS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xbdf0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_F",
    .udesc   = "Transactions homed locally Filter (experimental)",
    .ucode   = 0x80000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_HOM",
    .udesc   = "Transactions homed locally (experimental)",
    .ucode   = 0xbdf0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M",
    .udesc   = "M State (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MISS_ALL",
    .udesc   = "All Misses (experimental)",
    .ucode   = 0x1fe000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "OTHER_REQ_F",
    .udesc   = "Write Request Filter (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PREF_OR_DMND_REMOTE_F",
    .udesc   = "Remote non-snoop request Filter (experimental)",
    .ucode   = 0x20000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ",
    .udesc   = "Reads (experimental)",
    .ucode   = 0x1bd90000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_LOCAL_LOC_HOM",
    .udesc   = "Locally Requested Reads that are Locally HOMed (experimental)",
    .ucode   = 0x9d90000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_LOCAL_REM_HOM",
    .udesc   = "Locally Requested Reads that are Remotely HOMed (experimental)",
    .ucode   = 0x11d90000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_MISS",
    .udesc   = "Read Misses (experimental)",
    .ucode   = 0x1bd900000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_MISS_LOC_HOM",
    .udesc   = "Locally HOMed Read Misses (experimental)",
    .ucode   = 0xbd900000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_MISS_REM_HOM",
    .udesc   = "Remotely HOMed Read Misses (experimental)",
    .ucode   = 0x13d900000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_OR_SNOOP_REMOTE_MISS_REM_HOM",
    .udesc   = "Remotely requested Read or Snoop Misses that are Remotely HOMed (experimental)",
    .ucode   = 0x161900000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_REMOTE_LOC_HOM",
    .udesc   = "Remotely Requested Reads that are Locally HOMed (experimental)",
    .ucode   = 0xa190000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_SF_HIT",
    .udesc   = "Reads that Hit the Snoop Filter (experimental)",
    .ucode   = 0x1bd900000e00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTELY_HOMED_ADDRESS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x15df0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_F",
    .udesc   = "Transactions homed remotely Filter (experimental)",
    .ucode   = 0x100000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_SNOOP_F",
    .udesc   = "Remote snoop request Filter (experimental)",
    .ucode   = 0x40000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_SNP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1c190000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REM_HOM",
    .udesc   = "Transactions homed remotely (experimental)",
    .ucode   = 0x15df0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO",
    .udesc   = "RFO Requests (experimental)",
    .ucode   = 0x1bc80000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_F",
    .udesc   = "RFO Request Filter (experimental)",
    .ucode   = 0x800000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_LOCAL",
    .udesc   = "RFO Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19c80000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_MISS",
    .udesc   = "RFO Misses (experimental)",
    .ucode   = 0x1bc800000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_PREF_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8880000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_REMOTE",
    .udesc   = "RFO Requests that come from a Remote socket. (experimental)",
    .ucode   = 0x1a080000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S",
    .udesc   = "S State (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_E",
    .udesc   = "SnoopFilter - E State (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_H",
    .udesc   = "SnoopFilter - H State (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_S",
    .udesc   = "SnoopFilter - S State (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES_AND_OTHER",
    .udesc   = "Filters Requests for those that write info into the cache (experimental)",
    .ucode   = 0x1a420000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITE_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8420000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITE_REMOTE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x17c20000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_llc_victims[]={
  { .uname   = "ALL",
    .udesc   = "All Lines Victimized",
    .ucode   = 0x0f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "E_STATE",
    .udesc   = "Lines in E state (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_ALL",
    .udesc   = "Local - All Lines (experimental)",
    .ucode   = 0x2000000f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_E",
    .udesc   = "Local - Lines in E State (experimental)",
    .ucode   = 0x2000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_M",
    .udesc   = "Local - Lines in M State (experimental)",
    .ucode   = 0x2000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_ONLY",
    .udesc   = "Local Only (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_S",
    .udesc   = "Local - Lines in S State (experimental)",
    .ucode   = 0x2000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M_STATE",
    .udesc   = "Lines in M state (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_ALL",
    .udesc   = "Remote - All Lines (experimental)",
    .ucode   = 0x8000000f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_E",
    .udesc   = "Remote - Lines in E State (experimental)",
    .ucode   = 0x8000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_M",
    .udesc   = "Remote - Lines in M State (experimental)",
    .ucode   = 0x8000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_ONLY",
    .udesc   = "Remote Only (experimental)",
    .ucode   = 0x8000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_S",
    .udesc   = "Remote - Lines in S State (experimental)",
    .ucode   = 0x8000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S_STATE",
    .udesc   = "Lines in S State (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_misc[]={
  { .uname   = "CV0_PREF_MISS",
    .udesc   = "CV0 Prefetch Miss (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CV0_PREF_VIC",
    .udesc   = "CV0 Prefetch Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_HIT_S",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPI_WAS_FSE",
    .udesc   = "Silent Snoop Eviction (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WC_ALIASING",
    .udesc   = "Write Combining Aliasing (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_misc_external[]={
  { .uname   = "MBE_INST0",
    .udesc   = "Number of cycles MBE is high for MS2IDI0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MBE_INST1",
    .udesc   = "Number of cycles MBE is high for MS2IDI1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_osb[]={
  { .uname   = "LOCAL_INVITOE",
    .udesc   = "Local InvItoE (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_READ",
    .udesc   = "Local Rd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "OFF_PWRHEURISTIC",
    .udesc   = "Off (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_READ",
    .udesc   = "Remote Rd (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_READINVITOE",
    .udesc   = "Remote Rd InvItoE (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_HITS_SNP_BCAST",
    .udesc   = "RFO HitS Snoop Broadcast (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_pmm_memmode_nm_invitox[]={
  { .uname   = "LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SETCONFLICT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_pmm_memmode_nm_setconflicts[]={
  { .uname   = "LLC",
    .udesc   = "Counts the number of times CHA saw NM Set conflict in SF/LLC (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF",
    .udesc   = "Counts the number of times CHA saw NM Set conflict in SF/LLC (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOR",
    .udesc   = "Counts the number of times CHA saw NM Set conflict in TOR (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_pmm_memmode_nm_setconflicts2[]={
  { .uname   = "IODC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEMWR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEMWRNI",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_pmm_qos[]={
  { .uname   = "DDR4_FAST_INSERT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REJ_IRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOWTORQ_SKIP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOW_INSERT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "THROTTLE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "THROTTLE_IRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "THROTTLE_PRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_pmm_qos_occupancy[]={
  { .uname   = "DDR_FAST_FIFO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DDR_SLOW_FIFO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_requests[]={
  { .uname   = "INVITOE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x3000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "INVITOE_LOCAL",
    .udesc   = "TBD",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "INVITOE_REMOTE",
    .udesc   = "TBD",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READS",
    .udesc   = "TBD",
    .ucode   = 0x0300ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READS_LOCAL",
    .udesc   = "TBD",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READS_REMOTE",
    .udesc   = "TBD",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES",
    .udesc   = "TBD",
    .ucode   = 0x0c00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES_LOCAL",
    .udesc   = "TBD",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES_REMOTE",
    .udesc   = "TBD",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ring_bounces_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ring_sink_starved_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "Acknowledgements to Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_ring_sink_starved_vert[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "Acknowledgements to core (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "Data Responses to core (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "Snoops of processor's cache. (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_inserts[]={
  { .uname   = "IPQ",
    .udesc   = "IPQ (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ",
    .udesc   = "IRQ (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_REJ",
    .udesc   = "IRQ Rejected (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ",
    .udesc   = "PRQ (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ_REJ",
    .udesc   = "PRQ (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RRQ",
    .udesc   = "RRQ (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBQ",
    .udesc   = "WBQ (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_irq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_irq1_reject[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "ANY0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "HA (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "LLC or SF Way (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "LLC Victim (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PA_MATCH",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "SF Victim (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_ismq0_retry[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_ismq1_retry[]={
  { .uname   = "ANY0",
    .udesc   = "ANY0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "HA (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_occupancy[]={
  { .uname   = "IPQ",
    .udesc   = "IPQ (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ",
    .udesc   = "IRQ (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RRQ",
    .udesc   = "RRQ (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBQ",
    .udesc   = "WBQ (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_other1_retry[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "ANY0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "HA (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "LLC OR SF Way (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "LLC Victim (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PA_MATCH",
    .udesc   = "PhyAddr Match (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "SF Victim (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_prq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_req_q1_retry[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "ANY0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "HA (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "LLC OR SF Way (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "LLC Victim (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PA_MATCH",
    .udesc   = "PhyAddr Match (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "SF Victim (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_rrq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_wbq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxc_wbq1_reject[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "ANY0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "HA (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "LLC OR SF Way (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "LLC Victim (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PA_MATCH",
    .udesc   = "PhyAddr Match (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "SF Victim (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxr_crd_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IFV",
    .udesc   = "IFV - Credited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxr_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_rxr_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_sf_eviction[]={
  { .uname   = "E_STATE",
    .udesc   = "TBD",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M_STATE",
    .udesc   = "TBD",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S_STATE",
    .udesc   = "TBD",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_snoops_sent[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BCST_LOCAL",
    .udesc   = "Broadcast snoops for Local Requests (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BCST_REMOTE",
    .udesc   = "Broadcast snoops for Remote Requests (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRECT_LOCAL",
    .udesc   = "Directed snoops for Local Requests (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRECT_REMOTE",
    .udesc   = "Directed snoops for Remote Requests (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL",
    .udesc   = "Snoops sent for Local Requests (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE",
    .udesc   = "Snoops sent for Remote Requests (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_snoop_resp[]={
  { .uname   = "RSPCNFLCT",
    .udesc   = "RSPCNFLCT* (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWD",
    .udesc   = "RspFwd (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWDWB",
    .udesc   = "Rsp*Fwd*WB (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPI",
    .udesc   = "RspI (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWD",
    .udesc   = "RspIFwd (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPS",
    .udesc   = "RspS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPSFWD",
    .udesc   = "RspSFwd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPWB",
    .udesc   = "Rsp*WB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_snoop_resp_local[]={
  { .uname   = "RSPCNFLCT",
    .udesc   = "RspCnflct (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWD",
    .udesc   = "RspFwd (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWDWB",
    .udesc   = "Rsp*FWD*WB (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPI",
    .udesc   = "RspI (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWD",
    .udesc   = "RspIFwd (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPS",
    .udesc   = "RspS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPSFWD",
    .udesc   = "RspSFwd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPWB",
    .udesc   = "Rsp*WB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_snoop_rsp_misc[]={
  { .uname   = "MTOI_RSPDATAM",
    .udesc   = "MtoI RspIDataM (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MTOI_RSPIFWDM",
    .udesc   = "MtoI RspIFwdM (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PULLDATAPTL_HITLLC",
    .udesc   = "Pull Data Partial - Hit LLC (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PULLDATAPTL_HITSF",
    .udesc   = "Pull Data Partial - Hit SF (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWDMPTL_HITLLC",
    .udesc   = "RspIFwdPtl Hit LLC (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWDMPTL_HITSF",
    .udesc   = "RspIFwdPtl Hit SF (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_stall0_no_txr_horz_crd_ad_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_stall0_no_txr_horz_crd_bl_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_stall0_no_txr_horz_crd_bl_ag1[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_stall1_no_txr_horz_crd_ad_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_stall1_no_txr_horz_crd_bl_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_tor_inserts[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0xc001ff0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "DDR",
    .udesc   = "DDR4 Access (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DDR4",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EVICT",
    .udesc   = "SF/LLC Evictions (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HIT",
    .udesc   = "Just Hits (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA",
    .udesc   = "All requests from iA Cores",
    .ucode   = 0xc001ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CLFLUSH",
    .udesc   = "CLFlushes issued by iA Cores",
    .ucode   = 0xc8c7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CLFLUSHOPT",
    .udesc   = "CLFlushOpts issued by iA Cores (experimental)",
    .ucode   = 0xc8d7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CRD",
    .udesc   = "CRDs issued by iA Cores",
    .ucode   = 0xc80fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CRD_PREF",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc88fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD",
    .udesc   = "DRds issued by iA Cores (experimental)",
    .ucode   = 0xc817ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRDPTE",
    .udesc   = "DRd PTEs issued by iA Cores (experimental)",
    .ucode   = 0xc837ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_OPT",
    .udesc   = "DRd_Opts issued by iA Cores (experimental)",
    .ucode   = 0xc827ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_OPT_PREF",
    .udesc   = "DRd_Opt_Prefs issued by iA Cores (experimental)",
    .ucode   = 0xc8a7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_PREF",
    .udesc   = "DRd_Prefs issued by iA Cores",
    .ucode   = 0xc897ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT",
    .udesc   = "All requests from iA Cores that Hit the LLC",
    .ucode   = 0xc001fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CRD",
    .udesc   = "CRds issued by iA Cores that Hit the LLC",
    .ucode   = 0xc80ffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CRD_PREF",
    .udesc   = "CRd_Prefs issued by iA Cores that hit the LLC",
    .ucode   = 0xc88ffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD",
    .udesc   = "DRds issued by iA Cores that Hit the LLC",
    .ucode   = 0xc817fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRDPTE",
    .udesc   = "DRd PTEs issued by iA Cores that Hit the LLC (experimental)",
    .ucode   = 0xc837fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_OPT",
    .udesc   = "DRd_Opts issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xc827fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_OPT_PREF",
    .udesc   = "DRd_Opt_Prefs issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xc8a7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_PREF",
    .udesc   = "DRd_Prefs issued by iA Cores that Hit the LLC",
    .ucode   = 0xc897fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_ITOM",
    .udesc   = "ItoMs issued by iA Cores that Hit LLC (experimental)",
    .ucode   = 0xcc47fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFCODE",
    .udesc   = "LLCPrefCode issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xcccffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFCRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xcccffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFDATA",
    .udesc   = "LLCPrefData issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xccd7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFDRD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xccd7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFRFO",
    .udesc   = "LLCPrefRFO issued by iA Cores that hit the LLC",
    .ucode   = 0xccc7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_RFO",
    .udesc   = "RFOs issued by iA Cores that Hit the LLC",
    .ucode   = 0xc807fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_RFO_PREF",
    .udesc   = "RFO_Prefs issued by iA Cores that Hit the LLC",
    .ucode   = 0xc887fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_SPECITOM",
    .udesc   = "SpecItoMs issued by iA Cores that hit in the LLC (experimental)",
    .ucode   = 0xcc57fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_ITOM",
    .udesc   = "ItoMs issued by iA Cores (experimental)",
    .ucode   = 0xcc47ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears issued by iA Cores (experimental)",
    .ucode   = 0xcd47ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFCODE",
    .udesc   = "LLCPrefCode issued by iA Cores (experimental)",
    .ucode   = 0xcccfff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFDATA",
    .udesc   = "LLCPrefData issued by iA Cores",
    .ucode   = 0xccd7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFRFO",
    .udesc   = "LLCPrefRFO issued by iA Cores",
    .ucode   = 0xccc7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS",
    .udesc   = "All requests from iA Cores that Missed the LLC",
    .ucode   = 0xc001fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD",
    .udesc   = "CRds issued by iA Cores that Missed the LLC",
    .ucode   = 0xc80ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_LOCAL",
    .udesc   = "CRd issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc80efe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC",
    .ucode   = 0xc88ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF_LOCAL",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc88efe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF_REMOTE",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc88f7e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_REMOTE",
    .udesc   = "CRd issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc80f7e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD",
    .udesc   = "DRds issued by iA Cores that Missed the LLC",
    .ucode   = 0xc817fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRDPTE",
    .udesc   = "DRd PTEs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc837fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC",
    .ucode   = 0xc8178600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL",
    .udesc   = "DRds issued by iA Cores that Missed the LLC - HOMed locally",
    .ucode   = 0xc816fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed locally",
    .ucode   = 0xc8168600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed locally",
    .ucode   = 0xc8168a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT",
    .udesc   = "DRd_Opt issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xc827fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT_PREF",
    .udesc   = "DRd_Opt_Prefs issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xc8a7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC",
    .ucode   = 0xc8178a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF",
    .udesc   = "DRd_Prefs issued by iA Cores that Missed the LLC",
    .ucode   = 0xc897fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC (experimental)",
    .ucode   = 0xc8978600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL",
    .udesc   = "TBD",
    .ucode   = 0xc896fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8968600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8968a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC (experimental)",
    .ucode   = 0xc8978a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE",
    .udesc   = "TBD",
    .ucode   = 0xc8977e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8970600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8970a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE",
    .udesc   = "DRds issued by iA Cores that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8177e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8170600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8170a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR",
    .udesc   = "TBD",
    .ucode   = 0xc867fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8678600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_DRAM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8678600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_LOCAL_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8668600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_LOCAL_DRAM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8668600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_LOCAL_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8668a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8678a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_REMOTE_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8670600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_REMOTE_DRAM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8670600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_REMOTE_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8670a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_ITOM",
    .udesc   = "ItoMs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xcc47fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFCODE",
    .udesc   = "LLCPrefCode issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xcccffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFDATA",
    .udesc   = "LLCPrefData issued by iA Cores that missed the LLC",
    .ucode   = 0xccd7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFRFO",
    .udesc   = "LLCPrefRFO issued by iA Cores that missed the LLC",
    .ucode   = 0xccc7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8668600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8668a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc86e8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc86e8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR",
    .udesc   = "TBD",
    .ucode   = 0xc86ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_DRAM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_LOCAL_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86e8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_LOCAL_DRAM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86e8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_LOCAL_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86e8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_REMOTE_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f0600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_REMOTE_DRAM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f0600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_REMOTE_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f0a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8670600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC - HOMed remote memory (experimental)",
    .ucode   = 0xc8670a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc86f0600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc86f0a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO",
    .udesc   = "RFOs issued by iA Cores that Missed the LLC",
    .ucode   = 0xc807fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_LOCAL",
    .udesc   = "RFOs issued by iA Cores that Missed the LLC - HOMed locally",
    .ucode   = 0xc806fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF",
    .udesc   = "RFO_Prefs issued by iA Cores that Missed the LLC",
    .ucode   = 0xc887fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_LOCAL",
    .udesc   = "RFO_Prefs issued by iA Cores that Missed the LLC - HOMed locally",
    .ucode   = 0xc886fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_REMOTE",
    .udesc   = "RFO_Prefs issued by iA Cores that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8877e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_REMOTE",
    .udesc   = "RFOs issued by iA Cores that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8077e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_SPECITOM",
    .udesc   = "SpecItoMs issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xcc57fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_UCRDF",
    .udesc   = "UCRdFs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xc877de00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL",
    .udesc   = "WCiLs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc86ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF",
    .udesc   = "WCiLF issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc867fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC (experimental)",
    .ucode   = 0xc8678600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC (experimental)",
    .ucode   = 0xc8678a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC (experimental)",
    .ucode   = 0xc86f8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC (experimental)",
    .ucode   = 0xc86f8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WIL",
    .udesc   = "WiLs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xc87fde00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_RFO",
    .udesc   = "RFOs issued by iA Cores",
    .ucode   = 0xc807ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_RFO_PREF",
    .udesc   = "RFO_Prefs issued by iA Cores",
    .ucode   = 0xc887ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_SPECITOM",
    .udesc   = "SpecItoMs issued by iA Cores",
    .ucode   = 0xcc57ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBEFTOE",
    .udesc   = "WBEFtoEs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc3fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBEFTOI",
    .udesc   = "WBEFtoIs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc37ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBMTOE",
    .udesc   = "WBMtoEs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc2fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBMTOI",
    .udesc   = "WbMtoIs issued by an iA Cores. Modified Write Backs (experimental)",
    .ucode   = 0xcc27ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBSTOI",
    .udesc   = "WBStoIs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc67ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WCIL",
    .udesc   = "WCiLs issued by iA Cores (experimental)",
    .ucode   = 0xc86fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WCILF",
    .udesc   = "WCiLF issued by iA Cores (experimental)",
    .ucode   = 0xc867ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO",
    .udesc   = "All requests from IO Devices",
    .ucode   = 0xc001ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_CLFLUSH",
    .udesc   = "CLFlushes issued by IO Devices (experimental)",
    .ucode   = 0xc8c3ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT",
    .udesc   = "All requests from IO Devices that hit the LLC",
    .ucode   = 0xc001fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_ITOM",
    .udesc   = "ItoMs issued by IO Devices that Hit the LLC",
    .ucode   = 0xcc43fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices that hit the LLC",
    .ucode   = 0xcd43fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_PCIRDCUR",
    .udesc   = "PCIRdCurs issued by IO Devices that hit the LLC",
    .ucode   = 0xc8f3fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_RFO",
    .udesc   = "RFOs issued by IO Devices that hit the LLC (experimental)",
    .ucode   = 0xc803fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOM",
    .udesc   = "ItoMs issued by IO Devices",
    .ucode   = 0xcc43ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices",
    .ucode   = 0xcd43ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOMCACHENEAR_LOCAL",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices to locally HOMed memory",
    .ucode   = 0xcd42ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOMCACHENEAR_REMOTE",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices to remotely HOMed memory",
    .ucode   = 0xcd437f00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOM_LOCAL",
    .udesc   = "ItoMs issued by IO Devices to locally HOMed memory",
    .ucode   = 0xcc42ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOM_REMOTE",
    .udesc   = "ItoMs issued by IO Devices to remotely HOMed memory",
    .ucode   = 0xcc437f00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS",
    .udesc   = "All requests from IO Devices that missed the LLC",
    .ucode   = 0xc001fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_ITOM",
    .udesc   = "ItoMs issued by IO Devices that missed the LLC",
    .ucode   = 0xcc43fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices that missed the LLC",
    .ucode   = 0xcd43fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_PCIRDCUR",
    .udesc   = "PCIRdCurs issued by IO Devices that missed the LLC",
    .ucode   = 0xc8f3fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_RFO",
    .udesc   = "RFOs issued by IO Devices that missed the LLC (experimental)",
    .ucode   = 0xc803fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_PCIRDCUR",
    .udesc   = "PCIRdCurs issued by IO Devices",
    .ucode   = 0xc8f3ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_RFO",
    .udesc   = "RFOs issued by IO Devices (experimental)",
    .ucode   = 0xc803ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WBMTOI",
    .udesc   = "WbMtoIs issued by IO Devices (experimental)",
    .ucode   = 0xcc23ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IPQ",
    .udesc   = "IPQ (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_IA",
    .udesc   = "IRQ - iA (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_NON_IA",
    .udesc   = "IRQ - Non iA (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ISOC",
    .udesc   = "Just ISOC (experimental)",
    .ucode   = 0x200000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_TGT",
    .udesc   = "Just Local Targets (experimental)",
    .ucode   = 0x8000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_ALL",
    .udesc   = "All from Local iA and IO (experimental)",
    .ucode   = 0xc000ff00000500ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_IA",
    .udesc   = "All from Local iA (experimental)",
    .ucode   = 0xc000ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_IO",
    .udesc   = "All from Local IO (experimental)",
    .ucode   = 0xc000ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MATCH_OPC",
    .udesc   = "Match the Opcode in b[29:19] of the extended umask field (experimental)",
    .ucode   = 0x20000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MISS",
    .udesc   = "Just Misses (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MMCFG",
    .udesc   = "MMCFG Access (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NEARMEM",
    .udesc   = "Just NearMem (experimental)",
    .ucode   = 0x40000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NONCOH",
    .udesc   = "Just NonCoherent (experimental)",
    .ucode   = 0x100000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_NEARMEM",
    .udesc   = "Just NotNearMem (experimental)",
    .ucode   = 0x80000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM",
    .udesc   = "PMM Access (experimental)",
    .ucode   = 0x800000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PREMORPH_OPC",
    .udesc   = "Match the PreMorphed Opcode in b[29:19] of the extended umask field (experimental)",
    .ucode   = 0x40000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ_IOSF",
    .udesc   = "PRQ - IOSF (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ_NON_IOSF",
    .udesc   = "PRQ - Non IOSF (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_TGT",
    .udesc   = "Just Remote Targets (experimental)",
    .ucode   = 0x10000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RRQ",
    .udesc   = "RRQ (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBQ",
    .udesc   = "WBQ (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_tor_occupancy[]={
  { .uname   = "DDR",
    .udesc   = "DDR4 Access (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EVICT",
    .udesc   = "SF/LLC Evictions (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HIT",
    .udesc   = "Just Hits (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA",
    .udesc   = "All requests from iA Cores",
    .ucode   = 0xc001ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CLFLUSH",
    .udesc   = "CLFlushes issued by iA Cores (experimental)",
    .ucode   = 0xc8c7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CLFLUSHOPT",
    .udesc   = "CLFlushOpts issued by iA Cores (experimental)",
    .ucode   = 0xc8d7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CRD",
    .udesc   = "CRDs issued by iA Cores",
    .ucode   = 0xc80fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CRD_PREF",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc88fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD",
    .udesc   = "DRds issued by iA Cores",
    .ucode   = 0xc817ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRDPTE",
    .udesc   = "DRdPte issued by iA Cores due to a page walk (experimental)",
    .ucode   = 0xc837ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_OPT",
    .udesc   = "DRd_Opts issued by iA Cores (experimental)",
    .ucode   = 0xc827ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_OPT_PREF",
    .udesc   = "DRd_Opt_Prefs issued by iA Cores (experimental)",
    .ucode   = 0xc8a7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_PREF",
    .udesc   = "DRd_Prefs issued by iA Cores (experimental)",
    .ucode   = 0xc897ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT",
    .udesc   = "All requests from iA Cores that Hit the LLC",
    .ucode   = 0xc001fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CRD",
    .udesc   = "CRds issued by iA Cores that Hit the LLC (experimental)",
    .ucode   = 0xc80ffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CRD_PREF",
    .udesc   = "CRd_Prefs issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xc88ffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD",
    .udesc   = "DRds issued by iA Cores that Hit the LLC (experimental)",
    .ucode   = 0xc817fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRDPTE",
    .udesc   = "DRdPte issued by iA Cores due to a page walk that hit the LLC (experimental)",
    .ucode   = 0xc837fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_OPT",
    .udesc   = "DRd_Opts issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xc827fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_OPT_PREF",
    .udesc   = "DRd_Opt_Prefs issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xc8a7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_PREF",
    .udesc   = "DRd_Prefs issued by iA Cores that Hit the LLC (experimental)",
    .ucode   = 0xc897fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_ITOM",
    .udesc   = "ItoMs issued by iA Cores that Hit LLC (experimental)",
    .ucode   = 0xcc47fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFCODE",
    .udesc   = "LLCPrefCode issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xcccffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFDATA",
    .udesc   = "LLCPrefData issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xccd7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFRFO",
    .udesc   = "LLCPrefRFO issued by iA Cores that hit the LLC (experimental)",
    .ucode   = 0xccc7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_RFO",
    .udesc   = "RFOs issued by iA Cores that Hit the LLC (experimental)",
    .ucode   = 0xc807fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_RFO_PREF",
    .udesc   = "RFO_Prefs issued by iA Cores that Hit the LLC (experimental)",
    .ucode   = 0xc887fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_ITOM",
    .udesc   = "ItoMs issued by iA Cores (experimental)",
    .ucode   = 0xcc47ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears issued by iA Cores (experimental)",
    .ucode   = 0xcd47ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFCODE",
    .udesc   = "LLCPrefCode issued by iA Cores (experimental)",
    .ucode   = 0xcccfff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFDATA",
    .udesc   = "LLCPrefData issued by iA Cores (experimental)",
    .ucode   = 0xccd7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFRFO",
    .udesc   = "LLCPrefRFO issued by iA Cores (experimental)",
    .ucode   = 0xccc7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS",
    .udesc   = "All requests from iA Cores that Missed the LLC",
    .ucode   = 0xc001fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD",
    .udesc   = "CRds issued by iA Cores that Missed the LLC",
    .ucode   = 0xc80ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_LOCAL",
    .udesc   = "CRd issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc80efe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc88ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF_LOCAL",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc88efe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF_REMOTE",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc88f7e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_REMOTE",
    .udesc   = "CRd issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc80f7e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD",
    .udesc   = "DRds issued by iA Cores that Missed the LLC",
    .ucode   = 0xc817fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRDPTE",
    .udesc   = "DRdPte issued by iA Cores due to a page walk that missed the LLC (experimental)",
    .ucode   = 0xc837fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC",
    .ucode   = 0xc8178600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL",
    .udesc   = "DRds issued by iA Cores that Missed the LLC - HOMed locally",
    .ucode   = 0xc816fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8168600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8168a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT",
    .udesc   = "DRd_Opt issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xc827fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT_PREF",
    .udesc   = "DRd_Opt_Prefs issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xc8a7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC",
    .ucode   = 0xc8178a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF",
    .udesc   = "DRd_Prefs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc897fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC (experimental)",
    .ucode   = 0xc8978600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc896fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8968600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8968a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC (experimental)",
    .ucode   = 0xc8978a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8977e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8970600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8970a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE",
    .udesc   = "DRds issued by iA Cores that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8177e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8170600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8170a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc867fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8678600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_LOCAL_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8668600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_LOCAL_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8668a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8678a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_REMOTE_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8670600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_FULL_STREAMING_WR_REMOTE_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc8670a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_ITOM",
    .udesc   = "ItoMs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xcc47fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFCODE",
    .udesc   = "LLCPrefCode issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xcccffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFDATA",
    .udesc   = "LLCPrefData issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xccd7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFRFO",
    .udesc   = "LLCPrefRFO issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xccc7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8668600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8668a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc86e8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc86e8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_LOCAL_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86e8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_LOCAL_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86e8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_REMOTE_DDR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f0600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_PARTIAL_STREAMING_WR_REMOTE_PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc86f0a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8670600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8670a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc86f0600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc86f0a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO",
    .udesc   = "RFOs issued by iA Cores that Missed the LLC",
    .ucode   = 0xc807fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_LOCAL",
    .udesc   = "RFOs issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc806fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF",
    .udesc   = "RFO_Prefs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc887fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_LOCAL",
    .udesc   = "RFO_Prefs issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc886fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_REMOTE",
    .udesc   = "RFO_Prefs issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8877e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_REMOTE",
    .udesc   = "RFOs issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8077e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_SPECITOM",
    .udesc   = "SpecItoMs issued by iA Cores that missed the LLC (experimental)",
    .ucode   = 0xcc57fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_UCRDF",
    .udesc   = "UCRdFs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xc877de00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL",
    .udesc   = "WCiLs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc86ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF",
    .udesc   = "WCiLF issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc867fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC (experimental)",
    .ucode   = 0xc8678600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC (experimental)",
    .ucode   = 0xc8678a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC (experimental)",
    .ucode   = 0xc86f8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC (experimental)",
    .ucode   = 0xc86f8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WIL",
    .udesc   = "WiLs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xc87fde00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_RFO",
    .udesc   = "RFOs issued by iA Cores",
    .ucode   = 0xc807ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_RFO_PREF",
    .udesc   = "RFO_Prefs issued by iA Cores (experimental)",
    .ucode   = 0xc887ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_SPECITOM",
    .udesc   = "SpecItoMs issued by iA Cores (experimental)",
    .ucode   = 0xcc57ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBMTOI",
    .udesc   = "WbMtoIs issued by iA Cores (experimental)",
    .ucode   = 0xcc27ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WCIL",
    .udesc   = "WCiLs issued by iA Cores (experimental)",
    .ucode   = 0xc86fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WCILF",
    .udesc   = "WCiLF issued by iA Cores (experimental)",
    .ucode   = 0xc867ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO",
    .udesc   = "All requests from IO Devices",
    .ucode   = 0xc001ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_CLFLUSH",
    .udesc   = "CLFlushes issued by IO Devices (experimental)",
    .ucode   = 0xc8c3ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT",
    .udesc   = "All requests from IO Devices that hit the LLC",
    .ucode   = 0xc001fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_ITOM",
    .udesc   = "ItoMs issued by IO Devices that Hit the LLC (experimental)",
    .ucode   = 0xcc43fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices that hit the LLC (experimental)",
    .ucode   = 0xcd43fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_PCIRDCUR",
    .udesc   = "PCIRdCurs issued by IO Devices that hit the LLC (experimental)",
    .ucode   = 0xc8f3fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_RFO",
    .udesc   = "RFOs issued by IO Devices that hit the LLC (experimental)",
    .ucode   = 0xc803fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOM",
    .udesc   = "ItoMs issued by IO Devices (experimental)",
    .ucode   = 0xcc43ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices (experimental)",
    .ucode   = 0xcd43ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS",
    .udesc   = "All requests from IO Devices that missed the LLC",
    .ucode   = 0xc001fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_ITOM",
    .udesc   = "ItoMs issued by IO Devices that missed the LLC (experimental)",
    .ucode   = 0xcc43fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices that missed the LLC (experimental)",
    .ucode   = 0xcd43fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_PCIRDCUR",
    .udesc   = "PCIRdCurs issued by IO Devices that missed the LLC",
    .ucode   = 0xc8f3fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_RFO",
    .udesc   = "RFOs issued by IO Devices that missed the LLC (experimental)",
    .ucode   = 0xc803fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_PCIRDCUR",
    .udesc   = "PCIRdCurs issued by IO Devices",
    .ucode   = 0xc8f3ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_RFO",
    .udesc   = "RFOs issued by IO Devices (experimental)",
    .ucode   = 0xc803ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WBMTOI",
    .udesc   = "WbMtoIs issued by IO Devices (experimental)",
    .ucode   = 0xcc23ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IPQ",
    .udesc   = "IPQ (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_IA",
    .udesc   = "IRQ - iA (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_NON_IA",
    .udesc   = "IRQ - Non iA (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ISOC",
    .udesc   = "Just ISOC (experimental)",
    .ucode   = 0x200000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_TGT",
    .udesc   = "Just Local Targets (experimental)",
    .ucode   = 0x8000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_ALL",
    .udesc   = "All from Local iA and IO (experimental)",
    .ucode   = 0xc000ff00000500ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_IA",
    .udesc   = "All from Local iA (experimental)",
    .ucode   = 0xc000ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_IO",
    .udesc   = "All from Local IO (experimental)",
    .ucode   = 0xc000ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MATCH_OPC",
    .udesc   = "Match the Opcode in b[29:19] of the extended umask field (experimental)",
    .ucode   = 0x20000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MISS",
    .udesc   = "Just Misses (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MMCFG",
    .udesc   = "MMCFG Access (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NEARMEM",
    .udesc   = "Just NearMem (experimental)",
    .ucode   = 0x40000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NONCOH",
    .udesc   = "Just NonCoherent (experimental)",
    .ucode   = 0x100000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_NEARMEM",
    .udesc   = "Just NotNearMem (experimental)",
    .ucode   = 0x80000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM",
    .udesc   = "PMM Access (experimental)",
    .ucode   = 0x800000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PREMORPH_OPC",
    .udesc   = "Match the PreMorphed Opcode in b[29:19] of the extended umask field (experimental)",
    .ucode   = 0x40000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ",
    .udesc   = "PRQ - IOSF (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ_NON_IOSF",
    .udesc   = "PRQ - Non IOSF (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_TGT",
    .udesc   = "Just Remote Targets (experimental)",
    .ucode   = 0x10000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_horz_ads_used[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_horz_cycles_full[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_horz_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_horz_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_horz_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_ads_used[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_bypass[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG1",
    .udesc   = "IV - Agent 1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_cycles_full1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_cycles_ne0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_inserts1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_occupancy0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_occupancy1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_starved0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_txr_vert_starved1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGC",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_vert_ring_akc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_vert_ring_bl_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_vert_ring_iv_in_use[]={
  { .uname   = "DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_vert_ring_tgc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_wb_push_mtoi[]={
  { .uname   = "LLC",
    .udesc   = "Pushed to LLC (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM",
    .udesc   = "Pushed to Memory (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_write_no_credits[]={
  { .uname   = "MC0",
    .udesc   = "MC0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC1",
    .udesc   = "MC1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC10",
    .udesc   = "MC10 (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC11",
    .udesc   = "MC11 (experimental)",
    .ucode   = 0x800000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC12",
    .udesc   = "MC12 (experimental)",
    .ucode   = 0x1000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC13",
    .udesc   = "MC13 (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC2",
    .udesc   = "MC2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC3",
    .udesc   = "MC3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC4",
    .udesc   = "MC4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC5",
    .udesc   = "MC5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC6",
    .udesc   = "MC6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC7",
    .udesc   = "MC7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC8",
    .udesc   = "MC8 (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC9",
    .udesc   = "MC9 (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_cha_xpt_pref[]={
  { .uname   = "DROP0_CONFLICT",
    .udesc   = "Dropped (on 0?) - Conflict (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DROP0_NOCRD",
    .udesc   = "Dropped (on 0?) - No Credits (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DROP1_CONFLICT",
    .udesc   = "Dropped (on 1?) - Conflict (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DROP1_NOCRD",
    .udesc   = "Dropped (on 1?) - No Credits (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SENT0",
    .udesc   = "Sent (on 0?) (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SENT1",
    .udesc   = "Sent (on 1?) (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_icx_unc_cha_pe[]={
  { .name   = "UNC_CHA_2LM_NM_INVITOX",
    .desc   = "This event is deprecated. Refer to new event UNC_CHA_PMM_MEMMODE_NM_INVITOX.LOCAL",
    .code   = 0x0065,
    .equiv  = "UNC_CHA_PMM_MEMMODE_NM_INVITOX",
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_pmm_memmode_nm_invitox), /* shared */
    .umasks = icx_unc_cha_pmm_memmode_nm_invitox,
  },
  { .name   = "UNC_CHA_2LM_NM_SETCONFLICTS",
    .desc   = "This event is deprecated. Refer to new event UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS.TOR",
    .code   = 0x0064,
    .equiv  = "UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS",
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_2lm_nm_setconflicts),
    .umasks = icx_unc_cha_2lm_nm_setconflicts,
  },
  { .name   = "UNC_CHA_2LM_NM_SETCONFLICTS2",
    .desc   = "This event is deprecated. Refer to new event UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS2.MEMWR",
    .code   = 0x0070,
    .equiv  = "UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS2",
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_2lm_nm_setconflicts2),
    .umasks = icx_unc_cha_2lm_nm_setconflicts2,
  },
  { .name   = "UNC_CHA_AG0_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0080,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_cha_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_CHA_AG0_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0081,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_cha_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_CHA_AG0_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0082,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_ad_crd_occupancy0),
    .umasks = icx_unc_cha_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_CHA_AG0_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0083,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_ad_crd_occupancy1),
    .umasks = icx_unc_cha_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_CHA_AG0_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0088,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_bl_crd_occupancy0), /* shared */
    .umasks = icx_unc_cha_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_CHA_AG0_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0089,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_cha_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_CHA_AG0_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008a,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_bl_crd_occupancy0),
    .umasks = icx_unc_cha_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_CHA_AG0_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008b,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag0_bl_crd_occupancy1),
    .umasks = icx_unc_cha_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_CHA_AG1_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0084,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag1_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_cha_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_CHA_AG1_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0085,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag1_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_cha_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_CHA_AG1_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0086,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag1_ad_crd_occupancy0),
    .umasks = icx_unc_cha_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_CHA_AG1_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0087,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag1_ad_crd_occupancy1),
    .umasks = icx_unc_cha_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_CHA_AG1_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008c,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag1_bl_crd_acquired0),
    .umasks = icx_unc_cha_ag1_bl_crd_acquired0,
  },
  { .name   = "UNC_CHA_AG1_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008d,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag1_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_cha_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_CHA_AG1_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008e,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall0_no_txr_horz_crd_ad_ag0), /* shared */
    .umasks = icx_unc_cha_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_CHA_AG1_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008f,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ag1_bl_crd_occupancy1),
    .umasks = icx_unc_cha_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_CHA_BYPASS_CHA_IMC",
    .desc   = "CHA to iMC Bypass",
    .code   = 0x0057,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_bypass_cha_imc),
    .umasks = icx_unc_cha_bypass_cha_imc,
  },
  { .name   = "UNC_CHA_CLOCKTICKS",
    .desc   = "Clockticks of the uncore caching and home agent (CHA)",
    .code   = 0x0000,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_CHA_CMS_CLOCKTICKS",
    .desc   = "CMS Clockticks",
    .code   = 0x00c0,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_CHA_CORE_SNP",
    .desc   = "Core Cross Snoops Issued",
    .code   = 0x0033,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_core_snp),
    .umasks = icx_unc_cha_core_snp,
  },
  { .name   = "UNC_CHA_COUNTER0_OCCUPANCY",
    .desc   = "Counter 0 Occupancy (experimental)",
    .code   = 0x001f,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_CHA_DIRECT_GO",
    .desc   = "Direct GO",
    .code   = 0x006e,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_direct_go),
    .umasks = icx_unc_cha_direct_go,
  },
  { .name   = "UNC_CHA_DIRECT_GO_OPC",
    .desc   = "Direct GO",
    .code   = 0x006d,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_direct_go_opc),
    .umasks = icx_unc_cha_direct_go_opc,
  },
  { .name   = "UNC_CHA_DIR_LOOKUP",
    .desc   = "Multi-socket cacheline directory state lookups",
    .code   = 0x0053,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_dir_lookup),
    .umasks = icx_unc_cha_dir_lookup,
  },
  { .name   = "UNC_CHA_DIR_UPDATE",
    .desc   = "Multi-socket cacheline directory state updates; memory write due to directory update from the home agent (HA) pipe",
    .code   = 0x0054,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_dir_update),
    .umasks = icx_unc_cha_dir_update,
  },
  { .name   = "UNC_CHA_DISTRESS_ASSERTED",
    .desc   = "Distress signal asserted",
    .code   = 0x00af,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_distress_asserted),
    .umasks = icx_unc_cha_distress_asserted,
  },
  { .name   = "UNC_CHA_EGRESS_ORDERING",
    .desc   = "Egress Blocking due to Ordering requirements",
    .code   = 0x00ba,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_egress_ordering),
    .umasks = icx_unc_cha_egress_ordering,
  },
  { .name   = "UNC_CHA_HITME_HIT",
    .desc   = "Read request from a remote socket which hit in the HitMe Cache to a line In the E state",
    .code   = 0x005f,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_hitme_hit),
    .umasks = icx_unc_cha_hitme_hit,
  },
  { .name   = "UNC_CHA_HITME_LOOKUP",
    .desc   = "Counts Number of times HitMe Cache is accessed",
    .code   = 0x005e,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_hitme_lookup),
    .umasks = icx_unc_cha_hitme_lookup,
  },
  { .name   = "UNC_CHA_HITME_MISS",
    .desc   = "Counts Number of Misses in HitMe Cache",
    .code   = 0x0060,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_hitme_miss),
    .umasks = icx_unc_cha_hitme_miss,
  },
  { .name   = "UNC_CHA_HITME_UPDATE",
    .desc   = "Counts the number of Allocate/Update to HitMe Cache",
    .code   = 0x0061,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_hitme_update),
    .umasks = icx_unc_cha_hitme_update,
  },
  { .name   = "UNC_CHA_HORZ_RING_AD_IN_USE",
    .desc   = "Horizontal AD Ring In Use",
    .code   = 0x00b6,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_horz_ring_akc_in_use), /* shared */
    .umasks = icx_unc_cha_horz_ring_akc_in_use,
  },
  { .name   = "UNC_CHA_HORZ_RING_AKC_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00bb,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_horz_ring_akc_in_use),
    .umasks = icx_unc_cha_horz_ring_akc_in_use,
  },
  { .name   = "UNC_CHA_HORZ_RING_AK_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00b7,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_horz_ring_bl_in_use), /* shared */
    .umasks = icx_unc_cha_horz_ring_bl_in_use,
  },
  { .name   = "UNC_CHA_HORZ_RING_BL_IN_USE",
    .desc   = "Horizontal BL Ring in Use",
    .code   = 0x00b8,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_horz_ring_bl_in_use),
    .umasks = icx_unc_cha_horz_ring_bl_in_use,
  },
  { .name   = "UNC_CHA_HORZ_RING_IV_IN_USE",
    .desc   = "Horizontal IV Ring in Use",
    .code   = 0x00b9,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_horz_ring_iv_in_use),
    .umasks = icx_unc_cha_horz_ring_iv_in_use,
  },
  { .name   = "UNC_CHA_IMC_READS_COUNT",
    .desc   = "Normal priority reads issued to the memory controller from the CHA",
    .code   = 0x0059,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_imc_reads_count),
    .umasks = icx_unc_cha_imc_reads_count,
  },
  { .name   = "UNC_CHA_IMC_WRITES_COUNT",
    .desc   = "CHA to iMC Full Line Writes Issued",
    .code   = 0x005b,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_imc_writes_count),
    .umasks = icx_unc_cha_imc_writes_count,
  },
  { .name   = "UNC_CHA_LLC_LOOKUP",
    .desc   = "Cache and Snoop Filter Lookups; Data Read Request",
    .code   = 0x0034,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_llc_lookup),
    .umasks = icx_unc_cha_llc_lookup,
  },
  { .name   = "UNC_CHA_LLC_VICTIMS",
    .desc   = "Lines Victimized",
    .code   = 0x0037,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_llc_victims),
    .umasks = icx_unc_cha_llc_victims,
  },
  { .name   = "UNC_CHA_MISC",
    .desc   = "Number of times that an RFO hit in S state.",
    .code   = 0x0039,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_misc),
    .umasks = icx_unc_cha_misc,
  },
  { .name   = "UNC_CHA_MISC_EXTERNAL",
    .desc   = "Miscellaneous Events (mostly from MS2IDI)",
    .code   = 0x00e6,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_misc_external),
    .umasks = icx_unc_cha_misc_external,
  },
  { .name   = "UNC_CHA_OSB",
    .desc   = "OSB Snoop Broadcast",
    .code   = 0x0055,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_osb),
    .umasks = icx_unc_cha_osb,
  },
  { .name   = "UNC_CHA_PMM_MEMMODE_NM_INVITOX",
    .desc   = "UNC_CHA_PMM_MEMMODE_NM_INVITOX.LOCAL",
    .code   = 0x0065,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_pmm_memmode_nm_invitox),
    .umasks = icx_unc_cha_pmm_memmode_nm_invitox,
  },
  { .name   = "UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS",
    .desc   = "PMM Memory Mode related events",
    .code   = 0x0064,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_pmm_memmode_nm_setconflicts),
    .umasks = icx_unc_cha_pmm_memmode_nm_setconflicts,
  },
  { .name   = "UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS2",
    .desc   = "UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS2.IODC",
    .code   = 0x0070,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_pmm_memmode_nm_setconflicts2),
    .umasks = icx_unc_cha_pmm_memmode_nm_setconflicts2,
  },
  { .name   = "UNC_CHA_PMM_QOS",
    .desc   = "UNC_CHA_PMM_QOS.SLOW_INSERT",
    .code   = 0x0066,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_pmm_qos),
    .umasks = icx_unc_cha_pmm_qos,
  },
  { .name   = "UNC_CHA_PMM_QOS_OCCUPANCY",
    .desc   = "UNC_CHA_PMM_QOS_OCCUPANCY.DDR_SLOW_FIFO",
    .code   = 0x0067,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_pmm_qos_occupancy),
    .umasks = icx_unc_cha_pmm_qos_occupancy,
  },
  { .name   = "UNC_CHA_READ_NO_CREDITS",
    .desc   = "CHA iMC CHNx READ Credits Empty",
    .code   = 0x0058,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_write_no_credits), /* shared */
    .umasks = icx_unc_cha_write_no_credits,
  },
  { .name   = "UNC_CHA_REQUESTS",
    .desc   = "Local INVITOE requests (exclusive ownership of a cache line without receiving data) that miss the SF/LLC and are sent to the CHA's home agent",
    .code   = 0x0050,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_requests),
    .umasks = icx_unc_cha_requests,
  },
  { .name   = "UNC_CHA_RING_BOUNCES_HORZ",
    .desc   = "Messages that bounced on the Horizontal Ring.",
    .code   = 0x00ac,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ring_bounces_horz),
    .umasks = icx_unc_cha_ring_bounces_horz,
  },
  { .name   = "UNC_CHA_RING_BOUNCES_VERT",
    .desc   = "Messages that bounced on the Vertical Ring.",
    .code   = 0x00aa,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ring_sink_starved_vert), /* shared */
    .umasks = icx_unc_cha_ring_sink_starved_vert,
  },
  { .name   = "UNC_CHA_RING_SINK_STARVED_HORZ",
    .desc   = "Sink Starvation on Horizontal Ring",
    .code   = 0x00ad,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ring_sink_starved_horz),
    .umasks = icx_unc_cha_ring_sink_starved_horz,
  },
  { .name   = "UNC_CHA_RING_SINK_STARVED_VERT",
    .desc   = "Sink Starvation on Vertical Ring",
    .code   = 0x00ab,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_ring_sink_starved_vert),
    .umasks = icx_unc_cha_ring_sink_starved_vert,
  },
  { .name   = "UNC_CHA_RING_SRC_THRTL",
    .desc   = "Source Throttle (experimental)",
    .code   = 0x00ae,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_CHA_RxC_INSERTS",
    .desc   = "Ingress (from CMS) Allocations",
    .code   = 0x0013,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_inserts),
    .umasks = icx_unc_cha_rxc_inserts,
  },
  { .name   = "UNC_CHA_RxC_IPQ0_REJECT",
    .desc   = "IPQ Requests (from CMS) Rejected - Set 0",
    .code   = 0x0022,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_irq0_reject), /* shared */
    .umasks = icx_unc_cha_rxc_irq0_reject,
  },
  { .name   = "UNC_CHA_RxC_IPQ1_REJECT",
    .desc   = "IPQ Requests (from CMS) Rejected - Set 1",
    .code   = 0x0023,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_other1_retry), /* shared */
    .umasks = icx_unc_cha_rxc_other1_retry,
  },
  { .name   = "UNC_CHA_RxC_IRQ0_REJECT",
    .desc   = "IRQ Requests (from CMS) Rejected - Set 0",
    .code   = 0x0018,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_irq0_reject),
    .umasks = icx_unc_cha_rxc_irq0_reject,
  },
  { .name   = "UNC_CHA_RxC_IRQ1_REJECT",
    .desc   = "Ingress (from CMS) Request Queue Rejects; PhyAddr Match",
    .code   = 0x0019,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_irq1_reject),
    .umasks = icx_unc_cha_rxc_irq1_reject,
  },
  { .name   = "UNC_CHA_RxC_ISMQ0_REJECT",
    .desc   = "ISMQ Rejects - Set 0",
    .code   = 0x0024,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_ismq0_retry), /* shared */
    .umasks = icx_unc_cha_rxc_ismq0_retry,
  },
  { .name   = "UNC_CHA_RxC_ISMQ0_RETRY",
    .desc   = "ISMQ Retries - Set 0",
    .code   = 0x002c,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_ismq0_retry),
    .umasks = icx_unc_cha_rxc_ismq0_retry,
  },
  { .name   = "UNC_CHA_RxC_ISMQ1_REJECT",
    .desc   = "ISMQ Rejects - Set 1",
    .code   = 0x0025,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_ismq1_retry), /* shared */
    .umasks = icx_unc_cha_rxc_ismq1_retry,
  },
  { .name   = "UNC_CHA_RxC_ISMQ1_RETRY",
    .desc   = "ISMQ Retries - Set 1",
    .code   = 0x002d,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_ismq1_retry),
    .umasks = icx_unc_cha_rxc_ismq1_retry,
  },
  { .name   = "UNC_CHA_RxC_OCCUPANCY",
    .desc   = "Ingress (from CMS) Occupancy",
    .code   = 0x0011,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0x1ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_occupancy),
    .umasks = icx_unc_cha_rxc_occupancy,
  },
  { .name   = "UNC_CHA_RxC_OTHER0_RETRY",
    .desc   = "Other Retries - Set 0",
    .code   = 0x002e,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_prq0_reject), /* shared */
    .umasks = icx_unc_cha_rxc_prq0_reject,
  },
  { .name   = "UNC_CHA_RxC_OTHER1_RETRY",
    .desc   = "Other Retries - Set 1",
    .code   = 0x002f,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_other1_retry),
    .umasks = icx_unc_cha_rxc_other1_retry,
  },
  { .name   = "UNC_CHA_RxC_PRQ0_REJECT",
    .desc   = "PRQ Requests (from CMS) Rejected - Set 0",
    .code   = 0x0020,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_prq0_reject),
    .umasks = icx_unc_cha_rxc_prq0_reject,
  },
  { .name   = "UNC_CHA_RxC_PRQ1_REJECT",
    .desc   = "PRQ Requests (from CMS) Rejected - Set 1",
    .code   = 0x0021,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_req_q1_retry), /* shared */
    .umasks = icx_unc_cha_rxc_req_q1_retry,
  },
  { .name   = "UNC_CHA_RxC_REQ_Q0_RETRY",
    .desc   = "Request Queue Retries - Set 0",
    .code   = 0x002a,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_rrq0_reject), /* shared */
    .umasks = icx_unc_cha_rxc_rrq0_reject,
  },
  { .name   = "UNC_CHA_RxC_REQ_Q1_RETRY",
    .desc   = "Request Queue Retries - Set 1",
    .code   = 0x002b,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_req_q1_retry),
    .umasks = icx_unc_cha_rxc_req_q1_retry,
  },
  { .name   = "UNC_CHA_RxC_RRQ0_REJECT",
    .desc   = "RRQ Rejects - Set 0",
    .code   = 0x0026,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_rrq0_reject),
    .umasks = icx_unc_cha_rxc_rrq0_reject,
  },
  { .name   = "UNC_CHA_RxC_RRQ1_REJECT",
    .desc   = "RRQ Rejects - Set 1",
    .code   = 0x0027,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_wbq1_reject), /* shared */
    .umasks = icx_unc_cha_rxc_wbq1_reject,
  },
  { .name   = "UNC_CHA_RxC_WBQ0_REJECT",
    .desc   = "WBQ Rejects - Set 0",
    .code   = 0x0028,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_wbq0_reject),
    .umasks = icx_unc_cha_rxc_wbq0_reject,
  },
  { .name   = "UNC_CHA_RxC_WBQ1_REJECT",
    .desc   = "WBQ Rejects - Set 1",
    .code   = 0x0029,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxc_wbq1_reject),
    .umasks = icx_unc_cha_rxc_wbq1_reject,
  },
  { .name   = "UNC_CHA_RxR_BUSY_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e5,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_ads_used), /* shared */
    .umasks = icx_unc_cha_txr_horz_ads_used,
  },
  { .name   = "UNC_CHA_RxR_BYPASS",
    .desc   = "Transgress Ingress Bypass",
    .code   = 0x00e2,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxr_inserts), /* shared */
    .umasks = icx_unc_cha_rxr_inserts,
  },
  { .name   = "UNC_CHA_RxR_CRD_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e3,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxr_crd_starved),
    .umasks = icx_unc_cha_rxr_crd_starved,
  },
  { .name   = "UNC_CHA_RxR_CRD_STARVED_1",
    .desc   = "Transgress Injection Starvation (experimental)",
    .code   = 0x00e4,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_CHA_RxR_INSERTS",
    .desc   = "Transgress Ingress Allocations",
    .code   = 0x00e1,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxr_inserts),
    .umasks = icx_unc_cha_rxr_inserts,
  },
  { .name   = "UNC_CHA_RxR_OCCUPANCY",
    .desc   = "Transgress Ingress Occupancy",
    .code   = 0x00e0,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_rxr_occupancy),
    .umasks = icx_unc_cha_rxr_occupancy,
  },
  { .name   = "UNC_CHA_SF_EVICTION",
    .desc   = "Snoop filter capacity evictions for E-state entries.",
    .code   = 0x003d,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_sf_eviction),
    .umasks = icx_unc_cha_sf_eviction,
  },
  { .name   = "UNC_CHA_SNOOPS_SENT",
    .desc   = "Snoops Sent",
    .code   = 0x0051,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_snoops_sent),
    .umasks = icx_unc_cha_snoops_sent,
  },
  { .name   = "UNC_CHA_SNOOP_RESP",
    .desc   = "Snoop Responses Received",
    .code   = 0x005c,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_snoop_resp),
    .umasks = icx_unc_cha_snoop_resp,
  },
  { .name   = "UNC_CHA_SNOOP_RESP_LOCAL",
    .desc   = "Snoop Responses Received Local",
    .code   = 0x005d,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_snoop_resp_local),
    .umasks = icx_unc_cha_snoop_resp_local,
  },
  { .name   = "UNC_CHA_SNOOP_RSP_MISC",
    .desc   = "Misc Snoop Responses Received",
    .code   = 0x006b,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_snoop_rsp_misc),
    .umasks = icx_unc_cha_snoop_rsp_misc,
  },
  { .name   = "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d0,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall0_no_txr_horz_crd_ad_ag0),
    .umasks = icx_unc_cha_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d2,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall0_no_txr_horz_crd_bl_ag0), /* shared */
    .umasks = icx_unc_cha_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d4,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall0_no_txr_horz_crd_bl_ag0),
    .umasks = icx_unc_cha_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d6,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall0_no_txr_horz_crd_bl_ag1),
    .umasks = icx_unc_cha_stall0_no_txr_horz_crd_bl_ag1,
  },
  { .name   = "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d1,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall1_no_txr_horz_crd_ad_ag1_1), /* shared */
    .umasks = icx_unc_cha_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d3,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall1_no_txr_horz_crd_ad_ag1_1),
    .umasks = icx_unc_cha_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d5,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall1_no_txr_horz_crd_bl_ag1_1), /* shared */
    .umasks = icx_unc_cha_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d7,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_stall1_no_txr_horz_crd_bl_ag1_1),
    .umasks = icx_unc_cha_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_CHA_TOR_INSERTS",
    .desc   = "TOR Inserts",
    .code   = 0x0035,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_tor_inserts),
    .umasks = icx_unc_cha_tor_inserts,
  },
  { .name   = "UNC_CHA_TOR_OCCUPANCY",
    .desc   = "TOR Occupancy",
    .code   = 0x0036,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0x1ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_tor_occupancy),
    .umasks = icx_unc_cha_tor_occupancy,
  },
  { .name   = "UNC_CHA_TxR_HORZ_ADS_USED",
    .desc   = "CMS Horizontal ADS Used",
    .code   = 0x00a6,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_ads_used),
    .umasks = icx_unc_cha_txr_horz_ads_used,
  },
  { .name   = "UNC_CHA_TxR_HORZ_BYPASS",
    .desc   = "CMS Horizontal Bypass Used",
    .code   = 0x00a7,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_cycles_full), /* shared */
    .umasks = icx_unc_cha_txr_horz_cycles_full,
  },
  { .name   = "UNC_CHA_TxR_HORZ_CYCLES_FULL",
    .desc   = "Cycles CMS Horizontal Egress Queue is Full",
    .code   = 0x00a2,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_cycles_full),
    .umasks = icx_unc_cha_txr_horz_cycles_full,
  },
  { .name   = "UNC_CHA_TxR_HORZ_CYCLES_NE",
    .desc   = "Cycles CMS Horizontal Egress Queue is Not Empty",
    .code   = 0x00a3,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_inserts), /* shared */
    .umasks = icx_unc_cha_txr_horz_inserts,
  },
  { .name   = "UNC_CHA_TxR_HORZ_INSERTS",
    .desc   = "CMS Horizontal Egress Inserts",
    .code   = 0x00a1,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_inserts),
    .umasks = icx_unc_cha_txr_horz_inserts,
  },
  { .name   = "UNC_CHA_TxR_HORZ_NACK",
    .desc   = "CMS Horizontal Egress NACKs",
    .code   = 0x00a4,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_occupancy), /* shared */
    .umasks = icx_unc_cha_txr_horz_occupancy,
  },
  { .name   = "UNC_CHA_TxR_HORZ_OCCUPANCY",
    .desc   = "CMS Horizontal Egress Occupancy",
    .code   = 0x00a0,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_occupancy),
    .umasks = icx_unc_cha_txr_horz_occupancy,
  },
  { .name   = "UNC_CHA_TxR_HORZ_STARVED",
    .desc   = "CMS Horizontal Egress Injection Starvation",
    .code   = 0x00a5,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_horz_starved),
    .umasks = icx_unc_cha_txr_horz_starved,
  },
  { .name   = "UNC_CHA_TxR_VERT_ADS_USED",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009c,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_ads_used),
    .umasks = icx_unc_cha_txr_vert_ads_used,
  },
  { .name   = "UNC_CHA_TxR_VERT_BYPASS",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009d,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_bypass),
    .umasks = icx_unc_cha_txr_vert_bypass,
  },
  { .name   = "UNC_CHA_TxR_VERT_BYPASS_1",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009e,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_cycles_full1), /* shared */
    .umasks = icx_unc_cha_txr_vert_cycles_full1,
  },
  { .name   = "UNC_CHA_TxR_VERT_CYCLES_FULL0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0094,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_cycles_ne0), /* shared */
    .umasks = icx_unc_cha_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_CHA_TxR_VERT_CYCLES_FULL1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0095,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_cycles_full1),
    .umasks = icx_unc_cha_txr_vert_cycles_full1,
  },
  { .name   = "UNC_CHA_TxR_VERT_CYCLES_NE0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0096,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_cycles_ne0),
    .umasks = icx_unc_cha_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_CHA_TxR_VERT_CYCLES_NE1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0097,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_inserts1), /* shared */
    .umasks = icx_unc_cha_txr_vert_inserts1,
  },
  { .name   = "UNC_CHA_TxR_VERT_INSERTS0",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0092,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_occupancy0), /* shared */
    .umasks = icx_unc_cha_txr_vert_occupancy0,
  },
  { .name   = "UNC_CHA_TxR_VERT_INSERTS1",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0093,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_inserts1),
    .umasks = icx_unc_cha_txr_vert_inserts1,
  },
  { .name   = "UNC_CHA_TxR_VERT_NACK0",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0098,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_starved0), /* shared */
    .umasks = icx_unc_cha_txr_vert_starved0,
  },
  { .name   = "UNC_CHA_TxR_VERT_NACK1",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0099,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_occupancy1), /* shared */
    .umasks = icx_unc_cha_txr_vert_occupancy1,
  },
  { .name   = "UNC_CHA_TxR_VERT_OCCUPANCY0",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0090,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_occupancy0),
    .umasks = icx_unc_cha_txr_vert_occupancy0,
  },
  { .name   = "UNC_CHA_TxR_VERT_OCCUPANCY1",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0091,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_occupancy1),
    .umasks = icx_unc_cha_txr_vert_occupancy1,
  },
  { .name   = "UNC_CHA_TxR_VERT_STARVED0",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009a,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_starved0),
    .umasks = icx_unc_cha_txr_vert_starved0,
  },
  { .name   = "UNC_CHA_TxR_VERT_STARVED1",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009b,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_txr_vert_starved1),
    .umasks = icx_unc_cha_txr_vert_starved1,
  },
  { .name   = "UNC_CHA_VERT_RING_AD_IN_USE",
    .desc   = "Vertical AD Ring In Use",
    .code   = 0x00b0,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_vert_ring_akc_in_use), /* shared */
    .umasks = icx_unc_cha_vert_ring_akc_in_use,
  },
  { .name   = "UNC_CHA_VERT_RING_AKC_IN_USE",
    .desc   = "Vertical AKC Ring In Use",
    .code   = 0x00b4,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_vert_ring_akc_in_use),
    .umasks = icx_unc_cha_vert_ring_akc_in_use,
  },
  { .name   = "UNC_CHA_VERT_RING_AK_IN_USE",
    .desc   = "Vertical AK Ring In Use",
    .code   = 0x00b1,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_vert_ring_bl_in_use), /* shared */
    .umasks = icx_unc_cha_vert_ring_bl_in_use,
  },
  { .name   = "UNC_CHA_VERT_RING_BL_IN_USE",
    .desc   = "Vertical BL Ring in Use",
    .code   = 0x00b2,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_vert_ring_bl_in_use),
    .umasks = icx_unc_cha_vert_ring_bl_in_use,
  },
  { .name   = "UNC_CHA_VERT_RING_IV_IN_USE",
    .desc   = "Vertical IV Ring in Use",
    .code   = 0x00b3,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_vert_ring_iv_in_use),
    .umasks = icx_unc_cha_vert_ring_iv_in_use,
  },
  { .name   = "UNC_CHA_VERT_RING_TGC_IN_USE",
    .desc   = "Vertical TGC Ring In Use",
    .code   = 0x00b5,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_vert_ring_tgc_in_use),
    .umasks = icx_unc_cha_vert_ring_tgc_in_use,
  },
  { .name   = "UNC_CHA_WB_PUSH_MTOI",
    .desc   = "WbPushMtoI",
    .code   = 0x0056,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_wb_push_mtoi),
    .umasks = icx_unc_cha_wb_push_mtoi,
  },
  { .name   = "UNC_CHA_WRITE_NO_CREDITS",
    .desc   = "CHA iMC CHNx WRITE Credits Empty",
    .code   = 0x005a,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_write_no_credits),
    .umasks = icx_unc_cha_write_no_credits,
  },
  { .name   = "UNC_CHA_XPT_PREF",
    .desc   = "XPT Prefetches",
    .code   = 0x006f,
    .modmsk = ICX_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_cha_xpt_pref),
    .umasks = icx_unc_cha_xpt_pref,
  },
};
/* 132 events available */
