# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._operations._operations import (
    build_web_pub_sub_service_add_connection_to_group_request,
    build_web_pub_sub_service_add_connections_to_groups_request,
    build_web_pub_sub_service_add_user_to_group_request,
    build_web_pub_sub_service_close_all_connections_request,
    build_web_pub_sub_service_close_connection_request,
    build_web_pub_sub_service_close_group_connections_request,
    build_web_pub_sub_service_close_user_connections_request,
    build_web_pub_sub_service_connection_exists_request,
    build_web_pub_sub_service_get_client_access_token_request,
    build_web_pub_sub_service_get_service_status_request,
    build_web_pub_sub_service_grant_permission_request,
    build_web_pub_sub_service_group_exists_request,
    build_web_pub_sub_service_has_permission_request,
    build_web_pub_sub_service_list_connections_request,
    build_web_pub_sub_service_remove_connection_from_all_groups_request,
    build_web_pub_sub_service_remove_connection_from_group_request,
    build_web_pub_sub_service_remove_connections_from_groups_request,
    build_web_pub_sub_service_remove_user_from_all_groups_request,
    build_web_pub_sub_service_remove_user_from_group_request,
    build_web_pub_sub_service_revoke_permission_request,
    build_web_pub_sub_service_user_exists_request,
)
from ..._utils.model_base import SdkJSONEncoder, _deserialize
from ..._utils.utils import ClientMixinABC, raise_if_not_implemented
from .._configuration import WebPubSubServiceClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class _WebPubSubServiceClientOperationsMixin(  # pylint: disable=abstract-class-instantiated,too-many-public-methods
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], WebPubSubServiceClientConfiguration]
):

    def __init__(self) -> None:
        raise_if_not_implemented(
            self.__class__,
            [
                "send_to_all",
                "send_to_connection",
                "send_to_group",
                "send_to_user",
            ],
        )

    @distributed_trace_async
    async def get_service_status(self, **kwargs: Any) -> bool:
        """Get service health status.

        Get service health status.

        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_get_service_status_request(
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
        return 200 <= response.status_code <= 299

    @overload
    async def add_connections_to_groups(
        self, groups_to_add: _models.AddToGroupsRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add filtered connections to multiple groups.

        Add filtered connections to multiple groups.

        :param groups_to_add: Target groups and connection filter. Required.
        :type groups_to_add: ~azure.messaging.webpubsubservice.models.AddToGroupsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_connections_to_groups(
        self, groups_to_add: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add filtered connections to multiple groups.

        Add filtered connections to multiple groups.

        :param groups_to_add: Target groups and connection filter. Required.
        :type groups_to_add: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_connections_to_groups(
        self, groups_to_add: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add filtered connections to multiple groups.

        Add filtered connections to multiple groups.

        :param groups_to_add: Target groups and connection filter. Required.
        :type groups_to_add: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_connections_to_groups(
        self, groups_to_add: Union[_models.AddToGroupsRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Add filtered connections to multiple groups.

        Add filtered connections to multiple groups.

        :param groups_to_add: Target groups and connection filter. Is one of the following types:
         AddToGroupsRequest, JSON, IO[bytes] Required.
        :type groups_to_add: ~azure.messaging.webpubsubservice.models.AddToGroupsRequest or JSON or
         IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(groups_to_add, (IOBase, bytes)):
            _content = groups_to_add
        else:
            _content = json.dumps(groups_to_add, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_web_pub_sub_service_add_connections_to_groups_request(
            hub=self._config.hub,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def close_all_connections(
        self, *, excluded: Optional[List[str]] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Close the connections in the hub.

        Close the connections in the hub.

        :keyword excluded: Exclude these connectionIds when closing the connections in the hub. Default
         value is None.
        :paramtype excluded: list[str]
        :keyword reason: The reason closing the client connection. Default value is None.
        :paramtype reason: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_close_all_connections_request(
            hub=self._config.hub,
            excluded=excluded,
            reason=reason,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_client_access_token(
        self,
        *,
        user_id: Optional[str] = None,
        roles: Optional[List[str]] = None,
        minutes_to_expire: Optional[int] = None,
        groups: Optional[List[str]] = None,
        client_protocol: Optional[Union[str, _models.WebPubSubClientType]] = None,
        **kwargs: Any
    ) -> _models.ClientTokenResponse:
        """Generate token for the client to connect Azure Web PubSub service.

        Generate token for the client to connect Azure Web PubSub service.

        :keyword user_id: User Id. Default value is None.
        :paramtype user_id: str
        :keyword roles: Roles that the connection with the generated token will have. Default value is
         None.
        :paramtype roles: list[str]
        :keyword minutes_to_expire: The expire time of the generated token. Default value is None.
        :paramtype minutes_to_expire: int
        :keyword groups: Groups that the connection will join when it connects. Default value is None.
        :paramtype groups: list[str]
        :keyword client_protocol: The type of client. Case-insensitive. If not set, it's "Default". For
         Web
         PubSub for Socket.IO, only the default value is supported. For Web PubSub, the
         valid values are 'Default' and 'MQTT'. Known values are: "Default" and "mqtt". Default value
         is None.
        :paramtype client_protocol: str or ~azure.messaging.webpubsubservice.models.WebPubSubClientType
        :return: ClientTokenResponse. The ClientTokenResponse is compatible with MutableMapping
        :rtype: ~azure.messaging.webpubsubservice.models.ClientTokenResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ClientTokenResponse] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_get_client_access_token_request(
            hub=self._config.hub,
            user_id=user_id,
            roles=roles,
            minutes_to_expire=minutes_to_expire,
            groups=groups,
            client_protocol=client_protocol,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ClientTokenResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def remove_connections_from_groups(
        self,
        groups_to_remove: _models.RemoveFromGroupsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Remove filtered connections from multiple groups.

        Remove filtered connections from multiple groups.

        :param groups_to_remove: Target groups and connection filter. Required.
        :type groups_to_remove: ~azure.messaging.webpubsubservice.models.RemoveFromGroupsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_connections_from_groups(
        self, groups_to_remove: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove filtered connections from multiple groups.

        Remove filtered connections from multiple groups.

        :param groups_to_remove: Target groups and connection filter. Required.
        :type groups_to_remove: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_connections_from_groups(
        self, groups_to_remove: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove filtered connections from multiple groups.

        Remove filtered connections from multiple groups.

        :param groups_to_remove: Target groups and connection filter. Required.
        :type groups_to_remove: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_connections_from_groups(
        self, groups_to_remove: Union[_models.RemoveFromGroupsRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Remove filtered connections from multiple groups.

        Remove filtered connections from multiple groups.

        :param groups_to_remove: Target groups and connection filter. Is one of the following types:
         RemoveFromGroupsRequest, JSON, IO[bytes] Required.
        :type groups_to_remove: ~azure.messaging.webpubsubservice.models.RemoveFromGroupsRequest or
         JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(groups_to_remove, (IOBase, bytes)):
            _content = groups_to_remove
        else:
            _content = json.dumps(groups_to_remove, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_web_pub_sub_service_remove_connections_from_groups_request(
            hub=self._config.hub,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def close_connection(self, connection_id: str, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """Close the client connection.

        Close the client connection.

        :param connection_id: Target connection Id. Required.
        :type connection_id: str
        :keyword reason: The reason closing the client connection. Default value is None.
        :paramtype reason: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_close_connection_request(
            connection_id=connection_id,
            hub=self._config.hub,
            reason=reason,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def connection_exists(self, connection_id: str, **kwargs: Any) -> bool:
        """Check if the connection with the given connectionId exists.

        Check if the connection with the given connectionId exists.

        :param connection_id: The connection Id. Required.
        :type connection_id: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_connection_exists_request(
            connection_id=connection_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def remove_connection_from_all_groups(self, connection_id: str, **kwargs: Any) -> None:
        """Remove a connection from all groups.

        Remove a connection from all groups.

        :param connection_id: Target connection Id. Required.
        :type connection_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_remove_connection_from_all_groups_request(
            connection_id=connection_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def group_exists(self, group: str, **kwargs: Any) -> bool:
        """Check if there are any client connections inside the given group.

        Check if there are any client connections inside the given group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
         Required.
        :type group: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_group_exists_request(
            group=group,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def close_group_connections(
        self, group: str, *, excluded: Optional[List[str]] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Close connections in the specific group.

        Close connections in the specific group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
         Required.
        :type group: str
        :keyword excluded: Exclude these connectionIds when closing the connections in the group.
         Default value is None.
        :paramtype excluded: list[str]
        :keyword reason: The reason closing the client connection. Default value is None.
        :paramtype reason: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_close_group_connections_request(
            group=group,
            hub=self._config.hub,
            excluded=excluded,
            reason=reason,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_connections(
        self,
        group: str,
        *,
        top: Optional[int] = None,
        continuation_token_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.GroupMember"]:
        """List connections in a group.

        List connections in a group.

        :param group: Target group name, whose length should be greater than 0 and less than 1025.
         Required.
        :type group: str
        :keyword top: The maximum number of connections to return. If the value is not set, then all
         the connections in a group are returned. Default value is None.
        :paramtype top: int
        :keyword continuation_token_parameter: A token that allows the client to retrieve the next page
         of results. This
         parameter is provided by the service in the response of a previous request when
         there are additional results to be fetched. Clients should include the
         continuationToken in the next request to receive the subsequent page of data.
         If this parameter is omitted, the server will return the first page of results. Default value
         is None.
        :paramtype continuation_token_parameter: str
        :return: An iterator like instance of GroupMember
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.messaging.webpubsubservice.models.GroupMember]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.GroupMember]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_web_pub_sub_service_list_connections_request(
                    group=group,
                    hub=self._config.hub,
                    maxpagesize=maxpagesize,
                    top=top,
                    continuation_token_parameter=continuation_token_parameter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.GroupMember], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def remove_connection_from_group(self, group: str, connection_id: str, **kwargs: Any) -> None:
        """Remove a connection from the target group.

        Remove a connection from the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
         Required.
        :type group: str
        :param connection_id: Target connection Id. Required.
        :type connection_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_remove_connection_from_group_request(
            group=group,
            connection_id=connection_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def add_connection_to_group(self, group: str, connection_id: str, **kwargs: Any) -> None:
        """Add a connection to the target group.

        Add a connection to the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
         Required.
        :type group: str
        :param connection_id: Target connection Id. Required.
        :type connection_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_add_connection_to_group_request(
            group=group,
            connection_id=connection_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def revoke_permission(
        self,
        permission: Union[str, _models.WebPubSubPermission],
        connection_id: str,
        *,
        target_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Revoke permission for the connection.

        Revoke permission for the connection.

        :param permission: The permission: current supported actions are joinLeaveGroup and
         sendToGroup. Known values are: "sendToGroup" and "joinLeaveGroup". Required.
        :type permission: str or ~azure.messaging.webpubsubservice.models.WebPubSubPermission
        :param connection_id: Target connection Id. Required.
        :type connection_id: str
        :keyword target_name: The meaning of the target depends on the specific permission. For
         joinLeaveGroup and sendToGroup, targetName is a required parameter standing for
         the group name. Default value is None.
        :paramtype target_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_revoke_permission_request(
            permission=permission,
            connection_id=connection_id,
            hub=self._config.hub,
            target_name=target_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def has_permission(
        self,
        permission: Union[str, _models.WebPubSubPermission],
        connection_id: str,
        *,
        target_name: Optional[str] = None,
        **kwargs: Any
    ) -> bool:
        """Check if a connection has permission to the specified action.

        Check if a connection has permission to the specified action.

        :param permission: The permission: current supported actions are joinLeaveGroup and
         sendToGroup. Known values are: "sendToGroup" and "joinLeaveGroup". Required.
        :type permission: str or ~azure.messaging.webpubsubservice.models.WebPubSubPermission
        :param connection_id: Target connection Id. Required.
        :type connection_id: str
        :keyword target_name: The meaning of the target depends on the specific permission. For
         joinLeaveGroup and sendToGroup, targetName is a required parameter standing for
         the group name. Default value is None.
        :paramtype target_name: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_has_permission_request(
            permission=permission,
            connection_id=connection_id,
            hub=self._config.hub,
            target_name=target_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def grant_permission(
        self,
        permission: Union[str, _models.WebPubSubPermission],
        connection_id: str,
        *,
        target_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Grant permission to the connection.

        Grant permission to the connection.

        :param permission: The permission: current supported actions are joinLeaveGroup and
         sendToGroup. Known values are: "sendToGroup" and "joinLeaveGroup". Required.
        :type permission: str or ~azure.messaging.webpubsubservice.models.WebPubSubPermission
        :param connection_id: Target connection Id. Required.
        :type connection_id: str
        :keyword target_name: The meaning of the target depends on the specific permission. For
         joinLeaveGroup and sendToGroup, targetName is a required parameter standing for
         the group name. Default value is None.
        :paramtype target_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_grant_permission_request(
            permission=permission,
            connection_id=connection_id,
            hub=self._config.hub,
            target_name=target_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def user_exists(self, user_id: str, **kwargs: Any) -> bool:
        """Check if there are any client connections connected for the given user.

        Check if there are any client connections connected for the given user.

        :param user_id: Target user Id. Required.
        :type user_id: str
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_user_exists_request(
            user_id=user_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace_async
    async def close_user_connections(
        self, user_id: str, *, excluded: Optional[List[str]] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Close connections for the specific user.

        Close connections for the specific user.

        :param user_id: The user Id. Required.
        :type user_id: str
        :keyword excluded: Exclude these connectionIds when closing the connections for the user.
         Default value is None.
        :paramtype excluded: list[str]
        :keyword reason: The reason closing the client connection. Default value is None.
        :paramtype reason: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_close_user_connections_request(
            user_id=user_id,
            hub=self._config.hub,
            excluded=excluded,
            reason=reason,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def remove_user_from_all_groups(self, user_id: str, **kwargs: Any) -> None:
        """Remove a user from all groups.

        Remove a user from all groups.

        :param user_id: Target user Id. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_remove_user_from_all_groups_request(
            user_id=user_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def remove_user_from_group(self, group: str, user_id: str, **kwargs: Any) -> None:
        """Remove a user from the target group.

        Remove a user from the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
         Required.
        :type group: str
        :param user_id: Target user Id. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_remove_user_from_group_request(
            group=group,
            user_id=user_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def add_user_to_group(self, group: str, user_id: str, **kwargs: Any) -> None:
        """Add a user to the target group.

        Add a user to the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
         Required.
        :type group: str
        :param user_id: Target user Id. Required.
        :type user_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_web_pub_sub_service_add_user_to_group_request(
            group=group,
            user_id=user_id,
            hub=self._config.hub,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
