% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{merge.Assay}
\alias{merge.Assay}
\title{Merge Assays}
\usage{
\method{merge}{Assay}(
  x = NULL,
  y = NULL,
  add.cell.ids = NULL,
  merge.data = TRUE,
  labels = NULL,
  collapse = TRUE,
  ...
)
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{y}{One or more \code{\link{Assay}} objects}

\item{add.cell.ids}{A character vector of \code{length(x = c(x, y))};
appends the corresponding values to the start of each objects' cell names}

\item{merge.data}{Merge the data slots instead of just merging the counts
(which requires renormalization); this is recommended if the same
normalization approach was applied to all objects}

\item{labels, collapse}{Currently unused}

\item{...}{Ignored}
}
\value{
A new assay with data merged from \code{c(x, y)}
}
\description{
Merge one or more v3 assays together
}
\seealso{
v3 Assay object, validity, and interaction methods:
\code{\link{$.Assay}()},
\code{\link{Assay-class}},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[.Assay}()},
\code{\link{[[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{dimnames.Assay}()},
\code{\link{split.Assay}()},
\code{\link{subset.Assay}()}
}
\concept{assay}
