# `s390x-unknown-linux-musl`

**Tier: 3**

IBM z/Architecture (s390x) targets (including IBM Z and LinuxONE) running Linux.

## Target maintainers

[@uweigand](https://github.com/uweigand)

## Requirements

This target requires:

* Linux Kernel version 3.2 or later
* musl 1.2.5 or later

Code generated by the target uses the z/Architecture ISA assuming a minimum
architecture level of z10 (Eighth Edition of the z/Architecture Principles
of Operation), and is compliant with the s390x ELF ABI.

Reference material:

* [z/Architecture Principles of Operation][s390x-isa]
* [z/Architecture ELF Application Binary Interface][s390x-abi]

[s390x-isa]: https://publibfp.dhe.ibm.com/epubs/pdf/a227832d.pdf
[s390x-abi]: https://github.com/IBM/s390x-abi

## Building the target

Because it is Tier 3, Rust does not yet ship pre-compiled artifacts for this
target.

Therefore, you can build Rust with support for the target by adding it to the
target list in `bootstrap.toml`, a sample configuration is shown below.

```toml
[build]
target = ["s390x-unknown-linux-musl"]
```

## Building Rust programs

Rust does not yet ship pre-compiled artifacts for this target. To compile for
this target, you will first need to build Rust with the target enabled (see
"Building the target" above).

## Testing

There are no special requirements for testing and running the target.
For testing cross builds on the host, please refer to the "Cross-compilation
toolchains and C code" section below.

## Cross-compilation toolchains and C code

Rust code built using the target is compatible with C code compiled with
GCC or Clang using the `s390x-unknown-linux-musl` target triple (via either
native or cross-compilation).

Depending on your system, you may need to configure the target to use the GNU
GCC linker. To use it, add the following to your `.cargo/config.toml`:

```toml
[target.s390x-unknown-linux-musl]
linker = "s390x-linux-musl-gcc"
```

If your `s390x-linux-musl-*` toolchain is not in your `PATH` you may need to
configure additional settings:

```toml
[target.s390x-unknown-linux-musl]
# Adjust the paths to point at your toolchain
cc = "/TOOLCHAIN_PATH/bin/s390x-linux-musl-gcc"
cxx = "/TOOLCHAIN_PATH/bin/s390x-linux-musl-g++"
ar = "/TOOLCHAIN_PATH/bin/s390x-linux-musl-ar"
ranlib = "/TOOLCHAIN_PATH/bin/s390x-linux-musl-ranlib"
linker = "/TOOLCHAIN_PATH/bin/s390x-linux-musl-gcc"
```

To test cross compiled binaries on a non-s390x host, you can use
[`qemu`](https://www.qemu.org/docs/master/system/target-s390x.html).
