/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "audio/adlib_ctmidi.h"

const AdLibIbkInstrumentDefinition MidiDriver_ADLIB_CTMIDI::CTMIDI_INSTRUMENT_BANK[128] = {
	// 0x00
	{ 0x01, 0x11, 0x4f, 0x00, 0xf1, 0xd2, 0x51, 0x43, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x02, 0x12, 0x4f, 0x06, 0xf1, 0xd2, 0x51, 0x43, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x11, 0x4a, 0x04, 0xf1, 0xd2, 0x53, 0x74, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x03, 0x11, 0x4f, 0x04, 0xf1, 0xd2, 0x53, 0x74, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0x11, 0x66, 0x00, 0xf1, 0xd2, 0x51, 0xc3, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xc0, 0xd2, 0x52, 0x05, 0xf1, 0xd2, 0x53, 0x94, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x12, 0x18, 0x86, 0x00, 0xf3, 0xfc, 0x00, 0x33, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xd0, 0x12, 0x4e, 0x03, 0xa8, 0x92, 0x32, 0xa7, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x08
	{ 0xc8, 0xd1, 0x4f, 0x08, 0xf2, 0xf3, 0x64, 0x77, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x33, 0x34, 0x0e, 0x00, 0x01, 0x7d, 0x11, 0x34, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x17, 0x16, 0x50, 0x00, 0xd1, 0xd3, 0x52, 0x92, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe7, 0xe1, 0x21, 0x06, 0xf5, 0xf6, 0x77, 0x14, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x95, 0x81, 0x4e, 0x00, 0xda, 0xf9, 0x25, 0x15, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x27, 0x21, 0x1f, 0x03, 0xf5, 0xf5, 0x96, 0x57, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x87, 0xf1, 0x4e, 0x80, 0xb1, 0xe6, 0x33, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0x11, 0x87, 0x80, 0xa1, 0x7d, 0x11, 0x43, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x10
	{ 0x32, 0xb1, 0x8c, 0x03, 0x91, 0xa1, 0x07, 0x19, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0xb4, 0x54, 0x83, 0xf1, 0xf5, 0x07, 0x19, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x24, 0x21, 0x40, 0x53, 0xff, 0xff, 0x0f, 0x0f, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xd2, 0xf1, 0x44, 0x80, 0x91, 0xa1, 0x57, 0x09, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0x02, 0x52, 0x88, 0xf0, 0xf0, 0x1f, 0x1f, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x21, 0x32, 0x4f, 0x0b, 0xf2, 0x52, 0x0b, 0x0b, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf0, 0xf2, 0x93, 0x07, 0xd8, 0xb3, 0x0b, 0x0b, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x20, 0x31, 0x5d, 0x07, 0xf2, 0x52, 0x0b, 0x0b, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x18
	{ 0x01, 0x01, 0x1b, 0x04, 0xf4, 0xf3, 0x25, 0x46, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x11, 0x01, 0x0f, 0x07, 0xf4, 0xf3, 0x25, 0x46, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0x01, 0x27, 0x00, 0xf1, 0xf4, 0x1f, 0x88, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x12, 0x13, 0x44, 0x03, 0xea, 0xd2, 0x32, 0xe7, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x30, 0x31, 0x45, 0x00, 0xa4, 0xf5, 0x32, 0xe7, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x21, 0x21, 0x0f, 0x03, 0xf5, 0xf1, 0x17, 0x78, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0x20, 0x41, 0x07, 0xd1, 0xc1, 0x34, 0xa5, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x10, 0x12, 0x43, 0x02, 0xa7, 0xe3, 0x97, 0xe7, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x20
	{ 0x20, 0x21, 0x28, 0x01, 0xc5, 0xd2, 0x15, 0xa4, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x30, 0x21, 0x16, 0x05, 0xf2, 0xf3, 0x9f, 0x78, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x30, 0x21, 0x11, 0x05, 0x82, 0xf3, 0x9f, 0x78, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x21, 0x21, 0x23, 0x00, 0x73, 0x93, 0x1a, 0x87, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x30, 0x21, 0x0e, 0x09, 0x62, 0xf3, 0x55, 0x68, 0x02, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x30, 0x22, 0x0c, 0x00, 0x62, 0xd5, 0xb5, 0x98, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x70, 0x72, 0x93, 0x43, 0x64, 0xa1, 0x43, 0x43, 0x00, 0x00, 0x0a, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x30, 0x32, 0x8d, 0x85, 0x44, 0x92, 0x43, 0x43, 0x02, 0x00, 0x0a, 0x06, 0x00, 0x00, 0x00, 0x00 },
	// 0x28
	{ 0xe1, 0xe2, 0x4e, 0x00, 0x65, 0x61, 0x43, 0x44, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xa1, 0xa2, 0x8e, 0x05, 0x65, 0x63, 0x43, 0x45, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xb0, 0x61, 0x87, 0x40, 0xd1, 0x62, 0x11, 0x15, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf0, 0x20, 0x8a, 0x80, 0xb1, 0xa0, 0x11, 0x15, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf1, 0xe2, 0x89, 0x43, 0x73, 0x43, 0x01, 0x05, 0x02, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0x21, 0x57, 0x80, 0xf8, 0xf7, 0xf9, 0xe6, 0x03, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x32, 0x01, 0x24, 0x82, 0xf1, 0xf5, 0x35, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x04, 0x00, 0xaa, 0xd2, 0xc8, 0xb3, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x30
	{ 0xe0, 0xf1, 0x4f, 0x03, 0xd4, 0x55, 0x0b, 0x0b, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf0, 0x52, 0x00, 0x96, 0x35, 0x05, 0x01, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe1, 0xf1, 0x4f, 0x00, 0x36, 0x45, 0x05, 0x02, 0x02, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe2, 0xe1, 0x48, 0x81, 0x21, 0x41, 0x43, 0x45, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf1, 0x16, 0x00, 0x41, 0x20, 0x52, 0x72, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf1, 0x11, 0x00, 0x01, 0xd0, 0x52, 0x72, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf1, 0x1a, 0x00, 0x61, 0x30, 0x52, 0x73, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x50, 0x50, 0x0b, 0x07, 0x84, 0xa4, 0x4b, 0x99, 0x00, 0x00, 0x0a, 0x06, 0x00, 0x00, 0x00, 0x00 },
	// 0x38
	{ 0x31, 0x61, 0x1c, 0x84, 0x41, 0x92, 0x0b, 0x3b, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xb1, 0x61, 0x1c, 0x05, 0x41, 0x92, 0x1f, 0x3b, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x20, 0x21, 0x18, 0x00, 0x52, 0xa2, 0x15, 0x24, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xc1, 0xc1, 0x94, 0x84, 0x74, 0xa3, 0xea, 0xf5, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x21, 0x21, 0x28, 0x00, 0x41, 0x81, 0xb4, 0x98, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x21, 0x21, 0x1d, 0x01, 0x51, 0xe1, 0xae, 0x3e, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xe0, 0x93, 0x82, 0x51, 0x81, 0xa6, 0x97, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xe1, 0x93, 0x83, 0x51, 0xe1, 0xa6, 0x97, 0x02, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x40
	{ 0xe0, 0xf2, 0x4b, 0x0b, 0xd8, 0xb3, 0x0b, 0x0b, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf1, 0x49, 0x0b, 0xb8, 0xb3, 0x0b, 0x0b, 0x02, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf0, 0x4e, 0x0b, 0x98, 0xc3, 0x0b, 0x0b, 0x01, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf1, 0x4c, 0x0b, 0x88, 0xd3, 0x0b, 0x0b, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf1, 0xe4, 0xc5, 0x08, 0x7e, 0x8c, 0x17, 0x0e, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x60, 0x72, 0x4f, 0x0a, 0xd8, 0xb3, 0x0b, 0x0b, 0x00, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0x72, 0xd1, 0x80, 0xd5, 0x91, 0x19, 0x1b, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x32, 0x71, 0xc8, 0x80, 0xd5, 0x73, 0x19, 0x1b, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x48
	{ 0xe2, 0x62, 0x6a, 0x00, 0x9e, 0x55, 0x8f, 0x2a, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0x61, 0xec, 0x00, 0x7e, 0x65, 0x8f, 0x2a, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x62, 0xa2, 0x88, 0x8d, 0x84, 0x75, 0x27, 0x17, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x62, 0xa2, 0x84, 0x8d, 0x84, 0x75, 0x27, 0x17, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe3, 0x62, 0x6d, 0x00, 0x57, 0x57, 0x04, 0x77, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf1, 0xe1, 0x28, 0x00, 0x57, 0x67, 0x34, 0x5d, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xd1, 0x72, 0xc7, 0x03, 0x31, 0x42, 0x0f, 0x09, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf2, 0x72, 0xc7, 0x05, 0x51, 0x42, 0x05, 0x69, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x50
	{ 0x23, 0x31, 0x4f, 0x06, 0x51, 0x60, 0x5b, 0x25, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x22, 0x31, 0x48, 0x06, 0x31, 0xc0, 0x9b, 0x65, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf1, 0xe1, 0x28, 0x04, 0x57, 0x67, 0x34, 0x0d, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe1, 0xe1, 0x23, 0x00, 0x57, 0x67, 0x04, 0x4d, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe2, 0x31, 0x42, 0x12, 0x78, 0xf3, 0x0b, 0x0b, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe2, 0xe2, 0x21, 0x07, 0x11, 0x40, 0x52, 0x73, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x23, 0xa4, 0xc0, 0x00, 0x51, 0x35, 0x07, 0x79, 0x01, 0x02, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x24, 0xa0, 0xc0, 0x01, 0x51, 0x75, 0x07, 0x09, 0x01, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x58
	{ 0xe0, 0xf0, 0x16, 0x03, 0xb1, 0xe0, 0x51, 0x75, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x03, 0xa4, 0xc0, 0x04, 0x52, 0xf4, 0x03, 0x55, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe1, 0xe1, 0x93, 0x81, 0x31, 0xa1, 0xa6, 0x97, 0x01, 0x01, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf0, 0x71, 0xc4, 0x87, 0x10, 0x11, 0x01, 0xc1, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xc1, 0xe0, 0x4f, 0x00, 0xb1, 0x12, 0x53, 0x74, 0x02, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xc0, 0x41, 0x6d, 0x07, 0xf9, 0xf2, 0x21, 0xb3, 0x01, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe3, 0xe2, 0x4c, 0x07, 0x21, 0xa1, 0x43, 0x45, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe3, 0xe2, 0x0c, 0x09, 0x11, 0x80, 0x52, 0x73, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x60
	{ 0x26, 0x88, 0xc0, 0x00, 0x55, 0xf8, 0x47, 0x19, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x23, 0xe4, 0xd4, 0x00, 0xe5, 0x35, 0x03, 0x65, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x27, 0x32, 0xc0, 0x07, 0x32, 0xa4, 0x62, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xd0, 0x31, 0x4e, 0x03, 0x98, 0xa2, 0x32, 0x47, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf0, 0x71, 0xc0, 0x04, 0x93, 0x43, 0x03, 0x02, 0x01, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf1, 0x1a, 0x82, 0x13, 0x33, 0x52, 0x13, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe0, 0xf1, 0x1a, 0x04, 0x45, 0x32, 0xba, 0x91, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x11, 0x15, 0x18, 0x0d, 0x58, 0xa2, 0x02, 0x72, 0x01, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x68
	{ 0x10, 0x18, 0x80, 0x45, 0xf1, 0xf1, 0x53, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0x17, 0x86, 0x80, 0xa1, 0x7d, 0x11, 0x23, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x10, 0x18, 0x80, 0x40, 0xf1, 0xf6, 0x53, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0x34, 0x21, 0x02, 0xf5, 0x93, 0x56, 0xe8, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x03, 0x15, 0x4f, 0x03, 0xf1, 0xd6, 0x39, 0x74, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0x22, 0x43, 0x06, 0x6e, 0x8b, 0x17, 0x0c, 0x01, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x31, 0x22, 0x1c, 0x89, 0x61, 0x52, 0x03, 0x67, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x60, 0xf0, 0x0c, 0x89, 0x81, 0x61, 0x03, 0x0c, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x70
	{ 0x27, 0x05, 0x55, 0x05, 0x31, 0xa7, 0x62, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x95, 0x16, 0x81, 0x00, 0xe7, 0x96, 0x01, 0x67, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x0c, 0x01, 0x87, 0x80, 0xf0, 0xf2, 0x05, 0x05, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x35, 0x11, 0x44, 0x00, 0xf8, 0xf5, 0xff, 0x75, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x10, 0x10, 0x0b, 0x08, 0xa7, 0xd5, 0xec, 0xf5, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x20, 0x01, 0x0b, 0x07, 0xa8, 0xd6, 0xc8, 0xb7, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x01, 0x0b, 0x00, 0x88, 0xd5, 0xc4, 0xb7, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x0c, 0x10, 0x8f, 0x80, 0x41, 0x33, 0x31, 0x2b, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	// 0x78
	{ 0x17, 0xf7, 0x00, 0x00, 0x3b, 0xea, 0xdf, 0x97, 0x03, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x12, 0x18, 0x06, 0x09, 0x73, 0x3c, 0x02, 0x74, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x02, 0x08, 0x00, 0x02, 0x3e, 0x14, 0x01, 0xf3, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf5, 0xf6, 0xd4, 0x00, 0xeb, 0x45, 0x03, 0x68, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf0, 0xca, 0x00, 0xc0, 0xda, 0xb0, 0x71, 0x17, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf0, 0xe2, 0x00, 0xc0, 0x1e, 0x11, 0x11, 0x11, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xe7, 0xe8, 0x00, 0x0e, 0x34, 0x10, 0x00, 0xb2, 0x02, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x0c, 0x04, 0x00, 0x00, 0xf0, 0xf6, 0xf0, 0xe6, 0x02, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00 }
};

const int8 MidiDriver_ADLIB_CTMIDI::INSTRUMENT_TRANSPOSE[128] = {
	  0, -12,  12,   0,   0,  12, -12,   0,
	  0, -24,   0,   0,   0,   0,   0,   0,
	  0,   0, -12,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	 12,  12,  12,   0,   0,  12,  12,   0,
	-12, -12,   0,  12, -12, -12,   0,  12,
	  0,   0, -12,   0,   0,   0,  12,  12,
	  0,   0,  12,   0,   0,   0,  12,   0,
	  0,   0,  12,  12,   0,  12,   0,   0,
	  0,   0, -12, -12,   0,   0, -12, -12,
	  0,   0,   0,   0,   0, -12, -19,   0,
	  0, -12,   0,   0,   0,   0,   0,   0,
	-31, -12,   0,  12,  12,  12,  12,   0,
	 12,   0,  12,   0,   0,   0,   0,  12,
	  0,   0,   0,   0,  12,  12,  12,   0,
	  0,   0,   0,   0, -24, -36,   0,   0
};

const AdLibIbkInstrumentDefinition MidiDriver_ADLIB_CTMIDI::CTMIDI_RHYTHM_BANK[47] = {
	// 0x00
	{ 0x00, 0x00, 0x0b, 0x00, 0xa8, 0xd6, 0x4c, 0x45, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x0b, 0x00, 0xaa, 0xd2, 0xc8, 0xb7, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x26, 0x00, 0x00, 0x00, 0xf0, 0xfa, 0xf0, 0xb7, 0x03, 0x03, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x10, 0xc2, 0x07, 0x23, 0xf7, 0xe0, 0xf5, 0x41, 0x02, 0x02, 0x82, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0xf2, 0xf1, 0x0a, 0x38, 0x88, 0xad, 0xf4, 0x88, 0x02, 0x02, 0x02, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0xd0, 0xc2, 0x81, 0x23, 0xa6, 0xe0, 0xf6, 0x41, 0x02, 0x02, 0x81, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0x40, 0xc2, 0x00, 0x23, 0xf5, 0xe0, 0x38, 0x41, 0x00, 0x02, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xc2, 0x03, 0x23, 0xb8, 0xe0, 0xb5, 0x41, 0x01, 0x02, 0x7d, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	// 0x08
	{ 0x40, 0xc2, 0x00, 0x23, 0xf5, 0xe0, 0x38, 0x41, 0x00, 0x02, 0xf1, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xb3, 0x08, 0xc1, 0x88, 0x18, 0xa5, 0x50, 0x01, 0x00, 0xa3, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0xc2, 0x00, 0x23, 0xc6, 0xe0, 0x98, 0x41, 0x00, 0x02, 0x83, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xb3, 0x09, 0xc1, 0x86, 0x18, 0xa5, 0x50, 0x01, 0x00, 0xa3, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0xc2, 0x00, 0x23, 0xc6, 0xe0, 0x98, 0x41, 0x00, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0xc2, 0x00, 0x23, 0xc6, 0xe0, 0x98, 0x41, 0x00, 0x02, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x04, 0xc2, 0x0c, 0x23, 0xc5, 0xe0, 0xf6, 0x41, 0x00, 0x02, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xc2, 0x00, 0x23, 0xc6, 0xe0, 0x98, 0x41, 0x00, 0x02, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00 },
	// 0x10
	{ 0x01, 0xc2, 0x82, 0x23, 0xf6, 0xe0, 0xd5, 0x41, 0x01, 0x02, 0x83, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	{ 0x03, 0xbf, 0x09, 0xff, 0xe3, 0xd0, 0x97, 0x50, 0x00, 0x00, 0xbb, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	{ 0x0e, 0xbf, 0x07, 0xff, 0xb5, 0xd1, 0x15, 0x50, 0x01, 0x00, 0xbb, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x07, 0xc1, 0x77, 0xd1, 0x73, 0x50, 0x01, 0x00, 0xbb, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	{ 0x0e, 0xf1, 0xc7, 0x38, 0x95, 0xad, 0x78, 0x8e, 0x00, 0x02, 0x02, 0x09, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x00, 0xff, 0xf8, 0xd2, 0xb6, 0x50, 0x01, 0x00, 0xba, 0x0a, 0x00, 0x00, 0x00, 0x00 },
	{ 0x0a, 0xc2, 0xc7, 0x23, 0x95, 0xe0, 0x78, 0x41, 0x00, 0x02, 0x7c, 0x09, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x07, 0xc1, 0xf9, 0xd4, 0xb5, 0x50, 0x00, 0x00, 0xbb, 0x09, 0x00, 0x00, 0x00, 0x00 },
	// 0x18
	{ 0xd1, 0xc2, 0x05, 0x23, 0xe7, 0xe0, 0x65, 0x41, 0x01, 0x02, 0x9d, 0x09, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xfe, 0x00, 0x38, 0xe7, 0xa9, 0x94, 0x82, 0x00, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x00, 0xff, 0xe7, 0xd8, 0x94, 0x50, 0x00, 0x00, 0xbb, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x00, 0xff, 0x96, 0xd8, 0x67, 0x50, 0x00, 0x00, 0xba, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x00, 0xff, 0xb4, 0xda, 0x26, 0x50, 0x00, 0x00, 0xba, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x00, 0xc1, 0xb4, 0xdb, 0x26, 0x50, 0x00, 0x00, 0xba, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x95, 0x13, 0x81, 0x00, 0xe7, 0x95, 0x01, 0x65, 0x00, 0x00, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0x95, 0x13, 0x81, 0x00, 0xe7, 0x95, 0x01, 0x65, 0x00, 0x00, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x00 },
	// 0x20
	{ 0x10, 0xbf, 0x00, 0xc1, 0x96, 0xde, 0x67, 0x50, 0x00, 0x00, 0xba, 0x09, 0x00, 0x00, 0x00, 0x00 },
	{ 0x11, 0xbf, 0x00, 0xff, 0x96, 0xdf, 0x67, 0x50, 0x00, 0x00, 0xba, 0x09, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0xbf, 0x0e, 0xc1, 0x58, 0xd0, 0xdc, 0x50, 0x02, 0x00, 0xba, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0xbf, 0x0e, 0xff, 0x5a, 0xd2, 0xd6, 0x50, 0x02, 0x00, 0xba, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0x52, 0xbf, 0x07, 0xc1, 0x49, 0xd3, 0x04, 0x50, 0x03, 0x00, 0xbb, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x52, 0xbf, 0x07, 0xc1, 0x41, 0xd4, 0x02, 0x50, 0x03, 0x00, 0xbb, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0xbf, 0x0e, 0xff, 0x5a, 0xd5, 0xd6, 0x50, 0x01, 0x00, 0xba, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0x10, 0xbf, 0x0e, 0xc1, 0x53, 0xd6, 0x9f, 0x50, 0x01, 0x00, 0xba, 0x07, 0x00, 0x00, 0x00, 0x00 },
	// 0x28
	{ 0x11, 0xfe, 0x00, 0x38, 0xf5, 0xa9, 0x75, 0x80, 0x00, 0x02, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x04, 0xc2, 0x00, 0x23, 0xf8, 0xe0, 0xb6, 0x41, 0x01, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x04, 0xc2, 0x00, 0x23, 0xf8, 0xe0, 0xb7, 0x41, 0x01, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00 },
	{ 0x01, 0xbf, 0x0b, 0xc1, 0x5e, 0xd8, 0xdc, 0x50, 0x01, 0x00, 0xba, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0xbf, 0x07, 0xc1, 0x5c, 0xda, 0xdc, 0x50, 0x01, 0x00, 0xba, 0x07, 0x00, 0x00, 0x00, 0x00 },
	{ 0xc5, 0xd5, 0x4f, 0x00, 0xf2, 0xf4, 0x60, 0x7a, 0x00, 0x00, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00 },
	{ 0xc5, 0xd5, 0x4f, 0x00, 0xf2, 0xf2, 0x60, 0x72, 0x00, 0x00, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00 }
};

const uint8 MidiDriver_ADLIB_CTMIDI::RHYTHM_NOTE_INSTRUMENT_MAP[47] = {
	0x80, 0x81, 0x82, 0x83, 0x84,
	0x00, 0x8f, 0x87, 0x8f, 0x89, 0x8f, 0x8b, 0x8f,
	0x8f, 0x8e, 0x8f, 0x90, 0x00, 0x00, 0x93, 0x00,
	0xa0, 0x00, 0x00, 0x00, 0x99, 0x9a, 0x9b, 0x9c,
	0x9d, 0x8f, 0x8f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4,
	0xa5, 0xa6, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00
};

const uint8 MidiDriver_ADLIB_CTMIDI::RHYTHM_NOTES[47] = {
	0x2f, 0x24, 0x43, 0x3c, 0x3c,
	0x3c, 0x30, 0x3c, 0x34, 0x3c, 0x37, 0x3c, 0x3c,
	0x40, 0x3c, 0x43, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x30, 0x3c, 0x3c, 0x3c, 0x43, 0x3e, 0x43, 0x43,
	0x3c, 0x3c, 0x37, 0x35, 0x30, 0x3c, 0x3c, 0x4f,
	0x4f, 0x3c, 0x3c, 0x5b, 0x3c, 0x35, 0x3c, 0x3c,
	0x4f, 0x4f
};

const uint16 MidiDriver_ADLIB_CTMIDI::CTMIDI_NOTE_FREQUENCIES[768] = {
	0x0157, 0x0157, 0x0158, 0x0158, 0x0158, 0x0158, 0x0159, 0x0159,
	0x0159, 0x015A, 0x015A, 0x015A, 0x015B, 0x015B, 0x015B, 0x015C,
	0x015C, 0x015C, 0x015D, 0x015D, 0x015D, 0x015D, 0x015E, 0x015E,
	0x015E, 0x015F, 0x015F, 0x015F, 0x0160, 0x0160, 0x0160, 0x0161,
	0x0161, 0x0161, 0x0162, 0x0162, 0x0162, 0x0163, 0x0163, 0x0163,
	0x0164, 0x0164, 0x0164, 0x0164, 0x0165, 0x0165, 0x0165, 0x0166,
	0x0166, 0x0166, 0x0167, 0x0167, 0x0167, 0x0168, 0x0168, 0x0168,
	0x0169, 0x0169, 0x0169, 0x016A, 0x016A, 0x016A, 0x016B, 0x016B,
	0x016B, 0x016C, 0x016C, 0x016C, 0x016D, 0x016D, 0x016D, 0x016E,
	0x016E, 0x016E, 0x016F, 0x016F, 0x016F, 0x0170, 0x0170, 0x0170,
	0x0171, 0x0171, 0x0171, 0x0172, 0x0172, 0x0172, 0x0173, 0x0173,
	0x0173, 0x0174, 0x0174, 0x0174, 0x0175, 0x0175, 0x0175, 0x0176,
	0x0176, 0x0176, 0x0177, 0x0177, 0x0177, 0x0178, 0x0178, 0x0178,
	0x0179, 0x0179, 0x0179, 0x017A, 0x017A, 0x017A, 0x017B, 0x017B,
	0x017B, 0x017C, 0x017C, 0x017C, 0x017D, 0x017D, 0x017D, 0x017E,
	0x017E, 0x017E, 0x017F, 0x017F, 0x0180, 0x0180, 0x0180, 0x0181,
	0x0181, 0x0181, 0x0182, 0x0182, 0x0182, 0x0183, 0x0183, 0x0183,
	0x0184, 0x0184, 0x0184, 0x0185, 0x0185, 0x0185, 0x0186, 0x0186,
	0x0187, 0x0187, 0x0187, 0x0188, 0x0188, 0x0188, 0x0189, 0x0189,
	0x0189, 0x018A, 0x018A, 0x018A, 0x018B, 0x018B, 0x018B, 0x018C,
	0x018C, 0x018D, 0x018D, 0x018D, 0x018E, 0x018E, 0x018E, 0x018F,
	0x018F, 0x018F, 0x0190, 0x0190, 0x0191, 0x0191, 0x0191, 0x0192,
	0x0192, 0x0192, 0x0193, 0x0193, 0x0193, 0x0194, 0x0194, 0x0195,
	0x0195, 0x0195, 0x0196, 0x0196, 0x0196, 0x0197, 0x0197, 0x0197,
	0x0198, 0x0198, 0x0199, 0x0199, 0x0199, 0x019A, 0x019A, 0x019A,
	0x019B, 0x019B, 0x019C, 0x019C, 0x019C, 0x019D, 0x019D, 0x019D,
	0x019E, 0x019E, 0x019E, 0x019F, 0x019F, 0x01A0, 0x01A0, 0x01A0,
	0x01A1, 0x01A1, 0x01A1, 0x01A2, 0x01A2, 0x01A3, 0x01A3, 0x01A3,
	0x01A4, 0x01A4, 0x01A5, 0x01A5, 0x01A5, 0x01A6, 0x01A6, 0x01A6,
	0x01A7, 0x01A7, 0x01A8, 0x01A8, 0x01A8, 0x01A9, 0x01A9, 0x01A9,
	0x01AA, 0x01AA, 0x01AB, 0x01AB, 0x01AB, 0x01AC, 0x01AC, 0x01AD,
	0x01AD, 0x01AD, 0x01AE, 0x01AE, 0x01AE, 0x01AF, 0x01AF, 0x01B0,
	0x01B0, 0x01B0, 0x01B1, 0x01B1, 0x01B2, 0x01B2, 0x01B2, 0x01B3,
	0x01B3, 0x01B4, 0x01B4, 0x01B4, 0x01B5, 0x01B5, 0x01B6, 0x01B6,
	0x01B6, 0x01B7, 0x01B7, 0x01B8, 0x01B8, 0x01B8, 0x01B9, 0x01B9,
	0x01BA, 0x01BA, 0x01BA, 0x01BB, 0x01BB, 0x01BC, 0x01BC, 0x01BC,
	0x01BD, 0x01BD, 0x01BE, 0x01BE, 0x01BE, 0x01BF, 0x01BF, 0x01C0,
	0x01C0, 0x01C0, 0x01C1, 0x01C1, 0x01C2, 0x01C2, 0x01C2, 0x01C3,
	0x01C3, 0x01C4, 0x01C4, 0x01C4, 0x01C5, 0x01C5, 0x01C6, 0x01C6,
	0x01C6, 0x01C7, 0x01C7, 0x01C8, 0x01C8, 0x01C9, 0x01C9, 0x01C9,
	0x01CA, 0x01CA, 0x01CB, 0x01CB, 0x01CB, 0x01CC, 0x01CC, 0x01CD,
	0x01CD, 0x01CD, 0x01CE, 0x01CE, 0x01CF, 0x01CF, 0x01D0, 0x01D0,
	0x01D0, 0x01D1, 0x01D1, 0x01D2, 0x01D2, 0x01D3, 0x01D3, 0x01D3,
	0x01D4, 0x01D4, 0x01D5, 0x01D5, 0x01D5, 0x01D6, 0x01D6, 0x01D7,
	0x01D7, 0x01D8, 0x01D8, 0x01D8, 0x01D9, 0x01D9, 0x01DA, 0x01DA,
	0x01DB, 0x01DB, 0x01DB, 0x01DC, 0x01DC, 0x01DD, 0x01DD, 0x01DE,
	0x01DE, 0x01DE, 0x01DF, 0x01DF, 0x01E0, 0x01E0, 0x01E1, 0x01E1,
	0x01E1, 0x01E2, 0x01E2, 0x01E3, 0x01E3, 0x01E4, 0x01E4, 0x01E5,
	0x01E5, 0x01E5, 0x01E6, 0x01E6, 0x01E7, 0x01E7, 0x01E8, 0x01E8,
	0x01E8, 0x01E9, 0x01E9, 0x01EA, 0x01EA, 0x01EB, 0x01EB, 0x01EC,
	0x01EC, 0x01EC, 0x01ED, 0x01ED, 0x01EE, 0x01EE, 0x01EF, 0x01EF,
	0x01F0, 0x01F0, 0x01F0, 0x01F1, 0x01F1, 0x01F2, 0x01F2, 0x01F3,
	0x01F3, 0x01F4, 0x01F4, 0x01F5, 0x01F5, 0x01F5, 0x01F6, 0x01F6,
	0x01F7, 0x01F7, 0x01F8, 0x01F8, 0x01F9, 0x01F9, 0x01FA, 0x01FA,
	0x01FA, 0x01FB, 0x01FB, 0x01FC, 0x01FC, 0x01FD, 0x01FD, 0x01FE,
	0x01FE, 0x01FF, 0x01FF, 0x01FF, 0x0200, 0x0200, 0x0201, 0x0201,
	0x0202, 0x0202, 0x0203, 0x0203, 0x0204, 0x0204, 0x0205, 0x0205,
	0x0206, 0x0206, 0x0206, 0x0207, 0x0207, 0x0208, 0x0208, 0x0209,
	0x0209, 0x020A, 0x020A, 0x020B, 0x020B, 0x020C, 0x020C, 0x020D,
	0x020D, 0x020E, 0x020E, 0x020E, 0x020F, 0x020F, 0x0210, 0x0210,
	0x0211, 0x0211, 0x0212, 0x0212, 0x0213, 0x0213, 0x0214, 0x0214,
	0x0215, 0x0215, 0x0216, 0x0216, 0x0217, 0x0217, 0x0218, 0x0218,
	0x0219, 0x0219, 0x021A, 0x021A, 0x021A, 0x021B, 0x021B, 0x021C,
	0x021C, 0x021D, 0x021D, 0x021E, 0x021E, 0x021F, 0x021F, 0x0220,
	0x0220, 0x0221, 0x0221, 0x0222, 0x0222, 0x0223, 0x0223, 0x0224,
	0x0224, 0x0225, 0x0225, 0x0226, 0x0226, 0x0227, 0x0227, 0x0228,
	0x0228, 0x0229, 0x0229, 0x022A, 0x022A, 0x022B, 0x022B, 0x022C,
	0x022C, 0x022D, 0x022D, 0x022E, 0x022E, 0x022F, 0x022F, 0x0230,
	0x0230, 0x0231, 0x0231, 0x0232, 0x0232, 0x0233, 0x0233, 0x0234,
	0x0234, 0x0235, 0x0235, 0x0236, 0x0236, 0x0237, 0x0237, 0x0238,
	0x0238, 0x0239, 0x0239, 0x023A, 0x023B, 0x023B, 0x023C, 0x023C,
	0x023D, 0x023D, 0x023E, 0x023E, 0x023F, 0x023F, 0x0240, 0x0240,
	0x0241, 0x0241, 0x0242, 0x0242, 0x0243, 0x0243, 0x0244, 0x0244,
	0x0245, 0x0245, 0x0246, 0x0246, 0x0247, 0x0248, 0x0248, 0x0249,
	0x0249, 0x024A, 0x024A, 0x024B, 0x024B, 0x024C, 0x024C, 0x024D,
	0x024D, 0x024E, 0x024E, 0x024F, 0x024F, 0x0250, 0x0251, 0x0251,
	0x0252, 0x0252, 0x0253, 0x0253, 0x0254, 0x0254, 0x0255, 0x0255,
	0x0256, 0x0256, 0x0257, 0x0258, 0x0258, 0x0259, 0x0259, 0x025A,
	0x025A, 0x025B, 0x025B, 0x025C, 0x025C, 0x025D, 0x025E, 0x025E,
	0x025F, 0x025F, 0x0260, 0x0260, 0x0261, 0x0261, 0x0262, 0x0262,
	0x0263, 0x0264, 0x0264, 0x0265, 0x0265, 0x0266, 0x0266, 0x0267,
	0x0267, 0x0268, 0x0269, 0x0269, 0x026A, 0x026A, 0x026B, 0x026B,
	0x026C, 0x026C, 0x026D, 0x026E, 0x026E, 0x026F, 0x026F, 0x0270,
	0x0270, 0x0271, 0x0272, 0x0272, 0x0273, 0x0273, 0x0274, 0x0274,
	0x0275, 0x0275, 0x0276, 0x0277, 0x0277, 0x0278, 0x0278, 0x0279,
	0x0279, 0x027A, 0x027B, 0x027B, 0x027C, 0x027C, 0x027D, 0x027D,
	0x027E, 0x027F, 0x027F, 0x0280, 0x0280, 0x0281, 0x0282, 0x0282,
	0x0283, 0x0283, 0x0284, 0x0284, 0x0285, 0x0286, 0x0286, 0x0287,
	0x0287, 0x0288, 0x0289, 0x0289, 0x028A, 0x028A, 0x028B, 0x028B,
	0x028C, 0x028D, 0x028D, 0x028E, 0x028E, 0x028F, 0x0290, 0x0290,
	0x0291, 0x0291, 0x0292, 0x0293, 0x0293, 0x0294, 0x0294, 0x0295,
	0x0296, 0x0296, 0x0297, 0x0297, 0x0298, 0x0299, 0x0299, 0x029A,
	0x029A, 0x029B, 0x029C, 0x029C, 0x029D, 0x029D, 0x029E, 0x029F,
	0x029F, 0x02A0, 0x02A0, 0x02A1, 0x02A2, 0x02A2, 0x02A3, 0x02A3,
	0x02A4, 0x02A5, 0x02A5, 0x02A6, 0x02A6, 0x02A7, 0x02A8, 0x02A8,
	0x02A9, 0x02AA, 0x02AA, 0x02AB, 0x02AB, 0x02AC, 0x02AD, 0x02AD
};

const int8 MidiDriver_ADLIB_CTMIDI::NOTE_VOLUME_MODIFIER_VALUES[18] = {
	-63, -16,  -8,  -6,  -4,  -3,  -2,  -1,   0,   2,   4,   5,   6,   7,   8,   9,  10,  12
};

MidiDriver_ADLIB_CTMIDI::MidiDriver_ADLIB_CTMIDI(OPL::Config::OplType oplType, int timerFrequency) :
		MidiDriver_ADLIB_Multisource(oplType, timerFrequency) {
	memset(_ctmidiInstrumentBank, 0, sizeof(_ctmidiInstrumentBank));
	memset(_ctmidiRhythmBank, 0, sizeof(_ctmidiRhythmBank));

	_instrumentWriteMode = INSTRUMENT_WRITE_MODE_FIRST_NOTE_ON;
	_modulationDepth = MODULATION_DEPTH_LOW;
	_vibratoDepth = VIBRATO_DEPTH_LOW;
	_rhythmModeRewriteSharedRegister = true;
	// CTMIDI.DRV actually uses default volume 0x80, which is not a valid MIDI value.
	// This might cause marginally lower volumes in this implementation if a track
	// does not set volume controller values.
	setControllerDefault(MidiDriver_Multisource::CONTROLLER_DEFAULT_VOLUME, 0x7F);
}

int MidiDriver_ADLIB_CTMIDI::open() {
	// Initialize instrument banks
	for (int i = 0; i < 128; i++) {
		CTMIDI_INSTRUMENT_BANK[i].toOplInstrumentDefinition(_ctmidiInstrumentBank[i]);
		_ctmidiInstrumentBank[i].transpose = INSTRUMENT_TRANSPOSE[i];
	}

	_instrumentBank = _ctmidiInstrumentBank;

	for (int i = 0; i < 47; i++) {
		uint8 instrument = RHYTHM_NOTE_INSTRUMENT_MAP[i];
		uint8 rhythmBankIndex = instrument - 0x80;
		if (instrument < 0x80 || rhythmBankIndex >= 47) {
			// Unused or invalid instrument
			_ctmidiRhythmBank[i].rhythmType = RHYTHM_TYPE_UNDEFINED;
		} else {
			CTMIDI_RHYTHM_BANK[rhythmBankIndex].toOplInstrumentDefinition(_ctmidiRhythmBank[i]);
			_ctmidiRhythmBank[i].rhythmNote = RHYTHM_NOTES[i];
		}
	}

	_rhythmBank = _ctmidiRhythmBank;
	_rhythmBankFirstNote = 35;
	_rhythmBankLastNote = 75;

	int result = MidiDriver_ADLIB_Multisource::open();

	if (result == 0) {
		// Rhythm mode is permanently enabled in this driver
		setRhythmMode(true);
		initRhythmDefaults();
	}

	return result;
}

void MidiDriver_ADLIB_CTMIDI::deinitSource(uint8 source) {
	MidiDriver_ADLIB_Multisource::deinitSource(source);

	// Assume only the music source uses the rhythm channel
	if (source == 0)
		initRhythmDefaults();
}

void MidiDriver_ADLIB_CTMIDI::initRhythmDefaults() {
	// Write default block / F-num values for the rhythm channels
	writeRegister(0xA6, 0x00);
	writeRegister(0xB6, 0x0A);
	writeRegister(0xA7, 0x0B);
	writeRegister(0xB7, 0x0A);
	writeRegister(0xA8, 0x57);
	writeRegister(0xB8, 0x09);
}

void MidiDriver_ADLIB_CTMIDI::programChange(uint8 channel, uint8 program, uint8 source) {
	MidiDriver_ADLIB_Multisource::programChange(channel, program, source);

	// Deallocate all OPL channels from this MIDI channel that are not playing a note.
	// Note: original code also stops all active notes on this channel. This is
	// against the MIDI specification and is not implemented here.
	for (int i = 0; i < _numMelodicChannels; i++) {
		uint8 oplChannel = _melodicChannels[i];
		ActiveNote &activeNote = _activeNotes[oplChannel];
		if (activeNote.channelAllocated && activeNote.noteActive &&
				activeNote.source == source && activeNote.channel == channel) {
			activeNote.channelAllocated = false;
			activeNote.lastWrittenInstrumentId = -1;
		}
	}
}

uint8 MidiDriver_ADLIB_CTMIDI::allocateOplChannel(uint8 channel, uint8 source, InstrumentInfo &instrumentInfo) {
	if (channel == MIDI_RHYTHM_CHANNEL) {
		// For rhythm notes, just use the standard channel allocation
		return MidiDriver_ADLIB_Multisource::allocateOplChannel(channel, source, instrumentInfo);
	}

	// 1. Look for an OPL channel already allocated to this MIDI channel, but not playing a note
	// 2. Look for an unallocated OPL channel
	// 3. Look for an OPL channel allocated to another MIDI channel, but not playing a note
	// 4. Look for an OPL channel playing a note for this MIDI channel or a higher MIDI channel,
	//    with the lowest note counter value
	uint8 alreadyAllocatedChannel = 0xFF, unallocatedChannel = 0xFF, inactiveChannel = 0xFF, lowestCounterChannel = 0xFF;
	uint32 lowestNoteCounter = 0xFFFFFFFF;
	for (int i = 0; i < _numMelodicChannels; i++) {
		uint8 oplChannel = _melodicChannels[i];
		ActiveNote &activeNote = _activeNotes[oplChannel];
		if (activeNote.channelAllocated && activeNote.source == source && activeNote.channel == channel && !activeNote.noteActive) {
			alreadyAllocatedChannel = oplChannel;
			break;
		}
		if (unallocatedChannel == 0xFF && !activeNote.channelAllocated) {
			unallocatedChannel = oplChannel;
		}
		else if (inactiveChannel == 0xFF && activeNote.channelAllocated &&
				(activeNote.source != source || activeNote.channel != channel) && !activeNote.noteActive) {
			inactiveChannel = oplChannel;
		}
		else if (activeNote.channelAllocated && (activeNote.source != source || activeNote.channel >= channel) &&
				activeNote.noteActive && lowestNoteCounter > activeNote.noteCounterValue) {
			lowestCounterChannel = oplChannel;
			lowestNoteCounter = activeNote.noteCounterValue;
		}
	}

	uint8 allocatedChannel = 0xFF;
	if (alreadyAllocatedChannel != 0xFF) {
		allocatedChannel = alreadyAllocatedChannel;
	}
	else if (unallocatedChannel != 0xFF) {
		allocatedChannel = unallocatedChannel;
	}
	else if (inactiveChannel != 0xFF) {
		allocatedChannel = inactiveChannel;
	}
	else if (lowestCounterChannel != 0xFF) {
		allocatedChannel = lowestCounterChannel;
	}

	if (allocatedChannel != 0xFF) {
		_activeNotes[allocatedChannel].channelAllocated = true;
	}

	return allocatedChannel;
}

void MidiDriver_ADLIB_CTMIDI::writeFrequency(uint8 oplChannel, OplInstrumentRhythmType rhythmType) {
	Common::StackLock lock(_activeNotesMutex);

	if (rhythmType == RHYTHM_TYPE_CYMBAL || rhythmType == RHYTHM_TYPE_HI_HAT || rhythmType == RHYTHM_TYPE_SNARE_DRUM)
		// Frequency is not written for these rhythm instruments
		return;

	MidiDriver_ADLIB_Multisource::writeFrequency(oplChannel, rhythmType);

	if (rhythmType == RHYTHM_TYPE_TOM_TOM) {
		// For the tom-tom, write an additional harmonic frequency to OPL channel 7
		ActiveNote *activeNote = &_activeRhythmNotes[rhythmType - 1];
		// Transpose the note up by a perfect fifth
		uint8 oplNote = activeNote->oplNote + 7;
		if (oplNote > 0x7F)
			return;
		oplChannel = 7;

		// Calculate the frequency.
		uint16 channelOffset = determineChannelRegisterOffset(oplChannel, false);
		uint16 frequency = calculateFrequency(activeNote->channel, activeNote->source, oplNote);
		if (frequency == 0xFFFF)
			return;
		// Write the low 8 frequency bits.
		writeRegister(OPL_REGISTER_BASE_FNUMLOW + channelOffset, frequency & 0xFF);
		// Write the high 2 frequency bits and block.
		writeRegister(OPL_REGISTER_BASE_FNUMHIGH_BLOCK_KEYON + channelOffset, frequency >> 8);
	}
}

uint16 MidiDriver_ADLIB_CTMIDI::calculateFrequency(uint8 channel, uint8 source, uint8 note) {
	int32 noteValue = note << 6;
	noteValue += (((int32)_controlData[source][channel].pitchBend) - 0x2000) >> 6;
	// Transpose down 1 octave
	noteValue -= 0x300;
	if (noteValue < 0 || noteValue >= 0x1800)
		// Note value is out of range. Note should not be played.
		return 0xFFFF;

	uint16 block = noteValue / 0x300;
	uint16 fnum = CTMIDI_NOTE_FREQUENCIES[noteValue % 0x300];

	return (block << 10) | fnum;
}

uint8 MidiDriver_ADLIB_CTMIDI::calculateUnscaledVolume(uint8 channel, uint8 source, uint8 velocity,
		const OplInstrumentDefinition &instrumentDef, uint8 operatorNum) {
	if ((instrumentDef.rhythmType == RHYTHM_TYPE_UNDEFINED || instrumentDef.rhythmType == RHYTHM_TYPE_BASS_DRUM) &&
			operatorNum == 0) {
		// Original code does not apply velocity and channel volume to additive operators,
		// which is probably a bug.
		return instrumentDef.getOperatorDefinition(operatorNum).level & 0x3F;
	}

	// Determine a modifier value for the instrument definition operator volume
	// based on the note velocity and MIDI channel volume
	uint16 volumeModifierIndex = (((velocity << 1) | 1) * (_controlData[source][channel].volume << 1)) >> 11;
	volumeModifierIndex = (volumeModifierIndex >> 1) + (volumeModifierIndex & 0x1);
	assert(volumeModifierIndex >= 0 && volumeModifierIndex < 18);
	int8 volumeModifier = NOTE_VOLUME_MODIFIER_VALUES[volumeModifierIndex];

	uint8 operatorVolume = 0x3F - (instrumentDef.getOperatorDefinition(operatorNum).level & 0x3F);
	int16 volume = operatorVolume + volumeModifier;

	return 0x3F - CLIP(volume, (int16)0, (int16)0x3F);
}
