/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef PRINTER_H
#define PRINTER_H


#include <QObject>
#include <QtPlugin>
#include <QTimer>
#include <QListWidget>

#include "shell/interface.h"
#include "hoverwidget.h"
#include "imageutil.h"
#include "hoverbtn.h"
#include "titlelabel.h"
#include "fixlabel.h"
#include "settinggroup.h"
#include "ukccframe.h"
#include "printerbtn.h"
#include "addbutton.h"


namespace Ui {
class Printer;
}

class Printer : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:
    Printer();
    ~Printer();

    QString plugini18nName() Q_DECL_OVERRIDE;
    int pluginTypes() Q_DECL_OVERRIDE;
    QWidget * pluginUi() Q_DECL_OVERRIDE;
    const QString name() const  Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

public:
    void initUi(QWidget *widget);
    void initPrinterUi();
    void initComponent();
    void runExternalApp();
    void clearAutoItem();
    QString getPrinterInfo();

private:
    QString pluginName;
    int pluginType;
    QWidget *pluginWidget;
    SettingGroup *mPrinterWidget;
    UkccFrame *mAddWidget;
    TitleLabel *mPrinterLabel;
    QStringList mPrinterList;
    QVector <PrinterInfo> mPrinters;

    bool mFirstLoad;

public slots:
    void refreshPrinterDevSlot();

signals:
    void addsignal(QString);
    void removesignal(QString);

};

#endif // PRINTER_H
