/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef SHORTCUTUI_H
#define SHORTCUTUI_H

#include "settinggroup.h"
#include "addbutton.h"
#include "fixlabel.h"
#include "titlelabel.h"
#include "doubleclicklineedit.h"
#include "clickfixlabel.h"
#include "addshortcutdialog.h"

#include <QHBoxLayout>
#include <QWidget>
#include <QMenu>
#include <QMessageBox>

class ShortcutUi : public QWidget
{
    Q_OBJECT
public:
    ShortcutUi();
    ~ShortcutUi();
    void addSystemShortcut(const QString &name, const QString &shortcut, const QString &mediaKey, KeyEntryList *systemEntryList, KeyEntryList *customEntryList);
    void addCustomShortcut(KeyEntry keyEntry, KeyEntryList *systemEntryList, KeyEntryList *customEntryList);
    void clearCustomShorcutFrame();

private:
    void initUi();
    void initSystem();
    void initCustom();
    void updateGeneralShort(DoubleClickShortCut *shortCutEdit, QString key, QString value, bool isConflict);

    QString getShowShortcutString(QString src);
    QString keyToLib(QString key);
    QString conflictTip(const QString &key, const QString &value);
private:
    QVBoxLayout *uiLayout     = nullptr;
    QVBoxLayout *systemLayout = nullptr;
    QVBoxLayout *customLayout = nullptr;

private:
    TitleLabel   *systemTitle         = nullptr;
    SettingGroup *systemShortcutGroup = nullptr;

private:
    TitleLabel   *customTitle         = nullptr;
    SettingGroup *customShortcutGroup = nullptr;
    AddButton    *addButton           = nullptr;

    QList<KeyEntry>              mSystemEntryList;
    QList<KeyEntry>              mCustomEntryList;

    QList<DoubleClickShortCut *> mGeneralLineEdit;
    QList<ClickFixLabel *>       mGeneralName;
    QList<DoubleClickShortCut *> mCustomLineEdit;
    QList<ClickFixLabel *>       mCustomName;

    QMap<QString, QString>       mAllKeyI18nName;

Q_SIGNALS:
    void deleteShortcut(const QString &path);
    void toCreateShortcut(QString path, QString name, QString exec, QString key, bool buildFlag = true, bool convertFlag = true);
    void addButtonClicked();
    void updateSystemShortcut(const QString &key, const QString &value);
    void updateCustomShortcut(const QByteArray &path, const QString &key, const QString &value);
};

#endif // SHORTCUTUI_H
