/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.gui.Global;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.macro.Macro;
import rene.zirkel.objects.Circle3Object;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.SegmentObject;

public class CircleConstructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    boolean Fixed = false;
    FixedCircleObject C;
    ConstructionObject O;
    boolean ShowsValue;
    boolean ShowsName;
    int Moved;

    public CircleConstructor(boolean bl) {
        this.Fixed = bl;
    }

    public CircleConstructor() {
        this(false);
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zirkelCanvas.repaint();
            }
            this.showStatus(zirkelCanvas);
        } else if (mouseEvent.isShiftDown() || this.Fixed) {
            FixedCircleObject fixedCircleObject = new FixedCircleObject(zirkelCanvas.getConstruction(), this.P1, zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            zirkelCanvas.addObject(fixedCircleObject);
            fixedCircleObject.setDefaults();
            zirkelCanvas.repaint();
            this.C = fixedCircleObject;
            this.O = this.C;
            this.ShowsValue = fixedCircleObject.showValue();
            this.ShowsName = fixedCircleObject.showName();
            if (Global.getParameter("options.movefixname", true)) {
                this.C.setShowValue(true);
                this.C.setShowName(true);
            }
            this.Dragging = true;
            this.Moved = 0;
            this.P2 = null;
        } else {
            this.P2 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P2 != null) {
                if (this.P2 == this.P1) {
                    this.P2 = null;
                    return;
                }
                CircleObject circleObject = new CircleObject(zirkelCanvas.getConstruction(), this.P1, this.P2);
                zirkelCanvas.addObject(circleObject);
                circleObject.setDefaults();
                circleObject.validate();
                zirkelCanvas.repaint();
                if (this.P2.moveable() && !this.P2.isPointOn() && zirkelCanvas.isNewPoint()) {
                    this.ShowsValue = circleObject.showValue();
                    this.ShowsName = circleObject.showName();
                    if (Global.getParameter("options.movename", false)) {
                        circleObject.setShowValue(true);
                        circleObject.setShowName(true);
                    }
                    this.O = circleObject;
                    this.Dragging = true;
                    this.Moved = 0;
                } else {
                    this.P1.setSelected(false);
                    this.P2 = null;
                    this.P1 = null;
                    this.showStatus(zirkelCanvas);
                }
            }
        }
    }

    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 == null;
    }

    public void finishConstruction(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.P2 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
        if (this.P2 != null) {
            CircleObject circleObject = new CircleObject(zirkelCanvas.getConstruction(), this.P1, this.P2);
            zirkelCanvas.addObject(circleObject);
            circleObject.setDefaults();
            circleObject.validate();
            zirkelCanvas.repaint();
        }
        this.P2 = null;
    }

    public boolean waitForPoint() {
        return this.P1 == null || !this.Fixed;
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        ++this.Moved;
        if (this.P2 == null) {
            this.C.init(zirkelCanvas.getConstruction(), zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            if (this.C instanceof FixedCircleObject) {
                this.C.setDragable(this.Moved > 5);
            }
        } else {
            this.P2.move(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            zirkelCanvas.validate();
        }
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.setShowValue(this.ShowsValue);
        this.O.setShowName(this.ShowsName);
        zirkelCanvas.repaint();
        if (this.P2 == null) {
            this.P1.setSelected(false);
            this.P1 = null;
            this.C.round();
            if (this.Moved <= 5) {
                this.C.edit(zirkelCanvas);
                if (this.C instanceof FixedCircleObject && this.C.isEditAborted()) {
                    zirkelCanvas.delete(this.C);
                    zirkelCanvas.repaint();
                    this.reset(zirkelCanvas);
                }
            }
            this.C.validate();
            zirkelCanvas.check();
        } else {
            this.P1.setSelected(false);
            this.P2.updateText();
            this.P2 = null;
            this.P1 = null;
        }
        this.O.updateCircleDep();
        zirkelCanvas.repaint();
        zirkelCanvas.showStatus();
    }

    public PointObject select(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return zirkelCanvas.selectCreatePoint(n, n2);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        if (zirkelCanvas.Visual) {
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zirkelCanvas);
        } else {
            zirkelCanvas.setPrompt(Zirkel.name("prompt.circle"));
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.Fixed) {
            if (this.P1 == null) {
                zirkelCanvas.showStatus(Zirkel.name("message.fixedcircle.midpoint"));
            } else {
                zirkelCanvas.showStatus(Zirkel.name("message.fixedcircle.radius"));
            }
        } else if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.circle.midpoint"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.circle.radius"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        block23: {
            if (!this.testTree(xmlTree, "Circle")) {
                return false;
            }
            XmlTag xmlTag = xmlTree.getTag();
            try {
                if (!xmlTag.hasParam("midpoint")) {
                    throw new ConstructionException("Circle parameters missing!");
                }
                if (!xmlTag.hasParam("through")) {
                    if (xmlTag.hasParam("fixed")) {
                        PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("midpoint"));
                        FixedCircleObject fixedCircleObject = new FixedCircleObject(construction, pointObject, 0.0, 0.0);
                        construction.add(fixedCircleObject);
                        this.setConditionals(xmlTree, construction, fixedCircleObject);
                        this.setName(xmlTag, fixedCircleObject);
                        this.set(xmlTree, fixedCircleObject);
                        if (xmlTag.hasParam("partial")) {
                            fixedCircleObject.setPartial(true);
                        }
                        if (xmlTag.hasParam("filled")) {
                            fixedCircleObject.setFilled(true);
                        }
                        if (xmlTag.hasTrueParam("dragable")) {
                            fixedCircleObject.setDragable(true);
                        }
                        if (xmlTag.hasTrueParam("drawable")) {
                            fixedCircleObject.setDragable(true);
                        }
                        fixedCircleObject.setFixed(xmlTag.getValue("fixed"));
                        if (xmlTag.hasParam("start") && xmlTag.hasParam("end")) {
                            fixedCircleObject.setRange(xmlTag.getValue("start"), xmlTag.getValue("end"));
                        }
                        if (xmlTag.hasParam("acute")) {
                            fixedCircleObject.setObtuse(false);
                        }
                        if (xmlTag.hasParam("chord")) {
                            fixedCircleObject.setArc(false);
                        }
                    } else {
                        if (!(construction instanceof Macro)) {
                            throw new ConstructionException("Circle parameters missing!");
                        }
                        PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("midpoint"));
                        PrimitiveCircleObject primitiveCircleObject = new PrimitiveCircleObject(construction, pointObject);
                        this.setName(xmlTag, primitiveCircleObject);
                        this.set(xmlTree, primitiveCircleObject);
                        construction.add(primitiveCircleObject);
                        this.setConditionals(xmlTree, construction, primitiveCircleObject);
                    }
                    break block23;
                }
                PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("midpoint"));
                PointObject pointObject2 = (PointObject)construction.find(xmlTag.getValue("through"));
                CircleObject circleObject = new CircleObject(construction, pointObject, pointObject2);
                this.setName(xmlTag, circleObject);
                this.set(xmlTree, circleObject);
                construction.add(circleObject);
                this.setConditionals(xmlTree, construction, circleObject);
                if (xmlTag.hasParam("partial")) {
                    circleObject.setPartial(true);
                }
                if (xmlTag.hasParam("filled")) {
                    circleObject.setFilled(true);
                }
                if (xmlTag.hasParam("start") && xmlTag.hasParam("end")) {
                    circleObject.setRange(xmlTag.getValue("start"), xmlTag.getValue("end"));
                }
                if (xmlTag.hasParam("acute")) {
                    circleObject.setObtuse(false);
                }
                if (xmlTag.hasParam("chord")) {
                    circleObject.setArc(false);
                }
                if (!xmlTag.hasParam("fixed")) break block23;
                try {
                    circleObject.setFixed(true, xmlTag.getValue("fixed"));
                }
                catch (Exception exception) {
                    throw new ConstructionException("Fixed value illegal!");
                }
            }
            catch (ConstructionException constructionException) {
                throw constructionException;
            }
            catch (Exception exception) {
                throw new ConstructionException("Circle parameters illegal!");
            }
        }
        return true;
    }

    public String getTag() {
        return "Circle";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n > 3 || n == 0) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        if (!(constructionObject instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        if (n == 1) {
            PrimitiveCircleObject primitiveCircleObject = new PrimitiveCircleObject(construction, (PointObject)constructionObject);
            construction.add(primitiveCircleObject);
            primitiveCircleObject.setDefaults();
            if (!string.equals("")) {
                primitiveCircleObject.setNameCheck(string);
            }
            return;
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            Expression expression = new Expression(stringArray[1], construction, null);
            if (!expression.isValid()) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
            FixedCircleObject fixedCircleObject = new FixedCircleObject(construction, (PointObject)constructionObject, 0.0, 0.0);
            construction.add(fixedCircleObject);
            fixedCircleObject.setDefaults();
            fixedCircleObject.setFixed(stringArray[1]);
            fixedCircleObject.validate();
            if (!string.equals("")) {
                fixedCircleObject.setNameCheck(string);
            }
            return;
        }
        if (constructionObject2 instanceof SegmentObject) {
            Circle3Object circle3Object = new Circle3Object(construction, ((SegmentObject)constructionObject2).getP1(), ((SegmentObject)constructionObject2).getP2(), (PointObject)constructionObject);
            construction.add(circle3Object);
            circle3Object.setDefaults();
            if (!string.equals("")) {
                circle3Object.setNameCheck(string);
            }
            return;
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        if (n == 3) {
            ConstructionObject constructionObject3 = construction.find(stringArray[2]);
            if (constructionObject3 == null || !(constructionObject3 instanceof PointObject)) {
                CircleObject circleObject = new CircleObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2);
                if (!circleObject.canFix()) {
                    throw new ConstructionException(Zirkel.name("exception.canfix"));
                }
                circleObject.setFixed(true, stringArray[2]);
                if (!circleObject.isValidFix()) {
                    throw new ConstructionException(Zirkel.name("exception.fix") + " " + stringArray[2]);
                }
                construction.add(circleObject);
                circleObject.validate();
                if (!string.equals("")) {
                    circleObject.setNameCheck(string);
                }
                circleObject.setDefaults();
                return;
            }
            Circle3Object circle3Object = new Circle3Object(construction, (PointObject)constructionObject2, (PointObject)constructionObject3, (PointObject)constructionObject);
            construction.add(circle3Object);
            circle3Object.setDefaults();
            if (!string.equals("")) {
                circle3Object.setNameCheck(string);
            }
            return;
        }
        CircleObject circleObject = new CircleObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2);
        construction.add(circleObject);
        circleObject.setDefaults();
        if (!string.equals("")) {
            circleObject.setName(string);
        }
    }
}

