// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{AsyncResult, Cancellable, IOStream, ProxyAddress, ffi};
use glib::{prelude::*, translate::*};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "GProxy")]
    pub struct Proxy(Interface<ffi::GProxy, ffi::GProxyInterface>);

    match fn {
        type_ => || ffi::g_proxy_get_type(),
    }
}

impl Proxy {
    pub const NONE: Option<&'static Proxy> = None;

    #[doc(alias = "g_proxy_get_default_for_protocol")]
    #[doc(alias = "get_default_for_protocol")]
    pub fn default_for_protocol(protocol: &str) -> Option<Proxy> {
        unsafe {
            from_glib_full(ffi::g_proxy_get_default_for_protocol(
                protocol.to_glib_none().0,
            ))
        }
    }
}

pub trait ProxyExt: IsA<Proxy> + 'static {
    #[doc(alias = "g_proxy_connect")]
    fn connect(
        &self,
        connection: &impl IsA<IOStream>,
        proxy_address: &impl IsA<ProxyAddress>,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<IOStream, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::g_proxy_connect(
                self.as_ref().to_glib_none().0,
                connection.as_ref().to_glib_none().0,
                proxy_address.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_proxy_connect_async")]
    fn connect_async<P: FnOnce(Result<IOStream, glib::Error>) + 'static>(
        &self,
        connection: &impl IsA<IOStream>,
        proxy_address: &impl IsA<ProxyAddress>,
        cancellable: Option<&impl IsA<Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn connect_async_trampoline<
            P: FnOnce(Result<IOStream, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            unsafe {
                let mut error = std::ptr::null_mut();
                let ret = ffi::g_proxy_connect_finish(_source_object as *mut _, res, &mut error);
                let result = if error.is_null() {
                    Ok(from_glib_full(ret))
                } else {
                    Err(from_glib_full(error))
                };
                let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                    Box_::from_raw(user_data as *mut _);
                let callback: P = callback.into_inner();
                callback(result);
            }
        }
        let callback = connect_async_trampoline::<P>;
        unsafe {
            ffi::g_proxy_connect_async(
                self.as_ref().to_glib_none().0,
                connection.as_ref().to_glib_none().0,
                proxy_address.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn connect_future(
        &self,
        connection: &(impl IsA<IOStream> + Clone + 'static),
        proxy_address: &(impl IsA<ProxyAddress> + Clone + 'static),
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<IOStream, glib::Error>> + 'static>> {
        let connection = connection.clone();
        let proxy_address = proxy_address.clone();
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.connect_async(&connection, &proxy_address, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    #[doc(alias = "g_proxy_supports_hostname")]
    fn supports_hostname(&self) -> bool {
        unsafe {
            from_glib(ffi::g_proxy_supports_hostname(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl<O: IsA<Proxy>> ProxyExt for O {}
