/*
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License, version 2.1 as published by the Free Software
 * Foundation.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, you can obtain a copy at http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html
 * or from the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * Copyright (c) 2006 - 2009 Pentaho Corporation and Contributors.  All rights reserved.
 */

package org.pentaho.reporting.libraries.formula.function.information;

import org.pentaho.reporting.libraries.formula.FormulaTestBase;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;


/**
 * @author Cedric Pronzato
 */
public class ChooseFunctionTest extends FormulaTestBase
{
  public void testDefault() throws Exception
  {
    runDefaultTest();
  }

  public Object[][] createDataTest()
  {
    return new Object[][]
        {
            {"CHOOSE(3;\"Apple\";\"Orange\";\"Grape\";\"Perry\")", "Grape"},
            {"CHOOSE(0;\"Apple\";\"Orange\";\"Grape\";\"Perry\")", LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE},
            {"CHOOSE(5;\"Apple\";\"Orange\";\"Grape\";\"Perry\")", LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE},
//        {"CHOOSE(2;SUM([.B4:.B5]);SUM([.B5]))", Boolean.FALSE},
//        {"SUM(CHOOSE(2;[.B4:.B5];[.B5]))", Boolean.FALSE},
        };
  }

}
