/*
 * SPDX-FileCopyrightText: Copyright (c) 2021-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _BOARDS_NVSWITCH_H_
#define _BOARDS_NVSWITCH_H_

#include "common_nvswitch.h"

//
// NVSwitch board IDs
//
#define NVSWITCH_BOARD_UNKNOWN              0x0

#define NVSWITCH_BOARD_LS10_4840_0000_PC0   0x0396
#define NVSWITCH_BOARD_LS10_4840_0072_STA   0x0398
#define NVSWITCH_BOARD_LS10_5612_0002_890   0x03B7
#define NVSWITCH_BOARD_LS10_5612_0012_895   0x03B8
#define NVSWITCH_BOARD_LS10_5612_0002_ES    0x03D6
#define NVSWITCH_BOARD_LS10_4697_0000_895   0x03B9
#define NVSWITCH_BOARD_LS10_4262_0000_895   0x04FE
#define NVSWITCH_BOARD_LS10_4300_0000_895   0x0571

#define NVSWITCH_BOARD_UNKNOWN_NAME             "UNKNOWN"

#define NVSWITCH_BOARD_LS10_4840_0000_PC0_NAME  "LS10_4840_0000_PC0"
#define NVSWITCH_BOARD_LS10_4840_0072_STA_NAME  "LS10_4840_0072_STA"
#define NVSWITCH_BOARD_LS10_5612_0002_890_NAME  "LS10_5612_0002_890"
#define NVSWITCH_BOARD_LS10_5612_0012_895_NAME  "LS10_5612_0012_895"
#define NVSWITCH_BOARD_LS10_5612_0002_ES_NAME   "LS10_5612_0002_ES"
#define NVSWITCH_BOARD_LS10_4697_0000_895_NAME  "LS10_4697_0000_895"
#define NVSWITCH_BOARD_LS10_4262_0000_895_NAME  "LS10_4262_0000_895"
#define NVSWITCH_BOARD_LS10_4300_0000_895_NAME  "LS10_4300_0000_895"

#endif // _BOARDS_NVSWITCH_H_
