// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.


//---------------------------------------------------------------------------

//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: cmdstruct.h
//---------------------------------------------------------------------------

#pragma once

//   Debugger extensions should not have a table of types and associations
//  Type information be read dynamically from the symbol files.

//
// The API definition consists of a single array containing the size, name 
// and pointer to specific entry array produced above. This is for code 
// which needs to dispatch based on the command enum and needs to discover 
// the type information for the given command. It can loop the size and 
// process everything.
//

typedef struct
{
    CHAR name[100];
    CHAR type[100];
    bool fHasPayload;
    bool fTypePropertiesRead;
    ULONG64 TypeModule;
    ULONG TypeId;
    ULONG size;
} MILCOMMAND;

static MILCOMMAND MarshalCommands[] =
{
    /* 0x00 */ { NULL }, // MilCmdInvalid
    /* 0x01 */ { "MILCMD_TRANSPORT_SYNCFLUSH", "milcore!MILCMD_TRANSPORT_SYNCFLUSH", false, false, 0, 0, 0 }, // MilCmdTransportSyncFlush
    /* 0x02 */ { "MILCMD_TRANSPORT_DESTROYRESOURCESONCHANNEL", "milcore!MILCMD_TRANSPORT_DESTROYRESOURCESONCHANNEL", false, false, 0, 0, 0 }, // MilCmdTransportDestroyResourcesOnChannel
    /* 0x03 */ { "MILCMD_PARTITION_REGISTERFORNOTIFICATIONS", "milcore!MILCMD_PARTITION_REGISTERFORNOTIFICATIONS", false, false, 0, 0, 0 }, // MilCmdPartitionRegisterForNotifications
    /* 0x04 */ { "MILCMD_CHANNEL_REQUESTTIER", "milcore!MILCMD_CHANNEL_REQUESTTIER", false, false, 0, 0, 0 }, // MilCmdChannelRequestTier
    /* 0x05 */ { "MILCMD_PARTITION_SETVBLANKSYNCMODE", "milcore!MILCMD_PARTITION_SETVBLANKSYNCMODE", false, false, 0, 0, 0 }, // MilCmdPartitionSetVBlankSyncMode
    /* 0x06 */ { "MILCMD_PARTITION_NOTIFYPRESENT", "milcore!MILCMD_PARTITION_NOTIFYPRESENT", false, false, 0, 0, 0 }, // MilCmdPartitionNotifyPresent
    /* 0x07 */ { "MILCMD_CHANNEL_CREATERESOURCE", "milcore!MILCMD_CHANNEL_CREATERESOURCE", false, false, 0, 0, 0 }, // MilCmdChannelCreateResource
    /* 0x08 */ { "MILCMD_CHANNEL_DELETERESOURCE", "milcore!MILCMD_CHANNEL_DELETERESOURCE", false, false, 0, 0, 0 }, // MilCmdChannelDeleteResource
    /* 0x09 */ { "MILCMD_CHANNEL_DUPLICATEHANDLE", "milcore!MILCMD_CHANNEL_DUPLICATEHANDLE", false, false, 0, 0, 0 }, // MilCmdChannelDuplicateHandle
    /* 0x0a */ { "MILCMD_D3DIMAGE", "milcore!MILCMD_D3DIMAGE", false, false, 0, 0, 0 }, // MilCmdD3DImage
    /* 0x0b */ { "MILCMD_D3DIMAGE_PRESENT", "milcore!MILCMD_D3DIMAGE_PRESENT", false, false, 0, 0, 0 }, // MilCmdD3DImagePresent
    /* 0x0c */ { "MILCMD_BITMAP_SOURCE", "milcore!MILCMD_BITMAP_SOURCE", false, false, 0, 0, 0 }, // MilCmdBitmapSource
    /* 0x0d */ { "MILCMD_BITMAP_INVALIDATE", "milcore!MILCMD_BITMAP_INVALIDATE", false, false, 0, 0, 0 }, // MilCmdBitmapInvalidate
    /* 0x0e */ { "MILCMD_DOUBLERESOURCE", "milcore!MILCMD_DOUBLERESOURCE", false, false, 0, 0, 0 }, // MilCmdDoubleResource
    /* 0x0f */ { "MILCMD_COLORRESOURCE", "milcore!MILCMD_COLORRESOURCE", false, false, 0, 0, 0 }, // MilCmdColorResource
    /* 0x10 */ { "MILCMD_POINTRESOURCE", "milcore!MILCMD_POINTRESOURCE", false, false, 0, 0, 0 }, // MilCmdPointResource
    /* 0x11 */ { "MILCMD_RECTRESOURCE", "milcore!MILCMD_RECTRESOURCE", false, false, 0, 0, 0 }, // MilCmdRectResource
    /* 0x12 */ { "MILCMD_SIZERESOURCE", "milcore!MILCMD_SIZERESOURCE", false, false, 0, 0, 0 }, // MilCmdSizeResource
    /* 0x13 */ { "MILCMD_MATRIXRESOURCE", "milcore!MILCMD_MATRIXRESOURCE", false, false, 0, 0, 0 }, // MilCmdMatrixResource
    /* 0x14 */ { "MILCMD_POINT3DRESOURCE", "milcore!MILCMD_POINT3DRESOURCE", false, false, 0, 0, 0 }, // MilCmdPoint3DResource
    /* 0x15 */ { "MILCMD_VECTOR3DRESOURCE", "milcore!MILCMD_VECTOR3DRESOURCE", false, false, 0, 0, 0 }, // MilCmdVector3DResource
    /* 0x16 */ { "MILCMD_QUATERNIONRESOURCE", "milcore!MILCMD_QUATERNIONRESOURCE", false, false, 0, 0, 0 }, // MilCmdQuaternionResource
    /* 0x17 */ { "MILCMD_MEDIAPLAYER", "milcore!MILCMD_MEDIAPLAYER", false, false, 0, 0, 0 }, // MilCmdMediaPlayer
    /* 0x18 */ { "MILCMD_RENDERDATA", "milcore!MILCMD_RENDERDATA", true, false, 0, 0, 0 }, // MilCmdRenderData
    /* 0x19 */ { "MILCMD_ETWEVENTRESOURCE", "milcore!MILCMD_ETWEVENTRESOURCE", false, false, 0, 0, 0 }, // MilCmdEtwEventResource
    /* 0x1a */ { "MILCMD_VISUAL_CREATE", "milcore!MILCMD_VISUAL_CREATE", false, false, 0, 0, 0 }, // MilCmdVisualCreate
    /* 0x1b */ { "MILCMD_VISUAL_SETOFFSET", "milcore!MILCMD_VISUAL_SETOFFSET", false, false, 0, 0, 0 }, // MilCmdVisualSetOffset
    /* 0x1c */ { "MILCMD_VISUAL_SETTRANSFORM", "milcore!MILCMD_VISUAL_SETTRANSFORM", false, false, 0, 0, 0 }, // MilCmdVisualSetTransform
    /* 0x1d */ { "MILCMD_VISUAL_SETEFFECT", "milcore!MILCMD_VISUAL_SETEFFECT", false, false, 0, 0, 0 }, // MilCmdVisualSetEffect
    /* 0x1e */ { "MILCMD_VISUAL_SETCACHEMODE", "milcore!MILCMD_VISUAL_SETCACHEMODE", false, false, 0, 0, 0 }, // MilCmdVisualSetCacheMode
    /* 0x1f */ { "MILCMD_VISUAL_SETCLIP", "milcore!MILCMD_VISUAL_SETCLIP", false, false, 0, 0, 0 }, // MilCmdVisualSetClip
    /* 0x20 */ { "MILCMD_VISUAL_SETALPHA", "milcore!MILCMD_VISUAL_SETALPHA", false, false, 0, 0, 0 }, // MilCmdVisualSetAlpha
    /* 0x21 */ { "MILCMD_VISUAL_SETRENDEROPTIONS", "milcore!MILCMD_VISUAL_SETRENDEROPTIONS", false, false, 0, 0, 0 }, // MilCmdVisualSetRenderOptions
    /* 0x22 */ { "MILCMD_VISUAL_SETCONTENT", "milcore!MILCMD_VISUAL_SETCONTENT", false, false, 0, 0, 0 }, // MilCmdVisualSetContent
    /* 0x23 */ { "MILCMD_VISUAL_SETALPHAMASK", "milcore!MILCMD_VISUAL_SETALPHAMASK", false, false, 0, 0, 0 }, // MilCmdVisualSetAlphaMask
    /* 0x24 */ { "MILCMD_VISUAL_REMOVEALLCHILDREN", "milcore!MILCMD_VISUAL_REMOVEALLCHILDREN", false, false, 0, 0, 0 }, // MilCmdVisualRemoveAllChildren
    /* 0x25 */ { "MILCMD_VISUAL_REMOVECHILD", "milcore!MILCMD_VISUAL_REMOVECHILD", false, false, 0, 0, 0 }, // MilCmdVisualRemoveChild
    /* 0x26 */ { "MILCMD_VISUAL_INSERTCHILDAT", "milcore!MILCMD_VISUAL_INSERTCHILDAT", false, false, 0, 0, 0 }, // MilCmdVisualInsertChildAt
    /* 0x27 */ { "MILCMD_VISUAL_SETGUIDELINECOLLECTION", "milcore!MILCMD_VISUAL_SETGUIDELINECOLLECTION", true, false, 0, 0, 0 }, // MilCmdVisualSetGuidelineCollection
    /* 0x28 */ { "MILCMD_VISUAL_SETSCROLLABLEAREACLIP", "milcore!MILCMD_VISUAL_SETSCROLLABLEAREACLIP", false, false, 0, 0, 0 }, // MilCmdVisualSetScrollableAreaClip
    /* 0x29 */ { "MILCMD_VIEWPORT3DVISUAL_SETCAMERA", "milcore!MILCMD_VIEWPORT3DVISUAL_SETCAMERA", false, false, 0, 0, 0 }, // MilCmdViewport3DVisualSetCamera
    /* 0x2a */ { "MILCMD_VIEWPORT3DVISUAL_SETVIEWPORT", "milcore!MILCMD_VIEWPORT3DVISUAL_SETVIEWPORT", false, false, 0, 0, 0 }, // MilCmdViewport3DVisualSetViewport
    /* 0x2b */ { "MILCMD_VIEWPORT3DVISUAL_SET3DCHILD", "milcore!MILCMD_VIEWPORT3DVISUAL_SET3DCHILD", false, false, 0, 0, 0 }, // MilCmdViewport3DVisualSet3DChild
    /* 0x2c */ { "MILCMD_VISUAL3D_SETCONTENT", "milcore!MILCMD_VISUAL3D_SETCONTENT", false, false, 0, 0, 0 }, // MilCmdVisual3DSetContent
    /* 0x2d */ { "MILCMD_VISUAL3D_SETTRANSFORM", "milcore!MILCMD_VISUAL3D_SETTRANSFORM", false, false, 0, 0, 0 }, // MilCmdVisual3DSetTransform
    /* 0x2e */ { "MILCMD_VISUAL3D_REMOVEALLCHILDREN", "milcore!MILCMD_VISUAL3D_REMOVEALLCHILDREN", false, false, 0, 0, 0 }, // MilCmdVisual3DRemoveAllChildren
    /* 0x2f */ { "MILCMD_VISUAL3D_REMOVECHILD", "milcore!MILCMD_VISUAL3D_REMOVECHILD", false, false, 0, 0, 0 }, // MilCmdVisual3DRemoveChild
    /* 0x30 */ { "MILCMD_VISUAL3D_INSERTCHILDAT", "milcore!MILCMD_VISUAL3D_INSERTCHILDAT", false, false, 0, 0, 0 }, // MilCmdVisual3DInsertChildAt
    /* 0x31 */ { "MILCMD_HWNDTARGET_CREATE", "milcore!MILCMD_HWNDTARGET_CREATE", false, false, 0, 0, 0 }, // MilCmdHwndTargetCreate
    /* 0x32 */ { "MILCMD_HWNDTARGET_SUPPRESSLAYERED", "milcore!MILCMD_HWNDTARGET_SUPPRESSLAYERED", false, false, 0, 0, 0 }, // MilCmdHwndTargetSuppressLayered
    /* 0x33 */ { "MILCMD_TARGET_UPDATEWINDOWSETTINGS", "milcore!MILCMD_TARGET_UPDATEWINDOWSETTINGS", false, false, 0, 0, 0 }, // MilCmdTargetUpdateWindowSettings
    /* 0x34 */ { "MILCMD_GENERICTARGET_CREATE", "milcore!MILCMD_GENERICTARGET_CREATE", false, false, 0, 0, 0 }, // MilCmdGenericTargetCreate
    /* 0x35 */ { "MILCMD_TARGET_SETROOT", "milcore!MILCMD_TARGET_SETROOT", false, false, 0, 0, 0 }, // MilCmdTargetSetRoot
    /* 0x36 */ { "MILCMD_TARGET_SETCLEARCOLOR", "milcore!MILCMD_TARGET_SETCLEARCOLOR", false, false, 0, 0, 0 }, // MilCmdTargetSetClearColor
    /* 0x37 */ { "MILCMD_TARGET_INVALIDATE", "milcore!MILCMD_TARGET_INVALIDATE", true, false, 0, 0, 0 }, // MilCmdTargetInvalidate
    /* 0x38 */ { "MILCMD_TARGET_SETFLAGS", "milcore!MILCMD_TARGET_SETFLAGS", false, false, 0, 0, 0 }, // MilCmdTargetSetFlags
    /* 0x39 */ { "MILCMD_HWNDTARGET_DPICHANGED", "milcore!MILCMD_HWNDTARGET_DPICHANGED", false, false, 0, 0, 0 }, // MilCmdHwndTargetDpiChanged
    /* 0x3a */ { "MILCMD_GLYPHRUN_CREATE", "milcore!MILCMD_GLYPHRUN_CREATE", true, false, 0, 0, 0 }, // MilCmdGlyphRunCreate
    /* 0x3b */ { "MILCMD_DOUBLEBUFFEREDBITMAP", "milcore!MILCMD_DOUBLEBUFFEREDBITMAP", false, false, 0, 0, 0 }, // MilCmdDoubleBufferedBitmap
    /* 0x3c */ { "MILCMD_DOUBLEBUFFEREDBITMAP_COPYFORWARD", "milcore!MILCMD_DOUBLEBUFFEREDBITMAP_COPYFORWARD", false, false, 0, 0, 0 }, // MilCmdDoubleBufferedBitmapCopyForward
    /* 0x3d */ { "MILCMD_PARTITION_NOTIFYPOLICYCHANGEFORNONINTERACTIVEMODE", "milcore!MILCMD_PARTITION_NOTIFYPOLICYCHANGEFORNONINTERACTIVEMODE", false, false, 0, 0, 0 }, // MilCmdPartitionNotifyPolicyChangeForNonInteractiveMode
    /* 0x3e */ { "MILCMD_DRAW_LINE", "milcore!MILCMD_DRAW_LINE", false, false, 0, 0, 0 }, // MilDrawLine
    /* 0x3f */ { "MILCMD_DRAW_LINE_ANIMATE", "milcore!MILCMD_DRAW_LINE_ANIMATE", false, false, 0, 0, 0 }, // MilDrawLineAnimate
    /* 0x40 */ { "MILCMD_DRAW_RECTANGLE", "milcore!MILCMD_DRAW_RECTANGLE", false, false, 0, 0, 0 }, // MilDrawRectangle
    /* 0x41 */ { "MILCMD_DRAW_RECTANGLE_ANIMATE", "milcore!MILCMD_DRAW_RECTANGLE_ANIMATE", false, false, 0, 0, 0 }, // MilDrawRectangleAnimate
    /* 0x42 */ { "MILCMD_DRAW_ROUNDED_RECTANGLE", "milcore!MILCMD_DRAW_ROUNDED_RECTANGLE", false, false, 0, 0, 0 }, // MilDrawRoundedRectangle
    /* 0x43 */ { "MILCMD_DRAW_ROUNDED_RECTANGLE_ANIMATE", "milcore!MILCMD_DRAW_ROUNDED_RECTANGLE_ANIMATE", false, false, 0, 0, 0 }, // MilDrawRoundedRectangleAnimate
    /* 0x44 */ { "MILCMD_DRAW_ELLIPSE", "milcore!MILCMD_DRAW_ELLIPSE", false, false, 0, 0, 0 }, // MilDrawEllipse
    /* 0x45 */ { "MILCMD_DRAW_ELLIPSE_ANIMATE", "milcore!MILCMD_DRAW_ELLIPSE_ANIMATE", false, false, 0, 0, 0 }, // MilDrawEllipseAnimate
    /* 0x46 */ { "MILCMD_DRAW_GEOMETRY", "milcore!MILCMD_DRAW_GEOMETRY", false, false, 0, 0, 0 }, // MilDrawGeometry
    /* 0x47 */ { "MILCMD_DRAW_IMAGE", "milcore!MILCMD_DRAW_IMAGE", false, false, 0, 0, 0 }, // MilDrawImage
    /* 0x48 */ { "MILCMD_DRAW_IMAGE_ANIMATE", "milcore!MILCMD_DRAW_IMAGE_ANIMATE", false, false, 0, 0, 0 }, // MilDrawImageAnimate
    /* 0x49 */ { "MILCMD_DRAW_GLYPH_RUN", "milcore!MILCMD_DRAW_GLYPH_RUN", false, false, 0, 0, 0 }, // MilDrawGlyphRun
    /* 0x4a */ { "MILCMD_DRAW_DRAWING", "milcore!MILCMD_DRAW_DRAWING", false, false, 0, 0, 0 }, // MilDrawDrawing
    /* 0x4b */ { "MILCMD_DRAW_VIDEO", "milcore!MILCMD_DRAW_VIDEO", false, false, 0, 0, 0 }, // MilDrawVideo
    /* 0x4c */ { "MILCMD_DRAW_VIDEO_ANIMATE", "milcore!MILCMD_DRAW_VIDEO_ANIMATE", false, false, 0, 0, 0 }, // MilDrawVideoAnimate
    /* 0x4d */ { "MILCMD_PUSH_CLIP", "milcore!MILCMD_PUSH_CLIP", false, false, 0, 0, 0 }, // MilPushClip
    /* 0x4e */ { "MILCMD_PUSH_OPACITY_MASK", "milcore!MILCMD_PUSH_OPACITY_MASK", false, false, 0, 0, 0 }, // MilPushOpacityMask
    /* 0x4f */ { "MILCMD_PUSH_OPACITY", "milcore!MILCMD_PUSH_OPACITY", false, false, 0, 0, 0 }, // MilPushOpacity
    /* 0x50 */ { "MILCMD_PUSH_OPACITY_ANIMATE", "milcore!MILCMD_PUSH_OPACITY_ANIMATE", false, false, 0, 0, 0 }, // MilPushOpacityAnimate
    /* 0x51 */ { "MILCMD_PUSH_TRANSFORM", "milcore!MILCMD_PUSH_TRANSFORM", false, false, 0, 0, 0 }, // MilPushTransform
    /* 0x52 */ { "MILCMD_PUSH_GUIDELINE_SET", "milcore!MILCMD_PUSH_GUIDELINE_SET", false, false, 0, 0, 0 }, // MilPushGuidelineSet
    /* 0x53 */ { "MILCMD_PUSH_GUIDELINE_Y1", "milcore!MILCMD_PUSH_GUIDELINE_Y1", false, false, 0, 0, 0 }, // MilPushGuidelineY1
    /* 0x54 */ { "MILCMD_PUSH_GUIDELINE_Y2", "milcore!MILCMD_PUSH_GUIDELINE_Y2", false, false, 0, 0, 0 }, // MilPushGuidelineY2
    /* 0x55 */ { "MILCMD_PUSH_EFFECT", "milcore!MILCMD_PUSH_EFFECT", false, false, 0, 0, 0 }, // MilPushEffect
    /* 0x56 */ { "MILCMD_POP", "milcore!MILCMD_POP", false, false, 0, 0, 0 }, // MilPop
    /* 0x57 */ { "MILCMD_AXISANGLEROTATION3D", "milcore!MILCMD_AXISANGLEROTATION3D", false, false, 0, 0, 0 }, // MilCmdAxisAngleRotation3D
    /* 0x58 */ { "MILCMD_QUATERNIONROTATION3D", "milcore!MILCMD_QUATERNIONROTATION3D", false, false, 0, 0, 0 }, // MilCmdQuaternionRotation3D
    /* 0x59 */ { "MILCMD_PERSPECTIVECAMERA", "milcore!MILCMD_PERSPECTIVECAMERA", false, false, 0, 0, 0 }, // MilCmdPerspectiveCamera
    /* 0x5a */ { "MILCMD_ORTHOGRAPHICCAMERA", "milcore!MILCMD_ORTHOGRAPHICCAMERA", false, false, 0, 0, 0 }, // MilCmdOrthographicCamera
    /* 0x5b */ { "MILCMD_MATRIXCAMERA", "milcore!MILCMD_MATRIXCAMERA", false, false, 0, 0, 0 }, // MilCmdMatrixCamera
    /* 0x5c */ { "MILCMD_MODEL3DGROUP", "milcore!MILCMD_MODEL3DGROUP", true, false, 0, 0, 0 }, // MilCmdModel3DGroup
    /* 0x5d */ { "MILCMD_AMBIENTLIGHT", "milcore!MILCMD_AMBIENTLIGHT", false, false, 0, 0, 0 }, // MilCmdAmbientLight
    /* 0x5e */ { "MILCMD_DIRECTIONALLIGHT", "milcore!MILCMD_DIRECTIONALLIGHT", false, false, 0, 0, 0 }, // MilCmdDirectionalLight
    /* 0x5f */ { "MILCMD_POINTLIGHT", "milcore!MILCMD_POINTLIGHT", false, false, 0, 0, 0 }, // MilCmdPointLight
    /* 0x60 */ { "MILCMD_SPOTLIGHT", "milcore!MILCMD_SPOTLIGHT", false, false, 0, 0, 0 }, // MilCmdSpotLight
    /* 0x61 */ { "MILCMD_GEOMETRYMODEL3D", "milcore!MILCMD_GEOMETRYMODEL3D", false, false, 0, 0, 0 }, // MilCmdGeometryModel3D
    /* 0x62 */ { "MILCMD_MESHGEOMETRY3D", "milcore!MILCMD_MESHGEOMETRY3D", true, false, 0, 0, 0 }, // MilCmdMeshGeometry3D
    /* 0x63 */ { "MILCMD_MATERIALGROUP", "milcore!MILCMD_MATERIALGROUP", true, false, 0, 0, 0 }, // MilCmdMaterialGroup
    /* 0x64 */ { "MILCMD_DIFFUSEMATERIAL", "milcore!MILCMD_DIFFUSEMATERIAL", false, false, 0, 0, 0 }, // MilCmdDiffuseMaterial
    /* 0x65 */ { "MILCMD_SPECULARMATERIAL", "milcore!MILCMD_SPECULARMATERIAL", false, false, 0, 0, 0 }, // MilCmdSpecularMaterial
    /* 0x66 */ { "MILCMD_EMISSIVEMATERIAL", "milcore!MILCMD_EMISSIVEMATERIAL", false, false, 0, 0, 0 }, // MilCmdEmissiveMaterial
    /* 0x67 */ { "MILCMD_TRANSFORM3DGROUP", "milcore!MILCMD_TRANSFORM3DGROUP", true, false, 0, 0, 0 }, // MilCmdTransform3DGroup
    /* 0x68 */ { "MILCMD_TRANSLATETRANSFORM3D", "milcore!MILCMD_TRANSLATETRANSFORM3D", false, false, 0, 0, 0 }, // MilCmdTranslateTransform3D
    /* 0x69 */ { "MILCMD_SCALETRANSFORM3D", "milcore!MILCMD_SCALETRANSFORM3D", false, false, 0, 0, 0 }, // MilCmdScaleTransform3D
    /* 0x6a */ { "MILCMD_ROTATETRANSFORM3D", "milcore!MILCMD_ROTATETRANSFORM3D", false, false, 0, 0, 0 }, // MilCmdRotateTransform3D
    /* 0x6b */ { "MILCMD_MATRIXTRANSFORM3D", "milcore!MILCMD_MATRIXTRANSFORM3D", false, false, 0, 0, 0 }, // MilCmdMatrixTransform3D
    /* 0x6c */ { "MILCMD_PIXELSHADER", "milcore!MILCMD_PIXELSHADER", true, false, 0, 0, 0 }, // MilCmdPixelShader
    /* 0x6d */ { "MILCMD_IMPLICITINPUTBRUSH", "milcore!MILCMD_IMPLICITINPUTBRUSH", false, false, 0, 0, 0 }, // MilCmdImplicitInputBrush
    /* 0x6e */ { "MILCMD_BLUREFFECT", "milcore!MILCMD_BLUREFFECT", false, false, 0, 0, 0 }, // MilCmdBlurEffect
    /* 0x6f */ { "MILCMD_DROPSHADOWEFFECT", "milcore!MILCMD_DROPSHADOWEFFECT", false, false, 0, 0, 0 }, // MilCmdDropShadowEffect
    /* 0x70 */ { "MILCMD_SHADEREFFECT", "milcore!MILCMD_SHADEREFFECT", true, false, 0, 0, 0 }, // MilCmdShaderEffect
    /* 0x71 */ { "MILCMD_DRAWINGIMAGE", "milcore!MILCMD_DRAWINGIMAGE", false, false, 0, 0, 0 }, // MilCmdDrawingImage
    /* 0x72 */ { "MILCMD_TRANSFORMGROUP", "milcore!MILCMD_TRANSFORMGROUP", true, false, 0, 0, 0 }, // MilCmdTransformGroup
    /* 0x73 */ { "MILCMD_TRANSLATETRANSFORM", "milcore!MILCMD_TRANSLATETRANSFORM", false, false, 0, 0, 0 }, // MilCmdTranslateTransform
    /* 0x74 */ { "MILCMD_SCALETRANSFORM", "milcore!MILCMD_SCALETRANSFORM", false, false, 0, 0, 0 }, // MilCmdScaleTransform
    /* 0x75 */ { "MILCMD_SKEWTRANSFORM", "milcore!MILCMD_SKEWTRANSFORM", false, false, 0, 0, 0 }, // MilCmdSkewTransform
    /* 0x76 */ { "MILCMD_ROTATETRANSFORM", "milcore!MILCMD_ROTATETRANSFORM", false, false, 0, 0, 0 }, // MilCmdRotateTransform
    /* 0x77 */ { "MILCMD_MATRIXTRANSFORM", "milcore!MILCMD_MATRIXTRANSFORM", false, false, 0, 0, 0 }, // MilCmdMatrixTransform
    /* 0x78 */ { "MILCMD_LINEGEOMETRY", "milcore!MILCMD_LINEGEOMETRY", false, false, 0, 0, 0 }, // MilCmdLineGeometry
    /* 0x79 */ { "MILCMD_RECTANGLEGEOMETRY", "milcore!MILCMD_RECTANGLEGEOMETRY", false, false, 0, 0, 0 }, // MilCmdRectangleGeometry
    /* 0x7a */ { "MILCMD_ELLIPSEGEOMETRY", "milcore!MILCMD_ELLIPSEGEOMETRY", false, false, 0, 0, 0 }, // MilCmdEllipseGeometry
    /* 0x7b */ { "MILCMD_GEOMETRYGROUP", "milcore!MILCMD_GEOMETRYGROUP", true, false, 0, 0, 0 }, // MilCmdGeometryGroup
    /* 0x7c */ { "MILCMD_COMBINEDGEOMETRY", "milcore!MILCMD_COMBINEDGEOMETRY", false, false, 0, 0, 0 }, // MilCmdCombinedGeometry
    /* 0x7d */ { "MILCMD_PATHGEOMETRY", "milcore!MILCMD_PATHGEOMETRY", true, false, 0, 0, 0 }, // MilCmdPathGeometry
    /* 0x7e */ { "MILCMD_SOLIDCOLORBRUSH", "milcore!MILCMD_SOLIDCOLORBRUSH", false, false, 0, 0, 0 }, // MilCmdSolidColorBrush
    /* 0x7f */ { "MILCMD_LINEARGRADIENTBRUSH", "milcore!MILCMD_LINEARGRADIENTBRUSH", true, false, 0, 0, 0 }, // MilCmdLinearGradientBrush
    /* 0x80 */ { "MILCMD_RADIALGRADIENTBRUSH", "milcore!MILCMD_RADIALGRADIENTBRUSH", true, false, 0, 0, 0 }, // MilCmdRadialGradientBrush
    /* 0x81 */ { "MILCMD_IMAGEBRUSH", "milcore!MILCMD_IMAGEBRUSH", false, false, 0, 0, 0 }, // MilCmdImageBrush
    /* 0x82 */ { "MILCMD_DRAWINGBRUSH", "milcore!MILCMD_DRAWINGBRUSH", false, false, 0, 0, 0 }, // MilCmdDrawingBrush
    /* 0x83 */ { "MILCMD_VISUALBRUSH", "milcore!MILCMD_VISUALBRUSH", false, false, 0, 0, 0 }, // MilCmdVisualBrush
    /* 0x84 */ { "MILCMD_BITMAPCACHEBRUSH", "milcore!MILCMD_BITMAPCACHEBRUSH", false, false, 0, 0, 0 }, // MilCmdBitmapCacheBrush
    /* 0x85 */ { "MILCMD_DASHSTYLE", "milcore!MILCMD_DASHSTYLE", true, false, 0, 0, 0 }, // MilCmdDashStyle
    /* 0x86 */ { "MILCMD_PEN", "milcore!MILCMD_PEN", false, false, 0, 0, 0 }, // MilCmdPen
    /* 0x87 */ { "MILCMD_GEOMETRYDRAWING", "milcore!MILCMD_GEOMETRYDRAWING", false, false, 0, 0, 0 }, // MilCmdGeometryDrawing
    /* 0x88 */ { "MILCMD_GLYPHRUNDRAWING", "milcore!MILCMD_GLYPHRUNDRAWING", false, false, 0, 0, 0 }, // MilCmdGlyphRunDrawing
    /* 0x89 */ { "MILCMD_IMAGEDRAWING", "milcore!MILCMD_IMAGEDRAWING", false, false, 0, 0, 0 }, // MilCmdImageDrawing
    /* 0x8a */ { "MILCMD_VIDEODRAWING", "milcore!MILCMD_VIDEODRAWING", false, false, 0, 0, 0 }, // MilCmdVideoDrawing
    /* 0x8b */ { "MILCMD_DRAWINGGROUP", "milcore!MILCMD_DRAWINGGROUP", true, false, 0, 0, 0 }, // MilCmdDrawingGroup
    /* 0x8c */ { "MILCMD_GUIDELINESET", "milcore!MILCMD_GUIDELINESET", true, false, 0, 0, 0 }, // MilCmdGuidelineSet
    /* 0x8d */ { "MILCMD_BITMAPCACHE", "milcore!MILCMD_BITMAPCACHE", false, false, 0, 0, 0 }, // MilCmdBitmapCache
};



