### Concat Decoder Specification
### Inputs
The decompressor for the 'concat' codecs take 2 inputs:

- a numeric inputs, which contains the size of each segment to regenerate
- an input of type $T$ (either serial, numeric, struct, or string) and element width $n$ for numeric and struct types, which contains all segments concatenated in order

### Decoding
The first input is expected to host 32-bit unsigned values. It must contain as many numeric values as the number of segments to regenerate, and therefore have at least one value. The sum of all values in the sizes input must be strictly equal to the number of elements in the second input. Any deviation from these conditions is considered a corruption. The ouputs are generated by splitting the second input into segments of size indicated by the sizes input. Denoting the $i_{th}$ element of the first input $S_i$, the $k_{th}$ output will have size equal to $S_k$, containing the elements of the second input from the index $\sum_{i = 1}^{k-1} S_i$.

### Outputs
The outputs of the decompressor are $N$ outputs, equal to the length of the first input, that has type $T$ and width $n$
