doc ///
Key
  "VSP(F_Q,9)"
Headline
  Computation appearing in the proof of Theorem 5.16 in [QQ]
Description
  Text
    Let S be the ring $S$ and SQ be $S_{Q}$.
  Example
    S=QQ[h_1..h_4];
    SQ=QQ[x0,x1,y0,y1, Degrees=>{{1,0},{1,0},{0,1},{0,1}}];--quadric surface in PP^3
    A=gens kernel matrix{{h_1,h_2,h_3,h_4}};
    B=A++A++A++A++A++A;-- this gives a resolution of 6U
  Text
    Let $F_Q$ be a (4,4)-form, the restriction of a quartic form $F$ of type [100].  IS23 is the matrix of
    generators of $F_Q^{\perp}(2,3)$. The big matrix ZX represents the
    multiplication map $\rho$ from the resolution of $U\otimes
    F^{\perp}(2,3) \to S(3,4)$.
  Example
    F_{Q}=x0^4*y0^4+x1^4*y0^4+x0^3*x1*y0*y1^3+x0^2*x1^2*y0^2*y1^2+x1^4*y1^4
    IS23=((gens intersect(inverseSystem(F_{Q}), ((ideal(x0,x1))^2*(ideal(y0,y1))^3)))); --F_{Q}^\perp(2,3)
    ZX=sub((coefficients(
	IS23**matrix{{x0*y0,x1*y0,x0*y1,x1*y1}}
	,  Monomials=>gens  ((ideal(x0,x1))^3*(ideal(y0,y1))^4)))_1, S)*B;-- the big matrix representing the multiplication map from the resolution of U\otimes F^{\perp}(2,3) to S(3,4) 
    Z1=submatrix(ZX,{0,1,2,3,4,5,6,7,8,9,10,11,13,14,15,16,17,18},{1,2,4,6,8,10,13,15,17,19,22,23,25,28,29,32,34,35});
  Text
    Compute the ideal X that defines $VSP(F_{Q}, 9)$.
  Example
    D1=ideal det Z1;--rank <= 17 locus
    X1=decompose D1
    X=(X1)_5--the ideal generated by X(F_{Q})
  Text
    We check that $VSP(F_{Q}, 9)$ is smooth.
  Example
    JX=ideal flatten jacobian X;
    JX=ideal mingens JX;
    codim JX
  Text
    We check that the quartic form which defines $VSP(F_{Q})$ is of type [000]. 
  Example
    IX=inverseSystem X;
    betti res IX
  Text
    There is a function that gives us the type directly too.
  Example
    quarticType X_0
SeeAlso
  (quarticType, RingElement)
  "[QQ]"
///
