#ifndef __NAPT_PACKAGE_H_2024_11_10
#define __NAPT_PACKAGE_H_2024_11_10

#include "ipackage.h"

namespace NApt {

class Package : public IPackage
{
    QString _name;
    QString _architecture;
    QString _availableVersion;
    QString _installedVersion;
    QString _shortDescription;
    InstalledState _installedState;

public:
    Package(
        const QString& name,
        const QString& architecture,
        const QString& availableVersion,
        const QString& installedVersion,
        const QString& shortDescription,
        InstalledState installedState
    ) : _name(name),
        _architecture(architecture),
        _availableVersion(availableVersion),
        _installedVersion(installedVersion),
        _shortDescription(shortDescription),
        _installedState(installedState) {}

    virtual ~Package() override = default;

    QString name() const override { return _name; }
    QString architecture() const override { return _architecture; }
    QString availableVersion() const override { return _availableVersion; }
    QString installedVersion() const override { return _installedVersion; }
    InstalledState installedState() const override { return _installedState; }
    QString shortDescription() const override { return _shortDescription; }
};

}

#endif // __NAPT_PACKAGE_H_2024_11_10
