# Stubs for pysolar.util (Python 3.6)

import datetime
import numpy  # https://stackoverflow.com/questions/21968643/what-is-a-scalar-in-numpy  https://stackoverflow.com/questions/40378427/numpy-formal-definition-of-array-like-objects
from typing import Tuple, Union

AM_default: float
TL_default: float
SC_default: float
TY_default: float
elevation_default: float

def get_sunrise_sunset_transit(latitude_deg:float, longitude_deg:float, when:datetime.datetime) -> Tuple[datetime.datetime, datetime.datetime, datetime.datetime]: ...
def get_sunrise_sunset(latitude_deg:float, longitude_deg:float, when:datetime.datetime) -> Tuple[datetime.datetime, datetime.datetime]: ...
def get_sunrise_time(latitude_deg:float, longitude_deg:float, when:datetime.datetime) -> datetime.datetime: ...
def get_sunset_time(latitude_deg:float, longitude_deg:float, when:datetime.datetime) -> datetime.datetime: ...
def get_transit_time(latitude_deg:float, longitude_deg:float, when:datetime.datetime) -> datetime.datetime: ...
def mean_earth_sun_distance(when:datetime.datetime) -> float: ...
def extraterrestrial_irrad(when:datetime.datetime, latitude_deg:float, longitude_deg:float, SC:float = ...) -> float: ...
def declination_degree(when:datetime.datetime, TY:float = ...) -> float: ...
def solarelevation_function_clear(latitude_deg:float, longitude_deg:float, when:datetime.datetime, temperature:float = ..., pressure:float = ..., elevation:float = ...) -> float: ...
def solarelevation_function_overcast(latitude_deg:float, longitude_deg:float, when:datetime.datetime, elevation:float = ..., temperature:float = ..., pressure:float = ...) -> float: ...
def diffuse_transmittance(TL:float = ...) -> float: ...
def diffuse_underclear(latitude_deg:float, longitude_deg:float, when:datetime.datetime, elevation:float = ..., temperature:float = ..., pressure:float = ..., TL:float = ...) -> float: ...
def diffuse_underovercast(latitude_deg:float, longitude_deg:float, when:datetime.datetime, elevation:float = ..., temperature:float = ..., pressure:float = ..., TL:float = ...) -> float: ...
def direct_underclear(latitude_deg:float, longitude_deg:float, when:datetime.datetime, temperature:float = ..., pressure:float = ..., TY:float = ..., AM:float = ..., TL:float = ..., elevation:float = ...) -> float: ...
def global_irradiance_clear(DIRC, DIFFC, latitude_deg:float, longitude_deg:float, when:datetime.datetime, temperature:float = ..., pressure:float = ..., TY:float = ..., AM:float = ..., TL:float = ..., elevation:float = ...) -> float: ...
def global_irradiance_overcast(latitude_deg:float, longitude_deg:float, when:datetime.datetime, elevation:float = ..., temperature:float = ..., pressure:float = ...) -> float: ...
def diffuse_ratio(DIFF_data:Union[numpy.array,numpy.ndarray,numpy.generic,float,int], ghi_data:Union[numpy.array,numpy.ndarray,numpy.generic,float,int]) -> float: ...
def clear_index(ghi_data:Union[numpy.array,numpy.ndarray,numpy.generic,float,int], when:datetime.datetime, latitude_deg:float, longitude_deg:float) -> float: ...
