# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AzureLargeInstanceForcePowerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of two possible values to determine if the ALI instance restart operation should
    forcefully terminate and halt any existing processes that may be running on the server or not.
    """

    ACTIVE = "active"
    """Active means that the restart operation will terminate and halt existing processes that may be
    #: running on the server"""
    INACTIVE = "inactive"
    """Inactive means that the restart operation will not terminate and halt existing processes that
    #: may be running on the server"""


class AzureLargeInstanceHardwareTypeNamesEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of the hardware options (vendor and/or their product name) for an Azure Large Instance."""

    CISCO_UCS = "Cisco_UCS"
    """Hardware type of UCS from vendor Cisco"""
    HPE = "HPE"
    """Hardware type of HPE from vendor Hewlett Packard Enterprise"""
    SDFLEX = "SDFLEX"
    """Hardware type of SDFLEX"""


class AzureLargeInstancePowerStateEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Power states that an Azure Large Instance can be in."""

    STARTING = "starting"
    """Starting means that the Azure Large Instance resource is turning on."""
    STARTED = "started"
    """Started means that the Azure Large Instance resource has been powered on."""
    STOPPING = "stopping"
    """Stopping means that the Azure Large Instance resource is shutting down."""
    STOPPED = "stopped"
    """Stopped means that the Azure Large Instance resource has shut down."""
    RESTARTING = "restarting"
    """Restarting means that the Azure Large Instance resource is restarting."""
    UNKNOWN = "unknown"
    """Unknown means that the state of the Azure Large Instance is unknown."""


class AzureLargeInstanceProvisioningStatesEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning states that an Azure Large Instance can be in."""

    ACCEPTED = "Accepted"
    """Accepted means Azure Large Instance resource provisioning has been accepted."""
    CREATING = "Creating"
    """Creating means Azure Large Instance resource is being created."""
    UPDATING = "Updating"
    """Updating means an existing Azure Large Instance resource is being updated"""
    FAILED = "Failed"
    """Failed means Azure Large Instance resource is in failed state"""
    SUCCEEDED = "Succeeded"
    """Succeeded means Azure Large Instance resource creation succeeded during last create/update"""
    DELETING = "Deleting"
    """Deleting means Azure Large Instance resource is in the process of being deleted"""
    MIGRATING = "Migrating"
    """Migrating means Azure Large Instance resource is being migrated from one subscription or
    #: resource group to another"""
    CANCELED = "Canceled"
    """Cancelled Azure Large Instance resource operation has been cancelled"""


class AzureLargeInstanceSizeNamesEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of available model types (each of which have their own storage / memory sizes) for an
    Azure Large Instance type. See
    https://docs.microsoft.com/azure/sap/large-instances/hana-available-skus.
    """

    S72_M = "S72m"
    """Type I class SKU that can't be purchased anymore"""
    S144_M = "S144m"
    """Type I class SKU that can't be purchased anymore"""
    S72 = "S72"
    """Type I class SKU that can't be purchased anymore"""
    S144 = "S144"
    """Type I class SKU that can't be purchased anymore"""
    S192 = "S192"
    """Type I class SKU that can't be purchased anymore"""
    S192_M = "S192m"
    """Type I class SKU that can't be purchased anymore"""
    S192_XM = "S192xm"
    """Type I class SKU that can't be purchased anymore"""
    S96 = "S96"
    """2 sockets, 96 CPU threads, 48 CPU cores, 768 GB total memory, 768 GB DRAM, 3.0 TB storage,
    #: Cisco_UCS hardware type"""
    S112 = "S112"
    """No longer offered or used."""
    S224 = "S224"
    """4 sockets, 224 CPU threads, 112 CPU cores, 3 TB total memory, 3 TB DRAM, 6.3 TB storage,
    #: Cisco_UCS hardware type"""
    S224_M = "S224m"
    """4 sockets, 224 CPU threads, 112 CPU cores, 6 TB total memory, 6 TB DRAM, 10.5 TB storage,
    #: Cisco_UCS hardware type"""
    S224_OM = "S224om"
    """4 sockets, 224 CPU threads, 112 CPU cores, 6 TB total memory, 3 TB DRAM, 3 TB memory optane,
    #: 10.5 TB storage, Cisco_UCS hardware type"""
    S224_OO = "S224oo"
    """4 sockets, 224 CPU threads, 112 CPU cores, 4.5 TB total memory, 1.5 TB DRAM, 3 TB memory
    #: optane, 8.4 TB storage, Cisco_UCS hardware type"""
    S224_OOM = "S224oom"
    """4 sockets, 224 CPU threads, 112 CPU cores, 9 TB total memory, 3 TB DRAM, 6 TB memory optane,
    #: 14.8 TB storage, Cisco_UCS hardware type"""
    S224_OOO = "S224ooo"
    """4 sockets, 224 CPU threads, 112 CPU cores, 7.5TB total memory, 1.5 TB DRAM, 6 TB memory optane,
    #: 12.7 TB storage, Cisco_UCS hardware type"""
    S224_SE = "S224se"
    """4 sockets, 448 CPU threads, 6 TB total memory, SDFLEX hardware type"""
    S384 = "S384"
    """8 sockets, 384 CPU threads, 192 CPU cores, 4 TB total memory, 4 TB DRAM, 16 TB storage,
    #: HPEMc990x hardware type"""
    S384_M = "S384m"
    """8 sockets, 384 CPU threads, 192 CPU cores, 6 TB total memory, 6 TB DRAM, 18 TB storage,
    #: HPEMc990x hardware type"""
    S384_XM = "S384xm"
    """8 sockets, 384 CPU threads, 192 CPU cores, 8 TB total memory, 8 TB DRAM, 22 TB storage,
    #: HPEMc990x hardware type"""
    S384_XXM = "S384xxm"
    """8 sockets, 384 CPU threads, 12 TB total memory, HPEMc990x hardware type"""
    S448 = "S448"
    """8 sockets, 448 CPU threads, 224 CPU cores, 6 TB total memory, 6 TB DRAM, 10.5 TB storage,
    #: SDFLEX hardware type"""
    S448_M = "S448m"
    """8 sockets, 448 CPU threads, 224 CPU cores, 12 TB total memory, 12 TB DRAM, 18.9 TB storage,
    #: SDFLEX hardware type"""
    S448_OM = "S448om"
    """8 sockets, 448 CPU threads, 224 CPU cores, 12 TB total memory, 6 TB DRAM, 6 TB memory optane,
    #: 18.9 TB storage, SDFLEX hardware type"""
    S448_OO = "S448oo"
    """8 sockets, 448 CPU threads, 224 CPU cores, 9 TB total memory, 3 TB DRAM, 6 TB memory optane,
    #: 14.8 TB storage, SDFLEX hardware type"""
    S448_OOM = "S448oom"
    """8 sockets, 448 CPU threads, 224 CPU cores, 18 TB total memory, 6 TB DRAM, 12 memory optane,
    #: 27.4 TB storage, SDFLEX hardware type"""
    S448_OOO = "S448ooo"
    """8 sockets, 448 CPU threads, 224 CPU cores, 15 TB total memory, 3 TB DRAM, 12 memory optane,
    #: 23.2 TB storage, SDFLEX hardware type"""
    S448_SE = "S448se"
    """8 sockets, 448 CPU threads, 12 TB total memory, SDFLEX hardware type"""
    S576_M = "S576m"
    """12 sockets, 576 CPU threads, 288 CPU cores, 12 TB total memory, 12 TB DRAM, 28 TB storage,
    #: HPEMc990x hardware type"""
    S576_XM = "S576xm"
    """12 sockets, 576 CPU threads, 288 CPU cores, 18 TB total memory, HPEMc990x hardware type"""
    S672 = "S672"
    """12 sockets, 672 CPU threads, 336 CPU cores, 9 TB total memory, 9 TB DRAM, 14.7 TB storage,
    #: SDFLEX hardware type"""
    S672_M = "S672m"
    """12 sockets, 672 CPU threads, 336 CPU cores, 18 TB total memory, 18 TB DRAM, 27.4 TB storage,
    #: SDFLEX hardware type"""
    S672_OM = "S672om"
    """12 sockets, 672 CPU threads, 336 CPU cores, 18 TB total memory, 9 TB DRAM, 9 TB memory optane,
    #: 27.4 TB storage, SDFLEX hardware type"""
    S672_OO = "S672oo"
    """12 sockets, 672 CPU threads, 336 CPU cores, 13.5 TB total memory, 4.5 TB DRAM, 9 TB memory
    #: optane, 21.1 TB storage, SDFLEX hardware type"""
    S672_OOM = "S672oom"
    """12 sockets, 672 CPU threads, 336 CPU cores, 27 TB total memory, 9 TB DRAM, 18 TB memory optane,
    #: 40 TB storage, SDFLEX hardware type"""
    S672_OOO = "S672ooo"
    """12 sockets, 672 CPU threads, 336 CPU cores, 22.5 TB total memory, 4.5 TB DRAM, 18 TB memory
    #: optane, 33.7 TB storage, SDFLEX hardware type"""
    S768 = "S768"
    """No longer offered or used."""
    S768_M = "S768m"
    """16 sockets, 768 CPU threads, 384 CPU cores, 16 TB total memory, 16 TB DRAM, 36 TB storage,
    #: HPEMc990x hardware type"""
    S768_XM = "S768xm"
    """16 sockets, 768 CPU threads, 384 CPU cores, 24 TB total memory, 24 TB DRAM, 56 TB storage,
    #: HPEMc990x hardware type"""
    S896 = "S896"
    """16 sockets, 896 CPU threads, 448 CPU cores, 12 TB total memory, 12 TB DRAM, 18.9 TB storage,
    #: SDFLEX hardware type"""
    S896_M = "S896m"
    """16 sockets, 896 CPU threads, 448 CPU cores, 24 TB   total memory, 24 TB DRAM, 35.8 TB storage,
    #: SDFLEX hardware type"""
    S896_OM = "S896om"
    """16 sockets, 896 CPU threads, 448 CPU cores, 24 TB   total memory, 12 TB DRAM, 12 TB memory
    #: optane, 35.8 TB storage, SDFLEX hardware type"""
    S896_OO = "S896oo"
    """16 sockets, 896 CPU threads, 448 CPU cores, 18 TB  total memory, 6 TB DRAM, 12 TB memory
    #: optane, 27.4 TB storage, SDFLEX hardware type"""
    S896_OOM = "S896oom"
    """16 sockets, 896 CPU threads, 448 CPU cores, 36 TB total memory, 12 TB DRAM, 24 TB memory
    #: optane, 52.7 TB storage, SDFLEX hardware type"""
    S896_OOO = "S896ooo"
    """16 sockets, 896 CPU threads, 448 CPU cores, 30 TB total memory, 6 TB DRAM, 24 TB memory optane,
    #: 44.3 TB storage, SDFLEX hardware type"""
    S960_M = "S960m"
    """20 sockets, 960 CPU threads, 480 CPU cores, 20 TB total memory, 20 TB DRAM, 46 TB storage,
    #: HPEMc990x hardware type"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An enum of possible operation states for an AzureLargeStorageInstances."""

    ACCEPTED = "Accepted"
    """Accepted means ARM resource has been accepted."""
    CREATING = "Creating"
    """Creating means ARM resource is being created."""
    UPDATING = "Updating"
    """Updating means an existing ARM resource is being updated"""
    FAILED = "Failed"
    """Failed means resource is in failed state"""
    SUCCEEDED = "Succeeded"
    """Succeeded means resource creation succeeded during last create/update"""
    DELETING = "Deleting"
    """Deleting means resource is in the process of being deleted"""
    CANCELED = "Canceled"
    """Cancelled means resource operation has been cancelled"""
    MIGRATING = "Migrating"
    """Migrating means resource is being migrated from one subscription or resource group to another"""


class Versions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Azure Large Instance api versions."""

    V2023_07_20_PREVIEW = "2023-07-20-preview"
    """Azure Large Instance api version 2023-07-20-preview."""
