# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computeschedule import ComputeScheduleMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computeschedule
# USAGE
    python scheduled_actions_virtual_machines_execute_create_minimum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeScheduleMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.scheduled_actions.virtual_machines_execute_create(
        locationparameter="useast",
        request_body={
            "executionParameters": {},
            "resourceConfigParameters": {
                "baseProfile": {
                    "computeApiVersion": "2024-07-01",
                    "hardwareProfile": {"name": "F1"},
                    "provisioningState": 0,
                    "resourcegroupName": "RG5ABF491C-3164-42A6-8CB5-BF3CB53B018B",
                    "storageProfile": {"osDisk": {"osType": 0}},
                    "vmExtensions": [
                        {
                            "autoUpgradeMinorVersion": True,
                            "enableAutomaticUpgrade": True,
                            "protectedSettings": "SomeDecryptedSecretValue",
                            "provisioningState": 0,
                            "publisher": "Microsoft.Azure.Monitor",
                            "type": "AzureMonitorLinuxAgent",
                            "typeHandlerVersion": "1.0",
                        },
                        {"name": "myExtensionName"},
                    ],
                },
                "resourceCount": 2,
                "resourceOverrides": [
                    {
                        "location": "LocalDev",
                        "name": "myFleet_523",
                        "properties": {
                            "hardwareProfile": {"vmSize": "Standard_F1s"},
                            "osProfile": {
                                "adminPassword": "SomeDecryptedSecretValue",
                                "adminUsername": "adminUser",
                                "computerName": "myFleet000000",
                                "windowsConfiguration": {
                                    "additionalUnattendContent": [
                                        {"content": "", "passName": "someValue"},
                                        {"content": "SomeDecryptedSecretValue", "passName": "someOtherValue"},
                                    ]
                                },
                            },
                            "priority": 0,
                            "provisioningState": 0,
                        },
                        "zones": ["1"],
                    },
                    {
                        "location": "LocalDev",
                        "name": "myFleet_524",
                        "properties": {
                            "hardwareProfile": {"vmSize": "Standard_G1s"},
                            "osProfile": {
                                "adminPassword": "SomeDecryptedSecretValue",
                                "adminUsername": "adminUser",
                                "computerName": "myFleet000000",
                                "windowsConfiguration": {
                                    "additionalUnattendContent": [
                                        {"content": "", "passName": "someValue"},
                                        {"content": "SomeDecryptedSecretValue", "passName": "someOtherValue"},
                                    ]
                                },
                            },
                            "priority": 0,
                            "provisioningState": 0,
                        },
                        "zones": ["2"],
                    },
                ],
            },
        },
    )
    print(response)


# x-ms-original-file: 2025-04-15-preview/ScheduledActions_VirtualMachinesExecuteCreate_MinimumSet_Gen.json
if __name__ == "__main__":
    main()
