# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.communication import CommunicationServiceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCommunicationServiceManagementDomainsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CommunicationServiceManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_get(self, resource_group):
        response = self.client.domains.get(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_create_or_update(self, resource_group):
        response = self.client.domains.begin_create_or_update(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            parameters={
                "location": "str",
                "dataLocation": "str",
                "domainManagement": "str",
                "fromSenderDomain": "str",
                "id": "str",
                "mailFromSenderDomain": "str",
                "name": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "userEngagementTracking": "str",
                "verificationRecords": {
                    "DKIM": {"name": "str", "ttl": 0, "type": "str", "value": "str"},
                    "DKIM2": {"name": "str", "ttl": 0, "type": "str", "value": "str"},
                    "DMARC": {"name": "str", "ttl": 0, "type": "str", "value": "str"},
                    "Domain": {"name": "str", "ttl": 0, "type": "str", "value": "str"},
                    "SPF": {"name": "str", "ttl": 0, "type": "str", "value": "str"},
                },
                "verificationStates": {
                    "DKIM": {"errorCode": "str", "status": "str"},
                    "DKIM2": {"errorCode": "str", "status": "str"},
                    "DMARC": {"errorCode": "str", "status": "str"},
                    "Domain": {"errorCode": "str", "status": "str"},
                    "SPF": {"errorCode": "str", "status": "str"},
                },
            },
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_delete(self, resource_group):
        response = self.client.domains.begin_delete(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_update(self, resource_group):
        response = self.client.domains.begin_update(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            parameters={"tags": {"str": "str"}, "userEngagementTracking": "str"},
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_list_by_email_service_resource(self, resource_group):
        response = self.client.domains.list_by_email_service_resource(
            resource_group_name=resource_group.name,
            email_service_name="str",
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_initiate_verification(self, resource_group):
        response = self.client.domains.begin_initiate_verification(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            parameters={"verificationType": "str"},
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_domains_begin_cancel_verification(self, resource_group):
        response = self.client.domains.begin_cancel_verification(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            parameters={"verificationType": "str"},
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
