% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-data.R
\name{chk_data}
\alias{chk_data}
\alias{vld_data}
\title{Check Data}
\usage{
chk_data(x, x_name = NULL)

vld_data(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks data.frame using

\code{inherits(x, "data.frame")}

Note that there is a similar function, \code{\link[=check_data]{check_data()}}, which checks
the column names, values, number of rows, and keys of a data.frame.
}
\section{Functions}{
\itemize{
\item \code{vld_data()}: Validate Data

}}
\examples{
# chk_data
chk_data(data.frame(x = 1))
try(chk_data(1))
# vld_data
vld_data(data.frame())
vld_data(data.frame(x = 1))
vld_data(c(x = 1))
}
\seealso{
\code{\link[=inherits]{inherits()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other id_checkers: 
\code{\link{chk_is}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()}
}
\concept{id_checkers}
