% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign.R
\name{read_graph}
\alias{read_graph}
\alias{LGL}
\alias{Pajek}
\alias{GraphML}
\alias{GML}
\alias{DL}
\alias{UCINET}
\title{Reading foreign file formats}
\usage{
read_graph(
  file,
  format = c("edgelist", "pajek", "ncol", "lgl", "graphml", "dimacs", "graphdb", "gml",
    "dl"),
  ...
)
}
\arguments{
\item{file}{The connection to read from. This can be a local file, or a
\code{http} or \code{ftp} connection. It can also be a character string with
the file name or URI.}

\item{format}{Character constant giving the file format. Right now
\code{edgelist}, \code{pajek}, \code{ncol}, \code{lgl}, \code{graphml},
\code{dimacs}, \code{graphdb}, \code{gml} and \code{dl} are supported,
the default is \code{edgelist}. As of igraph 0.4 this argument is case
insensitive.}

\item{\dots}{Additional arguments, see below.}
}
\value{
A graph object.
}
\description{
The \code{read_graph()} function is able to read graphs in various
representations from a file, or from a http connection. Various formats
are supported.
}
\details{
The \code{read_graph()} function may have additional arguments depending on
the file format (the \code{format} argument). See the details separately for
each file format, below.
}
\section{Edge list format}{

This format is a simple text file with numeric
vertex IDs defining the edges. There is no need to have newline characters
between the edges, a simple space will also do. Vertex IDs contained in
the file are assumed to start at zero.

Additional arguments:
\describe{
\item{n}{
The number of vertices in the
graph. If it is smaller than or equal to the largest integer in the file,
then it is ignored; so it is safe to set it to zero (the default).
}
\item{directed}{
Logical scalar, whether to create a directed graph. The
default value is \code{TRUE}.
}
}
}

\section{Pajek format}{

Currently igraph only supports Pajek network
files, with a \code{.net} extension, but not Pajek project files with
a \code{.paj} extension. Only network data is supported; permutations,
hierarchies, clusters and vectors are not.
}

\section{NCOL format}{

Additional arguments:
\describe{
\item{predef}{
Names of the vertices in the file.
If \code{character(0)} (the default) is given here
then vertex IDs will be assigned to vertex names in the order of
their appearance in the .ncol file.
If it is not \code{character(0)} and some unknown vertex names are found
in the .ncol file then new vertex ids will be assigned to them.
}
\item{names}{
Logical value, if \code{TRUE} (the default)
the symbolic names of the vertices will be added to the graph
as a vertex attribute called “name”.
}
\item{weights}{
Whether to add the weights of the edges to the graph
as an edge attribute called “weight”.
\code{"yes"} adds the weights (even if they are not present in the file,
in this case they are assumed to be zero).
\code{"no"} does not add any edge attribute.
\code{"auto"} (the default) adds the attribute if and only
if there is at least one explicit edge weight in the input file.
}
\item{directed}{
Whether to create a directed graph (default: \code{FALSE}).
As this format was originally used only for undirected graphs
there is no information in the file about the directedness of the graph.
}
}
}

\section{GraphML format}{

GraphML is an XML-based file format for representing various types of graphs.
Currently only the most basic import functionality is implemented in igraph:
it can read GraphML files without nested graphs and hyperedges.
\describe{
\item{index}{Integer, specifies which graph to read from a GraphML file
containing multiple graphs. Defaults to 0 for the first graph.}
}
}

\section{LGL format}{

The .lgl format is used by the Large Graph Layout visualization software (\url{https://lgl.sourceforge.net}), it can describe undirected optionally weighted graphs
\describe{
\item{names}{Logical, whether to add vertex names as a vertex attribute
called "name". Default is TRUE.}
\item{weights}{
Whether to add the weights of the edges to the graph
as an edge attribute called “weight”.
\code{"yes"} adds the weights (even if they are not present in the file,
in this case they are assumed to be zero).
\code{"no"} does not add any edge attribute.
\code{"auto"} (the default) adds the attribute if and only
if there is at least one explicit edge weight in the input file.
}
\item{directed}{Logical, whether to create a directed graph. Default is FALSE.}
}
}

\section{DIMACS format}{

This is a line-oriented text file (ASCII) format.
The first character of each line defines the type of the line.
If the first character is c the line is a comment line and it is ignored.
There is one problem line (p in the file),
it must appear before any node and arc descriptor lines.
The problem line has three fields separated by spaces: the problem type (max or edge),
the number of vertices, and number of edges in the graph. In MAX problems,
exactly two node identification lines are expected (n), one for the source, and one for the target vertex.
These have two fields: the ID of the vertex and the type of the vertex, either s ( = source) or t ( = target).
Arc lines start with a and have three fields: the source vertex, the target vertex and the edge capacity.
In EDGE problems, there may be a node line (n) for each node. It specifies the node index and an
integer node label. Nodes for which no explicit label was specified will use their index as label.
In EDGE problems, each edge is specified as an edge line (e).
\describe{
\item{directed}{Logical, whether to create a directed graph. Default is TRUE.}
}
}

\section{DL format}{

This is a simple textual file format used by UCINET.
See \url{http://www.analytictech.com/networks/dataentry.htm} for examples.
All the forms described here are supported by igraph.
Vertex names and edge weights are also supported and they are added as attributes.
(If an attribute handler is attached.)
Note the specification does not mention whether the format is case sensitive or not.
For igraph DL files are case sensitive, i.e. Larry and larry are not the same.
\describe{
\item{directed}{Logical, whether to create a directed graph. Default is TRUE.}
}
}

\section{GML format}{

GML is a quite general textual format. For the specifics of the implementation, see the linked documentation of the cClibrary.
}

\section{GraphDB format}{

This is a binary format, used in the ARG Graph Database for isomorphism testing. For more information, see \url{https://mivia.unisa.it/datasets/graph-database/arg-database/}
\describe{
\item{directed}{Logical, whether to create a directed graph. Default is TRUE.}
}
}

\seealso{
\code{\link[=write_graph]{write_graph()}}

Foreign format readers
\code{\link{graph_from_graphdb}()},
\code{\link{write_graph}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{foreign}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_dimacs_flow}{\code{read_graph_dimacs_flow()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_dl}{\code{read_graph_dl()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_edgelist}{\code{read_graph_edgelist()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_gml}{\code{read_graph_gml()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_graphdb}{\code{read_graph_graphdb()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_graphml}{\code{read_graph_graphml()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_lgl}{\code{read_graph_lgl()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_ncol}{\code{read_graph_ncol()}}, \href{https://igraph.org/c/html/0.10.17/igraph-Foreign.html#igraph_read_graph_pajek}{\code{read_graph_pajek()}}.}

