% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMI-score.R
\name{lavTestScore.mi-deprecated}
\alias{lavTestScore.mi-deprecated}
\title{Score Test for Multiple Imputations}
\usage{
lavTestScore.mi(object, add = NULL, release = NULL,
                test = c("D2","D1"), scale.W = !asymptotic,
                omit.imps = c("no.conv","no.se"),
                asymptotic = is.null(add),
                univariate = TRUE, cumulative = FALSE,
                epc = FALSE, standardized = epc, cov.std = epc,
                verbose = FALSE, warn = TRUE, information = "expected")
}
\arguments{
\item{object}{An object of class \linkS4class{OLDlavaan.mi}.}

\item{add}{Either a \code{character} string (typically between single
quotes) or a parameter table containing additional (currently
fixed-to-zero) parameters for which the score test must be computed.}

\item{release}{Vector of \code{integer}s. The indices of the \emph{equality}
constraints that should be released. The indices correspond to the order of
the equality constraints as they appear in the parameter table.}

\item{test}{\code{character} indicating which pooling method to use.
\code{"D1"} requests Mansolf, Jorgensen, & Enders' (2020) proposed
Wald-like test for pooling the gradient and information, which are then
used to calculate score-test statistics in the usual manner. \code{"D2"}
(default because it is less computationall intensive) requests to pool the
complete-data score-test statistics from each imputed data set, then pool
them across imputations, described by Li et al. (1991) and Enders (2010).}

\item{scale.W}{\code{logical}. If \code{FALSE}, the pooled
information matrix is calculated as the weighted sum of the
within-imputation and between-imputation components. Otherwise, the pooled
information is calculated by scaling the within-imputation component by
the average relative increase in variance (ARIV; Enders, 2010, p. 235),
which is \emph{only} consistent when requesting the \emph{F} test (i.e.,
\code{asymptotic = FALSE}.  Ignored (irrelevant) if \code{test = "D2"}.}

\item{omit.imps}{\code{character} vector specifying criteria for omitting
imputations from pooled results.  Can include any of
\code{c("no.conv", "no.se", "no.npd")}, the first 2 of which are the
default setting, which excludes any imputations that did not
converge or for which standard errors could not be computed.  The
last option (\code{"no.npd"}) would exclude any imputations which
yielded a nonpositive definite covariance matrix for observed or
latent variables, which would include any "improper solutions" such
as Heywood cases. Specific imputation numbers can also be included in this
argument, in case users want to  apply their own custom omission criteria
(or simulations can use different numbers of imputations without
redundantly refitting the model).}

\item{asymptotic}{\code{logical}. If \code{FALSE} (default when using
\code{add} to test adding fixed parameters to the model), the pooled test
will be returned as an \emph{F}-distributed variable with numerator
(\code{df1}) and denominator (\code{df2}) degrees of freedom.
If \code{TRUE}, the pooled \emph{F} statistic will be multiplied by its
\code{df1} on the assumption that its \code{df2} is sufficiently large
enough that the statistic will be asymptotically \eqn{\chi^2} distributed
with \code{df1}. When using the \code{release} argument, \code{asymptotic}
will be set to \code{TRUE} because (A)RIV can only be calculated for
\code{add}ed parameters.}

\item{univariate}{\code{logical}. If \code{TRUE}, compute the univariate
score statistics, one for each constraint.}

\item{cumulative}{\code{logical}. If \code{TRUE}, order the univariate score
statistics from large to small, and compute a series of multivariate
score statistics, each time including an additional constraint in the test.}

\item{epc}{\code{logical}. If \code{TRUE}, and we are releasing existing
constraints, compute the expected parameter changes for the existing
(free) parameters (and any specified with \code{add}), if all constraints
were released. For EPCs associated with a particular (1-\emph{df})
constraint, only specify one parameter in \code{add} or one constraint in
\code{release}.}

\item{standardized}{If \code{TRUE}, two extra columns (\code{sepc.lv} and
\code{sepc.all}) in the \verb{$epc} table will contain standardized values
for the EPCs. See \code{\link[lavaan:lavTestScore]{lavaan::lavTestScore()}}.}

\item{cov.std}{\code{logical}. See \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}

\item{verbose}{\code{logical}. Not used for now.}

\item{warn}{\code{logical}. If \code{TRUE}, print warnings if they occur.}

\item{information}{\code{character} indicating the type of information
matrix to use (check \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} for available options).
\code{"expected"} information is the default, which provides better
control of Type I errors.}
}
\value{
A list containing at least one \code{data.frame}:
\itemize{
\item{\verb{$test}: The total score test, with columns for the score
test statistic (\code{X2}), its degrees of freedom (\code{df}), its
\emph{p} value under the \eqn{\chi^2} distribution (\code{p.value}),
and if \code{asymptotic=FALSE}, the average relative invrease in
variance (ARIV) used to calculate the denominator \emph{df} is also
returned as a missing-data diagnostic, along with the fraction missing
information (FMI = ARIV / (1 + ARIV)).}
\item{\verb{$uni}: Optional (if \code{univariate=TRUE}).
Each 1-\emph{df} score test, equivalent to modification indices. Also
includes EPCs if \code{epc=TRUE}, and RIV and FMI if
\code{asymptotic=FALSE}.}
\item{\verb{$cumulative}: Optional (if \code{cumulative=TRUE}).
Cumulative score tests, with ARIV and FMI if \code{asymptotic=FALSE}.}
\item{\verb{$epc}: Optional (if \code{epc=TRUE}). Parameter estimates,
expected parameter changes, and expected parameter values if ALL
the tested constraints were freed.}
}
See \code{\link[lavaan:lavTestScore]{lavaan::lavTestScore()}} for details.
}
\description{
Score test (or "Lagrange multiplier" test) for lavaan models fitted to
multiple imputed data sets. Statistics for releasing one or more
fixed or constrained parameters in model can be calculated by pooling
the gradient and information matrices pooled across imputed data sets in a
method proposed by Mansolf, Jorgensen, & Enders (2020)---analogous to
the "D1" Wald test proposed by Li, Meng, Raghunathan, & Rubin's (1991)---or
by pooling the complete-data score-test statistics across imputed data sets
(i.e., "D2"; Li et al., 1991).
}
\examples{

## See the new lavaan.mi package

}
\references{
Bentler, P. M., & Chou, C.-P. (1992). Some new covariance structure model
improvement statistics. \emph{Sociological Methods & Research, 21}(2),
259--282. \doi{10.1177/0049124192021002006}

Enders, C. K. (2010). \emph{Applied missing data analysis}.
New York, NY: Guilford.

Li, K.-H., Meng, X.-L., Raghunathan, T. E., & Rubin, D. B. (1991).
Significance levels from repeated \emph{p}-values with multiply-imputed
data. \emph{Statistica Sinica, 1}(1), 65--92. Retrieved from
\url{https://www.jstor.org/stable/24303994}

Mansolf, M., Jorgensen, T. D., & Enders, C. K. (2020). A multiple
imputation score test for model modification in structural equation
models. \emph{Psychological Methods, 25}(4), 393--411.
\doi{10.1037/met0000243}
}
\seealso{
\code{\link[lavaan:lavTestScore]{lavaan::lavTestScore()}}

\code{\link[=semTools-deprecated]{semTools-deprecated()}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})

Adapted from \pkg{lavaan} source code, written by
Yves Rosseel (Ghent University; \email{Yves.Rosseel@UGent.be})

\code{test = "D1"} method proposed by
Maxwell Mansolf (University of California, Los Angeles;
\email{mamansolf@gmail.com})
}
\keyword{internal}
